/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import java.util.ArrayList;
import java.util.logging.Logger;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.networking.Client;
import net.sf.freecol.common.PseudoRandom;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.ModelController;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.networking.Message;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientModelController
implements ModelController {
    private static final Logger logger = Logger.getLogger(ClientModelController.class.getName());
    private final FreeColClient freeColClient;

    public ClientModelController(FreeColClient freeColClient) {
        this.freeColClient = freeColClient;
    }

    @Override
    public int getRandom(String taskID, int n) {
        Client client = this.freeColClient.getClient();
        Element getRandomElement = Message.createNewRootElement("getRandom");
        getRandomElement.setAttribute("taskID", taskID);
        getRandomElement.setAttribute("n", Integer.toString(n));
        Element reply = client.ask(getRandomElement);
        if (!reply.getTagName().equals("getRandomConfirmed")) {
            logger.warning("Wrong tag name.");
            throw new IllegalStateException();
        }
        return Integer.parseInt(reply.getAttribute("result"));
    }

    @Override
    public Unit createUnit(String taskID, Location location, Player owner, UnitType type) {
        Element createUnitElement = Message.createNewRootElement("createUnit");
        createUnitElement.setAttribute("taskID", taskID);
        createUnitElement.setAttribute("location", location.getId());
        createUnitElement.setAttribute("owner", owner.getId());
        createUnitElement.setAttribute("type", type.getId());
        logger.info("Waiting for the server to reply...");
        Element reply = this.freeColClient.getClient().ask(createUnitElement);
        logger.info("Reply received from server.");
        if (!reply.getTagName().equals("createUnitConfirmed")) {
            logger.warning("Wrong tag name.");
            throw new IllegalStateException();
        }
        Element unitElement = (Element)reply.getElementsByTagName(Unit.getXMLElementTagName()).item(0);
        Unit unit = new Unit(this.freeColClient.getGame(), unitElement);
        unit.setLocationNoUpdate(null);
        unit.setLocation(location);
        return unit;
    }

    @Override
    public Building createBuilding(String taskID, Colony colony, BuildingType type) {
        Element createBuildingElement = Message.createNewRootElement("createBuilding");
        createBuildingElement.setAttribute("taskID", taskID);
        createBuildingElement.setAttribute("colony", colony.getId());
        createBuildingElement.setAttribute("type", type.getId());
        logger.info("Waiting for the server to reply...");
        Element reply = this.freeColClient.getClient().ask(createBuildingElement);
        logger.info("Reply received from server.");
        if (!reply.getTagName().equals("createBuildingConfirmed")) {
            logger.warning("Wrong tag name.");
            throw new IllegalStateException();
        }
        Element buildingElement = (Element)reply.getElementsByTagName(Building.getXMLElementTagName()).item(0);
        Building building = new Building(this.freeColClient.getGame(), buildingElement);
        return building;
    }

    @Override
    public Location setToVacantEntryLocation(Unit unit) {
        Element createUnitElement = Message.createNewRootElement("getVacantEntryLocation");
        createUnitElement.setAttribute("unit", unit.getId());
        Element reply = this.freeColClient.getClient().ask(createUnitElement);
        if (reply == null) {
            throw new IllegalStateException("No reply for getVacantEntryLocation!");
        }
        if (!"getVacantEntryLocationConfirmed".equals(reply.getTagName())) {
            throw new IllegalStateException("Unexpected reply type for getVacantEntryLocation: " + reply.getTagName());
        }
        Location entryLocation = (Location)((Object)this.freeColClient.getGame().getFreeColGameObject(reply.getAttribute("location")));
        unit.setLocation(entryLocation);
        return entryLocation;
    }

    @Override
    public void setStance(Player first, Player second, Player.Stance stance) {
    }

    @Override
    public void exploreTiles(Player player, ArrayList<Tile> tiles) {
    }

    public void update(Tile tile) {
    }

    @Override
    public PseudoRandom getPseudoRandom() {
        return this.freeColClient.getPseudoRandom();
    }

    @Override
    public TradeRoute getNewTradeRoute(Player player) {
        Element getNewTradeRouteElement;
        Game game = this.freeColClient.getGame();
        Client client = this.freeColClient.getClient();
        Element reply = client.ask(getNewTradeRouteElement = Message.createNewRootElement("getNewTradeRoute"));
        if (!reply.getTagName().equals("getNewTradeRouteConfirmed")) {
            logger.warning("Wrong tag name.");
            throw new IllegalStateException();
        }
        Element routeElement = (Element)reply.getElementsByTagName(TradeRoute.getXMLElementTagName()).item(0);
        TradeRoute tradeRoute = new TradeRoute(game, routeElement);
        return tradeRoute;
    }

    @Override
    public boolean shouldCallNewTurn(FreeColGameObject freeColGameObject) {
        if (freeColGameObject instanceof Ownable) {
            Ownable o = (Ownable)((Object)freeColGameObject);
            return o.getOwner() == this.freeColClient.getMyPlayer();
        }
        return true;
    }
}

