/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.InGameMenuBar;
import net.sf.freecol.client.gui.action.BuildColonyAction;
import net.sf.freecol.client.gui.animation.UnitMoveAnimation;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.option.FreeColActionUI;
import net.sf.freecol.client.gui.panel.ChoiceItem;
import net.sf.freecol.client.gui.panel.ReportTurnPanel;
import net.sf.freecol.client.gui.sound.SoundLibrary;
import net.sf.freecol.client.networking.Client;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoalDecider;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileItemContainer;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.BuyLandMessage;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.NetworkConstants;
import net.sf.freecol.common.networking.StatisticsMessage;
import net.sf.freecol.common.networking.StealLandMessage;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InGameController
implements NetworkConstants {
    private static final Logger logger = Logger.getLogger(InGameController.class.getName());
    private final FreeColClient freeColClient;
    private boolean endingTurn = false;
    private boolean canAutoEndTurn = false;
    private boolean executeGoto = false;
    private HashMap<String, Integer> messagesToIgnore = new HashMap();
    private ArrayList<File> allSaveGames = new ArrayList();

    public InGameController(FreeColClient freeColClient) {
        this.freeColClient = freeColClient;
    }

    public void saveGame() {
        File file;
        Canvas canvas = this.freeColClient.getCanvas();
        String fileName = this.freeColClient.getMyPlayer().getName() + "_" + this.freeColClient.getMyPlayer().getNationAsString() + "_" + this.freeColClient.getGame().getTurn().toSaveGameString();
        fileName = fileName.replaceAll(" ", "_");
        if (this.freeColClient.getMyPlayer().isAdmin() && this.freeColClient.getFreeColServer() != null && (file = canvas.showSaveDialog(FreeCol.getSaveDirectory(), fileName)) != null) {
            FreeCol.setSaveDirectory(file.getParentFile());
            this.saveGame(file);
        }
    }

    public void saveGame(final File file) {
        final Canvas canvas = this.freeColClient.getCanvas();
        canvas.showStatusPanel(Messages.message("status.savingGame", new String[0]));
        Thread t = new Thread("FreeColClient:Saving Game"){

            public void run() {
                try {
                    InGameController.this.freeColClient.getFreeColServer().saveGame(file, InGameController.this.freeColClient.getMyPlayer().getName());
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            canvas.closeStatusPanel();
                            canvas.requestFocusInWindow();
                        }
                    });
                }
                catch (IOException e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            canvas.errorMessage("couldNotSaveGame");
                        }
                    });
                }
            }
        };
        t.start();
    }

    public void loadGame() {
        Canvas canvas = this.freeColClient.getCanvas();
        File file = canvas.showLoadDialog(FreeCol.getSaveDirectory());
        if (file == null) {
            return;
        }
        if (!file.isFile()) {
            canvas.errorMessage("fileNotFound");
            return;
        }
        if (!canvas.showConfirmDialog("stopCurrentGame.text", "stopCurrentGame.yes", "stopCurrentGame.no", new String[0])) {
            return;
        }
        this.freeColClient.getConnectController().quitGame(true);
        canvas.removeInGameComponents();
        this.freeColClient.getConnectController().loadGame(file);
    }

    public void setInDebugMode(boolean debug) {
        FreeCol.setInDebugMode(debug);
        this.freeColClient.getCanvas().setJMenuBar(new InGameMenuBar(this.freeColClient));
        this.freeColClient.getCanvas().updateJMenuBar();
    }

    public void declareIndependence() {
        Game game = this.freeColClient.getGame();
        Player player = this.freeColClient.getMyPlayer();
        if (game.getCurrentPlayer() != player) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        Canvas canvas = this.freeColClient.getCanvas();
        if (player.getSoL() < 50) {
            canvas.showInformationMessage("declareIndependence.notMajority", FreeCol.getSpecification().getGoodsType("model.goods.bells"), "%percentage%", Integer.toString(player.getSoL()));
            return;
        }
        if (!canvas.showConfirmDialog("declareIndependence.areYouSure.text", "declareIndependence.areYouSure.yes", "declareIndependence.areYouSure.no", new String[0])) {
            return;
        }
        String nationName = Messages.message("declareIndependence.defaultNation", "%nation%", player.getNewLandName());
        nationName = canvas.showInputDialog("declareIndependence.enterNation", nationName, Messages.message("ok", new String[0]), Messages.message("cancel", new String[0]), new String[0]);
        player.setIndependentNationName(nationName);
        Element declareIndependenceElement = Message.createNewRootElement("declareIndependence");
        declareIndependenceElement.setAttribute("independentNationName", nationName);
        Element reply = this.freeColClient.getClient().ask(declareIndependenceElement);
        if (reply == null) {
            NullPointerException e = new NullPointerException("Failed to receive reply to \"declareIndependence\" message");
            throw e;
        }
        NodeList childNodes = reply.getChildNodes();
        Element playerElement = (Element)childNodes.item(0);
        Player refPlayer = (Player)game.getFreeColGameObject(playerElement.getAttribute("ID"));
        if (refPlayer == null) {
            refPlayer = new Player(game, playerElement);
        }
        for (int index = 1; index < childNodes.getLength(); ++index) {
            Element unitElement = (Element)childNodes.item(index);
            if (game.getFreeColGameObject(unitElement.getAttribute("ID")) != null) continue;
            new Unit(game, (Element)childNodes.item(index));
        }
        game.addPlayer(refPlayer);
        this.freeColClient.getMyPlayer().declareIndependence();
        this.freeColClient.getActionManager().update();
        canvas.showDeclarationDialog();
        this.nextModelMessage();
    }

    public void sendChat(String message) {
        Element chatElement = Message.createNewRootElement("chat");
        chatElement.setAttribute("message", message);
        chatElement.setAttribute("privateChat", "false");
        this.freeColClient.getClient().sendAndWait(chatElement);
    }

    public void setCurrentPlayer(Player currentPlayer) {
        logger.finest("Setting current player " + currentPlayer.getName());
        Game game = this.freeColClient.getGame();
        game.setCurrentPlayer(currentPlayer);
        if (this.freeColClient.getMyPlayer().equals(currentPlayer)) {
            if (this.freeColClient.getFreeColServer() != null) {
                int turnNumber = this.freeColClient.getGame().getTurn().getNumber();
                int savegamePeriod = this.freeColClient.getClientOptions().getInteger("model.option.autosavePeriod");
                if (savegamePeriod == 1 || savegamePeriod != 0 && turnNumber % savegamePeriod == 0) {
                    String filename = Messages.message("clientOptions.savegames.autosave.fileprefix", new String[0]) + '-' + this.freeColClient.getGame().getTurn().toSaveGameString() + ".fsg";
                    File saveGameFile = new File(FreeCol.getAutosaveDirectory(), filename);
                    this.saveGame(saveGameFile);
                    int generations = this.freeColClient.getClientOptions().getInteger("model.option.autosaveGenerations");
                    if (generations > 0) {
                        this.allSaveGames.add(saveGameFile);
                        if (this.allSaveGames.size() > generations) {
                            File fileToDelete = this.allSaveGames.remove(0);
                            fileToDelete.delete();
                        }
                    }
                }
            }
            this.removeUnitsOutsideLOS();
            if (currentPlayer.checkEmigrate()) {
                if (currentPlayer.hasAbility("model.ability.selectRecruit") && currentPlayer.getEurope().recruitablesDiffer()) {
                    this.emigrateUnitInEurope(this.freeColClient.getCanvas().showEmigrationPanel());
                } else {
                    this.emigrateUnitInEurope(0);
                }
            }
            if (!this.freeColClient.isSingleplayer()) {
                this.freeColClient.playSound(currentPlayer.getNation().getAnthem());
            }
            this.checkTradeRoutesInEurope();
            this.displayModelMessages(true);
            this.nextActiveUnit();
        }
        logger.finest("Exiting method setCurrentPlayer()");
    }

    public void rename(Nameable object) {
        if (!(object instanceof Ownable) || ((Ownable)((Object)object)).getOwner() != this.freeColClient.getMyPlayer()) {
            return;
        }
        String name = null;
        if (object instanceof Colony) {
            name = this.freeColClient.getCanvas().showInputDialog("renameColony.text", object.getName(), "renameColony.yes", "renameColony.no", new String[0]);
            if (name == null || name.length() == 0) {
                return;
            }
            if (this.freeColClient.getMyPlayer().getColony(name) != null) {
                this.freeColClient.getCanvas().showInformationMessage("nameColony.notUnique", "%name%", name);
                return;
            }
        } else if (object instanceof Unit) {
            name = this.freeColClient.getCanvas().showInputDialog("renameUnit.text", object.getName(), "renameUnit.yes", "renameUnit.no", false, new String[0]);
            if (name == null) {
                return;
            }
        } else {
            return;
        }
        object.setName(name);
        Element renameElement = Message.createNewRootElement("rename");
        renameElement.setAttribute("nameable", ((FreeColGameObject)((Object)object)).getId());
        renameElement.setAttribute("name", name);
        this.freeColClient.getClient().sendAndWait(renameElement);
    }

    private void removeUnitsOutsideLOS() {
        Player player = this.freeColClient.getMyPlayer();
        Map map = this.freeColClient.getGame().getMap();
        player.resetCanSeeTiles();
        Map.WholeMapIterator tileIterator = map.getWholeMapIterator();
        while (tileIterator.hasNext()) {
            Tile t = map.getTile((Map.Position)tileIterator.next());
            if (t == null || player.canSee(t) || t.getFirstUnit() == null) continue;
            if (t.getFirstUnit().getOwner() == player) {
                logger.warning("Could not see one of my own units!");
            }
            t.disposeAllUnits();
        }
        player.resetCanSeeTiles();
    }

    public void buildColony() {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        Client client = this.freeColClient.getClient();
        Game game = this.freeColClient.getGame();
        GUI gui = this.freeColClient.getGUI();
        Unit unit = this.freeColClient.getGUI().getActiveUnit();
        if (unit == null || !unit.canBuildColony()) {
            return;
        }
        Tile tile = unit.getTile();
        if (tile == null) {
            return;
        }
        if (this.freeColClient.getClientOptions().getBoolean("model.option.guiShowColonyWarnings") && !this.showColonyWarnings(tile, unit)) {
            return;
        }
        String name = this.freeColClient.getCanvas().showInputDialog("nameColony.text", this.freeColClient.getMyPlayer().getDefaultColonyName(), "nameColony.yes", "nameColony.no", new String[0]);
        if (name == null) {
            return;
        }
        if (this.freeColClient.getMyPlayer().getColony(name) != null) {
            this.freeColClient.getCanvas().showInformationMessage("nameColony.notUnique", "%name%", name);
            return;
        }
        Element buildColonyElement = Message.createNewRootElement("buildColony");
        buildColonyElement.setAttribute("name", name);
        buildColonyElement.setAttribute("unit", unit.getId());
        Element reply = client.ask(buildColonyElement);
        if (reply.getTagName().equals("buildColonyConfirmed")) {
            Element colonyElement;
            Colony colony;
            this.freeColClient.playSound(SoundLibrary.SoundEffect.BUILDING_COMPLETE);
            Element updateElement = this.getChildElement(reply, "update");
            if (updateElement != null) {
                this.freeColClient.getInGameInputHandler().update(updateElement);
            }
            if ((colony = (Colony)game.getFreeColGameObject((colonyElement = (Element)reply.getFirstChild()).getAttribute("ID"))) == null) {
                colony = new Colony(game, colonyElement);
            } else {
                colony.readFromXMLElement(colonyElement);
            }
            this.changeWorkType(unit, Goods.FOOD);
            unit.buildColony(colony);
            ArrayList<Unit> units = new ArrayList<Unit>(tile.getUnitList());
            for (Unit unitInTile : units) {
                if (!unitInTile.canCarryTreasure()) continue;
                this.checkCashInTreasureTrain(unitInTile);
            }
            gui.setActiveUnit(null);
            gui.setSelectedTile(colony.getTile().getPosition());
        }
    }

    private boolean showColonyWarnings(Tile tile, Unit unit) {
        boolean landLocked = true;
        boolean ownedByEuropeans = false;
        boolean ownedBySelf = false;
        boolean ownedByIndians = false;
        HashMap<GoodsType, Integer> goodsMap = new HashMap<GoodsType, Integer>();
        for (GoodsType goodsType : FreeCol.getSpecification().getGoodsTypeList()) {
            int potential;
            if (goodsType.isFoodType()) {
                potential = 0;
                if (tile.primaryGoods() == goodsType) {
                    potential = tile.potential(goodsType, null);
                }
                goodsMap.put(goodsType, new Integer(potential));
                continue;
            }
            if (!goodsType.isBuildingMaterial()) continue;
            while (goodsType.isRefined()) {
                goodsType = goodsType.getRawMaterial();
            }
            potential = 0;
            if (tile.secondaryGoods() == goodsType) {
                potential = tile.potential(goodsType, null);
            }
            goodsMap.put(goodsType, new Integer(potential));
        }
        Map map = tile.getGame().getMap();
        Iterator<Map.Position> tileIterator = map.getAdjacentIterator(tile.getPosition());
        block2: while (tileIterator.hasNext()) {
            Tile newTile = map.getTile(tileIterator.next());
            if (newTile.isLand()) {
                for (Map.Entry entry : goodsMap.entrySet()) {
                    entry.setValue((Integer)entry.getValue() + newTile.potential((GoodsType)entry.getKey(), null));
                }
                Player tileOwner = newTile.getOwner();
                if (tileOwner == unit.getOwner()) {
                    if (newTile.getOwningSettlement() != null) {
                        ownedBySelf = true;
                        continue;
                    }
                    Iterator<Map.Position> iterator = map.getAdjacentIterator(newTile.getPosition());
                    while (iterator.hasNext()) {
                        Colony colony = map.getTile(iterator.next()).getColony();
                        if (colony == null || colony.getOwner() != unit.getOwner()) continue;
                        ownedBySelf = true;
                        continue block2;
                    }
                    continue;
                }
                if (tileOwner != null && tileOwner.isEuropean()) {
                    ownedByEuropeans = true;
                    continue;
                }
                if (tileOwner == null) continue;
                ownedByIndians = true;
                continue;
            }
            landLocked = false;
        }
        int food = 0;
        for (Map.Entry entry : goodsMap.entrySet()) {
            if (!((GoodsType)entry.getKey()).isFoodType()) continue;
            food += ((Integer)entry.getValue()).intValue();
        }
        ArrayList<ModelMessage> messages = new ArrayList<ModelMessage>();
        if (landLocked) {
            messages.add(new ModelMessage((FreeColGameObject)unit, ModelMessage.MessageType.MISSING_GOODS, FreeCol.getSpecification().getGoodsType("model.goods.fish"), "buildColony.landLocked", new String[0]));
        }
        if (food < 8) {
            messages.add(new ModelMessage((FreeColGameObject)unit, ModelMessage.MessageType.MISSING_GOODS, FreeCol.getSpecification().getGoodsType("model.goods.food"), "buildColony.noFood", new String[0]));
        }
        for (Map.Entry entry : goodsMap.entrySet()) {
            if (((GoodsType)entry.getKey()).isFoodType() || (Integer)entry.getValue() >= 4) continue;
            messages.add(new ModelMessage((FreeColGameObject)unit, ModelMessage.MessageType.MISSING_GOODS, (FreeColObject)entry.getKey(), "buildColony.noBuildingMaterials", "%goods%", ((GoodsType)entry.getKey()).getName()));
        }
        if (ownedBySelf) {
            messages.add(new ModelMessage((FreeColGameObject)unit, ModelMessage.MessageType.WARNING, null, "buildColony.ownLand", new String[0]));
        }
        if (ownedByEuropeans) {
            messages.add(new ModelMessage((FreeColGameObject)unit, ModelMessage.MessageType.WARNING, null, "buildColony.EuropeanLand", new String[0]));
        }
        if (ownedByIndians) {
            messages.add(new ModelMessage((FreeColGameObject)unit, ModelMessage.MessageType.WARNING, null, "buildColony.IndianLand", new String[0]));
        }
        if (messages.isEmpty()) {
            return true;
        }
        ModelMessage[] modelMessageArray = messages.toArray(new ModelMessage[messages.size()]);
        return this.freeColClient.getCanvas().showConfirmDialog(modelMessageArray, "buildColony.yes", "buildColony.no");
    }

    public void moveActiveUnit(Map.Direction direction) {
        Unit unit = this.freeColClient.getGUI().getActiveUnit();
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        if (unit != null) {
            this.clearGotoOrders(unit);
            this.move(unit, direction);
            boolean alwaysCenter = this.freeColClient.getClientOptions().getBoolean("model.option.alwaysCenter");
            if (alwaysCenter && unit.getTile() != null) {
                this.centerOnUnit(unit);
            }
        }
    }

    public void selectDestination(Unit unit) {
        final Player player = this.freeColClient.getMyPlayer();
        Map map = this.freeColClient.getGame().getMap();
        final ArrayList<ChoiceItem> destinations = new ArrayList<ChoiceItem>();
        if (unit.isNaval() && unit.getOwner().canMoveToEurope()) {
            PathNode path = map.findPathToEurope(unit, unit.getTile());
            if (path != null) {
                int turns = path.getTotalTurns();
                destinations.add(new ChoiceItem(player.getEurope().getName() + " (" + turns + ")", player.getEurope()));
            } else if (unit.getTile() != null && (unit.getTile().canMoveToEurope() || map.isAdjacentToMapEdge(unit.getTile()))) {
                destinations.add(new ChoiceItem(player.getEurope().getName() + " (0)", player.getEurope()));
            }
        }
        final Settlement inSettlement = unit.getTile() != null ? unit.getTile().getSettlement() : null;
        map.search(unit, new GoalDecider(){

            public PathNode getGoal() {
                return null;
            }

            public boolean check(Unit u, PathNode p) {
                if (p.getTile().getSettlement() != null && p.getTile().getSettlement().getOwner() == player && p.getTile().getSettlement() != inSettlement) {
                    Settlement s = p.getTile().getSettlement();
                    int turns = p.getTurns();
                    destinations.add(new ChoiceItem(s.toString() + " (" + turns + ")", s));
                }
                return false;
            }

            public boolean hasSubGoals() {
                return false;
            }
        }, Integer.MAX_VALUE);
        Canvas canvas = this.freeColClient.getCanvas();
        ChoiceItem choice = (ChoiceItem)canvas.showChoiceDialog(Messages.message("selectDestination.text", new String[0]), Messages.message("selectDestination.cancel", new String[0]), destinations.toArray(new ChoiceItem[destinations.size()]));
        if (choice == null) {
            return;
        }
        Location destination = (Location)choice.getObject();
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.setDestination(unit, destination);
            return;
        }
        if (destination instanceof Europe && unit.getTile() != null && (unit.getTile().canMoveToEurope() || map.isAdjacentToMapEdge(unit.getTile()))) {
            this.moveToEurope(unit);
            this.nextActiveUnit();
        } else {
            this.setDestination(unit, destination);
            this.moveToDestination(unit);
        }
    }

    public void setDestination(Unit unit, Location destination) {
        Element setDestinationElement = Message.createNewRootElement("setDestination");
        setDestinationElement.setAttribute("unit", unit.getId());
        if (destination != null) {
            setDestinationElement.setAttribute("destination", destination.getId());
        }
        unit.setDestination(destination);
        this.freeColClient.getClient().sendAndWait(setDestinationElement);
    }

    public void moveToDestination(Unit unit) {
        Canvas canvas = this.freeColClient.getCanvas();
        Map map = this.freeColClient.getGame().getMap();
        Location destination = unit.getDestination();
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            canvas.showInformationMessage("notYourTurn");
            return;
        }
        if (unit.getTradeRoute() != null) {
            TradeRoute.Stop currStop = unit.getCurrentStop();
            if (!TradeRoute.isStopValid(unit, currStop)) {
                String oldTradeRouteName = unit.getTradeRoute().getName();
                logger.info("Trade unit " + unit.getId() + " in route " + oldTradeRouteName + " cannot continue, stop invalid");
                this.freeColClient.getCanvas().showInformationMessage("traderoute.broken", "%name%", oldTradeRouteName);
                this.clearOrders(unit);
                return;
            }
            if (unit.getLocation().getTile() == currStop.getLocation().getTile()) {
                logger.info("Trade unit " + unit.getId() + " in route " + unit.getTradeRoute().getName() + " is at " + unit.getCurrentStop().getLocation().getLocationName());
                this.followTradeRoute(unit);
                return;
            }
            logger.info("Unit " + unit.getId() + " is a trade unit in route " + unit.getTradeRoute().getName() + ", going to " + unit.getCurrentStop().getLocation().getLocationName());
        } else {
            logger.info("Moving unit " + unit.getId() + " to position " + unit.getDestination().getLocationName());
        }
        if (!(destination instanceof Europe || destination.getTile() != null && unit.getTile() != destination.getTile())) {
            this.clearGotoOrders(unit);
            return;
        }
        PathNode path = destination instanceof Europe ? map.findPathToEurope(unit, unit.getTile()) : map.findPath(unit, unit.getTile(), destination.getTile());
        if (path == null) {
            canvas.showInformationMessage("selectDestination.failed", unit, "%destination%", destination.getLocationName());
            this.setDestination(unit, null);
            return;
        }
        while (path != null) {
            Unit.MoveType mt = unit.getMoveType(path.getDirection());
            switch (mt) {
                case MOVE: {
                    this.reallyMove(unit, path.getDirection());
                    break;
                }
                case EXPLORE_LOST_CITY_RUMOUR: {
                    this.exploreLostCityRumour(unit, path.getDirection());
                    if (!unit.isDisposed()) break;
                    return;
                }
                case MOVE_HIGH_SEAS: {
                    if (destination instanceof Europe) {
                        this.moveToEurope(unit);
                        path = null;
                        break;
                    }
                    if (path == path.getLastNode()) {
                        this.move(unit, path.getDirection());
                        path = null;
                        break;
                    }
                    this.reallyMove(unit, path.getDirection());
                    break;
                }
                case DISEMBARK: {
                    this.disembark(unit, path.getDirection());
                    path = null;
                    break;
                }
                default: {
                    if (path == path.getLastNode() && mt != Unit.MoveType.ILLEGAL_MOVE && (mt != Unit.MoveType.ATTACK || this.knownEnemyOnLastTile(path))) {
                        this.move(unit, path.getDirection());
                        if (!unit.isDisposed()) break;
                        return;
                    }
                    Tile target = map.getNeighbourOrNull(path.getDirection(), unit.getTile());
                    if (unit.getMovesLeft() == 0 || unit.getMoveCost(target) > unit.getMovesLeft() && (target.getFirstUnit() == null || target.getFirstUnit().getOwner() == unit.getOwner()) && (target.getSettlement() == null || target.getSettlement().getOwner() == unit.getOwner())) {
                        unit.setMovesLeft(0);
                        this.nextActiveUnit();
                        return;
                    }
                    this.freeColClient.getGUI().setActiveUnit(unit);
                    return;
                }
            }
            if (path == null) continue;
            path = path.next;
        }
        if (unit.getTile() != null && destination instanceof Europe && map.isAdjacentToMapEdge(unit.getTile())) {
            this.moveToEurope(unit);
        }
        if (unit.getTradeRoute() == null) {
            this.setDestination(unit, null);
        } else {
            this.followTradeRoute(unit);
        }
        if (unit.canCarryTreasure() && this.checkCashInTreasureTrain(unit)) {
            unit = null;
        }
        if (unit != null && unit.getMovesLeft() > 0 && unit.getTile() != null) {
            this.freeColClient.getGUI().setActiveUnit(unit);
        } else if (this.freeColClient.getGUI().getActiveUnit() == unit) {
            this.nextActiveUnit();
        }
    }

    private boolean knownEnemyOnLastTile(PathNode path) {
        if (path != null && path.getLastNode() != null) {
            Tile tile = path.getLastNode().getTile();
            return tile.getFirstUnit() != null && tile.getFirstUnit().getOwner() != this.freeColClient.getMyPlayer() || tile.getSettlement() != null && tile.getSettlement().getOwner() != this.freeColClient.getMyPlayer();
        }
        return false;
    }

    private void checkTradeRoutesInEurope() {
        Europe europe = this.freeColClient.getMyPlayer().getEurope();
        if (europe == null) {
            return;
        }
        List<Unit> units = europe.getUnitList();
        for (Unit unit : units) {
            if (unit.getTradeRoute() == null || !unit.isInEurope()) continue;
            this.followTradeRoute(unit);
        }
    }

    private void followTradeRoute(Unit unit) {
        TradeRoute.Stop stop = unit.getCurrentStop();
        if (!TradeRoute.isStopValid(unit, stop)) {
            this.freeColClient.getCanvas().showInformationMessage("traderoute.broken", "%name%", unit.getTradeRoute().getName());
            return;
        }
        boolean inEurope = unit.isInEurope();
        if (this.freeColClient.getMyPlayer().getEurope() == stop.getLocation() && !inEurope) {
            return;
        }
        if (unit.getInitialMovesLeft() == unit.getMovesLeft()) {
            TradeRoute.Stop oldStop = unit.getCurrentStop();
            if (inEurope) {
                this.buyTradeGoodsFromEurope(unit);
            } else {
                this.loadTradeGoodsFromColony(unit);
            }
            this.updateCurrentStop(unit);
            if (oldStop.getLocation().getTile() == unit.getCurrentStop().getLocation().getTile()) {
                unit.setMovesLeft(0);
            }
        } else {
            logger.info("Trade unit " + unit.getId() + " in route " + unit.getTradeRoute().getName() + " arrives at " + unit.getCurrentStop().getLocation().getLocationName());
            if (inEurope) {
                this.sellTradeGoodsInEurope(unit);
            } else {
                this.unloadTradeGoodsToColony(unit);
            }
            unit.setMovesLeft(0);
        }
    }

    private void loadTradeGoodsFromColony(Unit unit) {
        TradeRoute.Stop stop = unit.getCurrentStop();
        Colony location = unit.getColony();
        logger.info("Trade unit " + unit.getId() + " loading in " + location.getLocationName());
        GoodsContainer warehouse = location.getGoodsContainer();
        if (warehouse == null) {
            throw new IllegalStateException("No warehouse in a stop's location");
        }
        ArrayList<GoodsType> goodsTypesToLoad = stop.getCargo();
        Iterator<Goods> goodsIterator = unit.getGoodsIterator();
        while (goodsIterator.hasNext()) {
            int amountPresent;
            int index;
            Goods goods = goodsIterator.next();
            if (goods.getAmount() >= 100 || (index = 0) >= goodsTypesToLoad.size()) continue;
            GoodsType goodsType = goodsTypesToLoad.get(index);
            ExportData exportData = unit.getColony().getExportData(goodsType);
            if (goods.getType() == goodsType && (amountPresent = warehouse.getGoodsCount(goodsType) - exportData.getExportLevel()) > 0) {
                logger.finest("Automatically loading goods " + goods.getName());
                int amountToLoad = Math.min(100 - goods.getAmount(), amountPresent);
                this.loadCargo(new Goods(this.freeColClient.getGame(), location, goods.getType(), amountToLoad), unit);
            }
            goodsTypesToLoad.remove(index);
        }
        for (GoodsType goodsType : goodsTypesToLoad) {
            if (unit.getSpaceLeft() == 0) break;
            ExportData exportData = unit.getColony().getExportData(goodsType);
            int amountPresent = warehouse.getGoodsCount(goodsType) - exportData.getExportLevel();
            if (amountPresent > 0) {
                logger.finest("Automatically loading goods " + goodsType.getName());
                this.loadCargo(new Goods(this.freeColClient.getGame(), location, goodsType, Math.min(amountPresent, 100)), unit);
                continue;
            }
            logger.finest("Can not load " + goodsType.getName() + " due to export settings.");
        }
    }

    private void unloadTradeGoodsToColony(Unit unit) {
        TradeRoute.Stop stop = unit.getCurrentStop();
        Colony location = unit.getColony();
        logger.info("Trade unit " + unit.getId() + " unloading in " + location.getLocationName());
        GoodsContainer warehouse = location.getGoodsContainer();
        if (warehouse == null) {
            throw new IllegalStateException("No warehouse in a stop's location");
        }
        ArrayList<GoodsType> goodsTypesToKeep = stop.getCargo();
        Iterator<Goods> goodsIterator = unit.getGoodsIterator();
        while (goodsIterator.hasNext()) {
            Goods goods = goodsIterator.next();
            boolean toKeep = false;
            for (int index = 0; index < goodsTypesToKeep.size(); ++index) {
                GoodsType goodsType = goodsTypesToKeep.get(index);
                if (goods.getType() != goodsType) continue;
                goodsTypesToKeep.remove(index);
                toKeep = true;
                break;
            }
            if (toKeep) continue;
            int capacity = location.getWarehouseCapacity() - warehouse.getGoodsCount(goods.getType());
            if (capacity < goods.getAmount() && !this.freeColClient.getCanvas().showConfirmDialog(Messages.message("traderoute.warehouseCapacity", "%unit%", unit.getName(), "%colony%", location.getName(), "%amount%", String.valueOf(goods.getAmount() - capacity), "%goods%", goods.getName()), "yes", "no", new String[0])) {
                logger.finest("Automatically unloading " + capacity + " " + goods.getName());
                this.unloadCargo(new Goods(this.freeColClient.getGame(), unit, goods.getType(), capacity));
                continue;
            }
            logger.finest("Automatically unloading " + goods.getAmount() + " " + goods.getName());
            this.unloadCargo(goods);
        }
    }

    private void sellTradeGoodsInEurope(Unit unit) {
        TradeRoute.Stop stop = unit.getCurrentStop();
        ArrayList<GoodsType> goodsTypesToLoad = stop.getCargo();
        Iterator<Goods> goodsIterator = unit.getGoodsIterator();
        while (goodsIterator.hasNext()) {
            Goods goods = goodsIterator.next();
            boolean toKeep = false;
            for (int index = 0; index < goodsTypesToLoad.size(); ++index) {
                GoodsType goodsType = goodsTypesToLoad.get(index);
                if (goods.getType() != goodsType) continue;
                goodsTypesToLoad.remove(index);
                toKeep = true;
                break;
            }
            if (toKeep) continue;
            logger.finest("Automatically unloading " + goods.getName());
            this.sellGoods(goods);
        }
    }

    private void buyTradeGoodsFromEurope(Unit unit) {
        TradeRoute.Stop stop = unit.getCurrentStop();
        ArrayList<GoodsType> goodsTypesToLoad = stop.getCargo();
        Iterator<Goods> goodsIterator = unit.getGoodsIterator();
        block0: while (goodsIterator.hasNext()) {
            Goods goods = goodsIterator.next();
            for (int index = 0; index < goodsTypesToLoad.size(); ++index) {
                GoodsType goodsType = goodsTypesToLoad.get(index);
                if (goods.getType() != goodsType) continue;
                if (goods.getAmount() < 100) {
                    logger.finest("Automatically loading goods " + goods.getName());
                    this.buyGoods(goods.getType(), 100 - goods.getAmount(), unit);
                }
                goodsTypesToLoad.remove(index);
                continue block0;
            }
        }
        for (GoodsType goodsType : goodsTypesToLoad) {
            if (unit.getSpaceLeft() <= 0) continue;
            logger.finest("Automatically loading goods " + goodsType.getName());
            this.buyGoods(goodsType, 100, unit);
        }
    }

    private void updateCurrentStop(Unit unit) {
        Element updateCurrentStopElement = Message.createNewRootElement("updateCurrentStop");
        updateCurrentStopElement.setAttribute("unit", unit.getId());
        this.freeColClient.getClient().sendAndWait(updateCurrentStopElement);
        TradeRoute.Stop stop = unit.nextStop();
        if (stop != null && stop.getLocation() != unit.getColony()) {
            if (unit.isInEurope()) {
                this.moveToAmerica(unit);
            } else {
                this.moveToDestination(unit);
            }
        }
    }

    public void move(Unit unit, Map.Direction direction) {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        Unit.MoveType move = unit.getMoveType(direction);
        switch (move) {
            case MOVE: {
                this.reallyMove(unit, direction);
                break;
            }
            case ATTACK: {
                this.attack(unit, direction);
                break;
            }
            case DISEMBARK: {
                this.disembark(unit, direction);
                break;
            }
            case EMBARK: {
                this.embark(unit, direction);
                break;
            }
            case MOVE_HIGH_SEAS: {
                this.moveHighSeas(unit, direction);
                break;
            }
            case ENTER_INDIAN_VILLAGE_WITH_SCOUT: {
                this.scoutIndianSettlement(unit, direction);
                break;
            }
            case ENTER_INDIAN_VILLAGE_WITH_MISSIONARY: {
                this.useMissionary(unit, direction);
                break;
            }
            case ENTER_INDIAN_VILLAGE_WITH_FREE_COLONIST: {
                this.learnSkillAtIndianSettlement(unit, direction);
                break;
            }
            case ENTER_FOREIGN_COLONY_WITH_SCOUT: {
                this.scoutForeignColony(unit, direction);
                break;
            }
            case ENTER_SETTLEMENT_WITH_CARRIER_AND_GOODS: {
                Map map = this.freeColClient.getGame().getMap();
                Settlement settlement = map.getNeighbourOrNull(direction, unit.getTile()).getSettlement();
                if (settlement instanceof Colony) {
                    this.negotiate(unit, direction);
                    break;
                }
                if (this.freeColClient.getGame().getCurrentPlayer().hasContacted(settlement.getOwner())) {
                    this.tradeWithSettlement(unit, direction);
                    break;
                }
                this.freeColClient.getCanvas().showInformationMessage("noContactWithIndians");
                break;
            }
            case EXPLORE_LOST_CITY_RUMOUR: {
                this.exploreLostCityRumour(unit, direction);
                break;
            }
            case ILLEGAL_MOVE: {
                this.freeColClient.playSound(SoundLibrary.SoundEffect.ILLEGAL_MOVE);
                break;
            }
            default: {
                throw new RuntimeException("unrecognised move: " + (Object)((Object)move));
            }
        }
        if (unit.canCarryTreasure()) {
            this.checkCashInTreasureTrain(unit);
            if (unit.isDisposed()) {
                this.nextActiveUnit();
            }
        }
        this.nextModelMessage();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InGameController.this.freeColClient.getActionManager().update();
                InGameController.this.freeColClient.getCanvas().updateJMenuBar();
            }
        });
    }

    private void negotiate(Unit unit, Map.Direction direction) {
        boolean isPlayersREF;
        Map map = this.freeColClient.getGame().getMap();
        Settlement settlement = map.getNeighbourOrNull(direction, unit.getTile()).getSettlement();
        Element spyElement = Message.createNewRootElement("spySettlement");
        spyElement.setAttribute("unit", unit.getId());
        spyElement.setAttribute("direction", String.valueOf((Object)direction));
        Element reply = this.freeColClient.getClient().ask(spyElement);
        if (reply == null) {
            throw new IllegalStateException("Received null response from server for a spySettlement message");
        }
        settlement.readFromXMLElement((Element)reply.getFirstChild());
        boolean bl = isPlayersREF = settlement.getOwner() == unit.getOwner().getREFPlayer();
        if (isPlayersREF) {
            throw new IllegalStateException("Scout tried to negociate with REF");
        }
        DiplomaticTrade agreement = this.freeColClient.getCanvas().showNegotiationDialog(unit, settlement, null);
        if (agreement != null) {
            unit.setMovesLeft(0);
            String nation = agreement.getRecipient().getNationAsString();
            reply = null;
            do {
                Element diplomaticElement = Message.createNewRootElement("diplomaticTrade");
                diplomaticElement.setAttribute("unit", unit.getId());
                diplomaticElement.setAttribute("direction", String.valueOf((Object)direction));
                diplomaticElement.appendChild(agreement.toXMLElement(null, diplomaticElement.getOwnerDocument()));
                reply = this.freeColClient.getClient().ask(diplomaticElement);
                if (reply != null) {
                    String accept = reply.getAttribute("accept");
                    if ("accept".equals(accept)) {
                        this.freeColClient.getCanvas().showInformationMessage("negotiationDialog.offerAccepted", "%nation%", nation);
                        agreement.makeTrade();
                        return;
                    }
                    Element childElement = (Element)reply.getFirstChild();
                    DiplomaticTrade proposal = new DiplomaticTrade(this.freeColClient.getGame(), childElement);
                    agreement = this.freeColClient.getCanvas().showNegotiationDialog(unit, settlement, proposal);
                    continue;
                }
                if (!agreement.isAccept()) continue;
                agreement.makeTrade();
                return;
            } while (reply != null);
            this.freeColClient.getCanvas().showInformationMessage("negotiationDialog.offerRejected", "%nation%", nation);
        }
    }

    private void spy(Unit unit, Map.Direction direction) {
        Game game = this.freeColClient.getGame();
        Colony colony = game.getMap().getNeighbourOrNull(direction, unit.getTile()).getColony();
        Element spyElement = Message.createNewRootElement("spySettlement");
        spyElement.setAttribute("unit", unit.getId());
        spyElement.setAttribute("direction", String.valueOf((Object)direction));
        Element reply = this.freeColClient.getClient().ask(spyElement);
        if (reply != null) {
            unit.setMovesLeft(0);
            NodeList childNodes = reply.getChildNodes();
            colony.readFromXMLElement((Element)childNodes.item(0));
            Tile tile = colony.getTile();
            for (int i = 1; i < childNodes.getLength(); ++i) {
                Element unitElement = (Element)childNodes.item(i);
                Unit foreignUnit = (Unit)game.getFreeColGameObject(unitElement.getAttribute("ID"));
                if (foreignUnit == null) {
                    foreignUnit = new Unit(game, unitElement);
                } else {
                    foreignUnit.readFromXMLElement(unitElement);
                }
                tile.add(foreignUnit);
            }
            this.freeColClient.getCanvas().showColonyPanel(colony);
        }
    }

    private void exploreLostCityRumour(Unit unit, Map.Direction direction) {
        this.freeColClient.getGUI().setFocusImmediately(unit.getTile().getPosition());
        if (this.freeColClient.getCanvas().showConfirmDialog("exploreLostCityRumour.text", "exploreLostCityRumour.yes", "exploreLostCityRumour.no", new String[0])) {
            this.reallyMove(unit, direction);
        }
    }

    public void buyLand(Tile tile) {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        Element buyLandElement = new BuyLandMessage(tile).toXMLElement();
        this.freeColClient.getMyPlayer().buyLand(tile);
        this.freeColClient.getClient().sendAndWait(buyLandElement);
        this.freeColClient.getCanvas().updateGoldLabel();
    }

    public void stealLand(Tile tile, Colony colony) {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        Element stealLandElement = new StealLandMessage(tile, colony).toXMLElement();
        this.freeColClient.getClient().sendAndWait(stealLandElement);
        tile.takeOwnership(this.freeColClient.getMyPlayer(), colony);
    }

    private void tradeWithSettlement(Unit unit, Map.Direction direction) {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        if (!unit.canCarryGoods()) {
            throw new IllegalArgumentException("The unit has to be able to carry goods in order to trade!");
        }
        Canvas canvas = this.freeColClient.getCanvas();
        Map map = this.freeColClient.getGame().getMap();
        Settlement settlement = map.getNeighbourOrNull(direction, unit.getTile()).getSettlement();
        if (settlement == null) {
            throw new IllegalArgumentException("No settlement in given direction!");
        }
        if (unit.getGoodsCount() == 0) {
            canvas.errorMessage("noGoodsOnboard");
            return;
        }
        int initialUnitMoves = unit.getMovesLeft();
        boolean actionTaken = false;
        java.util.Map<String, Boolean> transactionSession = this.getTransactionSession(unit, settlement);
        unit.setMovesLeft(0);
        boolean canBuy = transactionSession.get("canBuy") != false && unit.getSpaceLeft() != 0;
        boolean canSell = transactionSession.get("canSell");
        boolean canGift = transactionSession.get("canGift");
        ChoiceItem tradeType = canvas.showIndianSettlementTradeDlg(canBuy, canSell, canGift);
        while (tradeType != null) {
            boolean tradeFinished = false;
            switch (tradeType.getChoice()) {
                case 1: {
                    tradeFinished = this.attemptBuyFromIndianSettlement(unit, settlement);
                    if (!tradeFinished) break;
                    actionTaken = true;
                    canBuy = false;
                    break;
                }
                case 2: {
                    tradeFinished = this.attemptSellToIndianSettlement(unit, settlement);
                    if (!tradeFinished) break;
                    actionTaken = true;
                    canSell = false;
                    canBuy = transactionSession.get("canBuy") != false && unit.getSpaceLeft() != 0;
                    break;
                }
                case 3: {
                    tradeFinished = this.deliverGiftToSettlement(unit, settlement, null);
                    if (!tradeFinished) break;
                    actionTaken = true;
                    canGift = false;
                    break;
                }
                default: {
                    logger.warning("Unkown trade type");
                }
            }
            if (!canBuy && !canSell && !canGift) break;
            tradeType = canvas.showIndianSettlementTradeDlg(canBuy, canSell, canGift);
        }
        this.closeTransactionSession(unit, settlement);
        if (!actionTaken) {
            unit.setMovesLeft(initialUnitMoves);
        }
    }

    private java.util.Map<String, Boolean> getTransactionSession(Unit unit, Settlement settlement) {
        Element transactionElement = Message.createNewRootElement("getTransaction");
        transactionElement.setAttribute("unit", unit.getId());
        transactionElement.setAttribute("settlement", settlement.getId());
        Client client = this.freeColClient.getClient();
        Element reply = client.ask(transactionElement);
        if (reply == null || !reply.getTagName().equals("getTransactionAnswer")) {
            logger.warning("Illegal reply to getTransaction.");
            throw new IllegalStateException();
        }
        HashMap<String, Boolean> transactionSession = new HashMap<String, Boolean>();
        transactionSession.put("canBuy", new Boolean(reply.getAttribute("canBuy")));
        transactionSession.put("canSell", new Boolean(reply.getAttribute("canSell")));
        transactionSession.put("canGift", new Boolean(reply.getAttribute("canGift")));
        return transactionSession;
    }

    private void closeTransactionSession(Unit unit, Settlement settlement) {
        Element transactionElement = Message.createNewRootElement("closeTransaction");
        transactionElement.setAttribute("unit", unit.getId());
        transactionElement.setAttribute("settlement", settlement.getId());
        this.freeColClient.getClient().ask(transactionElement);
    }

    private ArrayList<Goods> getGoodsForSaleInIndianSettlement(Unit unit, Settlement settlement) {
        Element goodsForSaleElement = Message.createNewRootElement("goodsForSale");
        goodsForSaleElement.setAttribute("unit", unit.getId());
        goodsForSaleElement.setAttribute("settlement", settlement.getId());
        Client client = this.freeColClient.getClient();
        Element reply = client.ask(goodsForSaleElement);
        if (reply == null || !reply.getTagName().equals("goodsForSaleAnswer")) {
            logger.warning("Illegal reply to goodsForSale.");
            throw new IllegalStateException();
        }
        ArrayList<Goods> goodsOffered = new ArrayList<Goods>();
        NodeList childNodes = reply.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            goodsOffered.add(new Goods(this.freeColClient.getGame(), (Element)childNodes.item(i)));
        }
        return goodsOffered;
    }

    private boolean attemptBuyFromIndianSettlement(Unit unit, Settlement settlement) {
        Canvas canvas = this.freeColClient.getCanvas();
        ArrayList<Goods> goodsOffered = this.getGoodsForSaleInIndianSettlement(unit, settlement);
        Client client = this.freeColClient.getClient();
        ChoiceItem choice = null;
        block4: do {
            if ((choice = (ChoiceItem)canvas.showChoiceDialog(Messages.message("buyProposition.text", new String[0]), Messages.message("buyProposition.cancel", new String[0]), goodsOffered.iterator())) == null) {
                return false;
            }
            Goods goods = (Goods)choice.getObject();
            Element buyPropositionElement = Message.createNewRootElement("buyProposition");
            buyPropositionElement.setAttribute("unit", unit.getId());
            buyPropositionElement.appendChild(goods.toXMLElement(null, buyPropositionElement.getOwnerDocument()));
            Element proposalReply = client.ask(buyPropositionElement);
            block5: while (proposalReply != null) {
                if (!proposalReply.getTagName().equals("buyPropositionAnswer")) {
                    logger.warning("Illegal reply.");
                    throw new IllegalStateException();
                }
                int gold = Integer.parseInt(proposalReply.getAttribute("gold"));
                if (gold <= -1) {
                    canvas.showInformationMessage("noTrade");
                    return true;
                }
                String text = Messages.message("buy.text", "%nation%", settlement.getOwner().getNationAsString(), "%goods%", goods.getName(), "%gold%", Integer.toString(gold));
                ChoiceItem ci = (ChoiceItem)canvas.showChoiceDialog(text, Messages.message("buy.cancel", new String[0]), new ChoiceItem(Messages.message("buy.takeOffer", new String[0]), 1), new ChoiceItem(Messages.message("buy.moreGold", new String[0]), 2));
                if (ci == null) continue block4;
                switch (ci.getChoice()) {
                    case 1: {
                        this.buyFromSettlement(unit, (IndianSettlement)settlement, goods, gold);
                        return true;
                    }
                    case 2: {
                        int newPrice = gold * 9 / 10;
                        buyPropositionElement = Message.createNewRootElement("buyProposition");
                        buyPropositionElement.setAttribute("unit", unit.getId());
                        buyPropositionElement.appendChild(goods.toXMLElement(null, buyPropositionElement.getOwnerDocument()));
                        buyPropositionElement.setAttribute("gold", Integer.toString(newPrice));
                        proposalReply = client.ask(buyPropositionElement);
                        continue block5;
                    }
                }
                logger.warning("Unknown choice for buying goods from Indian Settlement.");
                throw new IllegalStateException();
            }
        } while (choice != null);
        logger.warning("Unexpected situation");
        return false;
    }

    private boolean attemptSellToIndianSettlement(Unit unit, Settlement settlement) {
        Canvas canvas = this.freeColClient.getCanvas();
        ChoiceItem choice = (ChoiceItem)canvas.showChoiceDialog(Messages.message("tradeProposition.text", new String[0]), Messages.message("tradeProposition.cancel", new String[0]), unit.getGoodsIterator());
        if (choice == null) {
            return false;
        }
        Client client = this.freeColClient.getClient();
        Goods goods = (Goods)choice.getObject();
        Element tradePropositionElement = Message.createNewRootElement("tradeProposition");
        tradePropositionElement.setAttribute("unit", unit.getId());
        tradePropositionElement.setAttribute("settlement", settlement.getId());
        tradePropositionElement.appendChild(goods.toXMLElement(null, tradePropositionElement.getOwnerDocument()));
        Element reply = client.ask(tradePropositionElement);
        while (reply != null) {
            if (!reply.getTagName().equals("tradePropositionAnswer")) {
                logger.warning("Illegal reply.");
                throw new IllegalStateException();
            }
            int gold = Integer.parseInt(reply.getAttribute("gold"));
            if (gold == 0) {
                canvas.showInformationMessage("noNeedForTheGoods", "%goods%", goods.getName());
                return true;
            }
            if (gold <= -1) {
                canvas.showInformationMessage("noTrade");
                return true;
            }
            String text = Messages.message("trade.text", "%nation%", settlement.getOwner().getNationAsString(), "%goods%", goods.getName(), "%gold%", Integer.toString(gold));
            ChoiceItem offerReply = (ChoiceItem)canvas.showChoiceDialog(text, Messages.message("trade.cancel", new String[0]), new ChoiceItem(Messages.message("trade.takeOffer", new String[0]), 1), new ChoiceItem(Messages.message("trade.moreGold", new String[0]), 2), new ChoiceItem(Messages.message("trade.gift", "%goods%", goods.getName()), 0));
            if (offerReply == null) {
                return false;
            }
            switch (offerReply.getChoice()) {
                case 0: {
                    this.deliverGiftToSettlement(unit, settlement, goods);
                    return true;
                }
                case 1: {
                    this.sellToSettlement(unit, settlement, goods, gold);
                    return true;
                }
                case 2: {
                    gold = gold * 11 / 10;
                    break;
                }
                default: {
                    logger.warning("Unknon player reply to indian proposal for goods sale");
                    return false;
                }
            }
            tradePropositionElement = Message.createNewRootElement("tradeProposition");
            tradePropositionElement.setAttribute("unit", unit.getId());
            tradePropositionElement.setAttribute("settlement", settlement.getId());
            tradePropositionElement.appendChild(goods.toXMLElement(null, tradePropositionElement.getOwnerDocument()));
            tradePropositionElement.setAttribute("gold", Integer.toString(gold));
            reply = client.ask(tradePropositionElement);
        }
        logger.warning("Request for indian proposal for goods sale was null");
        return false;
    }

    private void sellToSettlement(Unit unit, Settlement settlement, Goods goods, int gold) {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        Element tradeElement = Message.createNewRootElement("trade");
        tradeElement.setAttribute("unit", unit.getId());
        tradeElement.setAttribute("settlement", settlement.getId());
        tradeElement.setAttribute("gold", Integer.toString(gold));
        tradeElement.appendChild(goods.toXMLElement(null, tradeElement.getOwnerDocument()));
        Client client = this.freeColClient.getClient();
        Element reply = client.ask(tradeElement);
        unit.trade(settlement, goods, gold);
        this.freeColClient.getCanvas().updateGoldLabel();
    }

    private void buyFromSettlement(Unit unit, IndianSettlement settlement, Goods goods, int gold) {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        Element buyElement = Message.createNewRootElement("buy");
        buyElement.setAttribute("unit", unit.getId());
        buyElement.setAttribute("gold", Integer.toString(gold));
        buyElement.appendChild(goods.toXMLElement(null, buyElement.getOwnerDocument()));
        Client client = this.freeColClient.getClient();
        client.ask(buyElement);
        settlement.add(goods);
        unit.buy(settlement, goods, gold);
        this.freeColClient.getCanvas().updateGoldLabel();
    }

    private boolean deliverGiftToSettlement(Unit unit, Settlement settlement, Goods goods) {
        Canvas canvas = this.freeColClient.getCanvas();
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            canvas.showInformationMessage("notYourTurn");
            return false;
        }
        if (goods == null) {
            ChoiceItem choice = (ChoiceItem)canvas.showChoiceDialog(Messages.message("gift.text", new String[0]), Messages.message("tradeProposition.cancel", new String[0]), unit.getGoodsIterator());
            if (choice == null) {
                return false;
            }
            goods = (Goods)choice.getObject();
        }
        Element deliverGiftElement = Message.createNewRootElement("deliverGift");
        deliverGiftElement.setAttribute("unit", unit.getId());
        deliverGiftElement.setAttribute("settlement", settlement.getId());
        deliverGiftElement.appendChild(goods.toXMLElement(null, deliverGiftElement.getOwnerDocument()));
        Client client = this.freeColClient.getClient();
        client.sendAndWait(deliverGiftElement);
        unit.deliverGift(settlement, goods);
        return true;
    }

    public boolean checkCashInTreasureTrain(Unit unit) {
        Canvas canvas = this.freeColClient.getCanvas();
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            canvas.showInformationMessage("notYourTurn");
            return false;
        }
        Client client = this.freeColClient.getClient();
        if (unit.canCashInTreasureTrain()) {
            boolean cash;
            if (unit.getOwner().getEurope() == null) {
                canvas.showInformationMessage("cashInTreasureTrain.text.independence", "%nation%", unit.getOwner().getNationAsString());
                cash = true;
            } else {
                int transportFee = unit.getTransportFee();
                String message = transportFee == 0 ? "cashInTreasureTrain.text.free" : "cashInTreasureTrain.text.pay";
                cash = canvas.showConfirmDialog(message, "cashInTreasureTrain.yes", "cashInTreasureTrain.no", new String[0]);
            }
            if (cash) {
                Element cashInTreasureTrainElement = Message.createNewRootElement("cashInTreasureTrain");
                cashInTreasureTrainElement.setAttribute("unit", unit.getId());
                client.sendAndWait(cashInTreasureTrainElement);
                unit.cashInTreasureTrain();
                this.freeColClient.getCanvas().updateGoldLabel();
                return true;
            }
        }
        return false;
    }

    private void reallyMove(Unit unit, Map.Direction direction) {
        Region region;
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        Canvas canvas = this.freeColClient.getCanvas();
        Client client = this.freeColClient.getClient();
        Element moveElement = Message.createNewRootElement("move");
        moveElement.setAttribute("unit", unit.getId());
        moveElement.setAttribute("direction", direction.toString());
        if (!this.freeColClient.isHeadless()) {
            String key;
            String string = key = this.freeColClient.getMyPlayer() == unit.getOwner() ? "model.option.moveAnimationSpeed" : "model.option.enemyMoveAnimationSpeed";
            if (this.freeColClient.getClientOptions().getInteger(key) > 0) {
                new UnitMoveAnimation(canvas, unit, direction).animate();
            }
        }
        unit.move(direction);
        if (unit.getTile().isLand() && !unit.getOwner().isNewLandNamed()) {
            String newLandName = canvas.showInputDialog("newLand.text", unit.getOwner().getNewLandName(), "newLand.yes", null, new String[0]);
            unit.getOwner().setNewLandName(newLandName);
            Element setNewLandNameElement = Message.createNewRootElement("setNewLandName");
            setNewLandNameElement.setAttribute("newLandName", newLandName);
            client.sendAndWait(setNewLandNameElement);
            canvas.showEventDialog(0);
            unit.getOwner().getHistory().add(new HistoryEvent(unit.getGame().getTurn().getNumber(), HistoryEvent.Type.DISCOVER_NEW_WORLD, "%name%", newLandName));
            Player player = this.freeColClient.getMyPlayer();
            BuildColonyAction bca = (BuildColonyAction)this.freeColClient.getActionManager().getFreeColAction("buildColonyAction");
            KeyStroke keyStroke = bca.getAccelerator();
            player.addModelMessage(new ModelMessage((FreeColGameObject)player, ModelMessage.MessageType.TUTORIAL, player, "tutorial.buildColony", "%build_colony_key%", FreeColActionUI.getHumanKeyStrokeText(keyStroke), "%build_colony_menu_item%", Messages.message("unit.state.7", new String[0]), "%orders_menu_item%", Messages.message("menuBar.orders", new String[0])));
            this.nextModelMessage();
        }
        if ((region = unit.getTile().getDiscoverableRegion()) != null) {
            String name = null;
            if (region.isPacific()) {
                name = Messages.message("model.region.pacific", new String[0]);
                canvas.showEventDialog(5);
            } else if (unit.getGame().getGameOptions().getBoolean("model.option.explorationPoints")) {
                String defaultName = unit.getOwner().getDefaultRegionName(region.getType());
                name = this.freeColClient.getCanvas().showInputDialog("nameRegion.text", defaultName, "ok", "cancel", "%name%", region.getDisplayName());
                moveElement.setAttribute("regionName", name);
            }
            if (name != null) {
                this.freeColClient.getMyPlayer().getHistory().add(new HistoryEvent(this.freeColClient.getGame().getTurn().getNumber(), HistoryEvent.Type.DISCOVER_REGION, "%region%", name));
            }
        }
        Element reply = client.ask(moveElement);
        this.freeColClient.getInGameInputHandler().handle(client.getConnection(), reply);
        if (reply.hasAttribute("movesSlowed")) {
            unit.setMovesLeft(unit.getMovesLeft() - Integer.parseInt(reply.getAttribute("movesSlowed")));
            Unit slowedBy = (Unit)this.freeColClient.getGame().getFreeColGameObject(reply.getAttribute("slowedBy"));
            canvas.showInformationMessage("model.unit.slowed", slowedBy, "%unit%", unit.getName(), "%enemyUnit%", slowedBy.getName(), "%enemyNation%", slowedBy.getOwner().getNationAsString());
        }
        if (!unit.isDisposed()) {
            unit.setLocation(unit.getTile());
        }
        if (unit.getTile().getSettlement() != null && unit.isCarrier() && unit.getTradeRoute() == null && (unit.getDestination() == null || unit.getDestination().getTile() == unit.getTile())) {
            canvas.showColonyPanel((Colony)unit.getTile().getSettlement());
        } else if (unit.getMovesLeft() <= 0 || unit.isDisposed()) {
            this.nextActiveUnit(unit.getTile());
        }
        this.nextModelMessage();
    }

    private void attack(Unit unit, Map.Direction direction) {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        Tile target = this.freeColClient.getGame().getMap().getNeighbourOrNull(direction, unit.getTile());
        if (target.getSettlement() != null && target.getSettlement() instanceof IndianSettlement && unit.isArmed()) {
            IndianSettlement settlement = (IndianSettlement)target.getSettlement();
            switch (this.freeColClient.getCanvas().showArmedUnitIndianSettlementDialog(settlement)) {
                case INDIAN_SETTLEMENT_ATTACK: {
                    if (this.confirmHostileAction(unit, target) && this.confirmPreCombat(unit, target)) {
                        this.reallyAttack(unit, direction);
                    }
                    return;
                }
                case CANCEL: {
                    return;
                }
                case INDIAN_SETTLEMENT_TRIBUTE: {
                    Element demandMessage = Message.createNewRootElement("armedUnitDemandTribute");
                    demandMessage.setAttribute("unit", unit.getId());
                    demandMessage.setAttribute("direction", direction.toString());
                    Element reply = this.freeColClient.getClient().ask(demandMessage);
                    if (reply != null && reply.getTagName().equals("armedUnitDemandTributeResult")) {
                        String result = reply.getAttribute("result");
                        if (result.equals("agree")) {
                            String amount = reply.getAttribute("amount");
                            unit.getOwner().modifyGold(Integer.parseInt(amount));
                            this.freeColClient.getCanvas().updateGoldLabel();
                            this.freeColClient.getCanvas().showInformationMessage("scoutSettlement.tributeAgree", settlement, "%replace%", amount);
                        } else if (result.equals("disagree")) {
                            this.freeColClient.getCanvas().showInformationMessage("scoutSettlement.tributeDisagree", settlement);
                        }
                    } else {
                        logger.warning("Server gave an invalid reply to an armedUnitDemandTribute message");
                        return;
                    }
                    unit.setMovesLeft(0);
                    this.nextActiveUnit(unit.getTile());
                    break;
                }
                default: {
                    logger.warning("Incorrect response returned from Canvas.showArmedUnitIndianSettlementDialog()");
                    return;
                }
            }
        } else {
            if (this.confirmHostileAction(unit, target) && this.confirmPreCombat(unit, target)) {
                this.reallyAttack(unit, direction);
            }
            return;
        }
    }

    private boolean confirmHostileAction(Unit attacker, Tile target) {
        if (!attacker.hasAbility("model.ability.piracy")) {
            Player enemy;
            if (target.getSettlement() != null) {
                enemy = target.getSettlement().getOwner();
            } else {
                Unit defender = target.getDefendingUnit(attacker);
                if (defender == null) {
                    logger.warning("Attacking, but no defender - will try!");
                    return true;
                }
                if (defender.hasAbility("model.ability.piracy")) {
                    return true;
                }
                enemy = defender.getOwner();
            }
            if (attacker.getOwner().getStance(enemy) == null) {
                return true;
            }
            switch (attacker.getOwner().getStance(enemy)) {
                case CEASE_FIRE: {
                    return this.freeColClient.getCanvas().showConfirmDialog("model.diplomacy.attack.ceaseFire", "model.diplomacy.attack.confirm", "cancel", "%replace%", enemy.getNationAsString());
                }
                case PEACE: {
                    return this.freeColClient.getCanvas().showConfirmDialog("model.diplomacy.attack.peace", "model.diplomacy.attack.confirm", "cancel", "%replace%", enemy.getNationAsString());
                }
                case ALLIANCE: {
                    return this.freeColClient.getCanvas().showConfirmDialog("model.diplomacy.attack.alliance", "model.diplomacy.attack.confirm", "cancel", "%replace%", enemy.getNationAsString());
                }
                case WAR: {
                    logger.finest("Player at war, no confirmation needed");
                    return true;
                }
            }
            logger.warning("Unknown stance " + (Object)((Object)attacker.getOwner().getStance(enemy)));
            return true;
        }
        return true;
    }

    private boolean confirmPreCombat(Unit attacker, Tile target) {
        if (this.freeColClient.getClientOptions().getBoolean("model.option.guiShowPreCombat")) {
            Settlement settlementOrNull = target.getSettlement();
            Unit defenderOrNull = settlementOrNull != null ? null : target.getDefendingUnit(attacker);
            return this.freeColClient.getCanvas().showPreCombatDialog(attacker, defenderOrNull, settlementOrNull);
        }
        return true;
    }

    private void reallyAttack(Unit unit, Map.Direction direction) {
        Client client = this.freeColClient.getClient();
        Game game = this.freeColClient.getGame();
        Tile target = game.getMap().getNeighbourOrNull(direction, unit.getTile());
        Element attackElement = Message.createNewRootElement("attack");
        attackElement.setAttribute("unit", unit.getId());
        attackElement.setAttribute("direction", direction.toString());
        Element attackResultElement = client.ask(attackElement);
        if (attackResultElement != null && attackResultElement.getTagName().equals("attackResult")) {
            Element updateElement;
            Unit defender;
            CombatModel.CombatResultType result = Enum.valueOf(CombatModel.CombatResultType.class, attackResultElement.getAttribute("result"));
            int damage = Integer.parseInt(attackResultElement.getAttribute("damage"));
            int plunderGold = Integer.parseInt(attackResultElement.getAttribute("plunderGold"));
            Location repairLocation = (Location)((Object)game.getFreeColGameObjectSafely(attackResultElement.getAttribute("repairIn")));
            Element utElement = this.getChildElement(attackResultElement, Tile.getXMLElementTagName());
            if (utElement != null) {
                Tile updateTile = (Tile)game.getFreeColGameObject(utElement.getAttribute("ID"));
                updateTile.readFromXMLElement(utElement);
            }
            NodeList capturedGoods = attackResultElement.getElementsByTagName("capturedGoods");
            for (int i = 0; i < capturedGoods.getLength(); ++i) {
                Element goods = (Element)capturedGoods.item(i);
                GoodsType type = FreeCol.getSpecification().getGoodsType(goods.getAttribute("type"));
                int amount = Integer.parseInt(goods.getAttribute("amount"));
                unit.getGoodsContainer().addGoods(type, amount);
            }
            Element unitElement = this.getChildElement(attackResultElement, Unit.getXMLElementTagName());
            if (unitElement != null) {
                defender = (Unit)game.getFreeColGameObject(unitElement.getAttribute("ID"));
                if (defender == null) {
                    defender = new Unit(game, unitElement);
                } else {
                    defender.readFromXMLElement(unitElement);
                }
                defender.setLocation(target);
            } else {
                logger.log(Level.SEVERE, "Server reallyAttack did not return a defender!");
                defender = target.getDefendingUnit(unit);
                if (defender == null) {
                    throw new IllegalStateException("No defender available!");
                }
            }
            if (result == CombatModel.CombatResultType.DONE_SETTLEMENT) {
                this.freeColClient.playSound(SoundLibrary.SoundEffect.CAPTURED_BY_ARTILLERY);
            } else if (defender.isNaval() && result == CombatModel.CombatResultType.GREAT_WIN || unit.isNaval() && result == CombatModel.CombatResultType.GREAT_LOSS) {
                this.freeColClient.playSound(SoundLibrary.SoundEffect.SUNK);
            } else if (unit.isNaval()) {
                this.freeColClient.playSound(SoundLibrary.SoundEffect.ATTACK_NAVAL);
            } else if (unit.hasAbility("model.ability.bombard")) {
                this.freeColClient.playSound(SoundLibrary.SoundEffect.ATTACK_ARTILLERY);
            } else if (unit.isMounted()) {
                this.freeColClient.playSound(SoundLibrary.SoundEffect.ATTACK_DRAGOON);
            }
            try {
                game.getCombatModel().attack(unit, defender, new CombatModel.CombatResult(result, damage), plunderGold, repairLocation);
            }
            catch (Exception e) {
                LogRecord lr = new LogRecord(Level.WARNING, "Exception in reallyAttack");
                lr.setThrown(e);
                logger.log(lr);
            }
            Element convertElement = this.getChildElement(attackResultElement, "convert");
            if (convertElement != null) {
                unitElement = (Element)convertElement.getFirstChild();
                Unit convert = (Unit)game.getFreeColGameObject(unitElement.getAttribute("ID"));
                if (convert == null) {
                    convert = new Unit(game, unitElement);
                } else {
                    convert.readFromXMLElement(unitElement);
                }
                convert.setLocation(convert.getLocation());
                String nation = defender.getOwner().getNationAsString();
                ModelMessage message = new ModelMessage(convert, "model.unit.newConvertFromAttack", new String[][]{{"%nation%", nation}, {"%unit%", convert.getName()}}, ModelMessage.MessageType.UNIT_ADDED);
                this.freeColClient.getMyPlayer().addModelMessage(message);
                this.nextModelMessage();
            }
            if (defender.canCarryTreasure() && (result == CombatModel.CombatResultType.WIN || result == CombatModel.CombatResultType.GREAT_WIN)) {
                this.checkCashInTreasureTrain(defender);
            }
            if (!defender.isDisposed() && (result == CombatModel.CombatResultType.DONE_SETTLEMENT && unitElement != null || defender.getLocation() == null || !defender.isVisibleTo(this.freeColClient.getMyPlayer()))) {
                defender.dispose();
            }
            if ((updateElement = this.getChildElement(attackResultElement, "update")) != null) {
                this.freeColClient.getInGameInputHandler().handle(client.getConnection(), updateElement);
            }
            if (attackResultElement.getAttribute("indianCapitalBurned") != "") {
                Player indianPlayer = defender.getOwner();
                indianPlayer.surrenderTo(this.freeColClient.getMyPlayer());
                ModelMessage message = new ModelMessage(indianPlayer, "indianSettlement.capitalBurned", new String[][]{{"%nation%", indianPlayer.getNationAsString()}}, ModelMessage.MessageType.COMBAT_RESULT);
                this.freeColClient.getMyPlayer().addModelMessage(message);
                this.nextModelMessage();
            }
            if (unit.getMovesLeft() <= 0) {
                this.nextActiveUnit(unit.getTile());
            }
            this.freeColClient.getCanvas().refresh();
        } else {
            logger.log(Level.SEVERE, "Server returned null from reallyAttack!");
        }
    }

    private void disembark(Unit unit, Map.Direction direction) {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        if (!unit.isCarrier()) {
            throw new RuntimeException("Programming error: disembark called on non carrier.");
        }
        Canvas canvas = this.freeColClient.getCanvas();
        if (!canvas.showConfirmDialog("disembark.text", "disembark.yes", "disembark.no", new String[0])) {
            return;
        }
        Game game = this.freeColClient.getGame();
        Tile destinationTile = game.getMap().getNeighbourOrNull(direction, unit.getTile());
        unit.setStateToAllChildren(Unit.UnitState.ACTIVE);
        Unit toDisembark = unit.getFirstUnit();
        if (toDisembark.getMovesLeft() > 0) {
            if (destinationTile.hasLostCityRumour()) {
                this.exploreLostCityRumour(toDisembark, direction);
            } else {
                this.reallyMove(toDisembark, direction);
            }
        }
    }

    private void embark(Unit unit, Map.Direction direction) {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        Game game = this.freeColClient.getGame();
        Client client = this.freeColClient.getClient();
        GUI gui = this.freeColClient.getGUI();
        Canvas canvas = this.freeColClient.getCanvas();
        new UnitMoveAnimation(canvas, unit, direction).animate();
        Tile destinationTile = game.getMap().getNeighbourOrNull(direction, unit.getTile());
        Unit destinationUnit = null;
        if (destinationTile.getUnitCount() == 1) {
            destinationUnit = destinationTile.getFirstUnit();
        } else {
            ArrayList<Unit> choices = new ArrayList<Unit>();
            for (Unit nextUnit : destinationTile.getUnitList()) {
                if (nextUnit.getSpaceLeft() < unit.getType().getSpaceTaken()) continue;
                choices.add(nextUnit);
            }
            if (choices.size() == 1) {
                destinationUnit = (Unit)choices.get(0);
            } else {
                if (choices.size() == 0) {
                    throw new IllegalStateException();
                }
                ChoiceItem choice = (ChoiceItem)canvas.showChoiceDialog(Messages.message("embark.text", new String[0]), Messages.message("embark.cancel", new String[0]), choices.iterator());
                if (choice == null) {
                    return;
                }
                destinationUnit = (Unit)choice.getObject();
            }
        }
        unit.embark(destinationUnit);
        if (destinationUnit.getMovesLeft() > 0) {
            gui.setActiveUnit(destinationUnit);
        } else {
            this.nextActiveUnit(destinationUnit.getTile());
        }
        Element embarkElement = Message.createNewRootElement("embark");
        embarkElement.setAttribute("unit", unit.getId());
        embarkElement.setAttribute("direction", direction.toString());
        embarkElement.setAttribute("embarkOnto", destinationUnit.getId());
        client.sendAndWait(embarkElement);
    }

    public boolean boardShip(Unit unit, Unit carrier) {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            throw new IllegalStateException("Not your turn.");
        }
        if (unit == null) {
            logger.warning("unit == null");
            return false;
        }
        if (carrier == null) {
            logger.warning("Trying to load onto a non-existent carrier.");
            return false;
        }
        Client client = this.freeColClient.getClient();
        if (unit.isNaval()) {
            logger.warning("Trying to load a ship onto another carrier.");
            return false;
        }
        this.freeColClient.playSound(SoundLibrary.SoundEffect.LOAD_CARGO);
        Element boardShipElement = Message.createNewRootElement("boardShip");
        boardShipElement.setAttribute("unit", unit.getId());
        boardShipElement.setAttribute("carrier", carrier.getId());
        unit.boardShip(carrier);
        client.sendAndWait(boardShipElement);
        return true;
    }

    public void clearSpeciality(Unit unit) {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        UnitType newUnit = unit.getType().getDowngrade(UnitType.DowngradeType.CLEAR_SKILL);
        if (newUnit == null) {
            this.freeColClient.getCanvas().showInformationMessage("clearSpeciality.impossible", "%unit%", unit.getName());
            return;
        }
        if (unit.getLocation() instanceof Building && !((Building)unit.getLocation()).canAdd(newUnit)) {
            this.freeColClient.getCanvas().showInformationMessage("clearSpeciality.impossible", "%unit%", unit.getName());
            return;
        }
        if (!this.freeColClient.getCanvas().showConfirmDialog("clearSpeciality.areYouSure", "yes", "no", "%oldUnit%", unit.getName(), "%unit%", newUnit.getName())) {
            return;
        }
        Client client = this.freeColClient.getClient();
        Element clearSpecialityElement = Message.createNewRootElement("clearSpeciality");
        clearSpecialityElement.setAttribute("unit", unit.getId());
        unit.clearSpeciality();
        client.sendAndWait(clearSpecialityElement);
    }

    public void leaveShip(Unit unit) {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        Client client = this.freeColClient.getClient();
        unit.leaveShip();
        Element leaveShipElement = Message.createNewRootElement("leaveShip");
        leaveShipElement.setAttribute("unit", unit.getId());
        client.sendAndWait(leaveShipElement);
    }

    public void loadCargo(Goods goods, Unit carrier) {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        if (carrier == null) {
            throw new NullPointerException();
        }
        this.freeColClient.playSound(SoundLibrary.SoundEffect.LOAD_CARGO);
        Client client = this.freeColClient.getClient();
        goods.adjustAmount();
        Element loadCargoElement = Message.createNewRootElement("loadCargo");
        loadCargoElement.setAttribute("carrier", carrier.getId());
        loadCargoElement.appendChild(goods.toXMLElement(this.freeColClient.getMyPlayer(), loadCargoElement.getOwnerDocument()));
        goods.loadOnto(carrier);
        client.sendAndWait(loadCargoElement);
    }

    public void unloadCargo(Goods goods) {
        this.unloadCargo(goods, false);
    }

    public void unloadCargo(Goods goods, boolean dump) {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        if (!dump && goods.getLocation() instanceof Unit && ((Unit)goods.getLocation()).getLocation() instanceof Europe) {
            this.sellGoods(goods);
            return;
        }
        Client client = this.freeColClient.getClient();
        goods.adjustAmount();
        Element unloadCargoElement = Message.createNewRootElement("unloadCargo");
        unloadCargoElement.appendChild(goods.toXMLElement(this.freeColClient.getMyPlayer(), unloadCargoElement.getOwnerDocument()));
        if (!dump && goods.getLocation() instanceof Unit && ((Unit)goods.getLocation()).getColony() != null) {
            goods.unload();
        } else {
            goods.setLocation(null);
        }
        client.sendAndWait(unloadCargoElement);
    }

    public void buyGoods(GoodsType type, int amount, Unit carrier) {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        Client client = this.freeColClient.getClient();
        Player myPlayer = this.freeColClient.getMyPlayer();
        Canvas canvas = this.freeColClient.getCanvas();
        if (carrier == null) {
            throw new NullPointerException();
        }
        if (carrier.getOwner() != myPlayer || carrier.getSpaceLeft() <= 0 && carrier.getGoodsContainer().getGoodsCount(type) % 100 == 0) {
            return;
        }
        if (carrier.getSpaceLeft() <= 0) {
            amount = Math.min(amount, 100 - carrier.getGoodsContainer().getGoodsCount(type) % 100);
        }
        if (myPlayer.getMarket().getBidPrice(type, amount) > myPlayer.getGold()) {
            canvas.errorMessage("notEnoughGold");
            return;
        }
        this.freeColClient.playSound(SoundLibrary.SoundEffect.LOAD_CARGO);
        Element buyGoodsElement = Message.createNewRootElement("buyGoods");
        buyGoodsElement.setAttribute("carrier", carrier.getId());
        buyGoodsElement.setAttribute("type", type.getId());
        buyGoodsElement.setAttribute("amount", Integer.toString(amount));
        carrier.buyGoods(type, amount);
        this.freeColClient.getCanvas().updateGoldLabel();
        client.sendAndWait(buyGoodsElement);
    }

    public void sellGoods(Goods goods) {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        Client client = this.freeColClient.getClient();
        Player player = this.freeColClient.getMyPlayer();
        this.freeColClient.playSound(SoundLibrary.SoundEffect.SELL_CARGO);
        goods.adjustAmount();
        Element sellGoodsElement = Message.createNewRootElement("sellGoods");
        sellGoodsElement.appendChild(goods.toXMLElement(this.freeColClient.getMyPlayer(), sellGoodsElement.getOwnerDocument()));
        player.getMarket().sell(goods, player);
        this.freeColClient.getCanvas().updateGoldLabel();
        client.sendAndWait(sellGoodsElement);
    }

    public void setGoodsLevels(Colony colony, GoodsType goodsType) {
        Client client = this.freeColClient.getClient();
        ExportData data = colony.getExportData(goodsType);
        Element setGoodsLevelsElement = Message.createNewRootElement("setGoodsLevels");
        setGoodsLevelsElement.setAttribute("colony", colony.getId());
        setGoodsLevelsElement.appendChild(data.toXMLElement(colony.getOwner(), setGoodsLevelsElement.getOwnerDocument()));
        client.sendAndWait(setGoodsLevelsElement);
    }

    public void equipUnit(Unit unit, EquipmentType type, int amount) {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        if (amount == 0) {
            return;
        }
        Client client = this.freeColClient.getClient();
        Player myPlayer = this.freeColClient.getMyPlayer();
        Unit carrier = null;
        if (unit.isOnCarrier()) {
            carrier = (Unit)unit.getLocation();
            this.leaveShip(unit);
        }
        Element equipUnitElement = Message.createNewRootElement("equipUnit");
        equipUnitElement.setAttribute("unit", unit.getId());
        equipUnitElement.setAttribute("type", type.getId());
        equipUnitElement.setAttribute("amount", Integer.toString(amount));
        if (amount > 0) {
            for (AbstractGoods requiredGoods : type.getGoodsRequired()) {
                GoodsType goodsType = requiredGoods.getType();
                if (!unit.isInEurope() || myPlayer.canTrade(goodsType)) continue;
                this.payArrears(goodsType);
                if (myPlayer.canTrade(goodsType)) continue;
                return;
            }
            for (int count = 0; count < amount; ++count) {
                unit.equipWith(type);
            }
        } else {
            for (int count = 0; count > amount; --count) {
                unit.removeEquipment(type);
            }
        }
        this.freeColClient.getCanvas().updateGoldLabel();
        client.sendAndWait(equipUnitElement);
        if (unit.getLocation() instanceof Colony || unit.getLocation() instanceof Building || unit.getLocation() instanceof ColonyTile) {
            this.putOutsideColony(unit);
        } else if (carrier != null) {
            this.boardShip(unit, carrier);
        }
    }

    public void work(Unit unit, WorkLocation workLocation) {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        Client client = this.freeColClient.getClient();
        Element workElement = Message.createNewRootElement("work");
        workElement.setAttribute("unit", unit.getId());
        workElement.setAttribute("workLocation", workLocation.getId());
        unit.work(workLocation);
        client.sendAndWait(workElement);
    }

    public boolean putOutsideColony(Unit unit) {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            throw new IllegalStateException("Not your turn.");
        }
        if (!unit.getColony().canReducePopulation()) {
            throw new IllegalStateException("Can not reduce population.");
        }
        Element putOutsideColonyElement = Message.createNewRootElement("putOutsideColony");
        putOutsideColonyElement.setAttribute("unit", unit.getId());
        unit.putOutsideColony();
        Client client = this.freeColClient.getClient();
        client.sendAndWait(putOutsideColonyElement);
        return true;
    }

    public void changeWorkType(Unit unit, GoodsType workType) {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        Client client = this.freeColClient.getClient();
        Element changeWorkTypeElement = Message.createNewRootElement("changeWorkType");
        changeWorkTypeElement.setAttribute("unit", unit.getId());
        changeWorkTypeElement.setAttribute("workType", workType.getId());
        unit.setWorkType(workType);
        client.sendAndWait(changeWorkTypeElement);
    }

    public void changeWorkImprovementType(Unit unit, TileImprovementType improvementType) {
        Element improvementElement;
        int price;
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        if (!unit.checkSetState(Unit.UnitState.IMPROVING)) {
            return;
        }
        if ((improvementType.getId().equals("model.improvement.Road") || improvementType.getId().equals("model.improvement.Plow") || improvementType.getId().equals("model.improvement.ClearForest")) && (price = unit.getOwner().getLandPrice(unit.getTile())) > 0) {
            Player nation = unit.getTile().getOwner();
            ChoiceItem ci = (ChoiceItem)this.freeColClient.getCanvas().showChoiceDialog(Messages.message("indianLand.text", "%player%", nation.getName()), Messages.message("indianLand.cancel", new String[0]), new ChoiceItem(Messages.message("indianLand.pay", "%amount%", Integer.toString(price)), 1), new ChoiceItem(Messages.message("indianLand.take", new String[0]), 2));
            if (ci == null) {
                return;
            }
            if (ci.getChoice() == 1) {
                if (price > this.freeColClient.getMyPlayer().getGold()) {
                    this.freeColClient.getCanvas().errorMessage("notEnoughGold");
                    return;
                }
                this.buyLand(unit.getTile());
            }
        }
        Element changeWorkTypeElement = Message.createNewRootElement("workImprovement");
        changeWorkTypeElement.setAttribute("unit", unit.getId());
        changeWorkTypeElement.setAttribute("improvementType", improvementType.getId());
        Element reply = this.freeColClient.getClient().ask(changeWorkTypeElement);
        Element containerElement = this.getChildElement(reply, TileItemContainer.getXMLElementTagName());
        if (containerElement != null) {
            TileItemContainer container = (TileItemContainer)this.freeColClient.getGame().getFreeColGameObject(containerElement.getAttribute("ID"));
            if (container == null) {
                container = new TileItemContainer(this.freeColClient.getGame(), unit.getTile(), containerElement);
                unit.getTile().setTileItemContainer(container);
            } else {
                container.readFromXMLElement(containerElement);
            }
        }
        if ((improvementElement = this.getChildElement(reply, TileImprovement.getXMLElementTagName())) != null) {
            TileImprovement improvement = (TileImprovement)this.freeColClient.getGame().getFreeColGameObject(improvementElement.getAttribute("ID"));
            if (improvement == null) {
                improvement = new TileImprovement(this.freeColClient.getGame(), improvementElement);
                unit.getTile().add(improvement);
            } else {
                improvement.readFromXMLElement(improvementElement);
            }
            unit.work(improvement);
        }
    }

    public void assignTeacher(Unit student, Unit teacher) {
        Player player = this.freeColClient.getMyPlayer();
        if (this.freeColClient.getGame().getCurrentPlayer() != player) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        if (!student.canBeStudent(teacher)) {
            throw new IllegalStateException("Unit can not be student!");
        }
        if (!teacher.getColony().canTrain(teacher)) {
            throw new IllegalStateException("Unit can not be teacher!");
        }
        if (student.getOwner() != player) {
            throw new IllegalStateException("Student is not your unit!");
        }
        if (teacher.getOwner() != player) {
            throw new IllegalStateException("Teacher is not your unit!");
        }
        if (student.getColony() != teacher.getColony()) {
            throw new IllegalStateException("Student and teacher are not in the same colony!");
        }
        if (!(student.getLocation() instanceof WorkLocation)) {
            throw new IllegalStateException("Student is not in a WorkLocation!");
        }
        Element assignTeacherElement = Message.createNewRootElement("assignTeacher");
        assignTeacherElement.setAttribute("student", student.getId());
        assignTeacherElement.setAttribute("teacher", teacher.getId());
        if (student.getTeacher() != null) {
            student.getTeacher().setStudent(null);
        }
        student.setTeacher(teacher);
        if (teacher.getStudent() != null) {
            teacher.getStudent().setTeacher(null);
        }
        teacher.setStudent(student);
        this.freeColClient.getClient().sendAndWait(assignTeacherElement);
    }

    public void setCurrentlyBuilding(Colony colony, BuildableType type) {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        Client client = this.freeColClient.getClient();
        colony.setCurrentlyBuilding(type);
        Element setCurrentlyBuildingElement = Message.createNewRootElement("setCurrentlyBuilding");
        setCurrentlyBuildingElement.setAttribute("colony", colony.getId());
        setCurrentlyBuildingElement.setAttribute("type", type.getId());
        client.sendAndWait(setCurrentlyBuildingElement);
    }

    public void changeState(Unit unit, Unit.UnitState state) {
        Player enemy;
        Player myPlayer;
        Tile tile;
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        Client client = this.freeColClient.getClient();
        Game game = this.freeColClient.getGame();
        Canvas canvas = this.freeColClient.getCanvas();
        if (!unit.checkSetState(state)) {
            return;
        }
        if (state == Unit.UnitState.FORTIFYING && unit.isOffensiveUnit() && !unit.hasAbility("model.ability.piracy") && (tile = unit.getTile()) != null && tile.getOwningSettlement() != null && (myPlayer = unit.getOwner()) != (enemy = tile.getOwningSettlement().getOwner()) && myPlayer.getStance(enemy) != Player.Stance.ALLIANCE && !this.confirmHostileAction(unit, tile.getOwningSettlement().getTile())) {
            return;
        }
        unit.setState(state);
        Element changeStateElement = Message.createNewRootElement("changeState");
        changeStateElement.setAttribute("unit", unit.getId());
        changeStateElement.setAttribute("state", state.toString());
        client.sendAndWait(changeStateElement);
        if (!(this.freeColClient.getCanvas().isShowingSubPanel() || unit.getMovesLeft() != 0 && unit.getState() != Unit.UnitState.SENTRY && unit.getState() != Unit.UnitState.SKIPPED)) {
            this.nextActiveUnit();
        } else {
            this.freeColClient.getCanvas().refresh();
        }
    }

    public void clearOrders(Unit unit) {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        if (unit == null) {
            return;
        }
        if (unit.getState() == Unit.UnitState.IMPROVING) {
            ModelMessage message = new ModelMessage((FreeColGameObject)unit, ModelMessage.MessageType.WARNING, unit, "model.unit.confirmCancelWork", "%turns%", new Integer(unit.getWorkLeft()).toString());
            boolean cancelWork = this.freeColClient.getCanvas().showConfirmDialog(new ModelMessage[]{message}, "yes", "no");
            if (!cancelWork) {
                return;
            }
        }
        this.clearGotoOrders(unit);
        this.assignTradeRoute(unit, TradeRoute.NO_TRADE_ROUTE);
        this.changeState(unit, Unit.UnitState.ACTIVE);
    }

    public void clearGotoOrders(Unit unit) {
        if (unit == null) {
            return;
        }
        if (unit.getDestination() != null) {
            this.setDestination(unit, null);
        }
    }

    private void moveHighSeas(Unit unit, Map.Direction direction) {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        Canvas canvas = this.freeColClient.getCanvas();
        Map map = this.freeColClient.getGame().getMap();
        if (!unit.isAlreadyOnHighSea() && (unit.getTile() == null || canvas.showConfirmDialog("highseas.text", "highseas.yes", "highseas.no", new String[0]))) {
            this.moveToEurope(unit);
            this.nextActiveUnit();
        } else if (map.getNeighbourOrNull(direction, unit.getTile()) != null) {
            this.reallyMove(unit, direction);
        }
    }

    private void learnSkillAtIndianSettlement(Unit unit, Map.Direction direction) {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        Client client = this.freeColClient.getClient();
        Canvas canvas = this.freeColClient.getCanvas();
        Map map = this.freeColClient.getGame().getMap();
        IndianSettlement settlement = (IndianSettlement)map.getNeighbourOrNull(direction, unit.getTile()).getSettlement();
        if (!(settlement == null || settlement.getLearnableSkill() == null && settlement.hasBeenVisited())) {
            String skillName;
            unit.setMovesLeft(0);
            Element askSkill = Message.createNewRootElement("askSkill");
            askSkill.setAttribute("unit", unit.getId());
            askSkill.setAttribute("direction", direction.toString());
            Element reply = client.ask(askSkill);
            UnitType skill = null;
            if (reply.getTagName().equals("provideSkill")) {
                if (reply.hasAttribute("skill")) {
                    skill = FreeCol.getSpecification().getUnitType(reply.getAttribute("skill"));
                    skillName = skill.getName();
                } else {
                    skillName = null;
                }
            } else {
                logger.warning("Server gave an invalid reply to an askSkill message");
                return;
            }
            settlement.setLearnableSkill(skill);
            settlement.setVisited(unit.getOwner());
            if (skillName == null) {
                canvas.errorMessage("indianSettlement.noMoreSkill");
            } else if (!unit.getType().canBeUpgraded(skill, UnitType.UpgradeType.NATIVES)) {
                canvas.showInformationMessage("indianSettlement.cantLearnSkill", settlement, "%unit%", unit.getName(), "%skill%", skillName);
            } else {
                Element reply2;
                String result;
                Element learnSkill = Message.createNewRootElement("learnSkillAtSettlement");
                learnSkill.setAttribute("unit", unit.getId());
                learnSkill.setAttribute("direction", direction.toString());
                if (!canvas.showConfirmDialog("learnSkill.text", "learnSkill.yes", "learnSkill.no", "%replace%", skillName)) {
                    learnSkill.setAttribute("action", "cancel");
                }
                if ((result = (reply2 = this.freeColClient.getClient().ask(learnSkill)).getAttribute("result")).equals("die")) {
                    unit.dispose();
                    canvas.showInformationMessage("learnSkill.die");
                } else if (result.equals("leave")) {
                    canvas.showInformationMessage("learnSkill.leave");
                } else if (result.equals("success")) {
                    unit.setType(skill);
                    if (!settlement.isCapital()) {
                        settlement.setLearnableSkill(null);
                    }
                } else if (!result.equals("cancelled")) {
                    logger.warning("Server gave an invalid reply to an learnSkillAtSettlement message");
                }
            }
        } else if (unit.getDestination() != null) {
            this.setDestination(unit, null);
        }
        this.nextActiveUnit(unit.getTile());
    }

    private void scoutForeignColony(Unit unit, Map.Direction direction) {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        Canvas canvas = this.freeColClient.getCanvas();
        Map map = this.freeColClient.getGame().getMap();
        Tile tile = map.getNeighbourOrNull(direction, unit.getTile());
        Colony colony = tile.getColony();
        Canvas.ScoutAction userAction = canvas.showScoutForeignColonyDialog(colony, unit);
        switch (userAction) {
            case CANCEL: {
                break;
            }
            case FOREIGN_COLONY_ATTACK: {
                this.attack(unit, direction);
                break;
            }
            case FOREIGN_COLONY_NEGOTIATE: {
                this.negotiate(unit, direction);
                break;
            }
            case FOREIGN_COLONY_SPY: {
                this.spy(unit, direction);
                break;
            }
            default: {
                logger.warning("Incorrect response returned from Canvas.showScoutForeignColonyDialog()");
                return;
            }
        }
    }

    private void scoutIndianSettlement(Unit unit, Map.Direction direction) {
        UnitType skill;
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        Client client = this.freeColClient.getClient();
        Canvas canvas = this.freeColClient.getCanvas();
        Map map = this.freeColClient.getGame().getMap();
        Tile tile = map.getNeighbourOrNull(direction, unit.getTile());
        IndianSettlement settlement = (IndianSettlement)tile.getSettlement();
        int movesLeft = unit.getMovesLeft();
        unit.setMovesLeft(0);
        Element scoutMessage = Message.createNewRootElement("scoutIndianSettlement");
        scoutMessage.setAttribute("unit", unit.getId());
        scoutMessage.setAttribute("direction", direction.toString());
        scoutMessage.setAttribute("action", "basic");
        Element reply = client.ask(scoutMessage);
        if (reply.getTagName().equals("scoutIndianSettlementResult")) {
            skill = null;
            String skillStr = reply.getAttribute("skill");
            if (skillStr != null && !skillStr.equals("")) {
                skill = FreeCol.getSpecification().getUnitType(skillStr);
            }
        } else {
            logger.warning("Server gave an invalid reply to an askSkill message");
            return;
        }
        settlement.setLearnableSkill(skill);
        settlement.setWantedGoods(0, FreeCol.getSpecification().getGoodsType(reply.getAttribute("highlyWantedGoods")));
        settlement.setWantedGoods(1, FreeCol.getSpecification().getGoodsType(reply.getAttribute("wantedGoods1")));
        settlement.setWantedGoods(2, FreeCol.getSpecification().getGoodsType(reply.getAttribute("wantedGoods2")));
        settlement.setVisited(unit.getOwner());
        settlement.getOwner().setNumberOfSettlements(Integer.parseInt(reply.getAttribute("numberOfCamps")));
        this.freeColClient.getInGameInputHandler().update(reply);
        Canvas.ScoutAction userAction = canvas.showScoutIndianSettlementDialog(settlement);
        switch (userAction) {
            case INDIAN_SETTLEMENT_ATTACK: {
                scoutMessage.setAttribute("action", "attack");
                unit.setMovesLeft(movesLeft);
                client.sendAndWait(scoutMessage);
                if (this.confirmPreCombat(unit, tile)) {
                    this.reallyAttack(unit, direction);
                } else {
                    unit.setMovesLeft(0);
                }
                return;
            }
            case CANCEL: {
                scoutMessage.setAttribute("action", "cancel");
                client.sendAndWait(scoutMessage);
                return;
            }
            case INDIAN_SETTLEMENT_SPEAK: {
                scoutMessage.setAttribute("action", "speak");
                reply = client.ask(scoutMessage);
                break;
            }
            case INDIAN_SETTLEMENT_TRIBUTE: {
                scoutMessage.setAttribute("action", "tribute");
                reply = client.ask(scoutMessage);
                break;
            }
            default: {
                logger.warning("Incorrect response returned from Canvas.showScoutIndianSettlementDialog()");
                return;
            }
        }
        if (reply.getTagName().equals("scoutIndianSettlementResult")) {
            String result = reply.getAttribute("result");
            String action = scoutMessage.getAttribute("action");
            if (result.equals("die")) {
                unit.dispose();
                canvas.showInformationMessage("scoutSettlement.speakDie", settlement);
            } else if (action.equals("speak") && result.equals("tales")) {
                Element updateElement = this.getChildElement(reply, "update");
                if (updateElement != null) {
                    this.freeColClient.getInGameInputHandler().handle(client.getConnection(), updateElement);
                }
                canvas.showInformationMessage("scoutSettlement.speakTales", settlement);
            } else if (action.equals("speak") && result.equals("beads")) {
                String amount = reply.getAttribute("amount");
                unit.getOwner().modifyGold(Integer.parseInt(amount));
                this.freeColClient.getCanvas().updateGoldLabel();
                canvas.showInformationMessage("scoutSettlement.speakBeads", settlement, "%replace%", amount);
            } else if (action.equals("speak") && result.equals("nothing")) {
                canvas.showInformationMessage("scoutSettlement.speakNothing", settlement);
            } else if (action.equals("tribute") && result.equals("agree")) {
                String amount = reply.getAttribute("amount");
                unit.getOwner().modifyGold(Integer.parseInt(amount));
                this.freeColClient.getCanvas().updateGoldLabel();
                canvas.showInformationMessage("scoutSettlement.tributeAgree", settlement, "%replace%", amount);
            } else if (action.equals("tribute") && result.equals("disagree")) {
                canvas.showInformationMessage("scoutSettlement.tributeDisagree", settlement);
            }
        } else {
            logger.warning("Server gave an invalid reply to an scoutIndianSettlement message");
            return;
        }
        this.nextActiveUnit(unit.getTile());
    }

    private void useMissionary(Unit unit, Map.Direction direction) {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        Client client = this.freeColClient.getClient();
        Canvas canvas = this.freeColClient.getCanvas();
        Map map = this.freeColClient.getGame().getMap();
        IndianSettlement settlement = (IndianSettlement)map.getNeighbourOrNull(direction, unit.getTile()).getSettlement();
        List<Object> response = canvas.showUseMissionaryDialog(settlement);
        Canvas.MissionaryAction action = (Canvas.MissionaryAction)((Object)response.get(0));
        Element missionaryMessage = Message.createNewRootElement("missionaryAtSettlement");
        missionaryMessage.setAttribute("unit", unit.getId());
        missionaryMessage.setAttribute("direction", direction.toString());
        Element reply = null;
        unit.setMovesLeft(0);
        String success = "";
        switch (action) {
            case CANCEL: {
                missionaryMessage.setAttribute("action", "cancel");
                client.sendAndWait(missionaryMessage);
                break;
            }
            case ESTABLISH_MISSION: {
                missionaryMessage.setAttribute("action", "establish");
                reply = client.ask(missionaryMessage);
                if (!reply.getTagName().equals("missionaryReply")) {
                    logger.warning("Server gave an invalid reply to a missionaryAtSettlement message");
                    return;
                }
                success = reply.getAttribute("success");
                Tension.Level tension = Tension.Level.valueOf(reply.getAttribute("tension"));
                String missionResponse = null;
                String[] data = new String[]{"%nation%", settlement.getOwner().getNationAsString()};
                if (success.equals("true")) {
                    settlement.setMissionary(unit);
                    this.freeColClient.playSound(SoundLibrary.SoundEffect.MISSION_ESTABLISHED);
                    missionResponse = settlement.getResponseToMissionaryAttempt(tension, success);
                    canvas.showInformationMessage(missionResponse, settlement, data);
                } else {
                    missionResponse = settlement.getResponseToMissionaryAttempt(tension, success);
                    canvas.showInformationMessage(missionResponse, settlement, data);
                    unit.dispose();
                }
                this.nextActiveUnit();
                return;
            }
            case DENOUNCE_HERESY: {
                missionaryMessage.setAttribute("action", "heresy");
                reply = client.ask(missionaryMessage);
                if (!reply.getTagName().equals("missionaryReply")) {
                    logger.warning("Server gave an invalid reply to a missionaryAtSettlement message");
                    return;
                }
                success = reply.getAttribute("success");
                if (success.equals("true")) {
                    this.freeColClient.playSound(SoundLibrary.SoundEffect.MISSION_ESTABLISHED);
                    settlement.setMissionary(unit);
                    this.nextActiveUnit();
                } else {
                    unit.dispose();
                    this.nextActiveUnit();
                }
                return;
            }
            case INCITE_INDIANS: {
                missionaryMessage.setAttribute("action", "incite");
                missionaryMessage.setAttribute("incite", ((Player)response.get(1)).getId());
                reply = client.ask(missionaryMessage);
                if (reply.getTagName().equals("missionaryReply")) {
                    int amount = Integer.parseInt(reply.getAttribute("amount"));
                    boolean confirmed = canvas.showInciteDialog((Player)response.get(1), amount);
                    if (confirmed && unit.getOwner().getGold() < amount) {
                        canvas.showInformationMessage("notEnoughGold");
                        confirmed = false;
                    }
                    Element inciteMessage = Message.createNewRootElement("inciteAtSettlement");
                    inciteMessage.setAttribute("unit", unit.getId());
                    inciteMessage.setAttribute("direction", direction.toString());
                    inciteMessage.setAttribute("confirmed", confirmed ? "true" : "false");
                    inciteMessage.setAttribute("enemy", ((Player)response.get(1)).getId());
                    if (confirmed) {
                        Player briber = unit.getOwner();
                        Player indianNation = settlement.getOwner();
                        Player proposedEnemy = (Player)response.get(1);
                        briber.modifyGold(-amount);
                        indianNation.changeRelationWithPlayer(proposedEnemy, Player.Stance.WAR);
                    }
                    client.sendAndWait(inciteMessage);
                    break;
                }
                logger.warning("Server gave an invalid reply to a missionaryAtSettlement message");
                return;
            }
        }
        this.nextActiveUnit(unit.getTile());
    }

    public void moveToEurope(Unit unit) {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        Client client = this.freeColClient.getClient();
        unit.moveToEurope();
        Element moveToEuropeElement = Message.createNewRootElement("moveToEurope");
        moveToEuropeElement.setAttribute("unit", unit.getId());
        client.sendAndWait(moveToEuropeElement);
    }

    public void moveToAmerica(Unit unit) {
        boolean autoload;
        Canvas canvas = this.freeColClient.getCanvas();
        Player player = this.freeColClient.getMyPlayer();
        if (this.freeColClient.getGame().getCurrentPlayer() != player) {
            canvas.showInformationMessage("notYourTurn");
            return;
        }
        Client client = this.freeColClient.getClient();
        ClientOptions co = canvas.getClient().getClientOptions();
        if (unit.getLocation() instanceof Europe && (autoload = co.getBoolean("model.option.autoloadEmigrants"))) {
            int spaceLeft = unit.getSpaceLeft();
            ArrayList<Unit> unitsInEurope = new ArrayList<Unit>(unit.getLocation().getUnitList());
            for (Unit possiblePassenger : unitsInEurope) {
                if (possiblePassenger.isNaval()) continue;
                if (possiblePassenger.getType().getSpaceTaken() > spaceLeft) break;
                this.boardShip(possiblePassenger, unit);
                spaceLeft -= possiblePassenger.getType().getSpaceTaken();
            }
        }
        unit.moveToAmerica();
        Element moveToAmericaElement = Message.createNewRootElement("moveToAmerica");
        moveToAmericaElement.setAttribute("unit", unit.getId());
        client.sendAndWait(moveToAmericaElement);
    }

    public void trainUnitInEurope(UnitType unitType) {
        Unit unit;
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        Client client = this.freeColClient.getClient();
        Canvas canvas = this.freeColClient.getCanvas();
        Game game = this.freeColClient.getGame();
        Player myPlayer = this.freeColClient.getMyPlayer();
        Europe europe = myPlayer.getEurope();
        if (myPlayer.getGold() < europe.getUnitPrice(unitType)) {
            canvas.errorMessage("notEnoughGold");
            return;
        }
        Element trainUnitInEuropeElement = Message.createNewRootElement("trainUnitInEurope");
        trainUnitInEuropeElement.setAttribute("unitType", unitType.getId());
        Element reply = client.ask(trainUnitInEuropeElement);
        if (reply.getTagName().equals("trainUnitInEuropeConfirmed")) {
            Element unitElement = (Element)reply.getFirstChild();
            unit = (Unit)game.getFreeColGameObject(unitElement.getAttribute("ID"));
            if (unit == null) {
                unit = new Unit(game, unitElement);
            } else {
                unit.readFromXMLElement(unitElement);
            }
        } else {
            logger.warning("Could not train unit in europe.");
            return;
        }
        europe.train(unit);
        this.freeColClient.getCanvas().updateGoldLabel();
    }

    public void payForBuilding(Colony colony) {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        if (!this.freeColClient.getCanvas().showConfirmDialog("payForBuilding.text", "payForBuilding.yes", "payForBuilding.no", "%replace%", Integer.toString(colony.getPriceForBuilding()))) {
            return;
        }
        if (colony.getPriceForBuilding() > this.freeColClient.getMyPlayer().getGold()) {
            this.freeColClient.getCanvas().errorMessage("notEnoughGold");
            return;
        }
        Element payForBuildingElement = Message.createNewRootElement("payForBuilding");
        payForBuildingElement.setAttribute("colony", colony.getId());
        colony.payForBuilding();
        this.freeColClient.getClient().sendAndWait(payForBuildingElement);
    }

    public void recruitUnitInEurope(int slot) {
        Unit unit;
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        Client client = this.freeColClient.getClient();
        Canvas canvas = this.freeColClient.getCanvas();
        Game game = this.freeColClient.getGame();
        Player myPlayer = this.freeColClient.getMyPlayer();
        Europe europe = myPlayer.getEurope();
        if (myPlayer.getGold() < myPlayer.getRecruitPrice()) {
            canvas.errorMessage("notEnoughGold");
            return;
        }
        Element recruitUnitInEuropeElement = Message.createNewRootElement("recruitUnitInEurope");
        recruitUnitInEuropeElement.setAttribute("slot", Integer.toString(slot));
        Element reply = client.ask(recruitUnitInEuropeElement);
        if (reply.getTagName().equals("recruitUnitInEuropeConfirmed")) {
            Element unitElement = (Element)reply.getFirstChild();
            unit = (Unit)game.getFreeColGameObject(unitElement.getAttribute("ID"));
            if (unit == null) {
                unit = new Unit(game, unitElement);
            } else {
                unit.readFromXMLElement(unitElement);
            }
        } else {
            logger.warning("Could not recruit the specified unit in europe.");
            return;
        }
        String unitId = reply.getAttribute("newRecruitable");
        UnitType unitType = FreeCol.getSpecification().getUnitType(unitId);
        europe.recruit(slot, unit, unitType);
        this.freeColClient.getCanvas().updateGoldLabel();
    }

    private void emigrateUnitInEurope(int slot) {
        Element unitElement;
        Unit unit;
        Element reply;
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        Client client = this.freeColClient.getClient();
        Game game = this.freeColClient.getGame();
        Player myPlayer = this.freeColClient.getMyPlayer();
        Europe europe = myPlayer.getEurope();
        Element emigrateUnitInEuropeElement = Message.createNewRootElement("emigrateUnitInEurope");
        if (myPlayer.hasAbility("model.ability.selectRecruit")) {
            emigrateUnitInEuropeElement.setAttribute("slot", Integer.toString(slot));
        }
        if ((reply = client.ask(emigrateUnitInEuropeElement)) == null || !reply.getTagName().equals("emigrateUnitInEuropeConfirmed")) {
            logger.warning("Could not recruit unit: " + myPlayer.getCrosses() + "/" + myPlayer.getCrossesRequired());
            throw new IllegalStateException();
        }
        if (!myPlayer.hasAbility("model.ability.selectRecruit")) {
            slot = Integer.parseInt(reply.getAttribute("slot"));
        }
        if ((unit = (Unit)game.getFreeColGameObject((unitElement = (Element)reply.getFirstChild()).getAttribute("ID"))) == null) {
            unit = new Unit(game, unitElement);
        } else {
            unit.readFromXMLElement(unitElement);
        }
        String unitId = reply.getAttribute("newRecruitable");
        UnitType newRecruitable = FreeCol.getSpecification().getUnitType(unitId);
        europe.emigrate(slot, unit, newRecruitable);
        this.freeColClient.getCanvas().updateGoldLabel();
    }

    public void updateTradeRoute(TradeRoute route) {
        logger.finest("Entering method updateTradeRoute");
        Element tradeRouteElement = Message.createNewRootElement("updateTradeRoute");
        tradeRouteElement.appendChild(route.toXMLElement(null, tradeRouteElement.getOwnerDocument()));
        this.freeColClient.getClient().sendAndWait(tradeRouteElement);
    }

    public void setTradeRoutes(List<TradeRoute> routes) {
        Player myPlayer = this.freeColClient.getMyPlayer();
        myPlayer.setTradeRoutes(routes);
        Element tradeRoutesElement = Message.createNewRootElement("setTradeRoutes");
        for (TradeRoute route : routes) {
            Element routeElement = tradeRoutesElement.getOwnerDocument().createElement(TradeRoute.getXMLElementTagName());
            routeElement.setAttribute("id", route.getId());
            tradeRoutesElement.appendChild(routeElement);
        }
        this.freeColClient.getClient().sendAndWait(tradeRoutesElement);
    }

    public void assignTradeRoute(Unit unit) {
        this.assignTradeRoute(unit, this.freeColClient.getCanvas().showTradeRouteDialog(unit.getTradeRoute()));
    }

    public void assignTradeRoute(Unit unit, TradeRoute tradeRoute) {
        if (tradeRoute != null) {
            Element assignTradeRouteElement = Message.createNewRootElement("assignTradeRoute");
            assignTradeRouteElement.setAttribute("unit", unit.getId());
            if (tradeRoute == TradeRoute.NO_TRADE_ROUTE) {
                unit.setTradeRoute(null);
                this.freeColClient.getClient().sendAndWait(assignTradeRouteElement);
                this.setDestination(unit, null);
            } else {
                unit.setTradeRoute(tradeRoute);
                assignTradeRouteElement.setAttribute("tradeRoute", tradeRoute.getId());
                this.freeColClient.getClient().sendAndWait(assignTradeRouteElement);
                Location location = unit.getLocation();
                if (location instanceof Tile) {
                    location = ((Tile)location).getColony();
                }
                if (tradeRoute.getStops().get(0).getLocation() == location) {
                    this.followTradeRoute(unit);
                } else if (this.freeColClient.getGame().getCurrentPlayer() == this.freeColClient.getMyPlayer()) {
                    this.moveToDestination(unit);
                }
            }
        }
    }

    public void payArrears(Goods goods) {
        this.payArrears(goods.getType());
    }

    public void payArrears(GoodsType type) {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        Client client = this.freeColClient.getClient();
        Player player = this.freeColClient.getMyPlayer();
        int arrears = player.getArrears(type);
        if (player.getGold() >= arrears) {
            if (this.freeColClient.getCanvas().showConfirmDialog("model.europe.payArrears", "ok", "cancel", "%replace%", String.valueOf(arrears))) {
                player.modifyGold(-arrears);
                this.freeColClient.getCanvas().updateGoldLabel();
                player.resetArrears(type);
                Element payArrearsElement = Message.createNewRootElement("payArrears");
                payArrearsElement.setAttribute("goodsType", type.getId());
                client.sendAndWait(payArrearsElement);
            }
        } else {
            this.freeColClient.getCanvas().showInformationMessage("model.europe.cantPayArrears", "%amount%", String.valueOf(arrears));
        }
    }

    public void purchaseUnitFromEurope(UnitType unitType) {
        this.trainUnitInEurope(unitType);
    }

    public Element getForeignAffairsReport() {
        return this.freeColClient.getClient().ask(Message.createNewRootElement("foreignAffairs"));
    }

    public Element getHighScores() {
        return this.freeColClient.getClient().ask(Message.createNewRootElement("highScores"));
    }

    public Element getREFUnits() {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return null;
        }
        Element reply = this.freeColClient.getClient().ask(Message.createNewRootElement("getREFUnits"));
        return reply;
    }

    public void disbandActiveUnit() {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        GUI gui = this.freeColClient.getGUI();
        Unit unit = gui.getActiveUnit();
        Client client = this.freeColClient.getClient();
        if (unit == null) {
            return;
        }
        if (!this.freeColClient.getCanvas().showConfirmDialog("disbandUnit.text", "disbandUnit.yes", "disbandUnit.no", new String[0])) {
            return;
        }
        Element disbandUnit = Message.createNewRootElement("disbandUnit");
        disbandUnit.setAttribute("unit", unit.getId());
        unit.dispose();
        client.sendAndWait(disbandUnit);
        this.nextActiveUnit();
    }

    public void centerActiveUnit() {
        Unit activeUnit = this.freeColClient.getGUI().getActiveUnit();
        if (activeUnit == null) {
            return;
        }
        this.centerOnUnit(activeUnit);
    }

    public void centerOnUnit(Unit unit) {
        if (unit == null) {
            return;
        }
        Tile unitTile = unit.getTile();
        if (unitTile == null) {
            return;
        }
        this.freeColClient.getGUI().setFocus(unitTile.getPosition());
    }

    public void executeGotoOrders() {
        this.executeGoto = true;
        this.nextActiveUnit(null);
    }

    public void nextActiveUnit() {
        this.nextActiveUnit(null);
    }

    public void nextActiveUnit(Tile tile) {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        this.nextModelMessage();
        Canvas canvas = this.freeColClient.getCanvas();
        Player myPlayer = this.freeColClient.getMyPlayer();
        if (this.endingTurn || this.executeGoto) {
            while (!this.freeColClient.getCanvas().isShowingSubPanel() && myPlayer.hasNextGoingToUnit()) {
                Unit unit = myPlayer.getNextGoingToUnit();
                this.moveToDestination(unit);
                this.nextModelMessage();
                if (unit.getMovesLeft() <= 0) continue;
                if (this.endingTurn) {
                    unit.setMovesLeft(0);
                    continue;
                }
                return;
            }
            if (!myPlayer.hasNextGoingToUnit() && !this.freeColClient.getCanvas().isShowingSubPanel()) {
                if (this.endingTurn) {
                    canvas.getGUI().setActiveUnit(null);
                    this.endingTurn = false;
                    Element endTurnElement = Message.createNewRootElement("endTurn");
                    this.freeColClient.getClient().send(endTurnElement);
                    return;
                }
                this.executeGoto = false;
            }
        }
        GUI gui = this.freeColClient.getGUI();
        Unit nextActiveUnit = myPlayer.getNextActiveUnit();
        if (nextActiveUnit != null) {
            this.canAutoEndTurn = true;
            gui.setActiveUnit(nextActiveUnit);
        } else {
            nextActiveUnit = myPlayer.getNextGoingToUnit();
            if (nextActiveUnit != null) {
                this.moveToDestination(nextActiveUnit);
            } else if (tile != null) {
                Map.Position p = tile.getPosition();
                if (p != null) {
                    gui.setSelectedTile(p);
                }
                gui.setActiveUnit(null);
            } else {
                gui.setActiveUnit(null);
            }
            if (this.canAutoEndTurn && !this.endingTurn && this.freeColClient.getClientOptions().getBoolean("model.option.autoEndTurn")) {
                this.endTurn();
            }
        }
    }

    public synchronized void ignoreMessage(ModelMessage message, boolean flag) {
        String key = message.getSource().getId();
        String[] data = message.getData();
        for (int index = 0; index < data.length; index += 2) {
            if (!data[index].equals("%goods%")) continue;
            key = key + data[index + 1];
            break;
        }
        if (flag) {
            this.startIgnoringMessage(key, this.freeColClient.getGame().getTurn().getNumber());
        } else {
            this.stopIgnoringMessage(key);
        }
    }

    public void nextModelMessage() {
        this.displayModelMessages(false);
    }

    public void displayModelMessages(final boolean allMessages) {
        int thisTurn = this.freeColClient.getGame().getTurn().getNumber();
        final ArrayList<ModelMessage> messageList = new ArrayList<ModelMessage>();
        List<ModelMessage> inputList = allMessages ? this.freeColClient.getMyPlayer().getModelMessages() : this.freeColClient.getMyPlayer().getNewModelMessages();
        for (ModelMessage message : inputList) {
            if (this.shouldAllowMessage(message)) {
                if (message.getType() == ModelMessage.MessageType.WAREHOUSE_CAPACITY) {
                    Integer turn;
                    String key = message.getSource().getId();
                    String[] data = message.getData();
                    for (int index = 0; index < data.length; index += 2) {
                        if (!data[index].equals("%goods%")) continue;
                        key = key + data[index + 1];
                        break;
                    }
                    if ((turn = this.getTurnForMessageIgnored(key)) != null && turn == thisTurn - 1) {
                        this.startIgnoringMessage(key, thisTurn);
                        message.setBeenDisplayed(true);
                        continue;
                    }
                } else if (message.getType() == ModelMessage.MessageType.BUILDING_COMPLETED) {
                    this.freeColClient.playSound(SoundLibrary.SoundEffect.BUILDING_COMPLETE);
                } else if (message.getType() == ModelMessage.MessageType.FOREIGN_DIPLOMACY && message.getId().equals("EventPanel.MEETING_AZTEC")) {
                    this.freeColClient.playMusicOnce("aztec");
                }
                messageList.add(message);
            }
            message.setBeenDisplayed(true);
        }
        this.purgeOldMessagesFromMessagesToIgnore(thisTurn);
        final ModelMessage[] messages = messageList.toArray(new ModelMessage[0]);
        Runnable uiTask = new Runnable(){

            public void run() {
                Canvas canvas = InGameController.this.freeColClient.getCanvas();
                if (messageList.size() > 0) {
                    if (allMessages || messageList.size() > 5) {
                        canvas.addAsFrame(new ReportTurnPanel(canvas, messages));
                    } else {
                        canvas.showModelMessages(messages);
                    }
                }
                InGameController.this.freeColClient.getActionManager().update();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            uiTask.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(uiTask);
            }
            catch (InterruptedException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
    }

    private synchronized Integer getTurnForMessageIgnored(String key) {
        return this.messagesToIgnore.get(key);
    }

    private synchronized void startIgnoringMessage(String key, int turn) {
        logger.finer("Ignoring model message with key " + key);
        this.messagesToIgnore.put(key, new Integer(turn));
    }

    private synchronized void stopIgnoringMessage(String key) {
        logger.finer("Removing model message with key " + key + " from ignored messages.");
        this.messagesToIgnore.remove(key);
    }

    private synchronized void purgeOldMessagesFromMessagesToIgnore(int thisTurn) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (Map.Entry<String, Integer> entry : this.messagesToIgnore.entrySet()) {
            if (entry.getValue() >= thisTurn - 1) continue;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Removing old model message with key " + entry.getKey() + " from ignored messages.");
            }
            keysToRemove.add(entry.getKey());
        }
        for (String key : keysToRemove) {
            this.stopIgnoringMessage(key);
        }
    }

    private boolean shouldAllowMessage(ModelMessage message) {
        switch (message.getType()) {
            case DEFAULT: {
                return true;
            }
            case WARNING: {
                return this.freeColClient.getClientOptions().getBoolean("model.option.guiShowWarning");
            }
            case SONS_OF_LIBERTY: {
                return this.freeColClient.getClientOptions().getBoolean("model.option.guiShowSonsOfLiberty");
            }
            case GOVERNMENT_EFFICIENCY: {
                return this.freeColClient.getClientOptions().getBoolean("model.option.guiShowGovernmentEfficiency");
            }
            case WAREHOUSE_CAPACITY: {
                return this.freeColClient.getClientOptions().getBoolean("model.option.guiShowWarehouseCapacity");
            }
            case UNIT_IMPROVED: {
                return this.freeColClient.getClientOptions().getBoolean("model.option.guiShowUnitImproved");
            }
            case UNIT_DEMOTED: {
                return this.freeColClient.getClientOptions().getBoolean("model.option.guiShowUnitDemoted");
            }
            case UNIT_LOST: {
                return this.freeColClient.getClientOptions().getBoolean("model.option.guiShowUnitLost");
            }
            case UNIT_ADDED: {
                return this.freeColClient.getClientOptions().getBoolean("model.option.guiShowUnitAdded");
            }
            case BUILDING_COMPLETED: {
                return this.freeColClient.getClientOptions().getBoolean("model.option.guiShowBuildingCompleted");
            }
            case FOREIGN_DIPLOMACY: {
                return this.freeColClient.getClientOptions().getBoolean("model.option.guiShowForeignDiplomacy");
            }
            case MARKET_PRICES: {
                return this.freeColClient.getClientOptions().getBoolean("model.option.guiShowMarketPrices");
            }
            case MISSING_GOODS: {
                return this.freeColClient.getClientOptions().getBoolean("model.option.guiShowMissingGoods");
            }
            case TUTORIAL: {
                return this.freeColClient.getClientOptions().getBoolean("model.option.guiShowTutorial");
            }
        }
        return true;
    }

    public void endTurn() {
        if (this.freeColClient.getGame().getCurrentPlayer() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().showInformationMessage("notYourTurn");
            return;
        }
        this.endingTurn = true;
        this.canAutoEndTurn = false;
        this.nextActiveUnit(null);
    }

    protected Element getChildElement(Element element, String tagName) {
        NodeList n = element.getChildNodes();
        for (int i = 0; i < n.getLength(); ++i) {
            if (!((Element)n.item(i)).getTagName().equals(tagName)) continue;
            return (Element)n.item(i);
        }
        return null;
    }

    public void abandonColony(Colony colony) {
        if (colony == null) {
            return;
        }
        Client client = this.freeColClient.getClient();
        Element abandonColony = Message.createNewRootElement("abandonColony");
        abandonColony.setAttribute("colony", colony.getId());
        colony.getOwner().getHistory().add(new HistoryEvent(colony.getGame().getTurn().getNumber(), HistoryEvent.Type.ABANDON_COLONY, "%colony%", colony.getName()));
        colony.dispose();
        client.sendAndWait(abandonColony);
    }

    public StatisticsMessage getServerStatistics() {
        Element request = Message.createNewRootElement(StatisticsMessage.getXMLElementTagName());
        Element reply = this.freeColClient.getClient().ask(request);
        StatisticsMessage m = new StatisticsMessage(reply);
        return m;
    }
}

