/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InputHandler;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.animation.UnitMoveAnimation;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.VictoryPanel;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.util.Utils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class InGameInputHandler
extends InputHandler {
    private static final Logger logger = Logger.getLogger(InGameInputHandler.class.getName());

    public InGameInputHandler(FreeColClient freeColClient) {
        super(freeColClient);
    }

    public Element handle(Connection connection, Element element) {
        String type;
        Element reply = null;
        if (element != null) {
            type = element.getTagName();
            logger.log(Level.FINEST, "Received message " + type);
            if (type.equals("update")) {
                reply = this.update(element);
            } else if (type.equals("remove")) {
                reply = this.remove(element);
            } else if (type.equals("opponentMove")) {
                reply = this.opponentMove(element);
            } else if (type.equals("opponentAttack")) {
                reply = this.opponentAttack(element);
            } else if (type.equals("setCurrentPlayer")) {
                reply = this.setCurrentPlayer(element);
            } else if (type.equals("newTurn")) {
                reply = this.newTurn(element);
            } else if (type.equals("setDead")) {
                reply = this.setDead(element);
            } else if (type.equals("gameEnded")) {
                reply = this.gameEnded(element);
            } else if (type.equals("chat")) {
                reply = this.chat(element);
            } else if (type.equals("disconnect")) {
                reply = this.disconnect(element);
            } else if (type.equals("error")) {
                reply = this.error(element);
            } else if (type.equals("chooseFoundingFather")) {
                reply = this.chooseFoundingFather(element);
            } else if (type.equals("deliverGift")) {
                reply = this.deliverGift(element);
            } else if (type.equals("indianDemand")) {
                reply = this.indianDemand(element);
            } else if (type.equals("reconnect")) {
                reply = this.reconnect(element);
            } else if (type.equals("setAI")) {
                reply = this.setAI(element);
            } else if (type.equals("monarchAction")) {
                reply = this.monarchAction(element);
            } else if (type.equals("removeGoods")) {
                reply = this.removeGoods(element);
            } else if (type.equals("lostCityRumour")) {
                reply = this.lostCityRumour(element);
            } else if (type.equals("setStance")) {
                reply = this.setStance(element);
            } else if (type.equals("giveIndependence")) {
                reply = this.giveIndependence(element);
            } else if (type.equals("newConvert")) {
                reply = this.newConvert(element);
            } else if (type.equals("diplomaticTrade")) {
                reply = this.diplomaticTrade(element);
            } else if (type.equals("marketElement")) {
                reply = this.marketElement(element);
            } else if (type.equals("addPlayer")) {
                reply = this.addPlayer(element);
            } else {
                logger.warning("Message is of unsupported type \"" + type + "\".");
            }
        } else {
            throw new RuntimeException("Received empty (null) message! - should never happen");
        }
        logger.log(Level.FINEST, "Handled message " + type);
        return reply;
    }

    private Element reconnect(Element element) {
        logger.finest("Entered reconnect...");
        if (new ShowConfirmDialogSwingTask("reconnect.text", "reconnect.yes", "reconnect.no", new String[0]).confirm()) {
            logger.finest("User wants to reconnect, do it!");
            new ReconnectSwingTask().invokeLater();
        } else {
            logger.finest("No reconnect, quit.");
            this.getFreeColClient().quit();
        }
        return null;
    }

    public Element update(Element updateElement) {
        this.updateGameObjects(updateElement.getChildNodes());
        new RefreshCanvasSwingTask().invokeLater();
        return null;
    }

    private void updateGameObjects(NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            FreeColGameObject fcgo = this.getGame().getFreeColGameObjectSafely(element.getAttribute("ID"));
            if (fcgo != null) {
                fcgo.readFromXMLElement(element);
                continue;
            }
            logger.warning("Could not find 'FreeColGameObject' with ID: " + element.getAttribute("ID"));
        }
    }

    private Element remove(Element removeElement) {
        NodeList nodeList = removeElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            FreeColGameObject fcgo = this.getGame().getFreeColGameObject(element.getAttribute("ID"));
            if (fcgo != null) {
                fcgo.dispose();
                continue;
            }
            logger.warning("Could not find 'FreeColGameObject' with ID: " + element.getAttribute("ID"));
        }
        new RefreshCanvasSwingTask().invokeLater();
        return null;
    }

    private Element opponentMove(Element opponentMoveElement) {
        Map map = this.getGame().getMap();
        Map.Direction direction = Enum.valueOf(Map.Direction.class, opponentMoveElement.getAttribute("direction"));
        if (opponentMoveElement.hasAttribute("fromTile")) {
            String key;
            Unit unit = (Unit)this.getGame().getFreeColGameObjectSafely(opponentMoveElement.getAttribute("unit"));
            if (unit == null) {
                throw new IllegalStateException("Could not find the 'unit' in 'opponentMove'. Unit ID: " + opponentMoveElement.getAttribute("unit"));
            }
            Tile fromTile = (Tile)this.getGame().getFreeColGameObjectSafely(opponentMoveElement.getAttribute("fromTile"));
            if (fromTile == null) {
                throw new IllegalStateException("Ignoring opponentMove, unit " + unit.getId() + " has no tile!");
            }
            Tile toTile = map.getNeighbourOrNull(direction, fromTile);
            if (toTile == null) {
                throw new IllegalStateException("Destination tile is null!");
            }
            String string = key = this.getFreeColClient().getMyPlayer() == unit.getOwner() ? "model.option.moveAnimationSpeed" : "model.option.enemyMoveAnimationSpeed";
            if (this.getFreeColClient().getClientOptions().getInteger(key) > 0) {
                try {
                    new UnitMoveAnimationCanvasSwingTask(unit, toTile).invokeAndWait();
                }
                catch (InvocationTargetException exception) {
                    logger.warning("UnitMoveAnimationCanvasSwingTask raised " + exception.toString());
                }
            } else {
                new RefreshTilesSwingTask(unit.getTile(), toTile).invokeLater();
            }
            if (this.getFreeColClient().getMyPlayer().canSee(toTile)) {
                unit.moveToTile(toTile);
            } else {
                unit.dispose();
            }
        } else {
            String key;
            String tileID = opponentMoveElement.getAttribute("toTile");
            Element unitElement = Message.getChildElement(opponentMoveElement, Unit.getXMLElementTagName());
            if (unitElement == null) {
                throw new NullPointerException("unitElement == null");
            }
            Unit u = (Unit)this.getGame().getFreeColGameObjectSafely(unitElement.getAttribute("ID"));
            if (u == null) {
                u = new Unit(this.getGame(), unitElement);
            } else {
                u.readFromXMLElement(unitElement);
            }
            Unit unit = u;
            if (opponentMoveElement.hasAttribute("inUnit")) {
                String inUnitID = opponentMoveElement.getAttribute("inUnit");
                Unit inUnit = (Unit)this.getGame().getFreeColGameObjectSafely(inUnitID);
                NodeList units = opponentMoveElement.getElementsByTagName(Unit.getXMLElementTagName());
                Element locationElement = null;
                for (int i = 0; i < units.getLength() && locationElement == null; ++i) {
                    Element element = (Element)units.item(i);
                    if (!element.getAttribute("ID").equals(inUnitID)) continue;
                    locationElement = element;
                }
                if (locationElement != null) {
                    if (inUnit == null) {
                        inUnit = new Unit(this.getGame(), locationElement);
                    } else {
                        inUnit.readFromXMLElement(locationElement);
                    }
                }
            }
            if (this.getGame().getFreeColGameObject(tileID) == null) {
                throw new IllegalStateException("Could not find tile with id: " + tileID);
            }
            Tile newTile = (Tile)this.getGame().getFreeColGameObject(tileID);
            if (unit.getLocation() == null) {
                Tile oldTile = map.getNeighbourOrNull(direction.getReverseDirection(), newTile);
                unit.setLocationNoUpdate(oldTile);
            }
            String string = key = this.getFreeColClient().getMyPlayer() == unit.getOwner() ? "model.option.moveAnimationSpeed" : "model.option.enemyMoveAnimationSpeed";
            if (this.getFreeColClient().getClientOptions().getInteger(key) > 0) {
                try {
                    new UnitMoveAnimationCanvasSwingTask(unit, newTile).invokeAndWait();
                }
                catch (InvocationTargetException exception) {
                    logger.warning("UnitMoveAnimationCanvasSwingTask raised " + exception.toString());
                }
            } else {
                new RefreshTilesSwingTask(unit.getTile(), newTile).invokeLater();
            }
            unit.setLocation(newTile);
        }
        return null;
    }

    private Element opponentAttack(Element opponentAttackElement) {
        Unit unit = (Unit)this.getGame().getFreeColGameObjectSafely(opponentAttackElement.getAttribute("unit"));
        Colony colony = (Colony)this.getGame().getFreeColGameObjectSafely(opponentAttackElement.getAttribute("colony"));
        Unit defender = (Unit)this.getGame().getFreeColGameObjectSafely(opponentAttackElement.getAttribute("defender"));
        CombatModel.CombatResultType result = Enum.valueOf(CombatModel.CombatResultType.class, opponentAttackElement.getAttribute("result"));
        int damage = Integer.parseInt(opponentAttackElement.getAttribute("damage"));
        int plunderGold = Integer.parseInt(opponentAttackElement.getAttribute("plunderGold"));
        Location repairLocation = (Location)((Object)this.getGame().getFreeColGameObjectSafely(opponentAttackElement.getAttribute("repairIn")));
        if (opponentAttackElement.hasAttribute("update")) {
            String updateAttribute = opponentAttackElement.getAttribute("update");
            if (updateAttribute.equals("unit")) {
                Element unitElement = Message.getChildElement(opponentAttackElement, Unit.getXMLElementTagName());
                unit = (Unit)this.getGame().getFreeColGameObject(unitElement.getAttribute("ID"));
                if (unit == null) {
                    unit = new Unit(this.getGame(), unitElement);
                } else {
                    unit.readFromXMLElement(unitElement);
                }
                if (unit.getTile() == null) {
                    throw new NullPointerException("unit.getTile() == null");
                }
                unit.setLocation(unit.getTile());
            } else if (updateAttribute.equals("defender")) {
                Tile defenderTile = (Tile)this.getGame().getFreeColGameObjectSafely(opponentAttackElement.getAttribute("defenderTile"));
                Element defenderTileElement = Message.getChildElement(opponentAttackElement, Tile.getXMLElementTagName());
                if (defenderTileElement != null) {
                    Tile checkTile = (Tile)this.getGame().getFreeColGameObject(defenderTileElement.getAttribute("ID"));
                    if (checkTile != defenderTile) {
                        throw new IllegalStateException("Trying to update another tile than the defending unit's tile.");
                    }
                    defenderTile.readFromXMLElement(defenderTileElement);
                }
                Element defenderElement = Message.getChildElement(opponentAttackElement, Unit.getXMLElementTagName());
                defender = (Unit)this.getGame().getFreeColGameObject(defenderElement.getAttribute("ID"));
                if (defender == null) {
                    defender = new Unit(this.getGame(), defenderElement);
                } else {
                    defender.readFromXMLElement(defenderElement);
                }
                defender.setLocationNoUpdate(defenderTile);
            } else if (updateAttribute.equals("tile")) {
                Element tileElement = Message.getChildElement(opponentAttackElement, Tile.getXMLElementTagName());
                Tile tile = (Tile)this.getGame().getFreeColGameObject(tileElement.getAttribute("ID"));
                if (tile == null) {
                    tile = new Tile(this.getGame(), tileElement);
                } else {
                    tile.readFromXMLElement(tileElement);
                }
                colony = tile.getColony();
            } else {
                throw new IllegalStateException("Unknown update " + updateAttribute);
            }
        }
        if (unit == null && colony == null) {
            throw new NullPointerException("unit == null && colony == null");
        }
        if (defender == null) {
            throw new NullPointerException("defender == null");
        }
        if (colony != null) {
            this.getGame().getCombatModel().bombard(colony, defender, new CombatModel.CombatResult(result, damage), repairLocation);
        } else {
            unit.getGame().getCombatModel().attack(unit, defender, new CombatModel.CombatResult(result, damage), plunderGold, repairLocation);
            if (!(unit.isDisposed() || unit.getLocation() != null && unit.isVisibleTo(this.getFreeColClient().getMyPlayer()))) {
                unit.dispose();
            }
        }
        if (!(defender.isDisposed() || defender.getLocation() != null && defender.isVisibleTo(this.getFreeColClient().getMyPlayer()))) {
            if (result == CombatModel.CombatResultType.DONE_SETTLEMENT && defender.getColony() != null && !defender.getColony().isDisposed()) {
                defender.getColony().setUnitCount(defender.getColony().getUnitCount());
            }
            defender.dispose();
        }
        new RefreshCanvasSwingTask().invokeLater();
        return null;
    }

    private Element setCurrentPlayer(Element setCurrentPlayerElement) {
        final Player currentPlayer = (Player)this.getGame().getFreeColGameObject(setCurrentPlayerElement.getAttribute("player"));
        logger.finest("About to set currentPlayer to " + currentPlayer.getName());
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    InGameInputHandler.this.getFreeColClient().getInGameController().setCurrentPlayer(currentPlayer);
                    InGameInputHandler.this.getFreeColClient().getActionManager().update();
                }
            });
        }
        catch (InterruptedException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        logger.finest("Succeeded in setting currentPlayer to " + currentPlayer.getName());
        new RefreshCanvasSwingTask(true).invokeLater();
        return null;
    }

    private Element newTurn(Element newTurnElement) {
        this.getGame().getTurn().increase();
        this.getFreeColClient().getMyPlayer().newTurn();
        new UpdateMenuBarSwingTask().invokeLater();
        Turn currTurn = this.getGame().getTurn();
        if (currTurn.getYear() == 1600 && Turn.getYear(currTurn.getNumber() - 1) == 1599) {
            new ShowInformationMessageSwingTask("twoTurnsPerYear", new String[0]).invokeLater();
        }
        return null;
    }

    private Element setDead(Element element) {
        FreeColClient freeColClient = this.getFreeColClient();
        Player player = (Player)this.getGame().getFreeColGameObject(element.getAttribute("player"));
        player.setDead(true);
        if (player == freeColClient.getMyPlayer()) {
            if (freeColClient.isSingleplayer()) {
                if (!new ShowConfirmDialogSwingTask("defeatedSingleplayer.text", "defeatedSingleplayer.yes", "defeatedSingleplayer.no", new String[0]).confirm()) {
                    freeColClient.quit();
                } else {
                    freeColClient.getFreeColServer().enterRevengeMode(player.getName());
                }
            } else if (!new ShowConfirmDialogSwingTask("defeated.text", "defeated.yes", "defeated.no", new String[0]).confirm()) {
                freeColClient.quit();
            }
        }
        return null;
    }

    private Element gameEnded(Element element) {
        FreeColClient freeColClient = this.getFreeColClient();
        Player winner = (Player)this.getGame().getFreeColGameObject(element.getAttribute("winner"));
        if (winner == freeColClient.getMyPlayer()) {
            new ShowVictoryPanelSwingTask().invokeLater();
        }
        return null;
    }

    private Element chat(Element element) {
        final Player sender = (Player)this.getGame().getFreeColGameObjectSafely(element.getAttribute("sender"));
        final String message = element.getAttribute("message");
        final boolean privateChat = Boolean.valueOf(element.getAttribute("privateChat"));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InGameInputHandler.this.getFreeColClient().getCanvas().displayChatMessage(sender, message, privateChat);
            }
        });
        return null;
    }

    private Element error(Element element) {
        new ShowErrorMessageSwingTask(element.hasAttribute("messageID") ? element.getAttribute("messageID") : null, element.getAttribute("message")).show();
        return null;
    }

    private Element setAI(Element element) {
        Player p = (Player)this.getGame().getFreeColGameObject(element.getAttribute("player"));
        p.setAI(Boolean.valueOf(element.getAttribute("ai")));
        return null;
    }

    private Element chooseFoundingFather(Element element) {
        ArrayList<FoundingFather> possibleFoundingFathers = new ArrayList<FoundingFather>();
        for (FoundingFather.FoundingFatherType type : FoundingFather.FoundingFatherType.values()) {
            String id = element.getAttribute(type.toString());
            if (id == null || id.equals("")) continue;
            possibleFoundingFathers.add(FreeCol.getSpecification().getFoundingFather(id));
        }
        FoundingFather foundingFather = new ShowSelectFoundingFatherSwingTask(possibleFoundingFathers).select();
        Element reply = Message.createNewRootElement("chosenFoundingFather");
        reply.setAttribute("foundingFather", foundingFather.getId());
        this.getFreeColClient().getMyPlayer().setCurrentFather(foundingFather);
        return reply;
    }

    private Element newConvert(Element element) {
        Tile tile = (Tile)this.getGame().getFreeColGameObject(element.getAttribute("colonyTile"));
        Colony colony = tile.getColony();
        String nation = Specification.getSpecification().getNation(element.getAttribute("nation")).getName();
        Element unitElement = (Element)element.getFirstChild();
        Unit convert = new Unit(this.getGame(), unitElement);
        tile.add(convert);
        ModelMessage message = new ModelMessage((FreeColGameObject)convert, ModelMessage.MessageType.UNIT_ADDED, convert, "model.colony.newConvert", "%nation%", nation, "%colony%", colony.getName());
        this.getFreeColClient().getMyPlayer().addModelMessage(message);
        return null;
    }

    private Element diplomaticTrade(Element element) {
        Unit unit = (Unit)this.getGame().getFreeColGameObject(element.getAttribute("unit"));
        if (unit == null) {
            throw new IllegalArgumentException("Could not find 'Unit' with specified ID: " + element.getAttribute("unit"));
        }
        Map.Direction direction = Enum.valueOf(Map.Direction.class, element.getAttribute("direction"));
        Tile tile = this.getGame().getMap().getNeighbourOrNull(direction, unit.getTile());
        if (tile == null) {
            throw new IllegalArgumentException("Could not find 'Tile' in direction " + (Object)((Object)direction));
        }
        Settlement settlement = tile.getSettlement();
        if (settlement == null) {
            throw new IllegalArgumentException("No settlement on 'Tile' " + tile.getId());
        }
        NodeList childElements = element.getChildNodes();
        Element childElement = (Element)childElements.item(0);
        DiplomaticTrade proposal = new DiplomaticTrade(this.getGame(), childElement);
        if (proposal.isAccept()) {
            new ShowInformationMessageSwingTask("negotiationDialog.offerAccepted", "%nation%", unit.getOwner().getNationAsString()).show();
            proposal.makeTrade();
        } else {
            DiplomaticTrade agreement = new ShowNegotiationDialogSwingTask(unit, settlement, proposal).select();
            if (agreement != null) {
                Element diplomaticElement = Message.createNewRootElement("diplomaticTrade");
                if (agreement.isAccept()) {
                    diplomaticElement.setAttribute("accept", "accept");
                } else {
                    diplomaticElement.setAttribute("unit", unit.getId());
                    diplomaticElement.setAttribute("direction", String.valueOf((Object)direction));
                    diplomaticElement.appendChild(agreement.toXMLElement(null, diplomaticElement.getOwnerDocument()));
                }
                return diplomaticElement;
            }
        }
        return null;
    }

    private Element deliverGift(Element element) {
        Element unitElement = Message.getChildElement(element, Unit.getXMLElementTagName());
        Unit unit = (Unit)this.getGame().getFreeColGameObject(unitElement.getAttribute("ID"));
        if (unit == null) {
            unit = new Unit(this.getGame(), unitElement);
        } else {
            unit.readFromXMLElement(unitElement);
        }
        Settlement settlement = (Settlement)this.getGame().getFreeColGameObject(element.getAttribute("settlement"));
        Goods goods = new Goods(this.getGame(), Message.getChildElement(element, Goods.getXMLElementTagName()));
        unit.deliverGift(settlement, goods);
        return null;
    }

    private Element indianDemand(Element element) {
        boolean accepted;
        Element goodsElement;
        Unit unit = (Unit)this.getGame().getFreeColGameObject(element.getAttribute("unit"));
        Colony colony = (Colony)this.getGame().getFreeColGameObject(element.getAttribute("colony"));
        int gold = 0;
        Goods goods = null;
        Element unitElement = Message.getChildElement(element, Unit.getXMLElementTagName());
        if (unitElement != null) {
            if (unit == null) {
                unit = new Unit(this.getGame(), unitElement);
            } else {
                unit.readFromXMLElement(unitElement);
            }
        }
        if ((goodsElement = Message.getChildElement(element, Goods.getXMLElementTagName())) == null) {
            gold = Integer.parseInt(element.getAttribute("gold"));
            accepted = new ShowConfirmDialogSwingTask("indianDemand.gold.text", "indianDemand.gold.yes", "indianDemand.gold.no", "%nation%", unit.getOwner().getNationAsString(), "%colony%", colony.getName(), "%amount%", String.valueOf(gold)).confirm();
            if (accepted) {
                colony.getOwner().modifyGold(-gold);
            }
        } else {
            goods = new Goods(this.getGame(), goodsElement);
            accepted = goods.getType() == Goods.FOOD ? new ShowConfirmDialogSwingTask("indianDemand.food.text", "indianDemand.food.yes", "indianDemand.food.no", "%nation%", unit.getOwner().getNationAsString(), "%colony%", colony.getName(), "%amount%", String.valueOf(goods.getAmount())).confirm() : new ShowConfirmDialogSwingTask("indianDemand.other.text", "indianDemand.other.yes", "indianDemand.other.no", "%nation%", unit.getOwner().getNationAsString(), "%colony%", colony.getName(), "%amount%", String.valueOf(goods.getAmount()), "%goods%", goods.getName()).confirm();
            if (accepted) {
                colony.getGoodsContainer().removeGoods(goods);
            }
        }
        element.setAttribute("accepted", String.valueOf(accepted));
        return element;
    }

    private Element monarchAction(Element element) {
        final FreeColClient freeColClient = this.getFreeColClient();
        Player player = freeColClient.getMyPlayer();
        Monarch monarch = player.getMonarch();
        final Monarch.MonarchAction action = Enum.valueOf(Monarch.MonarchAction.class, element.getAttribute("action"));
        switch (action) {
            case RAISE_TAX: {
                Element reply;
                boolean force = Boolean.parseBoolean(element.getAttribute("force"));
                int amount = new Integer(element.getAttribute("amount"));
                if (force) {
                    freeColClient.getMyPlayer().setTax(amount);
                    player.addModelMessage(new ModelMessage(player, "model.monarch.forceTaxRaise", new String[][]{{"%replace%", String.valueOf(amount)}}, ModelMessage.MessageType.WARNING));
                    reply = null;
                } else {
                    reply = Message.createNewRootElement("acceptTax");
                    if (new ShowMonarchPanelSwingTask(action, "%replace%", element.getAttribute("amount"), "%goods%", element.getAttribute("goods")).confirm()) {
                        freeColClient.getMyPlayer().setTax(amount);
                        reply.setAttribute("accepted", String.valueOf(true));
                        new UpdateMenuBarSwingTask().invokeLater();
                    } else {
                        reply.setAttribute("accepted", String.valueOf(false));
                    }
                }
                return reply;
            }
            case LOWER_TAX: {
                int newTax = new Integer(element.getAttribute("amount"));
                int difference = freeColClient.getMyPlayer().getTax() - newTax;
                freeColClient.getMyPlayer().setTax(newTax);
                player.addModelMessage(new ModelMessage((FreeColGameObject)player, ModelMessage.MessageType.WARNING, null, "model.monarch.lowerTax", "%difference%", String.valueOf(difference), "%newTax%", String.valueOf(newTax)));
                break;
            }
            case ADD_TO_REF: {
                Element additionElement = Message.getChildElement(element, "addition");
                NodeList childElements = additionElement.getChildNodes();
                ArrayList<AbstractUnit> units = new ArrayList<AbstractUnit>();
                ArrayList<String> unitNames = new ArrayList<String>();
                for (int index = 0; index < childElements.getLength(); ++index) {
                    AbstractUnit unit = new AbstractUnit();
                    unit.readFromXMLElement((Element)childElements.item(index));
                    units.add(unit);
                    unitNames.add(unit.getNumber() + " " + Unit.getName(unit.getUnitType(), unit.getRole()));
                }
                monarch.addToREF(units);
                player.addModelMessage(new ModelMessage((FreeColGameObject)player, ModelMessage.MessageType.WARNING, null, "model.monarch.addToREF", "%addition%", Utils.join(" " + Messages.message("and", new String[0]) + " ", unitNames)));
                break;
            }
            case DECLARE_WAR: {
                Player enemy = (Player)this.getGame().getFreeColGameObject(element.getAttribute("enemy"));
                player.changeRelationWithPlayer(enemy, Player.Stance.WAR);
                player.addModelMessage(new ModelMessage(player, "model.monarch.declareWar", new String[][]{{"%nation%", enemy.getNationAsString()}}, ModelMessage.MessageType.WARNING));
                break;
            }
            case SUPPORT_LAND: 
            case SUPPORT_SEA: 
            case ADD_UNITS: {
                NodeList unitList = element.getChildNodes();
                for (int i = 0; i < unitList.getLength(); ++i) {
                    Element unitElement = (Element)unitList.item(i);
                    Unit newUnit = (Unit)this.getGame().getFreeColGameObject(unitElement.getAttribute("ID"));
                    if (newUnit == null) {
                        newUnit = new Unit(this.getGame(), unitElement);
                    } else {
                        newUnit.readFromXMLElement(unitElement);
                    }
                    player.getEurope().add(newUnit);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Canvas canvas = InGameInputHandler.this.getFreeColClient().getCanvas();
                        if (!(canvas.isShowingSubPanel() || action != Monarch.MonarchAction.ADD_UNITS && canvas.showMonarchPanel(action, new String[0]))) {
                            canvas.showEuropePanel();
                        }
                    }
                });
                break;
            }
            case OFFER_MERCENARIES: {
                Element reply = Message.createNewRootElement("hireMercenaries");
                Element mercenaryElement = Message.getChildElement(element, "mercenaries");
                NodeList childElements = mercenaryElement.getChildNodes();
                ArrayList<String> mercenaries = new ArrayList<String>();
                for (int index = 0; index < childElements.getLength(); ++index) {
                    AbstractUnit unit = new AbstractUnit();
                    unit.readFromXMLElement((Element)childElements.item(index));
                    mercenaries.add(unit.getNumber() + " " + Unit.getName(unit.getUnitType(), unit.getRole()));
                }
                if (new ShowMonarchPanelSwingTask(action, "%gold%", element.getAttribute("price"), "%mercenaries%", Utils.join(" " + Messages.message("and", new String[0]) + " ", mercenaries)).confirm()) {
                    int price = new Integer(element.getAttribute("price"));
                    freeColClient.getMyPlayer().modifyGold(-price);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            freeColClient.getCanvas().updateGoldLabel();
                        }
                    });
                    reply.setAttribute("accepted", String.valueOf(true));
                } else {
                    reply.setAttribute("accepted", String.valueOf(false));
                }
                return reply;
            }
        }
        return null;
    }

    private Element setStance(Element element) {
        FreeColClient freeColClient = this.getFreeColClient();
        Player player = freeColClient.getMyPlayer();
        Player.Stance stance = Enum.valueOf(Player.Stance.class, element.getAttribute("stance"));
        Player first = (Player)this.getGame().getFreeColGameObject(element.getAttribute("first"));
        Player second = (Player)this.getGame().getFreeColGameObject(element.getAttribute("second"));
        first.setStance(second, stance);
        if (second.getStance(first) != stance) {
            second.setStance(first, stance);
        }
        if (player.equals(second)) {
            player.addModelMessage(new ModelMessage(first, "model.diplomacy." + stance.toString().toLowerCase() + ".declared", new String[][]{{"%nation%", first.getNationAsString()}}, ModelMessage.MessageType.FOREIGN_DIPLOMACY));
        } else if (stance == Player.Stance.WAR || player.hasAbility("model.ability.betterForeignAffairsReport") || player.hasContacted(first) || player.hasContacted(second)) {
            player.addModelMessage(new ModelMessage(first, "model.diplomacy." + stance.toString().toLowerCase() + ".others", new String[][]{{"%attacker%", first.getNationAsString()}, {"%defender%", second.getNationAsString()}}, ModelMessage.MessageType.FOREIGN_DIPLOMACY));
        }
        return null;
    }

    private Element giveIndependence(Element element) {
        Player player = (Player)this.getGame().getFreeColGameObject(element.getAttribute("player"));
        player.giveIndependence();
        return null;
    }

    private Element addPlayer(Element element) {
        Element playerElement = (Element)element.getElementsByTagName(Player.getXMLElementTagName()).item(0);
        if (this.getGame().getFreeColGameObject(playerElement.getAttribute("ID")) == null) {
            Player newPlayer = new Player(this.getGame(), playerElement);
            this.getGame().addPlayer(newPlayer);
        } else {
            this.getGame().getFreeColGameObject(playerElement.getAttribute("ID")).readFromXMLElement(playerElement);
        }
        return null;
    }

    private Element marketElement(Element element) {
        Player player = this.getFreeColClient().getMyPlayer();
        GoodsType type = FreeCol.getSpecification().getGoodsType(element.getAttribute("type"));
        int amount = Integer.parseInt(element.getAttribute("amount"));
        if (amount > 0) {
            player.getMarket().add(type, amount);
        } else {
            player.getMarket().remove(type, -amount);
        }
        return null;
    }

    private Element removeGoods(Element element) {
        FreeColClient freeColClient = this.getFreeColClient();
        NodeList nodeList = element.getChildNodes();
        Element goodsElement = (Element)nodeList.item(0);
        if (goodsElement == null) {
            new ShowMonarchPanelSwingTask(Monarch.MonarchAction.WAIVE_TAX, new String[0]).confirm();
        } else {
            Goods goods = new Goods(this.getGame(), goodsElement);
            Colony colony = (Colony)goods.getLocation();
            colony.removeGoods(goods);
            freeColClient.getMyPlayer().setArrears(goods);
            String messageID = goods.getType().getId() + ".destroyed";
            if (!Messages.containsKey(messageID)) {
                messageID = colony.isLandLocked() ? "model.monarch.colonyGoodsParty.landLocked" : "model.monarch.colonyGoodsParty.harbour";
            }
            colony.getFeatureContainer().addModifier(Modifier.createTeaPartyModifier(this.getGame().getTurn()));
            new ShowModelMessageSwingTask(new ModelMessage((FreeColGameObject)colony, ModelMessage.MessageType.WARNING, null, messageID, "%colony%", colony.getName(), "%amount%", String.valueOf(goods.getAmount()), "%goods%", goods.getName())).invokeLater();
        }
        return null;
    }

    private Element lostCityRumour(Element element) {
        ModelMessage m;
        final FreeColClient freeColClient = this.getFreeColClient();
        final Player player = freeColClient.getMyPlayer();
        LostCityRumour.RumourType type = Enum.valueOf(LostCityRumour.RumourType.class, element.getAttribute("type"));
        Unit unit = (Unit)this.getGame().getFreeColGameObject(element.getAttribute("unit"));
        if (unit == null) {
            throw new IllegalArgumentException("Unit is null.");
        }
        Tile tile = unit.getTile();
        tile.setLostCityRumour(false);
        freeColClient.getGUI().setFocusImmediately(tile.getPosition());
        Unit newUnit = null;
        switch (type) {
            case BURIAL_GROUND: {
                Player indianPlayer = tile.getOwner();
                indianPlayer.modifyTension(player, Tension.Level.HATEFUL.getLimit());
                m = new ModelMessage(unit, "lostCityRumour.BurialGround", new String[][]{{"%nation%", indianPlayer.getNationAsString()}}, ModelMessage.MessageType.LOST_CITY_RUMOUR);
                break;
            }
            case EXPEDITION_VANISHES: {
                m = new ModelMessage(unit, "lostCityRumour.ExpeditionVanishes", null, ModelMessage.MessageType.LOST_CITY_RUMOUR);
                unit.dispose();
                break;
            }
            case NOTHING: {
                m = new ModelMessage(unit, "lostCityRumour.Nothing", null, ModelMessage.MessageType.LOST_CITY_RUMOUR);
                break;
            }
            case LEARN: {
                m = new ModelMessage(unit, "lostCityRumour.SeasonedScout", new String[][]{{"%unit%", unit.getName()}}, ModelMessage.MessageType.LOST_CITY_RUMOUR);
                unit.setType(FreeCol.getSpecification().getUnitType(element.getAttribute("unitType")));
                break;
            }
            case TRIBAL_CHIEF: {
                String amount = element.getAttribute("amount");
                m = new ModelMessage(unit, "lostCityRumour.TribalChief", new String[][]{{"%money%", amount}}, ModelMessage.MessageType.LOST_CITY_RUMOUR);
                player.modifyGold(Integer.parseInt(amount));
                break;
            }
            case COLONIST: {
                m = new ModelMessage((FreeColGameObject)unit, ModelMessage.MessageType.LOST_CITY_RUMOUR, null, "lostCityRumour.Colonist", new String[0]);
                NodeList unitList = element.getChildNodes();
                for (int i = 0; i < unitList.getLength(); ++i) {
                    Element unitElement = (Element)unitList.item(i);
                    newUnit = (Unit)this.getGame().getFreeColGameObject(unitElement.getAttribute("ID"));
                    if (newUnit == null) {
                        newUnit = new Unit(this.getGame(), unitElement);
                    } else {
                        newUnit.readFromXMLElement(unitElement);
                    }
                    tile.add(newUnit);
                }
                break;
            }
            case TREASURE: {
                String treasure = element.getAttribute("amount");
                NodeList unitList = element.getChildNodes();
                for (int i = 0; i < unitList.getLength(); ++i) {
                    Element unitElement = (Element)unitList.item(i);
                    newUnit = (Unit)this.getGame().getFreeColGameObject(unitElement.getAttribute("ID"));
                    if (newUnit == null) {
                        newUnit = new Unit(this.getGame(), unitElement);
                    } else {
                        newUnit.readFromXMLElement(unitElement);
                    }
                    tile.add(newUnit);
                }
                m = new ModelMessage((FreeColGameObject)unit, ModelMessage.MessageType.LOST_CITY_RUMOUR, newUnit, "lostCityRumour.TreasureTrain", "%money%", treasure);
                player.getHistory().add(new HistoryEvent(player.getGame().getTurn().getNumber(), HistoryEvent.Type.CITY_OF_GOLD, "%treasure%", String.valueOf(treasure)));
                break;
            }
            case FOUNTAIN_OF_YOUTH: {
                if (player.getEurope() == null) {
                    m = new ModelMessage(player, "lostCityRumour.FountainOfYouthWithoutEurope", null, ModelMessage.MessageType.LOST_CITY_RUMOUR);
                    break;
                }
                freeColClient.playMusicOnce("fountain");
                m = new ModelMessage(player.getEurope(), "lostCityRumour.FountainOfYouth", null, ModelMessage.MessageType.LOST_CITY_RUMOUR);
                if (player.hasAbility("model.ability.selectRecruit")) {
                    final int emigrants = Integer.parseInt(element.getAttribute("emigrants"));
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            for (int i = 0; i < emigrants; ++i) {
                                int slot = InGameInputHandler.this.getFreeColClient().getCanvas().showEmigrationPanel(true);
                                Element selectElement = Message.createNewRootElement("selectFromFountainYouth");
                                selectElement.setAttribute("slot", Integer.toString(slot));
                                Element reply = freeColClient.getClient().ask(selectElement);
                                Element unitElement = (Element)reply.getChildNodes().item(0);
                                Unit unit = (Unit)InGameInputHandler.this.getGame().getFreeColGameObject(unitElement.getAttribute("ID"));
                                if (unit == null) {
                                    unit = new Unit(InGameInputHandler.this.getGame(), unitElement);
                                } else {
                                    unit.readFromXMLElement(unitElement);
                                }
                                player.getEurope().add(unit);
                                String newRecruitableStr = reply.getAttribute("newRecruitable");
                                UnitType newRecruitable = FreeCol.getSpecification().getUnitType(newRecruitableStr);
                                player.getEurope().setRecruitable(slot, newRecruitable);
                            }
                        }
                    });
                    break;
                }
                NodeList unitList = element.getChildNodes();
                for (int i = 0; i < unitList.getLength(); ++i) {
                    Element unitElement = (Element)unitList.item(i);
                    newUnit = (Unit)this.getGame().getFreeColGameObject(unitElement.getAttribute("ID"));
                    if (newUnit == null) {
                        newUnit = new Unit(this.getGame(), unitElement);
                    } else {
                        newUnit.readFromXMLElement(unitElement);
                    }
                    player.getEurope().add(newUnit);
                }
                break;
            }
            default: {
                throw new IllegalStateException("No such rumour.");
            }
        }
        player.addModelMessage(m);
        return null;
    }

    class ShowMonarchPanelSwingTask
    extends SwingTask {
        private Monarch.MonarchAction _action;
        private String[] _replace;

        public ShowMonarchPanelSwingTask(Monarch.MonarchAction action, String ... replace) {
            this._action = action;
            this._replace = replace;
        }

        public boolean confirm() {
            try {
                Object result = this.invokeAndWait();
                return (Boolean)result;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        }

        protected Object doWork() {
            boolean choice = InGameInputHandler.this.getFreeColClient().getCanvas().showMonarchPanel(this._action, this._replace);
            return choice;
        }
    }

    class ShowNegotiationDialogSwingTask
    extends SwingTask {
        private Unit unit;
        private Settlement settlement;
        private DiplomaticTrade proposal;

        public ShowNegotiationDialogSwingTask(Unit unit, Settlement settlement, DiplomaticTrade proposal) {
            this.unit = unit;
            this.settlement = settlement;
            this.proposal = proposal;
        }

        public DiplomaticTrade select() {
            try {
                Object result = this.invokeAndWait();
                return (DiplomaticTrade)result;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        }

        protected Object doWork() {
            return InGameInputHandler.this.getFreeColClient().getCanvas().showNegotiationDialog(this.unit, this.settlement, this.proposal);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ShowSelectFoundingFatherSwingTask
    extends SwingTask {
        private List<FoundingFather> choices;

        public ShowSelectFoundingFatherSwingTask(List<FoundingFather> choices) {
            this.choices = choices;
        }

        @Override
        protected Object doWork() {
            return InGameInputHandler.this.getFreeColClient().getCanvas().showChooseFoundingFatherDialog(this.choices);
        }

        public FoundingFather select() {
            try {
                Object result = this.invokeAndWait();
                return (FoundingFather)result;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        }
    }

    abstract class ShowSelectSwingTask
    extends SwingTask {
        ShowSelectSwingTask() {
        }

        public int select() {
            try {
                Object result = this.invokeAndWait();
                return (Integer)result;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        }
    }

    class ShowErrorMessageSwingTask
    extends ShowMessageSwingTask {
        private String _messageId;
        private String _message;

        public ShowErrorMessageSwingTask(String messageId, String message) {
            this._messageId = messageId;
            this._message = message;
        }

        protected Object doWork() {
            InGameInputHandler.this.getFreeColClient().getCanvas().errorMessage(this._messageId, this._message);
            return null;
        }
    }

    class ShowInformationMessageSwingTask
    extends ShowMessageSwingTask {
        private String _messageId;
        private String[] _replace;

        public ShowInformationMessageSwingTask(String messageId, String ... replace) {
            this._messageId = messageId;
            this._replace = replace;
        }

        protected Object doWork() {
            InGameInputHandler.this.getFreeColClient().getCanvas().showInformationMessage(this._messageId, this._replace);
            return null;
        }
    }

    class ShowModelMessageSwingTask
    extends ShowMessageSwingTask {
        private ModelMessage _modelMessage;

        public ShowModelMessageSwingTask(ModelMessage modelMessage) {
            this._modelMessage = modelMessage;
        }

        protected Object doWork() {
            InGameInputHandler.this.getFreeColClient().getCanvas().showModelMessages(this._modelMessage);
            return null;
        }
    }

    abstract class ShowMessageSwingTask
    extends SwingTask {
        ShowMessageSwingTask() {
        }

        public void show() {
            try {
                this.invokeAndWait();
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        }
    }

    class ShowConfirmDialogSwingTask
    extends SwingTask {
        private String _text;
        private String _okText;
        private String _cancelText;
        private String[] _replace;

        public ShowConfirmDialogSwingTask(String text, String okText, String cancelText, String ... replace) {
            this._text = text;
            this._okText = okText;
            this._cancelText = cancelText;
            this._replace = replace;
        }

        public boolean confirm() {
            try {
                Object result = this.invokeAndWait();
                return (Boolean)result;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
        }

        protected Object doWork() {
            boolean choice = InGameInputHandler.this.getFreeColClient().getCanvas().showConfirmDialog(this._text, this._okText, this._cancelText, this._replace);
            return choice;
        }
    }

    class ShowVictoryPanelSwingTask
    extends NoResultCanvasSwingTask {
        ShowVictoryPanelSwingTask() {
        }

        protected void doWork(Canvas canvas) {
            canvas.showPanel(new VictoryPanel(canvas));
        }
    }

    class UpdateMenuBarSwingTask
    extends NoResultCanvasSwingTask {
        UpdateMenuBarSwingTask() {
        }

        protected void doWork(Canvas canvas) {
            canvas.updateJMenuBar();
        }
    }

    class ReconnectSwingTask
    extends SwingTask {
        ReconnectSwingTask() {
        }

        protected Object doWork() {
            InGameInputHandler.this.getFreeColClient().getConnectController().reconnect();
            return null;
        }
    }

    class UnitMoveAnimationCanvasSwingTask
    extends NoResultCanvasSwingTask {
        private final Unit _unit;
        private final Tile _destinationTile;
        private boolean _focus;

        public UnitMoveAnimationCanvasSwingTask(Unit unit, Tile destinationTile) {
            this(unit, destinationTile, true);
        }

        public UnitMoveAnimationCanvasSwingTask(Unit unit, Map.Direction direction) {
            this(unit, unit.getGame().getMap().getNeighbourOrNull(direction, unit.getTile()), true);
        }

        public UnitMoveAnimationCanvasSwingTask(Unit unit, Tile destinationTile, boolean focus) {
            this._unit = unit;
            this._destinationTile = destinationTile;
            this._focus = focus;
        }

        protected void doWork(Canvas canvas) {
            if (this._focus) {
                canvas.getGUI().setFocusImmediately(this._unit.getTile().getPosition());
            }
            new UnitMoveAnimation(canvas, this._unit, this._destinationTile).animate();
            canvas.refresh();
        }
    }

    class RefreshTilesSwingTask
    extends NoResultCanvasSwingTask {
        private final Tile _oldTile;
        private final Tile _newTile;

        public RefreshTilesSwingTask(Tile oldTile, Tile newTile) {
            this._oldTile = oldTile;
            this._newTile = newTile;
        }

        void doWork(Canvas canvas) {
            canvas.refreshTile(this._oldTile);
            canvas.refreshTile(this._newTile);
        }
    }

    class RefreshCanvasSwingTask
    extends NoResultCanvasSwingTask {
        private final boolean _requestFocus;

        public RefreshCanvasSwingTask() {
            this(false);
        }

        public RefreshCanvasSwingTask(boolean requestFocus) {
            this._requestFocus = requestFocus;
        }

        protected void doWork(Canvas canvas) {
            canvas.refresh();
            if (this._requestFocus && !canvas.isShowingSubPanel()) {
                canvas.requestFocusInWindow();
            }
        }
    }

    abstract class NoResultCanvasSwingTask
    extends SwingTask {
        NoResultCanvasSwingTask() {
        }

        protected Object doWork() {
            this.doWork(InGameInputHandler.this.getFreeColClient().getCanvas());
            return null;
        }

        abstract void doWork(Canvas var1);
    }

    static abstract class SwingTask
    implements Runnable {
        private static final Logger taskLogger = Logger.getLogger(SwingTask.class.getName());
        private Object _result;
        private boolean _synchronous;
        private boolean _started;

        SwingTask() {
        }

        public Object invokeAndWait() throws InvocationTargetException {
            this.verifyNotStarted();
            this.markStarted(true);
            try {
                SwingUtilities.invokeAndWait(this);
            }
            catch (InterruptedException e) {
                throw new InvocationTargetException(e);
            }
            return this._result;
        }

        public void invokeLater() {
            this.verifyNotStarted();
            this.markStarted(false);
            SwingUtilities.invokeLater(this);
        }

        private synchronized void markStarted(boolean synchronous) {
            this._synchronous = synchronous;
            this._started = true;
        }

        private synchronized void markDone() {
            this._started = false;
        }

        private synchronized void verifyNotStarted() {
            if (this._started) {
                throw new IllegalStateException("Swing task already started!");
            }
        }

        private synchronized boolean isSynchronous() {
            return this._synchronous;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            try {
                if (taskLogger.isLoggable(Level.FINEST)) {
                    taskLogger.log(Level.FINEST, "Running Swing task " + this.getClass().getName() + "...");
                }
                this.setResult(this.doWork());
                if (taskLogger.isLoggable(Level.FINEST)) {
                    taskLogger.log(Level.FINEST, "Swing task " + this.getClass().getName() + " returned " + this._result);
                }
            }
            catch (RuntimeException e) {
                taskLogger.log(Level.WARNING, "Swing task " + this.getClass().getName() + " failed!", e);
                if (this.isSynchronous()) {
                    throw e;
                }
            }
            finally {
                this.markDone();
            }
        }

        public synchronized Object getResult() {
            return this._result;
        }

        private synchronized void setResult(Object r) {
            this._result = r;
        }

        protected abstract Object doWork();
    }
}

