/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.MapEditorController;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.CanvasMapEditorMouseListener;
import net.sf.freecol.client.gui.CanvasMapEditorMouseMotionListener;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.MapEditorMenuBar;
import net.sf.freecol.client.gui.action.MapControlsAction;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.MapEditorTransformPanel;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.networking.NoRouteToServerException;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.generator.IMapGenerator;

public final class MapEditorController {
    private static final Logger logger = Logger.getLogger(MapEditorController.class.getName());
    private final FreeColClient freeColClient;
    private MapEditorTransformPanel.MapTransform currentMapTransform = null;

    public MapEditorController(FreeColClient freeColClient) {
        this.freeColClient = freeColClient;
    }

    public void startMapEditor() {
        try {
            this.freeColClient.setMapEditor(true);
            FreeColServer freeColServer = new FreeColServer(false, false, 0, null);
            this.freeColClient.setFreeColServer(freeColServer);
            this.freeColClient.setGame(freeColServer.getGame());
            this.freeColClient.setMyPlayer(null);
            Canvas canvas = this.freeColClient.getCanvas();
            GUI gui = this.freeColClient.getGUI();
            canvas.closeMainPanel();
            canvas.closeMenus();
            gui.setInGame(true);
            ImageLibrary im = this.freeColClient.getImageLibrary();
            if (gui.getImageLibrary() != im) {
                gui.setImageLibrary(im);
            }
            this.freeColClient.getCanvas().setJMenuBar(new MapEditorMenuBar(this.freeColClient));
            JInternalFrame f = this.freeColClient.getCanvas().addAsToolBox(new MapEditorTransformPanel(canvas));
            f.setLocation(f.getX(), 50);
            canvas.repaint();
            canvas.addMouseListener(new CanvasMapEditorMouseListener(canvas, gui));
            canvas.addMouseMotionListener(new CanvasMapEditorMouseMotionListener(canvas, gui));
        }
        catch (NoRouteToServerException e) {
            this.freeColClient.getCanvas().errorMessage("server.noRouteToServer");
            return;
        }
        catch (IOException e) {
            this.freeColClient.getCanvas().errorMessage("server.couldNotStart");
            return;
        }
    }

    public void setMapTransform(MapEditorTransformPanel.MapTransform mt) {
        this.currentMapTransform = mt;
        MapControlsAction mca = (MapControlsAction)this.freeColClient.getActionManager().getFreeColAction("mapControlsAction");
        if (mca.getMapControls() != null) {
            mca.getMapControls().update(mt);
        }
    }

    public MapEditorTransformPanel.MapTransform getMapTransform() {
        return this.currentMapTransform;
    }

    public void transform(Tile t) {
        if (this.currentMapTransform != null) {
            this.currentMapTransform.transform(t);
        }
    }

    public void newMap() {
        Canvas canvas = this.freeColClient.getCanvas();
        Game game = this.freeColClient.getGame();
        IMapGenerator mapGenerator = this.freeColClient.getFreeColServer().getMapGenerator();
        boolean ok = canvas.showMapGeneratorOptionsDialog(true, mapGenerator.getMapGeneratorOptions());
        if (!ok) {
            return;
        }
        try {
            mapGenerator.createMap(game);
            this.freeColClient.getGUI().setFocus(1, 1);
            this.freeColClient.getActionManager().update();
            canvas.refresh();
        }
        catch (FreeColException e) {
            canvas.closeMenus();
            canvas.errorMessage(e.getMessage());
        }
    }

    public void saveGame() {
        Canvas canvas = this.freeColClient.getCanvas();
        String fileName = "my_map.fsg";
        File file = canvas.showSaveDialog(FreeCol.getSaveDirectory(), fileName);
        if (file != null) {
            this.saveGame(file);
        }
    }

    public void saveGame(final File file) {
        final Canvas canvas = this.freeColClient.getCanvas();
        canvas.showStatusPanel(Messages.message("status.savingGame", new String[0]));
        Thread t = new Thread("FreeColClient:Saving Map"){

            public void run() {
                try {
                    MapEditorController.this.freeColClient.getFreeColServer().saveGame(file, "mapEditor");
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            canvas.closeStatusPanel();
                            canvas.requestFocusInWindow();
                        }
                    });
                }
                catch (IOException e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            canvas.errorMessage("couldNotSaveGame");
                        }
                    });
                }
            }
        };
        t.start();
    }

    public void loadGame() {
        Canvas canvas = this.freeColClient.getCanvas();
        File file = canvas.showLoadDialog(FreeCol.getSaveDirectory());
        if (file == null) {
            return;
        }
        if (!file.isFile()) {
            canvas.errorMessage("fileNotFound");
            return;
        }
        this.loadGame(file);
    }

    public void loadGame(File file) {
        final Canvas canvas = this.freeColClient.getCanvas();
        final File theFile = file;
        this.freeColClient.setMapEditor(true);
        canvas.showStatusPanel(Messages.message("status.loadingGame", new String[0]));
        Runnable loadGameJob = new Runnable(){

            public void run() {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class ErrorJob
                implements Runnable {
                    private final String message;
                    final /* synthetic */ Canvas val$canvas;
                    final /* synthetic */ MapEditorController this$0;

                    ErrorJob(String message) {
                        this.this$0 = mapEditorController;
                        this.val$canvas = canvas;
                        this.message = message;
                    }

                    public void run() {
                        this.val$canvas.closeMenus();
                        this.val$canvas.errorMessage(this.message);
                    }
                }
                FreeColServer freeColServer = null;
                try {
                    freeColServer = new FreeColServer(theFile, false, false, 0, "MapEditor");
                    MapEditorController.this.freeColClient.setFreeColServer(freeColServer);
                    MapEditorController.this.freeColClient.setGame(freeColServer.getGame());
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            canvas.closeStatusPanel();
                            MapEditorController.this.freeColClient.getGUI().setFocus(1, 1);
                            MapEditorController.this.freeColClient.getActionManager().update();
                            canvas.refresh();
                        }
                    });
                }
                catch (NoRouteToServerException e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            MapEditorController.this.freeColClient.getCanvas().closeMainPanel();
                            MapEditorController.this.freeColClient.getCanvas().showMainPanel();
                        }
                    });
                    SwingUtilities.invokeLater(new ErrorJob(MapEditorController.this, "server.noRouteToServer", canvas));
                }
                catch (FileNotFoundException e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            MapEditorController.this.freeColClient.getCanvas().closeMainPanel();
                            MapEditorController.this.freeColClient.getCanvas().showMainPanel();
                        }
                    });
                    SwingUtilities.invokeLater(new ErrorJob(MapEditorController.this, "fileNotFound", canvas));
                }
                catch (IOException e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            MapEditorController.this.freeColClient.getCanvas().closeMainPanel();
                            MapEditorController.this.freeColClient.getCanvas().showMainPanel();
                        }
                    });
                    SwingUtilities.invokeLater(new ErrorJob(MapEditorController.this, "server.couldNotStart", canvas));
                }
                catch (FreeColException e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            MapEditorController.this.freeColClient.getCanvas().closeMainPanel();
                            MapEditorController.this.freeColClient.getCanvas().showMainPanel();
                        }
                    });
                    SwingUtilities.invokeLater(new ErrorJob(MapEditorController.this, e.getMessage(), canvas));
                }
            }
        };
        this.freeColClient.worker.schedule(loadGameJob);
    }
}

