/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import java.awt.Color;
import java.util.logging.Logger;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.control.InGameInputHandler;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.CanvasKeyListener;
import net.sf.freecol.client.gui.CanvasMouseListener;
import net.sf.freecol.client.gui.CanvasMouseMotionListener;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.InGameMenuBar;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.generator.MapGeneratorOptions;
import org.w3c.dom.Element;

public final class PreGameController {
    private static final Logger logger = Logger.getLogger(PreGameController.class.getName());
    private FreeColClient freeColClient;
    private MapGeneratorOptions mapGeneratorOptions = null;

    public PreGameController(FreeColClient freeColClient) {
        this.freeColClient = freeColClient;
    }

    void setMapGeneratorOptions(MapGeneratorOptions mapGeneratorOptions) {
        this.mapGeneratorOptions = mapGeneratorOptions;
    }

    public MapGeneratorOptions getMapGeneratorOptions() {
        return this.mapGeneratorOptions;
    }

    public void setReady(boolean ready) {
        this.freeColClient.getMyPlayer().setReady(ready);
        Element readyElement = Message.createNewRootElement("ready");
        readyElement.setAttribute("value", Boolean.toString(ready));
        this.freeColClient.getClient().send(readyElement);
    }

    public void setNation(Nation nation) {
        this.freeColClient.getMyPlayer().setNation(nation);
        Element nationElement = Message.createNewRootElement("setNation");
        nationElement.setAttribute("value", nation.getId());
        this.freeColClient.getClient().sendAndWait(nationElement);
    }

    public void setNationType(NationType nationType) {
        this.freeColClient.getMyPlayer().setNationType(nationType);
        Element nationTypeElement = Message.createNewRootElement("setNationType");
        nationTypeElement.setAttribute("value", nationType.getId());
        this.freeColClient.getClient().sendAndWait(nationTypeElement);
    }

    public void setColor(Color color) {
        this.freeColClient.getMyPlayer().setColor(color);
        Element colorElement = Message.createNewRootElement("setColor");
        colorElement.setAttribute("value", "#" + Integer.toHexString(color.getRGB()).substring(2));
        this.freeColClient.getClient().sendAndWait(colorElement);
    }

    public void requestLaunch() {
        Canvas canvas = this.freeColClient.getCanvas();
        if (!this.freeColClient.getGame().isAllPlayersReadyToLaunch()) {
            canvas.errorMessage("server.notAllReady");
            return;
        }
        Element requestLaunchElement = Message.createNewRootElement("requestLaunch");
        this.freeColClient.getClient().send(requestLaunchElement);
        canvas.showStatusPanel(Messages.message("status.startingGame", new String[0]));
    }

    public void chat(String message) {
        Element chatElement = Message.createNewRootElement("chat");
        chatElement.setAttribute("senderName", this.freeColClient.getMyPlayer().getName());
        chatElement.setAttribute("message", message);
        chatElement.setAttribute("privateChat", "false");
        this.freeColClient.getClient().send(chatElement);
    }

    public void sendGameOptions() {
        Element updateGameOptionsElement = Message.createNewRootElement("updateGameOptions");
        updateGameOptionsElement.appendChild(this.freeColClient.getGame().getGameOptions().toXMLElement(updateGameOptionsElement.getOwnerDocument()));
        this.freeColClient.getClient().send(updateGameOptionsElement);
    }

    public void sendMapGeneratorOptions() {
        if (this.mapGeneratorOptions != null) {
            Element updateMapGeneratorOptionsElement = Message.createNewRootElement("updateMapGeneratorOptions");
            updateMapGeneratorOptionsElement.appendChild(this.mapGeneratorOptions.toXMLElement(updateMapGeneratorOptionsElement.getOwnerDocument()));
            this.freeColClient.getClient().send(updateMapGeneratorOptionsElement);
        }
    }

    public void startGame() {
        Canvas canvas = this.freeColClient.getCanvas();
        GUI gui = this.freeColClient.getGUI();
        if (!this.freeColClient.isHeadless()) {
            canvas.closeMainPanel();
            canvas.closeMenus();
            this.freeColClient.playMusicOnce("england", 2000);
        }
        InGameController inGameController = this.freeColClient.getInGameController();
        InGameInputHandler inGameInputHandler = this.freeColClient.getInGameInputHandler();
        this.freeColClient.getClient().setMessageHandler(inGameInputHandler);
        if (!this.freeColClient.isHeadless()) {
            gui.setInGame(true);
            this.freeColClient.getCanvas().setJMenuBar(new InGameMenuBar(this.freeColClient));
        }
        if (this.freeColClient.getGame().getTurn().getNumber() == 1) {
            Player player = this.freeColClient.getMyPlayer();
            player.addModelMessage(new ModelMessage((FreeColGameObject)player, ModelMessage.MessageType.TUTORIAL, player, "tutorial.startGame", new String[0]));
        }
        Unit activeUnit = this.freeColClient.getMyPlayer().getNextActiveUnit();
        gui.setActiveUnit(activeUnit);
        if (activeUnit != null) {
            gui.setFocus(activeUnit.getTile().getPosition());
        } else {
            gui.setFocus(((Tile)this.freeColClient.getMyPlayer().getEntryLocation()).getPosition());
        }
        canvas.addKeyListener(new CanvasKeyListener(canvas, inGameController));
        canvas.addMouseListener(new CanvasMouseListener(canvas, gui));
        canvas.addMouseMotionListener(new CanvasMouseMotionListener(canvas, gui, this.freeColClient.getGame().getMap()));
        if (this.freeColClient.getMyPlayer().equals(this.freeColClient.getGame().getCurrentPlayer())) {
            canvas.requestFocus();
            this.freeColClient.getInGameController().nextModelMessage();
        }
    }
}

