/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import java.awt.Color;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InputHandler;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GameOptions;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.StreamedMessageHandler;
import net.sf.freecol.server.generator.MapGeneratorOptions;
import org.w3c.dom.Element;

public final class PreGameInputHandler
extends InputHandler
implements StreamedMessageHandler {
    private static final Logger logger = Logger.getLogger(PreGameInputHandler.class.getName());

    public PreGameInputHandler(FreeColClient freeColClient) {
        super(freeColClient);
    }

    public synchronized Element handle(Connection connection, Element element) {
        Element reply = null;
        if (element != null) {
            String type = element.getTagName();
            if (type.equals("addPlayer")) {
                reply = this.addPlayer(element);
            } else if (type.equals("removePlayer")) {
                reply = this.removePlayer(element);
            } else if (type.equals("updateGameOptions")) {
                reply = this.updateGameOptions(element);
            } else if (type.equals("updateMapGeneratorOptions")) {
                reply = this.updateMapGeneratorOptions(element);
            } else if (type.equals("chat")) {
                reply = this.chat(element);
            } else if (type.equals("playerReady")) {
                reply = this.playerReady(element);
            } else if (type.equals("updateNation")) {
                reply = this.updateNation(element);
            } else if (type.equals("updateNationType")) {
                reply = this.updateNationType(element);
            } else if (type.equals("updateColor")) {
                reply = this.updateColor(element);
            } else if (type.equals("startGame")) {
                reply = this.startGame(element);
            } else if (type.equals("logout")) {
                reply = this.logout(element);
            } else if (type.equals("disconnect")) {
                reply = this.disconnect(element);
            } else if (type.equals("error")) {
                reply = this.error(element);
            } else {
                logger.warning("Message is of unsupported type \"" + type + "\".");
            }
        }
        return reply;
    }

    public void handle(Connection connection, XMLStreamReader in, XMLStreamWriter out) {
        if (in.getLocalName().equals("updateGame")) {
            this.updateGame(connection, in, out);
        } else {
            logger.warning("Unkown (streamed) request: " + in.getLocalName());
        }
    }

    public boolean accepts(String tagName) {
        return tagName.equals("updateGame");
    }

    private Element addPlayer(Element element) {
        Element playerElement;
        Game game = this.getFreeColClient().getGame();
        if (game.getFreeColGameObject((playerElement = (Element)element.getElementsByTagName(Player.getXMLElementTagName()).item(0)).getAttribute("ID")) == null) {
            Player newPlayer = new Player(game, playerElement);
            this.getFreeColClient().getGame().addPlayer(newPlayer);
        } else {
            game.getFreeColGameObject(playerElement.getAttribute("ID")).readFromXMLElement(playerElement);
        }
        this.getFreeColClient().getCanvas().getStartGamePanel().refreshPlayersTable();
        return null;
    }

    private Element removePlayer(Element element) {
        Game game = this.getFreeColClient().getGame();
        Element playerElement = (Element)element.getElementsByTagName(Player.getXMLElementTagName()).item(0);
        Player player = new Player(game, playerElement);
        this.getFreeColClient().getGame().removePlayer(player);
        this.getFreeColClient().getCanvas().getStartGamePanel().refreshPlayersTable();
        return null;
    }

    private Element updateGameOptions(Element element) {
        Game game = this.getFreeColClient().getGame();
        Element mgoElement = (Element)element.getElementsByTagName(GameOptions.getXMLElementTagName()).item(0);
        game.getGameOptions().readFromXMLElement(mgoElement);
        this.getFreeColClient().getCanvas().getStartGamePanel().updateGameOptions();
        return null;
    }

    private Element updateMapGeneratorOptions(Element element) {
        Element mgoElement = (Element)element.getElementsByTagName(MapGeneratorOptions.getXMLElementTagName()).item(0);
        this.getFreeColClient().getPreGameController().getMapGeneratorOptions().readFromXMLElement(mgoElement);
        this.getFreeColClient().getCanvas().getStartGamePanel().updateMapGeneratorOptions();
        return null;
    }

    private Element chat(Element element) {
        String senderName = element.getAttribute("senderName");
        String message = element.getAttribute("message");
        boolean privateChat = Boolean.valueOf(element.getAttribute("privateChat"));
        this.getFreeColClient().getCanvas().getStartGamePanel().displayChat(senderName, message, privateChat);
        return null;
    }

    private Element playerReady(Element element) {
        Game game = this.getFreeColClient().getGame();
        Player player = (Player)game.getFreeColGameObject(element.getAttribute("player"));
        boolean ready = Boolean.valueOf(element.getAttribute("value"));
        player.setReady(ready);
        this.getFreeColClient().getCanvas().getStartGamePanel().refreshPlayersTable();
        return null;
    }

    private Element updateNation(Element element) {
        Game game = this.getFreeColClient().getGame();
        Player player = (Player)game.getFreeColGameObject(element.getAttribute("player"));
        Nation nation = FreeCol.getSpecification().getNation(element.getAttribute("value"));
        player.setNation(nation);
        this.getFreeColClient().getCanvas().getStartGamePanel().refreshPlayersTable();
        return null;
    }

    private Element updateNationType(Element element) {
        Game game = this.getFreeColClient().getGame();
        Player player = (Player)game.getFreeColGameObject(element.getAttribute("player"));
        NationType nationType = FreeCol.getSpecification().getNationType(element.getAttribute("value"));
        player.setNationType(nationType);
        this.getFreeColClient().getCanvas().getStartGamePanel().refreshPlayersTable();
        return null;
    }

    private Element updateColor(Element element) {
        Game game = this.getFreeColClient().getGame();
        Player player = (Player)game.getFreeColGameObject(element.getAttribute("player"));
        String color = element.getAttribute("value");
        player.setColor(new Color(Integer.decode(color)));
        this.getFreeColClient().getCanvas().getStartGamePanel().refreshPlayersTable();
        return null;
    }

    private void updateGame(Connection connection, XMLStreamReader in, XMLStreamWriter out) {
        try {
            in.nextTag();
            this.getFreeColClient().getGame().readFromXML(in);
        }
        catch (XMLStreamException e) {
            logger.warning(e.toString());
        }
    }

    private Element startGame(Element element) {
        new Thread("FreeColClient:Starting game"){

            public void run() {
                while (PreGameInputHandler.this.getFreeColClient().getGame().getMap() == null) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception exception) {}
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        PreGameInputHandler.this.getFreeColClient().getPreGameController().startGame();
                    }
                });
            }
        }.start();
        return null;
    }

    private Element logout(Element element) {
        Game game = this.getFreeColClient().getGame();
        String playerID = element.getAttribute("player");
        Player player = (Player)game.getFreeColGameObject(playerID);
        game.removePlayer(player);
        this.getFreeColClient().getCanvas().getStartGamePanel().refreshPlayersTable();
        return null;
    }

    private Element error(Element element) {
        Canvas canvas = this.getFreeColClient().getCanvas();
        if (element.hasAttribute("messageID")) {
            canvas.errorMessage(element.getAttribute("messageID"), element.getAttribute("message"));
        } else {
            canvas.errorMessage(null, element.getAttribute("message"));
        }
        return null;
    }
}

