/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FreeColMenuBar;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.GUIMessage;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.TilePopup;
import net.sf.freecol.client.gui.action.MapControlsAction;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.BuildQueuePanel;
import net.sf.freecol.client.gui.panel.ChatPanel;
import net.sf.freecol.client.gui.panel.ChoiceItem;
import net.sf.freecol.client.gui.panel.ChooseFoundingFatherDialog;
import net.sf.freecol.client.gui.panel.ClientOptionsDialog;
import net.sf.freecol.client.gui.panel.ColonyPanel;
import net.sf.freecol.client.gui.panel.ColopediaPanel;
import net.sf.freecol.client.gui.panel.DeclarationDialog;
import net.sf.freecol.client.gui.panel.DumpCargoDialog;
import net.sf.freecol.client.gui.panel.EmigrationPanel;
import net.sf.freecol.client.gui.panel.ErrorPanel;
import net.sf.freecol.client.gui.panel.EuropePanel;
import net.sf.freecol.client.gui.panel.EventPanel;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.FreeColImageBorder;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.GameOptionsDialog;
import net.sf.freecol.client.gui.panel.IndianSettlementPanel;
import net.sf.freecol.client.gui.panel.InformationDialog;
import net.sf.freecol.client.gui.panel.LoadingSavegameDialog;
import net.sf.freecol.client.gui.panel.MainPanel;
import net.sf.freecol.client.gui.panel.MapControls;
import net.sf.freecol.client.gui.panel.MapGeneratorOptionsDialog;
import net.sf.freecol.client.gui.panel.MonarchPanel;
import net.sf.freecol.client.gui.panel.NegotiationDialog;
import net.sf.freecol.client.gui.panel.NewPanel;
import net.sf.freecol.client.gui.panel.PreCombatDialog;
import net.sf.freecol.client.gui.panel.RecruitDialog;
import net.sf.freecol.client.gui.panel.ReportCargoPanel;
import net.sf.freecol.client.gui.panel.ReportColonyPanel;
import net.sf.freecol.client.gui.panel.ReportContinentalCongressPanel;
import net.sf.freecol.client.gui.panel.ReportExplorationPanel;
import net.sf.freecol.client.gui.panel.ReportForeignAffairPanel;
import net.sf.freecol.client.gui.panel.ReportHighScoresPanel;
import net.sf.freecol.client.gui.panel.ReportHistoryPanel;
import net.sf.freecol.client.gui.panel.ReportIndianPanel;
import net.sf.freecol.client.gui.panel.ReportLabourPanel;
import net.sf.freecol.client.gui.panel.ReportMilitaryPanel;
import net.sf.freecol.client.gui.panel.ReportNavalPanel;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.client.gui.panel.ReportReligiousPanel;
import net.sf.freecol.client.gui.panel.ReportRequirementsPanel;
import net.sf.freecol.client.gui.panel.ReportTradePanel;
import net.sf.freecol.client.gui.panel.ReportTurnPanel;
import net.sf.freecol.client.gui.panel.RiverStylePanel;
import net.sf.freecol.client.gui.panel.SelectAmountDialog;
import net.sf.freecol.client.gui.panel.ServerListPanel;
import net.sf.freecol.client.gui.panel.StartGamePanel;
import net.sf.freecol.client.gui.panel.StatusPanel;
import net.sf.freecol.client.gui.panel.TilePanel;
import net.sf.freecol.client.gui.panel.TradeRouteDialog;
import net.sf.freecol.client.gui.panel.TradeRouteInputDialog;
import net.sf.freecol.client.gui.panel.TrainDialog;
import net.sf.freecol.client.gui.panel.WarehouseDialog;
import net.sf.freecol.common.ServerInfo;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.server.generator.MapGeneratorOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Canvas
extends JDesktopPane {
    private static final Logger logger = Logger.getLogger(Canvas.class.getName());
    private static final Integer MAIN_LAYER = JLayeredPane.DEFAULT_LAYER;
    private static final Integer STATUS_LAYER = JLayeredPane.POPUP_LAYER;
    private static final int EXIT = 0;
    private static final int RECRUIT = 1;
    private static final int PURCHASE = 2;
    private static final int TRAIN = 3;
    private static final int UNLOAD = 4;
    private FreeColDialog europeOpenDialog = null;
    private final FreeColClient freeColClient;
    private final MainPanel mainPanel;
    private final StartGamePanel startGamePanel;
    private final EuropePanel europePanel;
    private final StatusPanel statusPanel;
    private final ChatPanel chatPanel;
    private final GUI gui;
    private final ServerListPanel serverListPanel;
    private final ClientOptionsDialog clientOptionsDialog;
    private final LoadingSavegameDialog loadingSavegameDialog;
    private final GUI colonyTileGUI;
    private JMenuBar jMenuBar;
    private boolean clientOptionsDialogShowing = false;
    private MapControls mapControls;
    private Dimension oldSize = null;
    private Dimension initialSize = null;

    public Canvas(FreeColClient client, Dimension size, GUI gui) {
        this.freeColClient = client;
        this.gui = gui;
        this.colonyTileGUI = new GUI(client, size, this.freeColClient.getImageLibrary());
        this.initialSize = size;
        this.setLocation(0, 0);
        this.setSize(size);
        this.setDoubleBuffered(true);
        this.setOpaque(false);
        this.setLayout(null);
        this.mainPanel = new MainPanel(this, this.freeColClient);
        this.startGamePanel = new StartGamePanel(this, this.freeColClient);
        this.serverListPanel = new ServerListPanel(this, this.freeColClient, this.freeColClient.getConnectController());
        this.europePanel = new EuropePanel(this, this.freeColClient, this.freeColClient.getInGameController());
        this.statusPanel = new StatusPanel(this);
        this.chatPanel = new ChatPanel(this, this.freeColClient);
        this.clientOptionsDialog = new ClientOptionsDialog(this, this.freeColClient);
        this.loadingSavegameDialog = new LoadingSavegameDialog(this, this.freeColClient);
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        Runtime runtime = Runtime.getRuntime();
        runtime.addShutdownHook(new Thread("FreeColClient:Quitting Game"){

            public void run() {
                Canvas.this.freeColClient.getConnectController().quitGame(true);
            }
        });
        logger.info("Canvas created.");
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(640, 480);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.initialSize;
    }

    public GUI getColonyTileGUI() {
        return this.colonyTileGUI;
    }

    public ClientOptionsDialog getClientOptionsDialog() {
        return this.clientOptionsDialog;
    }

    public void setJMenuBar(JMenuBar mb) {
        if (this.jMenuBar != null) {
            this.remove(this.jMenuBar);
        }
        mb.setLocation(0, 0);
        mb.setSize(this.getWidth(), (int)mb.getPreferredSize().getHeight());
        this.add(mb);
        this.jMenuBar = mb;
    }

    public JMenuBar getJMenuBar() {
        return this.jMenuBar;
    }

    public void updateGoldLabel() {
        this.getJMenuBar().repaint();
    }

    public void updateSizes() {
        if (this.oldSize == null) {
            this.oldSize = this.getSize();
        }
        if (this.oldSize.width != this.getWidth() || this.oldSize.height != this.getHeight()) {
            JInternalFrame f;
            MapControlsAction mca;
            MapControls mc;
            if (this.jMenuBar != null) {
                this.jMenuBar.setSize(this.getWidth(), (int)this.jMenuBar.getPreferredSize().getHeight());
            }
            if ((mc = (mca = (MapControlsAction)this.freeColClient.getActionManager().getFreeColAction("mapControlsAction")).getMapControls()) != null && mc.isShowing()) {
                mc.removeFromComponent(this);
                mc.addToComponent(this);
                this.mapControls = mc;
            }
            if (this.europePanel != null && (f = this.getInternalFrame(this.europePanel)) != null) {
                f.setSize(this.getWidth(), this.getHeight() - this.getMenuBarHeight());
                f.setLocation(0, this.getMenuBarHeight());
            }
            this.gui.setSize(this.getSize());
            this.gui.forceReposition();
            this.oldSize = this.getSize();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        this.updateSizes();
        Graphics2D g2d = (Graphics2D)g;
        this.gui.display(g2d);
    }

    public int getMenuBarHeight() {
        if (this.jMenuBar == null) {
            return 0;
        }
        if (this.jMenuBar instanceof FreeColMenuBar) {
            return ((FreeColMenuBar)this.jMenuBar).getOpaqueHeight();
        }
        return this.jMenuBar.getHeight();
    }

    public void showStartGamePanel(Game game, Player player, boolean singlePlayerMode, int players, int advantages, boolean additionalNations) {
        this.closeMenus();
        if (game != null && player != null) {
            this.startGamePanel.initialize(singlePlayerMode, additionalNations, advantages);
            this.addAsFrame(this.startGamePanel);
            this.startGamePanel.requestFocus();
        } else {
            logger.warning("Tried to open 'StartGamePanel' without having 'game' and/or 'player' set.");
        }
    }

    public void showServerListPanel(String username, ArrayList<ServerInfo> serverList) {
        this.closeMenus();
        this.serverListPanel.initialize(username, serverList);
        this.addAsFrame(this.serverListPanel);
        this.serverListPanel.requestFocus();
    }

    public boolean showWarehouseDialog(Colony colony) {
        WarehouseDialog warehouseDialog = new WarehouseDialog(this);
        warehouseDialog.initialize(colony);
        this.addAsFrame(warehouseDialog);
        warehouseDialog.requestFocus();
        boolean response = warehouseDialog.getResponseBoolean();
        this.remove(warehouseDialog);
        return response;
    }

    public DiplomaticTrade showNegotiationDialog(Unit unit, Settlement settlement, DiplomaticTrade agreement) {
        NegotiationDialog negotiationDialog = new NegotiationDialog(this, unit, settlement, agreement);
        negotiationDialog.initialize();
        this.addAsFrame(negotiationDialog);
        DiplomaticTrade offer = (DiplomaticTrade)negotiationDialog.getResponse();
        this.remove(negotiationDialog);
        return offer;
    }

    public void showPanel(FreeColPanel panel) {
        this.closeMenus();
        this.addAsFrame(panel);
        panel.requestFocus();
    }

    public void showPanel(FreeColPanel panel, boolean centered) {
        this.closeMenus();
        this.addAsFrame(panel, false, centered);
        panel.requestFocus();
    }

    public void showSubPanel(FreeColPanel panel) {
        this.addAsFrame(panel);
        panel.requestFocus();
    }

    public void showChatPanel() {
        if (this.freeColClient.isSingleplayer()) {
            return;
        }
        this.closeMenus();
        this.addAsFrame(this.chatPanel);
        this.chatPanel.requestFocus();
    }

    public int showSelectAmountDialog(GoodsType goodsType, int available, boolean needToPay) {
        SelectAmountDialog dialog = new SelectAmountDialog(this, goodsType, available, needToPay);
        dialog.initialize();
        this.addAsFrame(dialog);
        dialog.requestFocus();
        int amount = dialog.getResponseInt();
        this.remove(dialog);
        return amount;
    }

    public void showModelMessages(ModelMessage ... modelMessages) {
        if (modelMessages.length == 1) {
            String id = modelMessages[0].getId();
            if ("EventPanel.MEETING_NATIVES".equals(id)) {
                this.showEventDialog(1);
                return;
            }
            if ("EventPanel.MEETING_AZTEC".equals(id)) {
                this.showEventDialog(3);
                return;
            }
        }
        String okText = "ok";
        String cancelText = "display";
        String[] messageText = new String[modelMessages.length];
        ImageIcon[] messageIcon = new ImageIcon[modelMessages.length];
        try {
            okText = Messages.message(okText, new String[0]);
        }
        catch (MissingResourceException e) {
            logger.warning("could not find message with id: " + okText + ".");
        }
        try {
            cancelText = Messages.message(cancelText, new String[0]);
        }
        catch (MissingResourceException e) {
            logger.warning("could not find message with id: " + cancelText + ".");
        }
        for (int i = 0; i < modelMessages.length; ++i) {
            try {
                messageText[i] = Messages.message(modelMessages[i].getId(), modelMessages[i].getData());
            }
            catch (MissingResourceException e) {
                logger.warning("could not find message with id: " + modelMessages[i].getId() + ".");
            }
            messageIcon[i] = this.getImageIcon(modelMessages[i].getDisplay(), false);
        }
        FreeColGameObject source = modelMessages[0].getSource();
        if (source instanceof Europe && !this.europePanel.isShowing() || source instanceof Colony || source instanceof WorkLocation) {
            FreeColDialog confirmDialog = FreeColDialog.createConfirmDialog(messageText, messageIcon, okText, cancelText);
            this.addAsFrame(confirmDialog);
            confirmDialog.requestFocus();
            if (!confirmDialog.getResponseBoolean()) {
                this.remove(confirmDialog);
                if (source instanceof Europe) {
                    this.showEuropePanel();
                } else if (source instanceof Colony) {
                    this.showColonyPanel((Colony)source);
                } else if (source instanceof WorkLocation) {
                    this.showColonyPanel(((WorkLocation)((Object)source)).getColony());
                }
            } else {
                this.remove(confirmDialog);
                if (!this.isShowingSubPanel()) {
                    this.freeColClient.getInGameController().nextModelMessage();
                }
            }
        } else {
            InformationDialog informationDialog = new InformationDialog(messageText, messageIcon);
            this.addAsFrame(informationDialog);
            informationDialog.requestFocus();
            informationDialog.getResponse();
            this.remove(informationDialog);
            if (!this.isShowingSubPanel()) {
                this.freeColClient.getInGameController().nextModelMessage();
            }
        }
    }

    public ImageIcon getImageIcon(Object display, boolean small) {
        ImageLibrary imageLibrary = this.getGUI().getImageLibrary();
        Image image = null;
        if (display == null) {
            return new ImageIcon();
        }
        if (display instanceof GoodsType) {
            GoodsType goodsType = (GoodsType)display;
            try {
                image = imageLibrary.getGoodsImage(goodsType);
            }
            catch (Exception e) {
                logger.warning("could not find image for goods " + goodsType.getName());
            }
        } else if (display instanceof Unit) {
            Unit unit = (Unit)display;
            try {
                image = imageLibrary.getUnitImageIcon(unit.getType()).getImage();
            }
            catch (Exception e) {
                logger.warning("could not find image for unit " + unit.getName());
            }
        } else if (display instanceof Settlement) {
            Settlement settlement = (Settlement)display;
            try {
                image = imageLibrary.getSettlementImage(settlement);
            }
            catch (Exception e) {
                logger.warning("could not find image for settlement " + settlement);
            }
        } else if (display instanceof LostCityRumour) {
            try {
                image = imageLibrary.getMiscImage("lostCityRumour.image");
            }
            catch (Exception e) {
                logger.warning("could not find image for lost city rumour");
            }
        } else if (display instanceof Player) {
            image = imageLibrary.getCoatOfArmsImage(((Player)display).getNation());
        }
        if (image != null && small) {
            return new ImageIcon(image.getScaledInstance(image.getWidth(null) / 3 * 2, image.getHeight(null) / 3 * 2, 4));
        }
        return image != null ? new ImageIcon(image) : null;
    }

    public void showDeclarationDialog() {
        DeclarationDialog declarationDialog = new DeclarationDialog(this, this.freeColClient);
        declarationDialog.initialize();
        this.addAsFrame(declarationDialog);
        declarationDialog.requestFocus();
        declarationDialog.getResponseBoolean();
        this.remove(declarationDialog);
    }

    public Object showFreeColDialog(FreeColDialog freeColDialog) {
        this.addAsFrame(freeColDialog);
        freeColDialog.requestFocus();
        Object response = freeColDialog.getResponse();
        this.remove(freeColDialog);
        return response;
    }

    public boolean showConfirmDialog(String text, String okText, String cancelText, String ... replace) {
        try {
            text = Messages.message(text, replace);
            okText = Messages.message(okText, new String[0]);
            cancelText = Messages.message(cancelText, new String[0]);
        }
        catch (MissingResourceException e) {
            logger.warning("could not find message with id: " + text + ", " + okText + " or " + cancelText + ".");
        }
        FreeColDialog confirmDialog = FreeColDialog.createConfirmDialog(text, okText, cancelText);
        this.addAsFrame(confirmDialog);
        confirmDialog.requestFocus();
        boolean response = confirmDialog.getResponseBoolean();
        this.remove(confirmDialog);
        return response;
    }

    public boolean showPreCombatDialog(Unit attacker, Unit defender, Settlement settlement) {
        PreCombatDialog preCombatDialog = new PreCombatDialog(attacker, defender, settlement, this);
        this.addAsFrame(preCombatDialog);
        preCombatDialog.requestFocus();
        boolean response = preCombatDialog.getResponseBoolean();
        this.remove(preCombatDialog);
        return response;
    }

    public boolean showConfirmDialog(ModelMessage[] messages, String okText, String cancelText) {
        try {
            okText = Messages.message(okText, new String[0]);
        }
        catch (MissingResourceException e) {
            logger.warning("could not find message with id: " + okText + ".");
        }
        try {
            cancelText = Messages.message(cancelText, new String[0]);
        }
        catch (MissingResourceException e) {
            logger.warning("could not find message with id: " + cancelText + ".");
        }
        String[] texts = new String[messages.length];
        ImageIcon[] images = new ImageIcon[messages.length];
        for (int i = 0; i < messages.length; ++i) {
            String id = messages[i].getId();
            try {
                texts[i] = Messages.message(id, messages[i].getData());
            }
            catch (MissingResourceException e) {
                logger.warning("could not find message with id: " + id + ".");
            }
            images[i] = this.getImageIcon(messages[i].getDisplay(), false);
        }
        FreeColDialog confirmDialog = FreeColDialog.createConfirmDialog(texts, images, okText, cancelText);
        this.addAsFrame(confirmDialog);
        confirmDialog.requestFocus();
        boolean response = confirmDialog.getResponseBoolean();
        this.remove(confirmDialog);
        return response;
    }

    public boolean isClientOptionsDialogShowing() {
        return this.clientOptionsDialogShowing;
    }

    public boolean isMapboardActionsEnabled() {
        return !this.isShowingSubPanel();
    }

    public boolean isShowingSubPanel() {
        Component[] components;
        for (Component c : components = this.getComponents()) {
            if (c instanceof ToolBoxFrame) continue;
            if (c instanceof JInternalFrame) {
                return true;
            }
            if (!(c instanceof JInternalFrame.JDesktopIcon)) continue;
            return true;
        }
        return false;
    }

    public boolean showGameOptionsDialog(boolean editable) {
        GameOptionsDialog gameOptionsDialog = new GameOptionsDialog(this, this.freeColClient);
        gameOptionsDialog.initialize(editable);
        this.addAsFrame(gameOptionsDialog);
        gameOptionsDialog.requestFocus();
        boolean r = gameOptionsDialog.getResponseBoolean();
        this.remove(gameOptionsDialog);
        return r;
    }

    public LoadingSavegameDialog getLoadingSavegameDialog() {
        return this.loadingSavegameDialog;
    }

    public boolean showLoadingSavegameDialog(boolean publicServer, boolean singleplayer) {
        this.loadingSavegameDialog.initialize(publicServer, singleplayer);
        this.addAsFrame(this.loadingSavegameDialog);
        this.loadingSavegameDialog.requestFocus();
        boolean r = this.loadingSavegameDialog.getResponseBoolean();
        this.remove(this.loadingSavegameDialog);
        return r;
    }

    public boolean showClientOptionsDialog() {
        this.clientOptionsDialog.initialize();
        this.clientOptionsDialogShowing = true;
        this.addAsFrame(this.clientOptionsDialog);
        this.clientOptionsDialog.requestFocus();
        boolean r = this.clientOptionsDialog.getResponseBoolean();
        this.remove(this.clientOptionsDialog);
        this.clientOptionsDialogShowing = false;
        this.freeColClient.getActionManager().update();
        return r;
    }

    public boolean showMapGeneratorOptionsDialog(boolean editable) {
        MapGeneratorOptions mgo = this.freeColClient.getPreGameController().getMapGeneratorOptions();
        return this.showMapGeneratorOptionsDialog(editable, mgo);
    }

    public boolean showMapGeneratorOptionsDialog(boolean editable, MapGeneratorOptions mgo) {
        MapGeneratorOptionsDialog mapGeneratorOptionsDialog = new MapGeneratorOptionsDialog(this, this.freeColClient);
        mapGeneratorOptionsDialog.initialize(editable, mgo);
        this.addAsFrame(mapGeneratorOptionsDialog);
        mapGeneratorOptionsDialog.requestFocus();
        boolean r = mapGeneratorOptionsDialog.getResponseBoolean();
        this.remove(mapGeneratorOptionsDialog);
        return r;
    }

    public File showLoadDialog(File directory) {
        return this.showLoadDialog(directory, new FileFilter[]{FreeColDialog.getFSGFileFilter()});
    }

    public File showLoadDialog(File directory, FileFilter[] fileFilters) {
        FreeColDialog loadDialog = FreeColDialog.createLoadDialog(directory, fileFilters);
        this.addAsFrame(loadDialog);
        loadDialog.requestFocus();
        File response = (File)loadDialog.getResponse();
        while (response != null && !response.isFile()) {
            this.errorMessage("noSuchFile");
            response = (File)loadDialog.getResponse();
        }
        this.remove(loadDialog);
        return response;
    }

    public File showSaveDialog(File directory, String defaultName) {
        return this.showSaveDialog(directory, ".fsg", new FileFilter[]{FreeColDialog.getFSGFileFilter()}, defaultName);
    }

    public File showSaveDialog(File directory, String standardName, FileFilter[] fileFilters, String defaultName) {
        FreeColDialog saveDialog = FreeColDialog.createSaveDialog(directory, standardName, fileFilters, defaultName);
        this.addAsFrame(saveDialog);
        saveDialog.requestFocus();
        File response = (File)saveDialog.getResponse();
        this.remove(saveDialog);
        return response;
    }

    public BoycottAction showBoycottedGoodsDialog(Goods goods, Europe europe) {
        int arrears = europe.getOwner().getArrears(goods.getType());
        FreeColDialog boycottedGoodsDialog = FreeColDialog.createChoiceDialog(Messages.message("boycottedGoods.text", "%goods%", goods.getName(), "%europe%", europe.getName(), "%amount%", String.valueOf(arrears)), null, new ChoiceItem(Messages.message("boycottedGoods.payArrears", new String[0]), (Object)BoycottAction.PAY_ARREARS), new ChoiceItem(Messages.message("boycottedGoods.dumpGoods", new String[0]), (Object)BoycottAction.DUMP_CARGO), new ChoiceItem(Messages.message("cancel", new String[0]), (Object)BoycottAction.CANCEL));
        this.addAsFrame(boycottedGoodsDialog);
        ChoiceItem response = (ChoiceItem)boycottedGoodsDialog.getResponse();
        this.remove(boycottedGoodsDialog);
        return (BoycottAction)((Object)response.getObject());
    }

    public ScoutAction showScoutIndianSettlementDialog(IndianSettlement settlement) {
        StringBuilder text = new StringBuilder(400);
        text.append(Messages.message(settlement.getAlarmLevelMessage(this.freeColClient.getMyPlayer()), "%nation%", settlement.getOwner().getNationAsString()));
        text.append("\n\n");
        text.append(Messages.message("scoutSettlement.greetings", "%nation%", settlement.getOwner().getNationAsString(), "%number%", String.valueOf(settlement.getOwner().getNumberOfSettlements())));
        text.append(" ");
        if (settlement.getLearnableSkill() != null) {
            text.append(Messages.message("scoutSettlement.skill", "%skill%", settlement.getLearnableSkill().getName()));
            text.append(" ");
        }
        text.append(Messages.message("scoutSettlement.trade", "%goods1%", settlement.getWantedGoods()[0].getName(), "%goods2%", settlement.getWantedGoods()[1].getName(), "%goods3%", settlement.getWantedGoods()[2].getName()));
        text.append("\n\n");
        FreeColDialog scoutDialog = FreeColDialog.createChoiceDialog(text.toString(), null, new ChoiceItem(Messages.message("scoutSettlement.speak", new String[0]), (Object)ScoutAction.INDIAN_SETTLEMENT_SPEAK), new ChoiceItem(Messages.message("scoutSettlement.tribute", new String[0]), (Object)ScoutAction.INDIAN_SETTLEMENT_TRIBUTE), new ChoiceItem(Messages.message("scoutSettlement.attack", new String[0]), (Object)ScoutAction.INDIAN_SETTLEMENT_ATTACK), new ChoiceItem(Messages.message("cancel", new String[0]), (Object)ScoutAction.CANCEL));
        this.addAsFrame(scoutDialog);
        scoutDialog.requestFocus();
        ChoiceItem responseItem = (ChoiceItem)scoutDialog.getResponse();
        ScoutAction response = (ScoutAction)((Object)responseItem.getObject());
        this.remove(scoutDialog);
        return response;
    }

    public ScoutAction showScoutForeignColonyDialog(Colony colony, Unit unit) {
        boolean isPlayersREF;
        String mainText = Messages.message("scoutColony.text", "%unit%", unit.getName(), "%colony%", colony.getName());
        ArrayList<ChoiceItem> choiceList = new ArrayList<ChoiceItem>();
        boolean bl = isPlayersREF = colony.getOwner() == unit.getOwner().getREFPlayer();
        if (!isPlayersREF) {
            choiceList.add(new ChoiceItem(Messages.message("scoutColony.negotiate", new String[0]), (Object)ScoutAction.FOREIGN_COLONY_NEGOTIATE));
        }
        choiceList.add(new ChoiceItem(Messages.message("scoutColony.spy", new String[0]), (Object)ScoutAction.FOREIGN_COLONY_SPY));
        choiceList.add(new ChoiceItem(Messages.message("scoutColony.attack", new String[0]), (Object)ScoutAction.FOREIGN_COLONY_ATTACK));
        choiceList.add(new ChoiceItem(Messages.message("cancel", new String[0]), (Object)ScoutAction.CANCEL));
        FreeColDialog scoutDialog = FreeColDialog.createChoiceDialog(mainText, null, choiceList.toArray(new ChoiceItem[0]));
        this.addAsFrame(scoutDialog);
        scoutDialog.requestFocus();
        ChoiceItem responseItem = (ChoiceItem)scoutDialog.getResponse();
        ScoutAction response = (ScoutAction)((Object)responseItem.getObject());
        this.remove(scoutDialog);
        return response;
    }

    public ScoutAction showArmedUnitIndianSettlementDialog(IndianSettlement settlement) {
        String introText = Messages.message(settlement.getAlarmLevelMessage(this.freeColClient.getMyPlayer()), "%nation%", settlement.getOwner().getNationAsString());
        FreeColDialog armedUnitDialog = FreeColDialog.createChoiceDialog(introText, null, new ChoiceItem(Messages.message("scoutSettlement.tribute", new String[0]), (Object)ScoutAction.INDIAN_SETTLEMENT_TRIBUTE), new ChoiceItem(Messages.message("scoutSettlement.attack", new String[0]), (Object)ScoutAction.INDIAN_SETTLEMENT_ATTACK), new ChoiceItem(Messages.message("cancel", new String[0]), (Object)ScoutAction.CANCEL));
        this.addAsFrame(armedUnitDialog);
        armedUnitDialog.requestFocus();
        ChoiceItem responseItem = (ChoiceItem)armedUnitDialog.getResponse();
        ScoutAction response = (ScoutAction)((Object)responseItem.getObject());
        this.remove(armedUnitDialog);
        return response;
    }

    public List<Object> showUseMissionaryDialog(IndianSettlement settlement) {
        StringBuilder introText = new StringBuilder(Messages.message(settlement.getAlarmLevelMessage(this.freeColClient.getMyPlayer()), "%nation%", settlement.getOwner().getNationAsString()));
        introText.append("\n\n");
        introText.append(Messages.message("missionarySettlement.question", new String[0]));
        ChoiceItem establish = new ChoiceItem(Messages.message("missionarySettlement.establish", new String[0]), (Object)MissionaryAction.ESTABLISH_MISSION);
        ChoiceItem heresy = new ChoiceItem(Messages.message("missionarySettlement.heresy", new String[0]), (Object)MissionaryAction.DENOUNCE_HERESY);
        ChoiceItem incite = new ChoiceItem(Messages.message("missionarySettlement.incite", new String[0]), (Object)MissionaryAction.INCITE_INDIANS);
        ChoiceItem cancel = new ChoiceItem(Messages.message("cancel", new String[0]), (Object)MissionaryAction.CANCEL);
        FreeColDialog missionaryDialog = settlement.getMissionary() == null ? FreeColDialog.createChoiceDialog(introText.toString(), null, establish, incite, cancel) : FreeColDialog.createChoiceDialog(introText.toString(), null, heresy, incite, cancel);
        this.addAsFrame(missionaryDialog);
        missionaryDialog.requestFocus();
        ChoiceItem responseItem = (ChoiceItem)missionaryDialog.getResponse();
        MissionaryAction response = (MissionaryAction)((Object)responseItem.getObject());
        ArrayList<Object> returnValue = new ArrayList<Object>();
        returnValue.add((Object)response);
        this.remove(missionaryDialog);
        if (MissionaryAction.INCITE_INDIANS.equals((Object)response)) {
            FreeColDialog inciteDialog = FreeColDialog.createInciteDialog(this.freeColClient.getGame().getEuropeanPlayers(), this.freeColClient.getMyPlayer());
            this.addAsFrame(inciteDialog);
            inciteDialog.requestFocus();
            Player response2 = (Player)inciteDialog.getResponse();
            if (response2 != null) {
                returnValue.add(response2);
            } else {
                returnValue.clear();
                returnValue.add((Object)MissionaryAction.CANCEL);
            }
            this.remove(inciteDialog);
        }
        return returnValue;
    }

    public boolean showInciteDialog(Player enemy, int amount) {
        String message = Messages.message("missionarySettlement.inciteConfirm", new String[0]);
        message = message.replaceAll("%player%", enemy.getName());
        message = message.replaceAll("%amount%", String.valueOf(amount));
        FreeColDialog confirmDialog = FreeColDialog.createConfirmDialog(message, Messages.message("yes", new String[0]), Messages.message("no", new String[0]));
        this.addAsFrame(confirmDialog);
        confirmDialog.requestFocus();
        boolean result = confirmDialog.getResponseBoolean();
        this.remove(confirmDialog);
        return result;
    }

    public String showInputDialog(String text, String defaultValue, String okText, String cancelText, String ... data) {
        return this.showInputDialog(text, defaultValue, okText, cancelText, true, data);
    }

    public String showInputDialog(String text, String defaultValue, String okText, String cancelText, boolean rejectEmptyString, String ... data) {
        try {
            text = Messages.message(text, data);
            okText = Messages.message(okText, new String[0]);
            if (cancelText != null) {
                cancelText = Messages.message(cancelText, new String[0]);
            }
        }
        catch (MissingResourceException e) {
            logger.warning("could not find message with id: " + text + ", " + okText + " or " + cancelText + ".");
        }
        FreeColDialog inputDialog = FreeColDialog.createInputDialog(text, defaultValue, okText, cancelText);
        this.addAsFrame(inputDialog);
        inputDialog.requestFocus();
        String response = (String)inputDialog.getResponse();
        while (rejectEmptyString && response != null && response.length() == 0) {
            String okTxt = "ok";
            String txt = "enterSomeText";
            try {
                okTxt = Messages.message(okTxt, new String[0]);
                txt = Messages.message(txt, new String[0]);
            }
            catch (MissingResourceException e) {
                logger.warning("could not find message with id: " + txt + " or " + okTxt + ".");
            }
            InformationDialog informationDialog = new InformationDialog(txt, null);
            this.remove(inputDialog);
            this.addAsFrame(informationDialog);
            informationDialog.requestFocus();
            informationDialog.getResponse();
            this.remove(informationDialog);
            this.addAsFrame(inputDialog);
            inputDialog.requestFocus();
            response = (String)inputDialog.getResponse();
        }
        this.remove(inputDialog);
        return response;
    }

    public Object showChoiceDialog(String text, String cancelText, Iterator<?> iterator) {
        ArrayList<ChoiceItem> a = new ArrayList<ChoiceItem>();
        while (iterator.hasNext()) {
            a.add(new ChoiceItem(iterator.next()));
        }
        return this.showChoiceDialog(text, cancelText, a.toArray(new ChoiceItem[0]));
    }

    public Object showChoiceDialog(String text, String cancelText, ChoiceItem ... objects) {
        FreeColDialog choiceDialog = FreeColDialog.createChoiceDialog(text, cancelText, objects);
        if (choiceDialog.getHeight() > this.getHeight() / 3) {
            choiceDialog.setSize(choiceDialog.getWidth(), this.getHeight() * 2 / 3);
        }
        this.addAsFrame(choiceDialog);
        choiceDialog.requestFocus();
        Object response = choiceDialog.getResponse();
        this.remove(choiceDialog);
        return response;
    }

    public void showStatusPanel(String message) {
        this.statusPanel.setStatusMessage(message);
        this.addCentered(this.statusPanel, STATUS_LAYER);
    }

    public void closeStatusPanel() {
        if (this.statusPanel.isVisible()) {
            this.remove(this.statusPanel);
        }
    }

    public void showColopediaPanel(ColopediaPanel.PanelType type) {
        ColopediaPanel colopediaPanel = new ColopediaPanel(this);
        colopediaPanel.initialize(type);
        this.addAsFrame(colopediaPanel);
        colopediaPanel.requestFocus();
    }

    public void showColopediaPanel(ColopediaPanel.PanelType panelType, FreeColGameObjectType objectType) {
        ColopediaPanel colopediaPanel = new ColopediaPanel(this);
        colopediaPanel.initialize(panelType, objectType);
        this.addAsFrame(colopediaPanel);
        colopediaPanel.requestFocus();
    }

    public void showReportPanel(String classname) {
        ReportPanel reportPanel = null;
        if ("net.sf.freecol.client.gui.panel.ReportReligiousPanel".equals(classname)) {
            reportPanel = new ReportReligiousPanel(this);
        } else if ("net.sf.freecol.client.gui.panel.ReportLabourPanel".equals(classname)) {
            reportPanel = new ReportLabourPanel(this);
        } else if ("net.sf.freecol.client.gui.panel.ReportForeignAffairPanel".equals(classname)) {
            reportPanel = new ReportForeignAffairPanel(this);
        } else if ("net.sf.freecol.client.gui.panel.ReportIndianPanel".equals(classname)) {
            reportPanel = new ReportIndianPanel(this);
        } else if ("net.sf.freecol.client.gui.panel.ReportTurnPanel".equals(classname)) {
            reportPanel = new ReportTurnPanel(this, new ModelMessage[0]);
        } else if ("net.sf.freecol.client.gui.panel.ReportContinentalCongressPanel".equals(classname)) {
            reportPanel = new ReportContinentalCongressPanel(this);
        } else if ("net.sf.freecol.client.gui.panel.ReportTradePanel".equals(classname)) {
            reportPanel = new ReportTradePanel(this);
        } else if ("net.sf.freecol.client.gui.panel.ReportMilitaryPanel".equals(classname)) {
            reportPanel = new ReportMilitaryPanel(this);
        } else if ("net.sf.freecol.client.gui.panel.ReportNavalPanel".equals(classname)) {
            reportPanel = new ReportNavalPanel(this);
        } else if ("net.sf.freecol.client.gui.panel.ReportCargoPanel".equals(classname)) {
            reportPanel = new ReportCargoPanel(this);
        } else if ("net.sf.freecol.client.gui.panel.ReportColonyPanel".equals(classname)) {
            reportPanel = new ReportColonyPanel(this);
        } else if ("net.sf.freecol.client.gui.panel.ReportRequirementsPanel".equals(classname)) {
            reportPanel = new ReportRequirementsPanel(this);
        } else if ("net.sf.freecol.client.gui.panel.ReportExplorationPanel".equals(classname)) {
            reportPanel = new ReportExplorationPanel(this);
        } else if ("net.sf.freecol.client.gui.panel.ReportHistoryPanel".equals(classname)) {
            reportPanel = new ReportHistoryPanel(this);
        } else if ("net.sf.freecol.client.gui.panel.ReportHighScoresPanel".equals(classname)) {
            reportPanel = new ReportHighScoresPanel(this);
        } else {
            logger.warning("Request for Report panel could not be processed.  Name=" + classname);
        }
        if (reportPanel != null) {
            reportPanel.initialize();
            this.addAsFrame(reportPanel);
            reportPanel.requestFocus();
        }
    }

    public FoundingFather showChooseFoundingFatherDialog(List<FoundingFather> possibleFoundingFathers) {
        this.closeStatusPanel();
        ChooseFoundingFatherDialog chooseFoundingFatherDialog = new ChooseFoundingFatherDialog(this);
        chooseFoundingFatherDialog.initialize(possibleFoundingFathers);
        this.addAsFrame(chooseFoundingFatherDialog);
        chooseFoundingFatherDialog.requestFocus();
        int response = chooseFoundingFatherDialog.getResponseInt();
        this.remove(chooseFoundingFatherDialog);
        return possibleFoundingFathers.get(response);
    }

    public boolean showEventDialog(int eventID) {
        EventPanel eventPanel = new EventPanel(this, this.freeColClient);
        eventPanel.initialize(eventID);
        this.addAsFrame(eventPanel);
        eventPanel.requestFocus();
        boolean response = eventPanel.getResponseBoolean();
        this.remove(eventPanel);
        return response;
    }

    public void showEuropePanel() {
        this.closeMenus();
        if (this.freeColClient.getGame() == null) {
            this.errorMessage("europe.noGame");
        } else {
            this.europePanel.initialize(this.freeColClient.getMyPlayer().getEurope(), this.freeColClient.getGame());
            JInternalFrame f = this.addAsSimpleFrame(this.europePanel);
            f.setBorder(null);
            f.setSize(this.getWidth(), this.getHeight() - this.getMenuBarHeight());
            f.setLocation(0, this.getMenuBarHeight());
            f.moveToBack();
        }
    }

    public int showEuropeDialog(EuropePanel.EuropeAction europeAction) {
        try {
            if (this.europeOpenDialog != null) {
                this.europeOpenDialog.setResponse(new Integer(-1));
            }
        }
        catch (NumberFormatException e) {
            logger.warning("Canvas.showEuropeDialog: Invalid europeDialogType");
        }
        FreeColDialog localDialog = null;
        switch (europeAction) {
            case EXIT: 
            case UNLOAD: 
            case SAIL: {
                return -1;
            }
            case RECRUIT: {
                localDialog = new RecruitDialog(this);
                break;
            }
            case PURCHASE: 
            case TRAIN: {
                localDialog = new TrainDialog(this, europeAction);
            }
        }
        localDialog.initialize();
        this.europeOpenDialog = localDialog;
        this.addAsFrame(localDialog);
        localDialog.requestFocus();
        int response = localDialog.getResponseInt();
        this.remove(localDialog);
        if (this.europeOpenDialog == localDialog) {
            this.europeOpenDialog = null;
        }
        return response;
    }

    public TradeRoute showTradeRouteDialog(TradeRoute selectedRoute) {
        TradeRouteDialog tradeRouteDialog = new TradeRouteDialog(this);
        tradeRouteDialog.initialize();
        tradeRouteDialog.setSelectedRoute(selectedRoute);
        this.addAsFrame(tradeRouteDialog);
        tradeRouteDialog.requestFocus();
        TradeRoute response = (TradeRoute)tradeRouteDialog.getResponse();
        this.remove(tradeRouteDialog);
        return response;
    }

    public boolean showTradeRouteInputDialog(TradeRoute route) {
        TradeRouteInputDialog tradeRouteInputDialog = new TradeRouteInputDialog(this);
        tradeRouteInputDialog.initialize(route);
        this.addAsFrame(tradeRouteInputDialog);
        tradeRouteInputDialog.requestFocus();
        boolean response = tradeRouteInputDialog.getResponseBoolean();
        this.remove(tradeRouteInputDialog);
        return response;
    }

    public void showColonyPanel(Colony colony) {
        this.freeColClient.getGUI().stopBlinking();
        ColonyPanel colonyPanel = new ColonyPanel(this, this.freeColClient);
        colonyPanel.initialize(colony, this.freeColClient.getGame());
        this.addAsFrame(colonyPanel);
        colonyPanel.requestFocus();
    }

    public void showBuildQueuePanel(Colony colony) {
        BuildQueuePanel buildQueuePanel = new BuildQueuePanel(this);
        buildQueuePanel.initialize(colony);
        this.addAsFrame(buildQueuePanel);
        buildQueuePanel.requestFocus();
    }

    public void showIndianSettlementPanel(IndianSettlement settlement) {
        this.closeMenus();
        IndianSettlementPanel indianSettlementPanel = new IndianSettlementPanel(this.freeColClient);
        indianSettlementPanel.initialize(settlement);
        this.addAsFrame(indianSettlementPanel);
        indianSettlementPanel.requestFocus();
        indianSettlementPanel.getResponseBoolean();
        this.remove(indianSettlementPanel);
    }

    public ChoiceItem showIndianSettlementTradeDlg(boolean showBuy, boolean showSell, boolean showGift) {
        ArrayList<ChoiceItem> choices = new ArrayList<ChoiceItem>();
        if (showBuy) {
            choices.add(new ChoiceItem(Messages.message("tradeProposition.toBuy", new String[0]), 1));
        }
        if (showSell) {
            choices.add(new ChoiceItem(Messages.message("tradeProposition.toSell", new String[0]), 2));
        }
        if (showGift) {
            choices.add(new ChoiceItem(Messages.message("tradeProposition.toGift", new String[0]), 3));
        }
        ChoiceItem choice = (ChoiceItem)this.showChoiceDialog(Messages.message("tradeProposition.welcome", new String[0]), Messages.message("tradeProposition.cancel", new String[0]), choices.toArray(new ChoiceItem[0]));
        return choice;
    }

    public void showTilePanel(Tile tile) {
        TilePanel tilePanel = new TilePanel(this);
        tilePanel.initialize(tile);
        this.addAsFrame(tilePanel);
        tilePanel.requestFocus();
        tilePanel.getResponseBoolean();
        this.remove(tilePanel);
    }

    public void showDumpCargoDialog(Unit unit) {
        DumpCargoDialog dumpCargoDialog = new DumpCargoDialog(this);
        dumpCargoDialog.initialize(unit);
        this.addAsFrame(dumpCargoDialog);
        dumpCargoDialog.requestFocus();
        dumpCargoDialog.getResponseBoolean();
        this.remove(dumpCargoDialog);
    }

    public boolean showMonarchPanel(Monarch.MonarchAction action, String ... replace) {
        this.closeStatusPanel();
        MonarchPanel monarchPanel = new MonarchPanel(this);
        monarchPanel.initialize(action, replace);
        this.addAsFrame(monarchPanel);
        monarchPanel.requestFocus();
        boolean response = monarchPanel.getResponseBoolean();
        this.remove(monarchPanel);
        return response;
    }

    public int showEmigrationPanel() {
        return this.showEmigrationPanel(false);
    }

    public int showEmigrationPanel(boolean fountainOfYouth) {
        EmigrationPanel emigrationPanel = new EmigrationPanel(this);
        emigrationPanel.initialize(this.freeColClient.getMyPlayer().getEurope(), fountainOfYouth);
        this.addAsFrame(emigrationPanel);
        emigrationPanel.requestFocus();
        int response = emigrationPanel.getResponseInt();
        this.remove(emigrationPanel);
        return response;
    }

    public int showRiverStylePanel() {
        RiverStylePanel riverStylePanel = new RiverStylePanel(this);
        this.addAsFrame(riverStylePanel);
        riverStylePanel.requestFocus();
        int response = riverStylePanel.getResponseInt();
        this.remove(riverStylePanel);
        return response;
    }

    public void updateJMenuBar() {
        if (this.jMenuBar instanceof FreeColMenuBar) {
            ((FreeColMenuBar)this.jMenuBar).update();
        }
    }

    public void resetFreeColMenuBar() {
        if (this.jMenuBar instanceof FreeColMenuBar) {
            ((FreeColMenuBar)this.jMenuBar).reset();
        }
    }

    @Override
    public void remove(Component comp) {
        this.remove(comp, true);
    }

    private JInternalFrame getInternalFrame(Component c) {
        Component temp;
        for (temp = c; temp != null && !(temp instanceof JInternalFrame); temp = temp.getParent()) {
        }
        return (JInternalFrame)temp;
    }

    public void remove(Component comp, boolean update) {
        boolean takeFocus;
        if (comp == null) {
            return;
        }
        Rectangle updateBounds = comp.getBounds();
        if (comp == this.jMenuBar) {
            this.jMenuBar = null;
            super.remove(comp);
        } else {
            JInternalFrame frame = this.getInternalFrame(comp);
            if (frame != null && frame != comp) {
                frame.dispose();
            } else {
                super.remove(comp);
            }
        }
        this.repaint(updateBounds.x, updateBounds.y, updateBounds.width, updateBounds.height);
        boolean bl = takeFocus = comp != this.statusPanel;
        if (update) {
            this.updateJMenuBar();
            this.freeColClient.getActionManager().update();
            if (takeFocus && !this.isShowingSubPanel()) {
                this.takeFocus();
            }
        }
    }

    @Override
    public Component add(Component comp) {
        this.add(comp, null);
        return comp;
    }

    public Component addCentered(Component comp) {
        this.addCentered(comp, null);
        return comp;
    }

    public JInternalFrame addAsFrame(JComponent comp) {
        return this.addAsFrame(comp, false);
    }

    public JInternalFrame addAsToolBox(JComponent comp) {
        return this.addAsFrame(comp, true);
    }

    private JInternalFrame addAsFrame(JComponent comp, boolean toolBox) {
        return this.addAsFrame(comp, toolBox, true);
    }

    private JInternalFrame addAsFrame(JComponent comp, boolean toolBox, boolean centered) {
        JInternalFrame f;
        int FRAME_EMPTY_SPACE = 60;
        JInternalFrame jInternalFrame = f = toolBox ? new ToolBoxFrame() : new JInternalFrame();
        if (f.getContentPane() instanceof JComponent) {
            JComponent c = (JComponent)f.getContentPane();
            c.setOpaque(false);
            c.setBorder(null);
        }
        if (comp.getBorder() != null) {
            Image menuborderN = ResourceManager.getImage("menuborder.n.image");
            Image menuborderNW = ResourceManager.getImage("menuborder.nw.image");
            Image menuborderNE = ResourceManager.getImage("menuborder.ne.image");
            Image menuborderW = ResourceManager.getImage("menuborder.w.image");
            Image menuborderE = ResourceManager.getImage("menuborder.e.image");
            Image menuborderS = ResourceManager.getImage("menuborder.s.image");
            Image menuborderSW = ResourceManager.getImage("menuborder.sw.image");
            Image menuborderSE = ResourceManager.getImage("menuborder.se.image");
            FreeColImageBorder imageBorder = new FreeColImageBorder(menuborderN, menuborderW, menuborderS, menuborderE, menuborderNW, menuborderNE, menuborderSW, menuborderSE);
            f.setBorder(imageBorder);
            comp.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        } else {
            f.setBorder(null);
        }
        FrameMotionListener fml = new FrameMotionListener(f);
        comp.addMouseMotionListener(fml);
        comp.addMouseListener(fml);
        if (f.getUI() instanceof BasicInternalFrameUI) {
            BasicInternalFrameUI biu = (BasicInternalFrameUI)f.getUI();
            biu.setNorthPane(null);
            biu.setSouthPane(null);
            biu.setWestPane(null);
            biu.setEastPane(null);
        }
        f.getContentPane().add(comp);
        f.setOpaque(false);
        f.pack();
        int width = f.getWidth();
        int height = f.getHeight();
        if (width > this.getWidth() - 60) {
            width = Math.min(width, this.getWidth());
        }
        if (height > this.getHeight() - 60) {
            height = Math.min(height, this.getHeight() - this.getMenuBarHeight());
        }
        f.setSize(width, height);
        if (centered) {
            this.addCentered(f, MODAL_LAYER);
        } else {
            f.setLocation(0, this.getMenuBarHeight());
            this.add((Component)f, MODAL_LAYER);
        }
        f.setName(comp.getClass().getSimpleName());
        f.setFrameIcon(null);
        f.setVisible(true);
        f.setResizable(true);
        try {
            f.setSelected(true);
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        return f;
    }

    public JInternalFrame addAsSimpleFrame(JComponent comp) {
        JInternalFrame f = new JInternalFrame();
        JScrollPane scrollPane = new JScrollPane(comp, 20, 30);
        f.getContentPane().add(scrollPane);
        f.pack();
        this.addCentered(f);
        f.setName(comp.getClass().getSimpleName());
        if (f.getUI() instanceof BasicInternalFrameUI) {
            BasicInternalFrameUI biu = (BasicInternalFrameUI)f.getUI();
            biu.setNorthPane(null);
        }
        f.setFrameIcon(null);
        f.setVisible(true);
        f.setResizable(false);
        try {
            f.setSelected(true);
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        return f;
    }

    public void deactivateMovable(JComponent c) {
        for (MouseListener mouseListener : c.getMouseListeners()) {
            if (!(mouseListener instanceof FrameMotionListener)) continue;
            c.removeMouseListener(mouseListener);
        }
        for (EventListener eventListener : c.getMouseMotionListeners()) {
            if (!(eventListener instanceof FrameMotionListener)) continue;
            c.removeMouseMotionListener((MouseMotionListener)eventListener);
        }
    }

    public void addCentered(Component comp, Integer i) {
        comp.setLocation(this.getWidth() / 2 - comp.getWidth() / 2, (this.getHeight() + this.getMenuBarHeight()) / 2 - comp.getHeight() / 2);
        this.add(comp, i);
    }

    public void add(Component comp, Integer i) {
        this.add(comp, i, true);
    }

    public void add(Component comp, Integer i, boolean update) {
        if (comp != this.statusPanel && !(comp instanceof JMenuItem) && !(comp instanceof FreeColDialog) && this.statusPanel.isVisible()) {
            this.remove(this.statusPanel, false);
        }
        try {
            if (i == null) {
                super.add(comp);
            } else {
                super.add(comp, i);
            }
        }
        catch (Exception e) {
            logger.warning("add component failed with layer " + i);
        }
        if (update) {
            this.updateJMenuBar();
            this.freeColClient.getActionManager().update();
        }
    }

    private void takeFocus() {
        if (!this.isShowingSubPanel()) {
            this.requestFocus();
        }
    }

    public EuropePanel getEuropePanel() {
        return this.europePanel;
    }

    public MapControls getMapControls() {
        return this.mapControls;
    }

    public void showPopup(JPopupMenu popup, int x, int y) {
        popup.show(this, x, y);
        popup.repaint();
    }

    public void showTilePopup(Map.Position pos, int x, int y) {
        Tile t;
        if (pos != null && (t = this.freeColClient.getGame().getMap().getTile(pos.getX(), pos.getY())) != null) {
            TilePopup tp = new TilePopup(t, this.freeColClient, this, this.getGUI());
            if (tp.hasItem()) {
                this.showPopup(tp, x, y);
            } else if (t.isExplored()) {
                this.showTilePanel(t);
            }
        }
    }

    public void errorMessage(String messageID) {
        this.errorMessage(messageID, "Unspecified error: " + messageID);
    }

    public void errorMessage(String messageID, String message) {
        if (messageID != null) {
            try {
                message = Messages.message(messageID, new String[0]);
            }
            catch (MissingResourceException e) {
                logger.warning("could not find message with id: " + messageID);
            }
        }
        ErrorPanel errorPanel = new ErrorPanel(this);
        errorPanel.initialize(message);
        this.addAsFrame(errorPanel);
        errorPanel.requestFocus();
        errorPanel.getResponse();
        this.remove(errorPanel);
    }

    public void showInformationMessage(String messageId) {
        this.showInformationMessage(messageId, (FreeColObject)null, new String[0]);
    }

    public void showInformationMessage(String messageId, FreeColObject displayObject) {
        this.showInformationMessage(messageId, displayObject, new String[0]);
    }

    public void showInformationMessage(String messageId, String ... replace) {
        this.showInformationMessage(messageId, (FreeColObject)null, replace);
    }

    public void showInformationMessage(String messageId, FreeColObject displayObject, String ... replace) {
        String text;
        try {
            text = Messages.message(messageId, replace);
        }
        catch (MissingResourceException e) {
            text = messageId;
            logger.warning("Missing i18n resource: " + messageId);
        }
        ImageIcon icon = null;
        if (displayObject != null) {
            icon = this.getImageIcon(displayObject, false);
        }
        InformationDialog infoDialog = new InformationDialog(text, icon);
        this.addAsFrame(infoDialog);
        infoDialog.requestFocus();
        infoDialog.getResponse();
        this.remove(infoDialog);
    }

    public void refresh() {
        this.gui.forceReposition();
        this.repaint(0, 0, this.getWidth(), this.getHeight());
    }

    public void refreshTile(int x, int y) {
        if (x >= 0 && y >= 0) {
            this.repaint(this.gui.getTileBounds(x, y));
        }
    }

    public void refreshTile(Tile t) {
        this.refreshTile(t.getX(), t.getY());
    }

    public void refreshTile(Map.Position p) {
        this.refreshTile(p.getX(), p.getY());
    }

    public void closeMenus() {
        for (JInternalFrame frame : this.getAllFrames()) {
            frame.dispose();
        }
    }

    public void showMainPanel() {
        this.closeMenus();
        this.addCentered(this.mainPanel, MAIN_LAYER);
        this.mainPanel.requestFocus();
    }

    public MainPanel getMainPanel() {
        return this.mainPanel;
    }

    public void closeMainPanel() {
        this.remove(this.mainPanel);
    }

    public void showOpenGamePanel() {
        this.errorMessage("openGame.unimplemented");
    }

    public StartGamePanel getStartGamePanel() {
        return this.startGamePanel;
    }

    public void displayChatMessage(Player sender, String message, boolean privateChat) {
        this.gui.addMessage(new GUIMessage(sender.getName() + ": " + message, sender.getColor()));
    }

    public void displayChatMessage(String message) {
        this.displayChatMessage(this.freeColClient.getMyPlayer(), message, false);
    }

    public void quit() {
        if (this.showConfirmDialog("quitDialog.areYouSure.text", "ok", "cancel", new String[0])) {
            this.freeColClient.quit();
        }
    }

    public void retire() {
        if (this.showConfirmDialog("retireDialog.areYouSure.text", "ok", "cancel", new String[0])) {
            if (this.freeColClient.retire()) {
                this.showReportPanel(ReportHighScoresPanel.class.getName());
            }
            this.quit();
        }
    }

    public void returnToTitle() {
        this.closeMenus();
        this.removeInGameComponents();
        this.showMainPanel();
        this.repaint();
    }

    public void removeInGameComponents() {
        KeyListener[] keyListeners = this.getKeyListeners();
        for (int i = 0; i < keyListeners.length; ++i) {
            this.removeKeyListener(keyListeners[i]);
        }
        MouseListener[] mouseListeners = this.getMouseListeners();
        for (int i = 0; i < mouseListeners.length; ++i) {
            this.removeMouseListener(mouseListeners[i]);
        }
        MouseMotionListener[] mouseMotionListeners = this.getMouseMotionListeners();
        for (int i = 0; i < mouseMotionListeners.length; ++i) {
            this.removeMouseMotionListener(mouseMotionListeners[i]);
        }
        this.getGUI().getViewMode().changeViewMode(0);
        if (this.jMenuBar != null) {
            this.remove(this.jMenuBar);
        }
        for (Component c : this.getComponents()) {
            this.remove(c, false);
        }
    }

    public boolean containsInGameComponents() {
        KeyListener[] keyListeners = this.getKeyListeners();
        if (keyListeners.length > 0) {
            return true;
        }
        MouseListener[] mouseListeners = this.getMouseListeners();
        if (mouseListeners.length > 0) {
            return true;
        }
        MouseMotionListener[] mouseMotionListeners = this.getMouseMotionListeners();
        return mouseMotionListeners.length > 0;
    }

    public GUI getGUI() {
        return this.gui;
    }

    public FreeColClient getClient() {
        return this.freeColClient;
    }

    public void newGame() {
        if (!this.showConfirmDialog("stopCurrentGame.text", "stopCurrentGame.yes", "stopCurrentGame.no", new String[0])) {
            return;
        }
        this.freeColClient.getConnectController().quitGame(true);
        this.removeInGameComponents();
        this.showPanel(new NewPanel(this));
    }

    class FrameMotionListener
    extends MouseAdapter
    implements MouseMotionListener {
        private JInternalFrame f;
        private Point loc = null;

        FrameMotionListener(JInternalFrame f) {
            this.f = f;
        }

        public void mousePressed(MouseEvent e) {
            if (this.f.getDesktopPane() == null || this.f.getDesktopPane().getDesktopManager() == null) {
                return;
            }
            this.loc = SwingUtilities.convertPoint((Component)e.getSource(), e.getX(), e.getY(), null);
            this.f.getDesktopPane().getDesktopManager().beginDraggingFrame(this.f);
        }

        public void mouseReleased(MouseEvent e) {
            if (this.loc == null || this.f.getDesktopPane() == null || this.f.getDesktopPane().getDesktopManager() == null) {
                return;
            }
            this.f.getDesktopPane().getDesktopManager().endDraggingFrame(this.f);
        }

        public void mouseDragged(MouseEvent e) {
            if (this.loc == null || this.f.getDesktopPane() == null || this.f.getDesktopPane().getDesktopManager() == null) {
                return;
            }
            Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getX(), e.getY(), null);
            int moveX = this.loc.x - p.x;
            int moveY = this.loc.y - p.y;
            this.f.getDesktopPane().getDesktopManager().dragFrame(this.f, this.f.getX() - moveX, this.f.getY() - moveY);
            this.loc = p;
        }

        public void mouseMoved(MouseEvent arg0) {
        }
    }

    class ToolBoxFrame
    extends JInternalFrame {
        ToolBoxFrame() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BoycottAction {
        CANCEL,
        PAY_ARREARS,
        DUMP_CARGO;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MissionaryAction {
        CANCEL,
        ESTABLISH_MISSION,
        DENOUNCE_HERESY,
        INCITE_INDIANS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScoutAction {
        CANCEL,
        INDIAN_SETTLEMENT_SPEAK,
        INDIAN_SETTLEMENT_TRIBUTE,
        INDIAN_SETTLEMENT_ATTACK,
        FOREIGN_COLONY_NEGOTIATE,
        FOREIGN_COLONY_SPY,
        FOREIGN_COLONY_ATTACK;

    }
}

