/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.TerrainCursor;
import net.sf.freecol.common.model.Map;

public final class CanvasKeyListener
implements KeyListener {
    private static final Logger logger = Logger.getLogger(CanvasKeyListener.class.getName());
    private final Canvas parent;
    private final InGameController inGameController;

    public CanvasKeyListener(Canvas parent, InGameController inGameController) {
        this.parent = parent;
        this.inGameController = inGameController;
    }

    public void keyPressed(KeyEvent e) {
        if (this.parent.getGUI().isGotoStarted() && e.getKeyCode() != this.parent.getClient().getActionManager().getFreeColAction("gotoTileAction").getAccelerator().getKeyCode()) {
            this.parent.getGUI().stopGoto();
        }
        if (e.isShiftDown() && e.isControlDown() && e.getKeyCode() == 68) {
            this.inGameController.setInDebugMode(!FreeCol.isInDebugMode());
            return;
        }
        if (e.getModifiers() != 0) {
            return;
        }
        try {
            int viewMode = this.parent.getGUI().getViewMode().getView();
            if (viewMode == 0) {
                this.moveUnit(e);
            } else if (viewMode == 1) {
                this.moveCursor(e);
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Exception occurred while handling KeyEvent.", ex);
        }
    }

    private void moveCursor(KeyEvent e) {
        if (!this.parent.isMapboardActionsEnabled()) {
            return;
        }
        switch (e.getKeyCode()) {
            case 27: {
                break;
            }
            case 35: 
            case 97: {
                this.parent.getGUI().moveTileCursor(Map.Direction.SW);
                break;
            }
            case 40: 
            case 98: 
            case 225: {
                this.parent.getGUI().moveTileCursor(Map.Direction.S);
                break;
            }
            case 34: 
            case 99: {
                this.parent.getGUI().moveTileCursor(Map.Direction.SE);
                break;
            }
            case 37: 
            case 100: 
            case 226: {
                this.parent.getGUI().moveTileCursor(Map.Direction.W);
                break;
            }
            case 67: 
            case 101: {
                this.inGameController.centerActiveUnit();
                break;
            }
            case 39: 
            case 102: 
            case 227: {
                this.parent.getGUI().moveTileCursor(Map.Direction.E);
                break;
            }
            case 36: 
            case 103: {
                this.parent.getGUI().moveTileCursor(Map.Direction.NW);
                break;
            }
            case 38: 
            case 104: 
            case 224: {
                this.parent.getGUI().moveTileCursor(Map.Direction.N);
                break;
            }
            case 33: 
            case 105: {
                this.parent.getGUI().moveTileCursor(Map.Direction.NE);
                break;
            }
            case 32: {
                TerrainCursor cursor = this.parent.getGUI().getCursor();
                this.parent.showTilePopup(this.parent.getGUI().getSelectedTile(), cursor.getCanvasX(), cursor.getCanvasY());
                break;
            }
            default: {
                logger.info("The typed key (" + e.getKeyCode() + ") doesn't have a function yet.");
            }
        }
    }

    private void moveUnit(KeyEvent e) {
        if (!this.parent.isMapboardActionsEnabled()) {
            return;
        }
        switch (e.getKeyCode()) {
            case 27: {
                break;
            }
            case 35: 
            case 97: {
                this.inGameController.moveActiveUnit(Map.Direction.SW);
                break;
            }
            case 40: 
            case 98: 
            case 225: {
                this.inGameController.moveActiveUnit(Map.Direction.S);
                break;
            }
            case 34: 
            case 99: {
                this.inGameController.moveActiveUnit(Map.Direction.SE);
                break;
            }
            case 37: 
            case 100: 
            case 226: {
                this.inGameController.moveActiveUnit(Map.Direction.W);
                break;
            }
            case 67: 
            case 101: {
                this.inGameController.centerActiveUnit();
                break;
            }
            case 39: 
            case 102: 
            case 227: {
                this.inGameController.moveActiveUnit(Map.Direction.E);
                break;
            }
            case 36: 
            case 103: {
                this.inGameController.moveActiveUnit(Map.Direction.NW);
                break;
            }
            case 38: 
            case 104: 
            case 224: {
                this.inGameController.moveActiveUnit(Map.Direction.N);
                break;
            }
            case 33: 
            case 105: {
                this.inGameController.moveActiveUnit(Map.Direction.NE);
                break;
            }
            default: {
                logger.info("The typed key (" + e.getKeyCode() + ") doesn't have a function yet.");
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 16) {
            this.parent.getGUI().setGotoPath(null);
        }
    }

    public void keyTyped(KeyEvent e) {
    }
}

