/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.Unit;

public final class CanvasMapEditorMouseListener
implements MouseListener {
    private static final Logger logger = Logger.getLogger(CanvasMapEditorMouseListener.class.getName());
    private final Canvas canvas;
    private final GUI gui;

    public CanvasMapEditorMouseListener(Canvas canvas, GUI g) {
        this.canvas = canvas;
        this.gui = g;
    }

    private Map getMap() {
        Map map = null;
        if (this.canvas.getClient().getGame() != null) {
            map = this.canvas.getClient().getGame().getMap();
        }
        return map;
    }

    public void mouseClicked(MouseEvent e) {
        if (this.getMap() == null) {
            return;
        }
        try {
            if (e.getClickCount() > 1) {
                Map.Position p = this.gui.convertToMapCoordinates(e.getX(), e.getY());
                this.gui.showColonyPanel(p);
            } else {
                this.canvas.requestFocus();
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error in mouseClicked!", ex);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (!e.getComponent().isEnabled()) {
            return;
        }
        if (this.getMap() == null) {
            return;
        }
        try {
            if (e.getButton() == 3 || e.isPopupTrigger()) {
                Map.Position p = this.gui.convertToMapCoordinates(e.getX(), e.getY());
                Tile tile = this.getMap().getTile(p);
                if (tile != null && tile.hasRiver()) {
                    TileImprovement river = tile.getRiver();
                    int style = this.canvas.showRiverStylePanel();
                    if (style != -1) {
                        if (style == 0) {
                            tile.getTileItemContainer().removeTileItem(river);
                        } else if (0 < style && style < 81) {
                            river.setStyle(style);
                        } else {
                            logger.warning("Unknown river style: " + style);
                        }
                    }
                } else {
                    this.gui.setSelectedTile(p, true);
                }
            } else if (e.getButton() == 1 && this.gui.getFocus() != null) {
                Map.Position p = this.gui.convertToMapCoordinates(e.getX(), e.getY());
                Tile t = this.getMap().getTile(p);
                if (t == null) {
                    return;
                }
                this.canvas.getClient().getMapEditorController().transform(t);
                this.canvas.refresh();
                this.canvas.requestFocus();
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error in mousePressed!", ex);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.getMap() == null) {
            return;
        }
        try {
            if (this.gui.getGotoPath() != null) {
                PathNode temp = this.gui.getGotoPath();
                this.gui.stopGoto();
                Unit unit = this.gui.getActiveUnit();
                this.canvas.getClient().getInGameController().setDestination(unit, temp.getLastNode().getTile());
                if (this.canvas.getClient().getGame().getCurrentPlayer() == this.canvas.getClient().getMyPlayer()) {
                    this.canvas.getClient().getInGameController().moveToDestination(unit);
                }
            } else if (this.gui.isGotoStarted()) {
                this.gui.stopGoto();
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error in mouseReleased!", ex);
        }
    }
}

