/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Tile;

public final class CanvasMapEditorMouseMotionListener
implements MouseMotionListener {
    private static final Logger logger = Logger.getLogger(CanvasMapEditorMouseMotionListener.class.getName());
    private final Canvas canvas;
    private final GUI gui;
    private ScrollThread scrollThread;
    private static final int SCROLLSPACE = 100;

    public CanvasMapEditorMouseMotionListener(Canvas canvas, GUI g) {
        this.canvas = canvas;
        this.gui = g;
        this.scrollThread = null;
    }

    private Map getMap() {
        Map map = null;
        if (this.canvas.getClient().getGame() != null) {
            map = this.canvas.getClient().getGame().getMap();
        }
        return map;
    }

    public void mouseMoved(MouseEvent e) {
        if (this.getMap() == null) {
            return;
        }
        if (this.scrollThread != null) {
            this.scrollThread.stopScrolling();
            this.scrollThread = null;
        }
    }

    private void scroll(int x, int y) {
        Map.Direction direction;
        if (this.getMap() == null) {
            return;
        }
        if (!this.canvas.getClient().getClientOptions().getBoolean("model.option.mapScrollOnDrag")) {
            return;
        }
        if (x < 100 && y < 100) {
            direction = Map.Direction.NW;
        } else if (x >= this.gui.getWidth() - 100 && y < 100) {
            direction = Map.Direction.NE;
        } else if (x >= this.gui.getWidth() - 100 && y >= this.gui.getHeight() - 100) {
            direction = Map.Direction.SE;
        } else if (x < 100 && y >= this.gui.getHeight() - 100) {
            direction = Map.Direction.SW;
        } else if (y < 100) {
            direction = Map.Direction.N;
        } else if (x >= this.gui.getWidth() - 100) {
            direction = Map.Direction.E;
        } else if (y >= this.gui.getHeight() - 100) {
            direction = Map.Direction.S;
        } else if (x < 100) {
            direction = Map.Direction.W;
        } else {
            if (this.scrollThread != null) {
                this.scrollThread.stopScrolling();
                this.scrollThread = null;
            }
            return;
        }
        if (this.scrollThread != null) {
            this.scrollThread.setDirection(direction);
        } else {
            this.scrollThread = new ScrollThread(this.getMap(), this.gui);
            this.scrollThread.setDirection(direction);
            this.scrollThread.start();
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.getMap() == null) {
            return;
        }
        Map.Position p = this.gui.convertToMapCoordinates(e.getX(), e.getY());
        if (e.getComponent().isEnabled()) {
            this.scroll(e.getX(), e.getY());
        } else if (this.scrollThread != null) {
            this.scrollThread.stopScrolling();
            this.scrollThread = null;
        }
        if (p == null || !this.getMap().isValid(p)) {
            return;
        }
        if ((e.getModifiersEx() & 0x400) == 0) {
            return;
        }
        Tile tile = this.getMap().getTile(p);
        if (tile != null) {
            this.canvas.getClient().getMapEditorController().transform(tile);
            this.canvas.refresh();
        }
    }

    private class ScrollThread
    extends Thread {
        private final Map map;
        private final GUI gui;
        private Map.Direction direction;
        private boolean cont;

        public ScrollThread(Map m, GUI g) {
            super("FreeColClient:Mouse scroller");
            this.map = m;
            this.gui = g;
            this.cont = true;
        }

        public void setDirection(Map.Direction d) {
            this.direction = d;
        }

        public void stopScrolling() {
            this.cont = false;
        }

        public void run() {
            do {
                try {
                    ScrollThread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            try {
                                int x;
                                int y;
                                Tile t = ScrollThread.this.map.getTile(ScrollThread.this.gui.getFocus().getX(), ScrollThread.this.gui.getFocus().getY());
                                if (t == null) {
                                    return;
                                }
                                t = ScrollThread.this.map.getNeighbourOrNull(ScrollThread.this.direction, t);
                                if (t == null) {
                                    return;
                                }
                                if (ScrollThread.this.gui.isMapNearTop(t.getY()) && ScrollThread.this.gui.isMapNearTop(ScrollThread.this.gui.getFocus().getY())) {
                                    if (t.getY() > ScrollThread.this.gui.getFocus().getY()) {
                                        y = t.getY();
                                        while (ScrollThread.this.gui.isMapNearTop(y += 2)) {
                                        }
                                    } else {
                                        y = ScrollThread.this.gui.getFocus().getY();
                                    }
                                } else if (ScrollThread.this.gui.isMapNearBottom(t.getY()) && ScrollThread.this.gui.isMapNearBottom(ScrollThread.this.gui.getFocus().getY())) {
                                    if (t.getY() < ScrollThread.this.gui.getFocus().getY()) {
                                        y = t.getY();
                                        while (ScrollThread.this.gui.isMapNearBottom(y -= 2)) {
                                        }
                                    } else {
                                        y = ScrollThread.this.gui.getFocus().getY();
                                    }
                                } else {
                                    y = t.getY();
                                }
                                if (ScrollThread.this.gui.isMapNearLeft(t.getX(), t.getY()) && ScrollThread.this.gui.isMapNearLeft(ScrollThread.this.gui.getFocus().getX(), ScrollThread.this.gui.getFocus().getY())) {
                                    if (t.getX() > ScrollThread.this.gui.getFocus().getX()) {
                                        x = t.getX();
                                        while (ScrollThread.this.gui.isMapNearLeft(++x, y)) {
                                        }
                                    } else {
                                        x = ScrollThread.this.gui.getFocus().getX();
                                    }
                                } else if (ScrollThread.this.gui.isMapNearRight(t.getX(), t.getY()) && ScrollThread.this.gui.isMapNearRight(ScrollThread.this.gui.getFocus().getX(), ScrollThread.this.gui.getFocus().getY())) {
                                    if (t.getX() < ScrollThread.this.gui.getFocus().getX()) {
                                        x = t.getX();
                                        while (ScrollThread.this.gui.isMapNearRight(--x, y)) {
                                        }
                                    } else {
                                        x = ScrollThread.this.gui.getFocus().getX();
                                    }
                                } else {
                                    x = t.getX();
                                }
                                ScrollThread.this.gui.setFocus(x, y);
                            }
                            catch (Exception e) {
                                logger.log(Level.WARNING, "Exception while scrolling!", e);
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    logger.log(Level.WARNING, "Scroll thread caught error", e);
                    this.cont = false;
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "Scroll thread interrupted", e);
                    this.cont = false;
                }
            } while (this.cont);
        }
    }
}

