/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;

public final class CanvasMouseListener
implements MouseListener {
    private static final Logger logger = Logger.getLogger(CanvasMouseListener.class.getName());
    private final Canvas canvas;
    private final GUI gui;

    public CanvasMouseListener(Canvas canvas, GUI g) {
        this.canvas = canvas;
        this.gui = g;
    }

    public void mouseClicked(MouseEvent e) {
        try {
            if (e.getClickCount() > 1) {
                this.gui.showColonyPanel(this.gui.convertToMapCoordinates(e.getX(), e.getY()));
            } else {
                this.canvas.requestFocus();
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error in mouseClicked!", ex);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (!e.getComponent().isEnabled()) {
            return;
        }
        try {
            if (e.getButton() == 3 || e.isPopupTrigger()) {
                if (this.gui.isGotoStarted()) {
                    this.gui.stopGoto();
                }
                this.canvas.showTilePopup(this.gui.convertToMapCoordinates(e.getX(), e.getY()), e.getX(), e.getY());
            } else if (e.getButton() == 2) {
                Unit unit;
                Map.Position p = this.gui.convertToMapCoordinates(e.getX(), e.getY());
                if (p == null || !this.canvas.getClient().getGame().getMap().isValid(p)) {
                    return;
                }
                Tile tile = this.canvas.getClient().getGame().getMap().getTile(p);
                if (tile != null && (unit = this.gui.getActiveUnit()) != null && unit.getTile() != tile) {
                    PathNode dragPath = unit.findPath(tile);
                    this.gui.startGoto();
                    this.gui.setGotoPath(dragPath);
                }
            } else if (e.getButton() == 1) {
                if (this.gui.isGotoStarted()) {
                    PathNode path = this.gui.getGotoPath();
                    if (path != null) {
                        this.gui.stopGoto();
                        Unit unit = this.gui.getActiveUnit();
                        this.canvas.getClient().getInGameController().setDestination(unit, path.getLastNode().getTile());
                        if (this.canvas.getClient().getGame().getCurrentPlayer() == this.canvas.getClient().getMyPlayer()) {
                            this.canvas.getClient().getInGameController().moveToDestination(unit);
                        }
                    }
                } else {
                    this.gui.setSelectedTile(this.gui.convertToMapCoordinates(e.getX(), e.getY()), true);
                }
                this.canvas.requestFocus();
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error in mousePressed!", ex);
        }
    }

    public void mouseReleased(MouseEvent e) {
        try {
            if (this.gui.getGotoPath() != null) {
                PathNode temp = this.gui.getGotoPath();
                this.gui.stopGoto();
                Unit unit = this.gui.getActiveUnit();
                this.canvas.getClient().getInGameController().setDestination(unit, temp.getLastNode().getTile());
                if (this.canvas.getClient().getGame().getCurrentPlayer() == this.canvas.getClient().getMyPlayer()) {
                    this.canvas.getClient().getInGameController().moveToDestination(unit);
                }
            } else if (this.gui.isGotoStarted()) {
                this.gui.stopGoto();
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error in mouseReleased!", ex);
        }
    }
}

