/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.UIManager;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.GUIMessage;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.TerrainCursor;
import net.sf.freecol.client.gui.ViewMode;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.MapControls;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileItemContainer;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.server.ai.AIUnit;

public final class GUI {
    private static final Logger logger = Logger.getLogger(GUI.class.getName());
    private final FreeColClient freeColClient;
    private Dimension size;
    private ImageLibrary lib;
    private TerrainCursor cursor;
    private ViewMode viewMode;
    private boolean inGame;
    private final Vector<GUIMessage> messages;
    private Map.Position selectedTile;
    private Map.Position focus = null;
    private Unit activeUnit;
    private PathNode currentPath;
    private PathNode gotoPath = null;
    private boolean gotoStarted = false;
    private int tileHeight;
    private int tileWidth;
    private int topSpace;
    private int topRows;
    private int bottomRows;
    private int leftSpace;
    private int rightSpace;
    private int bottomRow = -1;
    private int topRow;
    private int bottomRowY;
    private int topRowY;
    private int leftColumn;
    private int rightColumn;
    private int leftColumnX;
    public static final int UNIT_OFFSET = 20;
    public static final int TEXT_OFFSET_X = 2;
    public static final int TEXT_OFFSET_Y = 13;
    public static final int STATE_OFFSET_X = 25;
    public static final int STATE_OFFSET_Y = 10;
    public static final int ALARM_OFFSET_X = 37;
    public static final int ALARM_OFFSET_Y = 10;
    public static final int RUMOUR_OFFSET_X = 40;
    public static final int RUMOUR_OFFSET_Y = 5;
    public static final int MISSION_OFFSET_X = 49;
    public static final int MISSION_OFFSET_Y = 10;
    public static final int OTHER_UNITS_OFFSET_X = -5;
    public static final int OTHER_UNITS_OFFSET_Y = 1;
    public static final int OTHER_UNITS_WIDTH = 3;
    public static final int MAX_OTHER_UNITS = 10;
    public static final int MESSAGE_COUNT = 3;
    public static final int MESSAGE_AGE = 30000;
    private boolean displayGrid = false;
    private int displayTileText = 0;
    private GeneralPath gridPath = null;
    public boolean displayCoordinates = false;
    public boolean displayColonyValue = false;
    public Player displayColonyValuePlayer = null;
    public boolean debugShowMission = false;
    public boolean debugShowMissionInfo = false;
    private volatile boolean blinkingMarqueeEnabled;
    private Image cursorImage;
    private GrayLayer greyLayer;

    public GUI(FreeColClient freeColClient, Dimension size, ImageLibrary lib) {
        this.freeColClient = freeColClient;
        this.size = size;
        this.setImageLibrary(lib);
        this.inGame = false;
        logger.info("GUI created.");
        this.messages = new Vector(3);
        this.viewMode = new ViewMode(this);
        logger.info("Starting in Move Units View Mode");
        this.displayGrid = freeColClient.getClientOptions().getBoolean("model.option.displayGrid");
        this.displayTileText = freeColClient.getClientOptions().getDisplayTileText();
        this.blinkingMarqueeEnabled = true;
        this.cursor = new TerrainCursor();
    }

    public void setImageLibrary(ImageLibrary lib) {
        this.lib = lib;
        this.cursorImage = lib.getMiscImage("unitSelect.image");
        TileType tileType = FreeCol.getSpecification().getTileTypeList().get(0);
        this.tileHeight = lib.getTerrainImageHeight(tileType);
        this.tileWidth = lib.getTerrainImageWidth(tileType);
        this.updateMapDisplayVariables();
    }

    private void updateMapDisplayVariables() {
        this.topSpace = (this.size.height - this.tileHeight) / 2;
        this.topRows = this.topSpace % (this.tileHeight / 2) != 0 ? this.topSpace / (this.tileHeight / 2) + 2 : this.topSpace / (this.tileHeight / 2) + 1;
        this.bottomRows = this.topRows;
        this.rightSpace = this.leftSpace = (this.size.width - this.tileWidth) / 2;
    }

    public ViewMode getViewMode() {
        return this.viewMode;
    }

    public void startCursorBlinking() {
        final FreeColClient theFreeColClient = this.freeColClient;
        ActionListener taskPerformer = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (!GUI.this.blinkingMarqueeEnabled) {
                    return;
                }
                if (GUI.this.getActiveUnit() != null && GUI.this.getActiveUnit().getTile() != null) {
                    theFreeColClient.getCanvas().refreshTile(GUI.this.getActiveUnit().getTile());
                }
            }
        };
        this.cursor.addActionListener(taskPerformer);
        this.cursor.startBlinking();
    }

    public TerrainCursor getCursor() {
        return this.cursor;
    }

    public void setSize(Dimension size) {
        this.size = size;
        this.updateMapDisplayVariables();
    }

    public void moveTileCursor(Map.Direction direction) {
        Tile selectedTile = this.freeColClient.getGame().getMap().getTile(this.getSelectedTile());
        if (selectedTile != null) {
            Tile newTile = this.freeColClient.getGame().getMap().getNeighbourOrNull(direction, selectedTile);
            if (newTile != null) {
                this.setSelectedTile(newTile.getPosition());
            }
        } else {
            logger.warning("selectedTile is null");
        }
    }

    public void setSelectedTile(Map.Position selectedTile) {
        this.setSelectedTile(selectedTile, false);
    }

    public void setSelectedTile(Map.Position selectedTile, boolean clearGoToOrders) {
        Game gameData = this.freeColClient.getGame();
        if (selectedTile != null && !gameData.getMap().isValid(selectedTile)) {
            return;
        }
        Map.Position oldPosition = this.selectedTile;
        this.selectedTile = selectedTile;
        if (this.viewMode.getView() == 0) {
            if (this.activeUnit == null || this.activeUnit.getTile() != null && !this.activeUnit.getTile().getPosition().equals(selectedTile)) {
                Unit unitInFront;
                Tile t = gameData.getMap().getTile(selectedTile);
                if (t != null && t.getSettlement() != null) {
                    Settlement s = t.getSettlement();
                    if (s instanceof Colony && s.getOwner().equals(this.freeColClient.getMyPlayer())) {
                        this.setFocus(selectedTile);
                        this.freeColClient.getCanvas().showColonyPanel((Colony)s);
                        return;
                    }
                    if (s instanceof IndianSettlement) {
                        this.setFocus(selectedTile);
                        this.freeColClient.getCanvas().showIndianSettlementPanel((IndianSettlement)s);
                        return;
                    }
                }
                if ((unitInFront = this.getUnitInFront(gameData.getMap().getTile(selectedTile))) != null) {
                    this.setActiveUnit(unitInFront);
                    this.updateGotoPathForActiveUnit();
                } else {
                    this.setFocus(selectedTile);
                }
            } else if (this.activeUnit.getTile() != null && this.activeUnit.getTile().getPosition().equals(selectedTile) && clearGoToOrders && this.activeUnit.getDestination() != null) {
                this.freeColClient.getInGameController().clearGotoOrders(this.activeUnit);
                this.updateGotoPathForActiveUnit();
            }
        }
        this.freeColClient.getActionManager().update();
        this.freeColClient.getCanvas().updateJMenuBar();
        int x = 0;
        int y = 0;
        MapControls mapControls = this.freeColClient.getCanvas().getMapControls();
        if (mapControls != null) {
            x = this.getWidth() - mapControls.getInfoPanelWidth();
            y = this.getHeight() - mapControls.getInfoPanelHeight();
        }
        this.freeColClient.getCanvas().repaint(x, y, this.getWidth(), this.getHeight());
        if (!this.onScreen(selectedTile) && this.freeColClient.getClientOptions().getBoolean("model.option.jumpToActiveUnit") || this.freeColClient.getClientOptions().getBoolean("model.option.alwaysCenter")) {
            this.setFocus(selectedTile);
        } else {
            if (oldPosition != null) {
                this.freeColClient.getCanvas().refreshTile(oldPosition);
            }
            if (selectedTile != null) {
                this.freeColClient.getCanvas().refreshTile(selectedTile);
            }
        }
    }

    public void showColonyPanel(Map.Position selectedTile) {
        Tile t;
        Game gameData = this.freeColClient.getGame();
        if (selectedTile != null && !gameData.getMap().isValid(selectedTile)) {
            return;
        }
        if (this.viewMode.getView() == 0 && (t = gameData.getMap().getTile(selectedTile)) != null && t.getSettlement() != null && t.getSettlement() instanceof Colony && t.getSettlement().getOwner().equals(this.freeColClient.getMyPlayer())) {
            this.setFocus(selectedTile);
            this.stopBlinking();
            this.freeColClient.getCanvas().showColonyPanel((Colony)t.getSettlement());
            return;
        }
    }

    public void restartBlinking() {
        this.blinkingMarqueeEnabled = true;
    }

    public void stopBlinking() {
        this.blinkingMarqueeEnabled = false;
    }

    public Unit getUnitInFront(Tile unitTile) {
        if (unitTile == null || unitTile.getUnitCount() <= 0) {
            return null;
        }
        if (this.activeUnit != null && this.activeUnit.getTile() == unitTile) {
            return this.activeUnit;
        }
        if (unitTile.getSettlement() == null) {
            Unit bestDefendingUnit = null;
            if (this.activeUnit != null && (bestDefendingUnit = unitTile.getDefendingUnit(this.activeUnit)) != null) {
                return bestDefendingUnit;
            }
            Unit movableUnit = unitTile.getMovableUnit();
            if (movableUnit != null && movableUnit.getLocation() == movableUnit.getTile()) {
                return movableUnit;
            }
            Unit bestPick = null;
            Iterator<Unit> unitIterator = unitTile.getUnitIterator();
            while (unitIterator.hasNext()) {
                Unit u = unitIterator.next();
                if (bestPick != null && bestPick.getMovesLeft() >= u.getMovesLeft()) continue;
                bestPick = u;
            }
            return bestPick;
        }
        return null;
    }

    public Map.Position getSelectedTile() {
        return this.selectedTile;
    }

    public Unit getActiveUnit() {
        return this.activeUnit;
    }

    public void setActiveUnit(Unit activeUnit) {
        if (activeUnit != null && activeUnit.getOwner() != this.freeColClient.getMyPlayer()) {
            this.freeColClient.getCanvas().repaint(0, 0, this.getWidth(), this.getHeight());
            return;
        }
        if (activeUnit != null && activeUnit.getTile() == null) {
            activeUnit = null;
        }
        this.activeUnit = activeUnit;
        if (activeUnit != null) {
            if (this.freeColClient.getGame().getCurrentPlayer() == this.freeColClient.getMyPlayer()) {
                if (activeUnit.getState() != Unit.UnitState.ACTIVE) {
                    this.freeColClient.getInGameController().clearOrders(activeUnit);
                }
            } else {
                this.freeColClient.getInGameController().clearGotoOrders(activeUnit);
            }
        }
        this.updateGotoPathForActiveUnit();
        if (this.viewMode.getView() == 1 && activeUnit != null) {
            this.viewMode.changeViewMode(0);
        }
        if (activeUnit != null) {
            this.setSelectedTile(activeUnit.getTile().getPosition());
        } else {
            this.freeColClient.getActionManager().update();
            this.freeColClient.getCanvas().updateJMenuBar();
            int x = 0;
            int y = 0;
            MapControls mapControls = this.freeColClient.getCanvas().getMapControls();
            if (mapControls != null) {
                x = this.getWidth() - mapControls.getInfoPanelWidth();
                y = this.getHeight() - mapControls.getInfoPanelHeight();
            }
            this.freeColClient.getCanvas().repaint(x, y, this.getWidth(), this.getHeight());
        }
    }

    public Map.Position getFocus() {
        return this.focus;
    }

    public void setFocus(Map.Position focus) {
        this.focus = focus;
        this.forceReposition();
        this.freeColClient.getCanvas().repaint(0, 0, this.getWidth(), this.getHeight());
    }

    public void setFocusImmediately(Map.Position focus) {
        this.focus = focus;
        this.forceReposition();
        this.freeColClient.getCanvas().paintImmediately(0, 0, this.getWidth(), this.getHeight());
    }

    public void setFocus(int x, int y) {
        this.setFocus(new Map.Position(x, y));
    }

    public int getMessageCount() {
        return this.messages.size();
    }

    public GUIMessage getMessage(int index) {
        return this.messages.get(index);
    }

    public synchronized void addMessage(GUIMessage message) {
        if (this.getMessageCount() == 3) {
            this.messages.remove(0);
        }
        this.messages.add(message);
        this.freeColClient.getCanvas().repaint(0, 0, this.getWidth(), this.getHeight());
    }

    public synchronized boolean removeOldMessages() {
        long currentTime = new Date().getTime();
        boolean result = false;
        int i = 0;
        while (i < this.getMessageCount()) {
            long messageCreationTime = this.getMessage(i).getCreationTime().getTime();
            if (currentTime - messageCreationTime >= 30000L) {
                result = true;
                this.messages.remove(i);
                continue;
            }
            ++i;
        }
        return result;
    }

    public int getWidth() {
        return this.size.width;
    }

    public int getHeight() {
        return this.size.height;
    }

    public void display(Graphics2D g) {
        if (this.freeColClient.getGame() != null && this.freeColClient.getGame().getMap() != null && this.focus != null && this.inGame) {
            this.removeOldMessages();
            this.displayMap(g);
        } else if (this.freeColClient.isMapEditor()) {
            g.setColor(Color.black);
            g.fillRect(0, 0, this.size.width, this.size.height);
        } else {
            Image bgImage = ResourceManager.getImage("CanvasBackgroundImage", this.size);
            if (bgImage != null) {
                g.drawImage(bgImage, 0, 0, this.freeColClient.getCanvas());
                String versionStr = "v. " + FreeCol.getVersion();
                Font oldFont = g.getFont();
                Color oldColor = g.getColor();
                Font newFont = oldFont.deriveFont(1);
                TextLayout layout = new TextLayout(versionStr, newFont, g.getFontRenderContext());
                Rectangle2D bounds = layout.getBounds();
                float x = (float)this.getWidth() - (float)bounds.getWidth() - 5.0f;
                float y = (float)this.getHeight() - (float)bounds.getHeight();
                g.setColor(Color.white);
                layout.draw(g, x, y);
                g.setFont(oldFont);
                g.setColor(oldColor);
            } else {
                g.setColor(Color.black);
                g.fillRect(0, 0, this.size.width, this.size.height);
            }
        }
    }

    private int getLeftColumns() {
        return this.getLeftColumns(this.focus.getY());
    }

    private int getLeftColumns(int y) {
        int leftColumns;
        if (y % 2 == 0) {
            leftColumns = this.leftSpace / this.tileWidth + 1;
            if (this.leftSpace % this.tileWidth > 32) {
                ++leftColumns;
            }
        } else {
            leftColumns = this.leftSpace / this.tileWidth + 1;
            if (this.leftSpace % this.tileWidth == 0) {
                --leftColumns;
            }
        }
        return leftColumns;
    }

    private int getRightColumns() {
        return this.getRightColumns(this.focus.getY());
    }

    private int getRightColumns(int y) {
        int rightColumns;
        if (y % 2 == 0) {
            rightColumns = this.rightSpace / this.tileWidth + 1;
            if (this.rightSpace % this.tileWidth == 0) {
                --rightColumns;
            }
        } else {
            rightColumns = this.rightSpace / this.tileWidth + 1;
            if (this.rightSpace % this.tileWidth > 32) {
                ++rightColumns;
            }
        }
        return rightColumns;
    }

    private void positionMap() {
        Game gameData = this.freeColClient.getGame();
        if (this.focus == null) {
            return;
        }
        int x = this.focus.getX();
        int y = this.focus.getY();
        int leftColumns = this.getLeftColumns();
        int rightColumns = this.getRightColumns();
        if (y < this.topRows) {
            this.bottomRow = this.size.height / (this.tileHeight / 2) - 1;
            if (this.size.height % (this.tileHeight / 2) != 0) {
                ++this.bottomRow;
            }
            this.topRow = 0;
            this.bottomRowY = this.bottomRow * (this.tileHeight / 2);
            this.topRowY = 0;
        } else if (y >= gameData.getMap().getHeight() - this.bottomRows) {
            this.bottomRow = gameData.getMap().getHeight() - 1;
            this.topRow = this.size.height / (this.tileHeight / 2);
            if (this.size.height % (this.tileHeight / 2) > 0) {
                ++this.topRow;
            }
            this.topRow = gameData.getMap().getHeight() - this.topRow;
            this.bottomRowY = this.size.height - this.tileHeight;
            this.topRowY = this.bottomRowY - (this.bottomRow - this.topRow) * (this.tileHeight / 2);
        } else {
            this.bottomRow = y + this.bottomRows;
            this.topRow = y - this.topRows;
            this.bottomRowY = this.topSpace + this.tileHeight / 2 * this.bottomRows;
            this.topRowY = this.topSpace - this.topRows * (this.tileHeight / 2);
        }
        if (x < leftColumns) {
            this.leftColumn = 0;
            this.rightColumn = this.size.width / this.tileWidth - 1;
            if (this.size.width % this.tileWidth > 0) {
                ++this.rightColumn;
            }
            this.leftColumnX = 0;
        } else if (x >= gameData.getMap().getWidth() - rightColumns) {
            this.rightColumn = gameData.getMap().getWidth() - 1;
            this.leftColumn = this.size.width / this.tileWidth;
            if (this.size.width % this.tileWidth > 0) {
                ++this.leftColumn;
            }
            this.leftColumnX = this.size.width - this.tileWidth - this.tileWidth / 2 - this.leftColumn * this.tileWidth;
            this.leftColumn = this.rightColumn - this.leftColumn;
        } else {
            this.leftColumn = x - leftColumns;
            this.rightColumn = x + rightColumns;
            this.leftColumnX = (this.size.width - this.tileWidth) / 2 - leftColumns * this.tileWidth;
        }
    }

    private void displayGotoPath(Graphics2D g, PathNode gotoPath) {
        if (gotoPath != null) {
            PathNode temp = gotoPath;
            while (temp != null) {
                Point p = this.getTilePosition(temp.getTile());
                if (p != null) {
                    Color textColor;
                    Image image;
                    Tile tile = temp.getTile();
                    if (temp.getTurns() == 0) {
                        g.setColor(Color.GREEN);
                        image = this.getPathImage(this.activeUnit);
                        if (this.activeUnit != null && tile.isExplored() && this.activeUnit.isNaval() && tile.isLand() && (tile.getColony() == null || tile.getColony().getOwner() != this.activeUnit.getOwner())) {
                            image = this.getPathImage(this.activeUnit.getFirstUnit());
                        }
                        textColor = Color.BLACK;
                    } else {
                        g.setColor(Color.RED);
                        image = this.getPathNextTurnImage(this.activeUnit);
                        if (this.activeUnit != null && tile.isExplored() && this.activeUnit.isNaval() && tile.isLand() && (tile.getColony() == null || tile.getColony().getOwner() != this.activeUnit.getOwner())) {
                            image = this.getPathNextTurnImage(this.activeUnit.getFirstUnit());
                        }
                        textColor = Color.WHITE;
                    }
                    if (image != null) {
                        g.drawImage(image, p.x + (this.tileWidth - image.getWidth(null)) / 2, p.y + (this.tileHeight - image.getHeight(null)) / 2, null);
                    } else {
                        g.fillOval(p.x + this.tileWidth / 2, p.y + this.tileHeight / 2, 10, 10);
                        g.setColor(Color.BLACK);
                        g.drawOval(p.x + this.tileWidth / 2, p.y + this.tileHeight / 2, 10, 10);
                    }
                    if (temp.getTurns() > 0) {
                        BufferedImage stringImage = this.createStringImage(g, Integer.toString(temp.getTurns()), textColor, this.tileWidth, 12);
                        g.drawImage((Image)stringImage, p.x + (this.tileWidth - stringImage.getWidth(null)) / 2, p.y + (this.tileHeight - stringImage.getHeight()) / 2, null);
                    }
                }
                temp = temp.next;
            }
        }
    }

    private int getXOffset(int clipLeftX, int tileY) {
        int xx = clipLeftX;
        if (tileY % 2 != 0) {
            xx += this.tileWidth / 2;
        }
        return xx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayMap(Graphics2D g) {
        Tile tile;
        int tileX;
        int tileY;
        int xx;
        Rectangle clipBounds = g.getClipBounds();
        Map map = this.freeColClient.getGame().getMap();
        if (this.bottomRow < 0) {
            this.positionMap();
        }
        int clipTopRow = (clipBounds.y - this.topRowY) / (this.tileHeight / 2) - 1;
        int clipTopY = this.topRowY + clipTopRow * (this.tileHeight / 2);
        clipTopRow = this.topRow + clipTopRow;
        int clipLeftCol = (clipBounds.x - this.leftColumnX) / this.tileWidth - 1;
        int clipLeftX = this.leftColumnX + clipLeftCol * this.tileWidth;
        clipLeftCol = this.leftColumn + clipLeftCol;
        int clipBottomRow = (clipBounds.y + clipBounds.height - this.topRowY) / (this.tileHeight / 2);
        clipBottomRow = this.topRow + clipBottomRow;
        int clipRightCol = (clipBounds.x + clipBounds.width - this.leftColumnX) / this.tileWidth;
        clipRightCol = this.leftColumn + clipRightCol;
        if (this.displayGrid) {
            this.gridPath = new GeneralPath();
            this.gridPath.moveTo(0.0f, 0.0f);
            int nextX = this.tileWidth / 2;
            int nextY = -(this.tileHeight / 2);
            for (int i = 0; i <= (clipRightCol - clipLeftCol) * 2 + 1; ++i) {
                this.gridPath.lineTo(nextX, nextY);
                nextX += this.tileWidth / 2;
                nextY = nextY == -(this.tileHeight / 2) ? 0 : -(this.tileHeight / 2);
            }
        }
        g.setColor(Color.black);
        g.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
        int yy = clipTopY;
        for (int tileY2 = clipTopRow; tileY2 <= clipBottomRow; ++tileY2) {
            xx = this.getXOffset(clipLeftX, tileY2);
            for (int tileX2 = clipLeftCol; tileX2 <= clipRightCol; ++tileX2) {
                this.displayBaseTile(g, map, map.getTile(tileX2, tileY2), xx, yy, true);
                xx += this.tileWidth;
            }
            yy += this.tileHeight / 2;
        }
        ArrayList<Unit> darkUnits = new ArrayList<Unit>();
        ArrayList<Integer> darkUnitsX = new ArrayList<Integer>();
        ArrayList<Integer> darkUnitsY = new ArrayList<Integer>();
        yy = clipTopY;
        for (tileY = clipTopRow; tileY <= clipBottomRow; ++tileY) {
            xx = this.getXOffset(clipLeftX, tileY);
            if (this.displayGrid) {
                g.translate(xx, yy + this.tileHeight / 2);
                g.setColor(Color.BLACK);
                g.draw(this.gridPath);
                g.translate(-xx, -(yy + this.tileHeight / 2));
            }
            for (tileX = clipLeftCol; tileX <= clipRightCol; ++tileX) {
                tile = map.getTile(tileX, tileY);
                this.displayTileOverlays(g, map, tile, xx, yy, true, true);
                if (this.viewMode.displayTileCursor(tile, xx, yy)) {
                    this.drawCursor(g, xx, yy);
                }
                xx += this.tileWidth;
            }
            xx = this.getXOffset(clipLeftX, tileY);
            for (tileX = clipLeftCol; tileX <= clipRightCol; ++tileX) {
                Unit unitInFront = this.getUnitInFront(map.getTile(tileX, tileY));
                if (unitInFront != null) {
                    this.displayUnit(g, unitInFront, xx, yy);
                    if (unitInFront.isUndead()) {
                        darkUnits.add(unitInFront);
                        darkUnitsX.add(xx);
                        darkUnitsY.add(yy);
                    }
                }
                xx += this.tileWidth;
            }
            yy += this.tileHeight / 2;
        }
        if (darkUnits.size() > 0) {
            g.setColor(Color.BLACK);
            Image im = this.getImageLibrary().getMiscImage("halo.dark.image");
            for (int index = 0; index < darkUnits.size(); ++index) {
                Unit u = (Unit)darkUnits.get(index);
                int x = (Integer)darkUnitsX.get(index);
                int y = (Integer)darkUnitsY.get(index);
                g.drawImage(im, x + this.tileWidth / 2 - im.getWidth(null) / 2, y + this.tileHeight / 2 - im.getHeight(null) / 2, null);
                this.displayUnit(g, u, x, y);
            }
        }
        yy = clipTopY;
        for (tileY = clipTopRow; tileY <= clipBottomRow; ++tileY) {
            xx = this.getXOffset(clipLeftX, tileY);
            for (tileX = clipLeftCol; tileX <= clipRightCol; ++tileX) {
                tile = map.getTile(tileX, tileY);
                if (tile != null && tile.getSettlement() instanceof Colony) {
                    Colony colony = (Colony)tile.getSettlement();
                    BufferedImage stringImage = this.createColonyNameImage(g, colony, this.lib.getTerrainImageWidth(tile.getType()) * 4 / 3, 16);
                    g.drawImage((Image)stringImage, xx + (this.lib.getTerrainImageWidth(tile.getType()) - stringImage.getWidth()) / 2 + 1, yy + (this.lib.getSettlementImage(colony).getHeight(null) + 1), null);
                }
                xx += this.tileWidth;
            }
            yy += this.tileHeight / 2;
        }
        this.displayGotoPath(g, this.currentPath);
        this.displayGotoPath(g, this.gotoPath);
        Canvas canvas = this.freeColClient.getCanvas();
        if (!this.freeColClient.isMapEditor() && this.freeColClient.getGame() != null && this.freeColClient.getMyPlayer() != this.freeColClient.getGame().getCurrentPlayer()) {
            if (this.greyLayer == null) {
                this.greyLayer = new GrayLayer(this.lib);
            }
            if (this.greyLayer.getParent() == null) {
                canvas.add((Component)this.greyLayer, JLayeredPane.DEFAULT_LAYER, false);
                canvas.moveToFront(this.greyLayer);
            }
            this.greyLayer.setBounds(0, 0, canvas.getSize().width, canvas.getSize().height);
            this.greyLayer.setPlayer(this.freeColClient.getGame().getCurrentPlayer());
        } else if (this.greyLayer != null && this.greyLayer.getParent() != null) {
            canvas.remove(this.greyLayer, false);
        }
        GUI gUI = this;
        synchronized (gUI) {
            BufferedImage si = this.createStringImage(g, "getSizes", Color.WHITE, this.size.width, 12);
            yy = this.size.height - 300 - this.getMessageCount() * si.getHeight();
            xx = 40;
            for (int i = 0; i < this.getMessageCount(); ++i) {
                GUIMessage message = this.getMessage(i);
                g.drawImage((Image)this.createStringImage(g, message.getMessage(), message.getColor(), this.size.width, 12), xx, yy, null);
                yy += si.getHeight();
            }
        }
    }

    private Image getPathImage(Unit u) {
        if (u == null) {
            return null;
        }
        return ResourceManager.getImage("path." + u.getPathTypeImage() + ".image");
    }

    private Image getPathNextTurnImage(Unit u) {
        if (u == null) {
            return null;
        }
        return ResourceManager.getImage("path." + u.getPathTypeImage() + ".nextTurn.image");
    }

    public BufferedImage createStringImage(Graphics2D g, String nameString, Color color, int maxWidth, int preferredFontSize) {
        return this.createStringImage(null, g, nameString, color, maxWidth, preferredFontSize);
    }

    public BufferedImage createStringImage(JComponent c, String nameString, Color color, int maxWidth, int preferredFontSize) {
        return this.createStringImage(c, null, nameString, color, maxWidth, preferredFontSize);
    }

    private BufferedImage createStringImage(JComponent c, Graphics g, String nameString, Color color, int maxWidth, int preferredFontSize) {
        if (color == null) {
            logger.warning("createStringImage called with color null");
            color = Color.WHITE;
        }
        Font nameFont = c != null ? c.getFont() : g.getFont();
        FontMetrics nameFontMetrics = c != null ? c.getFontMetrics(nameFont) : g.getFontMetrics(nameFont);
        BufferedImage bi = null;
        int fontSize = preferredFontSize;
        do {
            nameFont = nameFont.deriveFont(1, fontSize);
            nameFontMetrics = c != null ? c.getFontMetrics(nameFont) : g.getFontMetrics(nameFont);
            bi = new BufferedImage(nameFontMetrics.stringWidth(nameString) + 4, nameFontMetrics.getMaxAscent() + nameFontMetrics.getMaxDescent(), 2);
            fontSize -= 2;
        } while (bi.getWidth() > maxWidth);
        Graphics2D big = bi.createGraphics();
        big.setColor(color);
        big.setFont(nameFont);
        big.drawString(nameString, 2, nameFontMetrics.getMaxAscent());
        int playerColor = color.getRGB();
        for (int biX = 0; biX < bi.getWidth(); ++biX) {
            for (int biY = 0; biY < bi.getHeight(); ++biY) {
                int r = bi.getRGB(biX, biY);
                if (r == playerColor) continue;
                for (int cX = -1; cX <= 1; ++cX) {
                    for (int cY = -1; cY <= 1; ++cY) {
                        if (biX + cX < 0 || biY + cY < 0 || biX + cX >= bi.getWidth() || biY + cY >= bi.getHeight() || bi.getRGB(biX + cX, biY + cY) != playerColor) continue;
                        bi.setRGB(biX, biY, this.getStringBorderColor(color).getRGB());
                    }
                }
            }
        }
        return bi;
    }

    private BufferedImage createColonyNameImage(Graphics g, Colony colony, int maxWidth, int preferredFontSize) {
        return this.createStringImage((Graphics2D)g, colony.getName(), colony.getOwner().getColor(), maxWidth, preferredFontSize);
    }

    public void drawRoad(Graphics2D g, long seed, int x1, int y1, int x2, int y2) {
        int MAX_CORR = 4;
        Color oldColor = g.getColor();
        Random roadRandom = new Random(seed);
        int i = Math.max(Math.abs(x2 - x1), Math.abs(y2 - y1));
        int baseX = x1;
        int baseY = y1;
        double addX = (double)(x2 - x1) / (double)i;
        double addY = (double)(y2 - y1) / (double)i;
        int corr = 0;
        int xCorr = 0;
        int yCorr = 0;
        int lastDiff = 1;
        g.setColor(new Color(128, 64, 0));
        g.drawLine(baseX, baseY, baseX, baseY);
        for (int j = 1; j <= i; ++j) {
            int oldCorr = corr;
            if (oldCorr != (corr = corr + roadRandom.nextInt(3) - 1)) {
                lastDiff = oldCorr - corr;
            }
            if (Math.abs(corr) > 4 || Math.abs(corr) >= i - j) {
                corr = corr > 0 ? --corr : ++corr;
            }
            if (corr != oldCorr) {
                g.setColor(new Color(128, 128, 0));
                g.drawLine(baseX + (int)((double)j * addX) + xCorr, baseY + (int)((double)j * addY) + yCorr, baseX + (int)((double)j * addX) + xCorr, baseY + (int)((double)j * addY) + yCorr);
            } else {
                int oldXCorr = 0;
                int oldYCorr = 0;
                if (x2 - x1 == 0) {
                    oldXCorr = corr + lastDiff;
                    oldYCorr = 0;
                } else if (y2 - y1 == 0) {
                    oldXCorr = 0;
                    oldYCorr = corr + lastDiff;
                } else if (corr > 0) {
                    oldXCorr = corr + lastDiff;
                } else {
                    oldYCorr = corr + lastDiff;
                }
                g.setColor(new Color(128, 128, 0));
                g.drawLine(baseX + (int)((double)j * addX) + oldXCorr, baseY + (int)((double)j * addY) + oldYCorr, baseX + (int)((double)j * addX) + oldXCorr, baseY + (int)((double)j * addY) + oldYCorr);
            }
            if (x2 - x1 == 0) {
                xCorr = corr;
                yCorr = 0;
            } else if (y2 - y1 == 0) {
                xCorr = 0;
                yCorr = corr;
            } else if (corr > 0) {
                xCorr = corr;
            } else {
                yCorr = corr;
            }
            g.setColor(new Color(128, 64, 0));
            g.drawLine(baseX + (int)((double)j * addX) + xCorr, baseY + (int)((double)j * addY) + yCorr, baseX + (int)((double)j * addX) + xCorr, baseY + (int)((double)j * addY) + yCorr);
        }
        g.setColor(oldColor);
    }

    public void displayColonyTile(Graphics2D g, Map map, Tile tile, int x, int y, Colony colony) {
        Object image;
        this.displayBaseTile(g, map, tile, x, y, false);
        Unit occupyingUnit = colony.getColonyTile(tile).getOccupyingUnit();
        Settlement settlement = tile.getOwningSettlement();
        int price = colony.getOwner().getLandPrice(tile);
        if (settlement != null && settlement instanceof Colony && settlement != colony || settlement instanceof IndianSettlement && price > 0 || occupyingUnit != null) {
            g.drawImage(this.lib.getMiscImage("tileTaken.image"), x, y, null);
        }
        this.displayTileOverlays(g, map, tile, x, y, false, false);
        if (price > 0 && tile.getSettlement() == null) {
            image = this.lib.getMiscImage("nativeLand.image");
            g.drawImage((Image)image, x + this.tileWidth / 2 - ((Image)image).getWidth(null) / 2, y + this.tileHeight / 2 - ((Image)image).getHeight(null) / 2, null);
        }
        if (occupyingUnit != null) {
            image = this.lib.getScaledImageIcon(this.lib.getUnitImageIcon(occupyingUnit), 0.5f);
            g.drawImage(((ImageIcon)image).getImage(), x + this.tileWidth / 4 - ((ImageIcon)image).getIconWidth() / 2, y + this.tileHeight / 2 - ((ImageIcon)image).getIconHeight() / 2, null);
            this.displayOccupationIndicator(g, occupyingUnit, x + (int)(25.0f * this.lib.getScalingFactor()), y);
        }
    }

    public void displayTerrain(Graphics2D g, Map map, Tile tile, int x, int y) {
        this.displayBaseTile(g, map, tile, x, y, true);
        this.displayAdditionsAndImprovements(g, map, tile, x, y);
    }

    public void displayTile(Graphics2D g, Map map, Tile tile, int x, int y) {
        this.displayTile(g, map, tile, x, y, true);
    }

    public void displayTile(Graphics2D g, Map map, Tile tile, int x, int y, boolean drawUnexploredBorders) {
        this.displayBaseTile(g, map, tile, x, y, drawUnexploredBorders);
        this.displayTileOverlays(g, map, tile, x, y, drawUnexploredBorders, true);
    }

    private void displayBaseTile(Graphics2D g, Map map, Tile tile, int x, int y, boolean drawUnexploredBorders) {
        if (tile == null) {
            return;
        }
        g.drawImage(this.lib.getTerrainImage(tile.getType(), tile.getX(), tile.getY()), x, y, null);
        Map.Position pos = new Map.Position(tile.getX(), tile.getY());
        for (Map.Direction direction : Map.Direction.values()) {
            Map.Position p = Map.getAdjacent(pos, direction);
            if (!map.isValid(p)) continue;
            Tile borderingTile = map.getTile(p.x, p.y);
            if (borderingTile == null) {
                logger.warning("Bordering Tile was null.");
                continue;
            }
            if (!drawUnexploredBorders && !borderingTile.isExplored() && (direction == Map.Direction.SE || direction == Map.Direction.S || direction == Map.Direction.SW) || tile.getType() == borderingTile.getType() || tile.isLand() && !borderingTile.isLand()) continue;
            if (!tile.isLand() && borderingTile.isLand() && borderingTile.isExplored()) {
                if (borderingTile.getType().getArtCoast() != null) {
                    g.drawImage(this.lib.getCoastImage(borderingTile.getType(), direction, tile.getX(), tile.getY()), x, y, null);
                }
                g.drawImage(this.lib.getBorderImage(borderingTile.getType(), direction, tile.getX(), tile.getY()), x, y, null);
                continue;
            }
            if (!tile.isExplored() || !borderingTile.isExplored() || tile.getType().getArtBasic().equals(borderingTile.getType().getArtBasic()) || borderingTile.getType().getIndex() >= tile.getType().getIndex()) continue;
            g.drawImage(this.lib.getBorderImage(borderingTile.getType(), direction, tile.getX(), tile.getY()), x, y, null);
        }
    }

    private void displayTileOverlays(Graphics2D g, Map map, Tile tile, int x, int y, boolean drawUnexploredBorders, boolean withNumber) {
        if (tile != null) {
            if (drawUnexploredBorders) {
                this.displayUnexploredBorders(g, map, tile, x, y);
            }
            this.displayAdditionsAndImprovements(g, map, tile, x, y);
            this.displaySettlement(g, map, tile, x, y, withNumber);
            this.displayFogOfWar(g, map, tile, x, y);
            this.displayOptionalValues(g, map, tile, x, y);
        }
    }

    private void displayAdditionsAndImprovements(Graphics2D g, Map map, Tile tile, int x, int y) {
        Map.Position pos = new Map.Position(tile.getX(), tile.getY());
        if (!tile.isExplored()) {
            g.drawImage(this.lib.getTerrainImage(null, tile.getX(), tile.getY()), x, y, null);
        } else {
            TileItemContainer tic;
            if (tile.getType().getArtOverlay() != null) {
                g.drawImage(this.lib.getOverlayImage(tile.getType(), tile.getX(), tile.getY()), x, y - (int)(32.0f * this.lib.getScalingFactor()), null);
            }
            if ((tic = tile.getTileItemContainer()) == null) {
                if (tile.isForested()) {
                    g.drawImage(this.lib.getForestImage(tile.getType()), x, y, null);
                }
            } else {
                Image bonusImage;
                List<TileImprovement> tiList = tile.getCompletedTileImprovements();
                ArrayList<TileImprovement> tiList2 = new ArrayList<TileImprovement>();
                for (TileImprovement ti : tiList) {
                    if (ti == tic.getRiver() || ti == tic.getRoad()) continue;
                    if (!ti.getType().isArtOverTrees()) {
                        tiList2.add(ti);
                        continue;
                    }
                    if (ti.getType().getArtOverlay() == null) continue;
                    g.drawImage(ResourceManager.getImage(ti.getType().getArtOverlay()), x, y, null);
                }
                if (tic.hasRiver() && tic.getRiver().getMagnitude() < 3) {
                    g.drawImage(this.lib.getRiverImage(tic.getRiverStyle()), x, y, null);
                }
                if (tile.isForested()) {
                    g.drawImage(this.lib.getForestImage(tile.getType()), x, y, null);
                }
                for (TileImprovement ti : tiList2) {
                    if (ti == tic.getRiver() || ti == tic.getRoad() || ti.getType().getArtOverlay() == null) continue;
                    g.drawImage(ResourceManager.getImage(ti.getType().getArtOverlay()), x, y, null);
                }
                if (tile.hasResource() && (bonusImage = this.lib.getBonusImage(tic.getResource().getType())) != null) {
                    g.drawImage(bonusImage, x + this.tileWidth / 2 - bonusImage.getWidth(null) / 2, y + this.tileHeight / 2 - bonusImage.getHeight(null) / 2, null);
                }
                if (tile.hasRoad()) {
                    long seed = Long.parseLong(Integer.toString(tile.getX()) + Integer.toString(tile.getY()));
                    boolean connectedRoad = false;
                    for (Map.Direction direction : Map.Direction.values()) {
                        Tile borderingTile;
                        Map.Position p = Map.getAdjacent(pos, direction);
                        if (!map.isValid(p) || !(borderingTile = map.getTile(p)).hasRoad()) continue;
                        connectedRoad = true;
                        int nx = x + this.tileWidth / 2;
                        int ny = y + this.tileHeight / 2;
                        switch (direction) {
                            case N: {
                                nx = x + this.tileWidth / 2;
                                ny = y;
                                break;
                            }
                            case NE: {
                                nx = x + this.tileWidth * 3 / 4;
                                ny = y + this.tileHeight / 4;
                                break;
                            }
                            case E: {
                                nx = x + this.tileWidth;
                                ny = y + this.tileHeight / 2;
                                break;
                            }
                            case SE: {
                                nx = x + this.tileWidth * 3 / 4;
                                ny = y + this.tileHeight * 3 / 4;
                                break;
                            }
                            case S: {
                                nx = x + this.tileWidth / 2;
                                ny = y + this.tileHeight;
                                break;
                            }
                            case SW: {
                                nx = x + this.tileWidth / 4;
                                ny = y + this.tileHeight * 3 / 4;
                                break;
                            }
                            case W: {
                                nx = x;
                                ny = y + this.tileHeight / 2;
                                break;
                            }
                            case NW: {
                                nx = x + this.tileWidth / 4;
                                ny = y + this.tileHeight / 4;
                            }
                        }
                        this.drawRoad(g, seed, x + this.tileWidth / 2, y + this.tileHeight / 2, nx, ny);
                    }
                    if (!connectedRoad) {
                        this.drawRoad(g, seed, x + this.tileWidth / 2 - 10, y + this.tileHeight / 2, x + this.tileWidth / 2 + 10, y + this.tileHeight / 2);
                        this.drawRoad(g, seed, x + this.tileWidth / 2, y + this.tileHeight / 2 - 10, x + this.tileWidth / 2, y + this.tileHeight / 2 + 10);
                    }
                }
            }
        }
    }

    private void displaySettlement(Graphics2D g, Map map, Tile tile, int x, int y, boolean withNumber) {
        if (tile.isExplored()) {
            Settlement settlement = tile.getSettlement();
            if (settlement != null) {
                if (settlement instanceof Colony) {
                    Image colonyImage = this.lib.getSettlementImage(settlement);
                    g.drawImage(colonyImage, x + (this.lib.getTerrainImageWidth(tile.getType()) - colonyImage.getWidth(null)) / 2, y + (this.lib.getTerrainImageHeight(tile.getType()) - colonyImage.getHeight(null)) / 2, null);
                    if (withNumber) {
                        String populationString = Integer.toString(((Colony)settlement).getUnitCount());
                        Color theColor = null;
                        int bonus = ((Colony)settlement).getProductionBonus();
                        switch (bonus) {
                            case 2: {
                                theColor = Color.BLUE;
                                break;
                            }
                            case 1: {
                                theColor = Color.GREEN;
                                break;
                            }
                            case -1: {
                                theColor = Color.ORANGE;
                                break;
                            }
                            case -2: {
                                theColor = Color.RED;
                                break;
                            }
                            default: {
                                theColor = Color.WHITE;
                            }
                        }
                        BufferedImage stringImage = this.createStringImage(g, populationString, theColor, this.lib.getTerrainImageWidth(tile.getType()), 12);
                        g.drawImage((Image)stringImage, x + (this.lib.getTerrainImageWidth(tile.getType()) - stringImage.getWidth()) / 2 + 1, y + (this.lib.getTerrainImageHeight(tile.getType()) - stringImage.getHeight()) / 2 + 1, null);
                    }
                    g.setColor(Color.BLACK);
                } else if (settlement instanceof IndianSettlement) {
                    Tension alarm;
                    IndianSettlement indianSettlement = (IndianSettlement)settlement;
                    Image settlementImage = this.lib.getSettlementImage(settlement);
                    g.drawImage(settlementImage, x + (this.lib.getTerrainImageWidth(tile.getType()) - settlementImage.getWidth(null)) / 2, y + (this.lib.getTerrainImageHeight(tile.getType()) - settlementImage.getHeight(null)) / 2, null);
                    g.drawImage(this.lib.getColorChip(indianSettlement.getOwner().getColor()), x + (int)(25.0f * this.lib.getScalingFactor()), y + (int)(10.0f * this.lib.getScalingFactor()), null);
                    Unit missionary = indianSettlement.getMissionary();
                    if (missionary != null) {
                        boolean expert = missionary.hasAbility("model.ability.expertMissionary");
                        g.drawImage(this.lib.getMissionChip(missionary.getOwner().getColor(), expert), x + (int)(25.0f * this.lib.getScalingFactor()) + 24, y + (int)(10.0f * this.lib.getScalingFactor()), null);
                    }
                    if (this.freeColClient.getMyPlayer() != null && (alarm = indianSettlement.getAlarm(this.freeColClient.getMyPlayer())) != null) {
                        boolean visited = indianSettlement.hasBeenVisited(this.freeColClient.getMyPlayer());
                        g.drawImage(this.lib.getAlarmChip(alarm.getLevel(), visited), x + (int)(25.0f * this.lib.getScalingFactor()) + 12, y + (int)(10.0f * this.lib.getScalingFactor()), null);
                    }
                    g.setColor(Color.BLACK);
                    if (indianSettlement.isCapital()) {
                        g.drawString("*", (float)x + 25.0f * this.lib.getScalingFactor() + 2.0f + 1.0f, (float)(y + (int)(10.0f * this.lib.getScalingFactor()) + 13 + 2));
                    } else {
                        g.drawString("-", x + (int)(25.0f * this.lib.getScalingFactor()) + 2, y + (int)(10.0f * this.lib.getScalingFactor()) + 13);
                    }
                } else {
                    logger.warning("Requested to draw unknown settlement type.");
                }
            } else if (tile.hasLostCityRumour()) {
                g.drawImage(this.lib.getMiscImage("lostCityRumour.image"), x + (int)(40.0f * this.lib.getScalingFactor()), y + (int)(5.0f * this.lib.getScalingFactor()), null);
            }
        }
    }

    private void displayFogOfWar(Graphics2D g, Map map, Tile tile, int x, int y) {
        if (tile.isExplored()) {
            boolean displayFogOfWar;
            boolean bl = displayFogOfWar = this.freeColClient.getGame().getGameOptions().getBoolean("model.option.fogOfWar") && this.freeColClient.getClientOptions().getBoolean("model.option.displayFogOfWar");
            if (displayFogOfWar && this.freeColClient.getMyPlayer() != null && !this.freeColClient.getMyPlayer().canSee(tile)) {
                g.setColor(Color.BLACK);
                Composite oldComposite = g.getComposite();
                g.setComposite(AlphaComposite.getInstance(3, 0.2f));
                Polygon pol = new Polygon(new int[]{x + this.tileWidth / 2, x + this.tileWidth, x + this.tileWidth / 2, x}, new int[]{y, y + this.tileHeight / 2, y + this.tileHeight, y + this.tileHeight / 2}, 4);
                g.fill(pol);
                g.setComposite(oldComposite);
            }
        }
    }

    private void displayUnexploredBorders(Graphics2D g, Map map, Tile tile, int x, int y) {
        if (tile.isExplored()) {
            Map.Position pos = new Map.Position(tile.getX(), tile.getY());
            for (Map.Direction direction : Map.Direction.values()) {
                Tile borderingTile;
                Map.Position p = Map.getAdjacent(pos, direction);
                if (!map.isValid(p) || (borderingTile = map.getTile(p)) == null || borderingTile.isExplored()) continue;
                g.drawImage(this.lib.getBorderImage(null, direction, tile.getX(), tile.getY()), x, y, null);
            }
        }
    }

    private void displayOptionalValues(Graphics2D g, Map map, Tile tile, int x, int y) {
        switch (this.displayTileText) {
            case 0: {
                break;
            }
            case 1: {
                if (tile.getName() == null) break;
                String tileName = tile.getName();
                g.setColor(Color.BLACK);
                int b = this.getBreakingPoint(tileName);
                if (b == -1) {
                    g.drawString(tileName, x + (this.lib.getTerrainImageWidth(tile.getType()) - g.getFontMetrics().stringWidth(tileName)) / 2, y + this.lib.getTerrainImageHeight(tile.getType()) / 2);
                    break;
                }
                g.drawString(tileName.substring(0, b), x + (this.lib.getTerrainImageWidth(tile.getType()) - g.getFontMetrics().stringWidth(tileName.substring(0, b))) / 2, y + this.lib.getTerrainImageHeight(tile.getType()) / 2 - g.getFontMetrics().getAscent() * 2 / 3);
                g.drawString(tileName.substring(b + 1), x + (this.lib.getTerrainImageWidth(tile.getType()) - g.getFontMetrics().stringWidth(tileName.substring(b + 1))) / 2, y + this.lib.getTerrainImageHeight(tile.getType()) / 2 + g.getFontMetrics().getAscent() * 2 / 3);
                break;
            }
            case 2: {
                if (tile.getOwner() == null) break;
                String tileOwner = tile.getOwner().getNationAsString();
                g.setColor(Color.BLACK);
                int b = this.getBreakingPoint(tileOwner);
                if (b == -1) {
                    g.drawString(tileOwner, x + (this.lib.getTerrainImageWidth(tile.getType()) - g.getFontMetrics().stringWidth(tileOwner)) / 2, y + this.lib.getTerrainImageHeight(tile.getType()) / 2);
                    break;
                }
                g.drawString(tileOwner.substring(0, b), x + (this.lib.getTerrainImageWidth(tile.getType()) - g.getFontMetrics().stringWidth(tileOwner.substring(0, b))) / 2, y + this.lib.getTerrainImageHeight(tile.getType()) / 2 - g.getFontMetrics().getAscent() * 2 / 3);
                g.drawString(tileOwner.substring(b + 1), x + (this.lib.getTerrainImageWidth(tile.getType()) - g.getFontMetrics().stringWidth(tileOwner.substring(b + 1))) / 2, y + this.lib.getTerrainImageHeight(tile.getType()) / 2 + g.getFontMetrics().getAscent() * 2 / 3);
                break;
            }
            case 3: {
                if (tile.getRegion() == null) break;
                String regionString = tile.getRegion().getDisplayName();
                g.setColor(Color.BLACK);
                int b = this.getBreakingPoint(regionString);
                if (b == -1) {
                    g.drawString(regionString, x + (this.lib.getTerrainImageWidth(tile.getType()) - g.getFontMetrics().stringWidth(regionString)) / 2, y + this.lib.getTerrainImageHeight(tile.getType()) / 2);
                    break;
                }
                g.drawString(regionString.substring(0, b), x + (this.lib.getTerrainImageWidth(tile.getType()) - g.getFontMetrics().stringWidth(regionString.substring(0, b))) / 2, y + this.lib.getTerrainImageHeight(tile.getType()) / 2 - g.getFontMetrics().getAscent() * 2 / 3);
                g.drawString(regionString.substring(b + 1), x + (this.lib.getTerrainImageWidth(tile.getType()) - g.getFontMetrics().stringWidth(regionString.substring(b + 1))) / 2, y + this.lib.getTerrainImageHeight(tile.getType()) / 2 + g.getFontMetrics().getAscent() * 2 / 3);
                break;
            }
            default: {
                logger.warning("displayTileText out of range");
            }
        }
        g.setColor(Color.BLACK);
        if (this.displayCoordinates) {
            String posString = tile.getX() + ", " + tile.getY();
            g.drawString(posString, x + (this.lib.getTerrainImageWidth(tile.getType()) - g.getFontMetrics().stringWidth(posString)) / 2, y + (this.lib.getTerrainImageHeight(tile.getType()) - g.getFontMetrics().getAscent()) / 2);
        }
        if (this.displayColonyValue && tile.isExplored() && tile.isLand()) {
            String valueString = this.displayColonyValuePlayer == null ? Integer.toString(tile.getColonyValue()) : Integer.toString(this.displayColonyValuePlayer.getColonyValue(tile));
            g.drawString(valueString, x + (this.lib.getTerrainImageWidth(tile.getType()) - g.getFontMetrics().stringWidth(valueString)) / 2, y + (this.lib.getTerrainImageHeight(tile.getType()) - g.getFontMetrics().getAscent()) / 2);
        }
    }

    public void stopGoto() {
        this.freeColClient.getCanvas().setCursor(null);
        this.setGotoPath(null);
        this.updateGotoPathForActiveUnit();
        this.gotoStarted = false;
    }

    public void startGoto() {
        this.gotoStarted = true;
        this.freeColClient.getCanvas().setCursor((Cursor)UIManager.get("cursor.go"));
        this.setGotoPath(null);
    }

    public boolean isGotoStarted() {
        return this.gotoStarted;
    }

    public void updateGotoPathForActiveUnit() {
        this.currentPath = this.activeUnit == null || this.activeUnit.getDestination() == null ? null : (this.activeUnit.getDestination() instanceof Europe ? this.freeColClient.getGame().getMap().findPathToEurope(this.activeUnit, this.activeUnit.getTile()) : (this.activeUnit.getDestination().getTile() == this.activeUnit.getTile() ? null : this.activeUnit.findPath(this.activeUnit.getDestination().getTile())));
    }

    public void setGotoPath(PathNode gotoPath) {
        this.gotoPath = gotoPath;
        this.freeColClient.getCanvas().refresh();
    }

    public PathNode getGotoPath() {
        return this.gotoPath;
    }

    public void setDisplayGrid(boolean displayGrid) {
        this.displayGrid = displayGrid;
    }

    public void setDisplayTileText(int tileTextType) {
        this.displayTileText = tileTextType;
    }

    public int getBreakingPoint(String string) {
        int center = string.length() / 2;
        int bestIndex = string.indexOf(32);
        int index = 0;
        while (index != -1 && index != bestIndex) {
            if (Math.abs(center - index) < Math.abs(center - bestIndex)) {
                bestIndex = index;
            }
            index = string.indexOf(32, bestIndex);
        }
        if (bestIndex == 0 || bestIndex == string.length()) {
            return -1;
        }
        return bestIndex;
    }

    private Image getOccupationIndicatorImage(Unit unit) {
        String occupationString;
        Image chip = this.lib.getColorChip(unit.getOwner().getColor());
        BufferedImage img = new BufferedImage(chip.getWidth(null), chip.getHeight(null), 2);
        Graphics g = img.getGraphics();
        g.drawImage(chip, 0, 0, null);
        g.setColor(this.getForegroundColor(unit.getOwner().getColor()));
        if (unit.getOwner() != this.freeColClient.getMyPlayer() && unit.isNaval()) {
            occupationString = Integer.toString(unit.getVisibleGoodsCount());
        } else {
            occupationString = unit.getOccupationIndicator();
            if (unit.getState() == Unit.UnitState.FORTIFIED) {
                g.setColor(Color.GRAY);
            }
        }
        g.drawString(occupationString, 2, 13);
        return img;
    }

    private Color getForegroundColor(Color background) {
        if ((double)background.getRed() * 0.3 + (double)background.getGreen() * 0.59 + (double)background.getBlue() * 0.11 < 126.0) {
            return Color.WHITE;
        }
        return Color.BLACK;
    }

    private Color getStringBorderColor(Color color) {
        if ((double)color.getRed() * 0.3 + (double)color.getGreen() * 0.59 + (double)color.getBlue() * 0.11 < 10.0) {
            return Color.WHITE;
        }
        return Color.BLACK;
    }

    public void displayOccupationIndicator(Graphics g, Unit unit, int x, int y) {
        g.drawImage(this.getOccupationIndicatorImage(unit), x, y, null);
    }

    private void displayUnit(Graphics2D g, Unit unit, int x, int y) {
        AIUnit au;
        try {
            if (this.viewMode.displayUnitCursor(unit, x, y)) {
                this.drawCursor(g, x, y);
            }
            Image image = this.lib.getUnitImageIcon(unit, unit.getState() == Unit.UnitState.SENTRY).getImage();
            Point p = this.getUnitImagePositionInTile(image, x, y);
            g.drawImage(image, p.x, p.y, null);
            this.displayOccupationIndicator(g, unit, x + (int)(25.0f * this.lib.getScalingFactor()), y);
            int unitsOnTile = 0;
            if (unit.getTile() != null) {
                unitsOnTile = unit.getTile().getTotalUnitCount();
            }
            if (unitsOnTile > 1) {
                g.setColor(Color.WHITE);
                int unitLinesY = y + 1;
                for (int i = 0; i < unitsOnTile && i < 10; ++i) {
                    g.drawLine(x + (int)(20.0f * this.lib.getScalingFactor()), unitLinesY, x + (int)(23.0f * this.lib.getScalingFactor()), unitLinesY);
                    unitLinesY += 2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.debugShowMission && this.freeColClient.getFreeColServer() != null && (au = (AIUnit)this.freeColClient.getFreeColServer().getAIMain().getAIObject(unit)) != null) {
            g.setColor(Color.WHITE);
            String text = unit.getOwner().isAI() ? "" : "(";
            String debuggingInfo = "";
            if (au.getMission() != null) {
                String missionName = au.getMission().getClass().toString();
                missionName = missionName.substring(missionName.lastIndexOf(46) + 1);
                text = text + missionName;
                if (this.debugShowMissionInfo) {
                    debuggingInfo = au.getMission().getDebuggingInfo();
                }
            } else {
                text = text + "No mission";
            }
            text = text + (unit.getOwner().isAI() ? "" : ")");
            g.drawString(text, x, y);
            g.drawString(debuggingInfo, x, y + 25);
        }
    }

    private Point getUnitImagePositionInTile(Image unitImage, int tileX, int tileY) {
        return this.getUnitImagePositionInTile(unitImage.getWidth(null), unitImage.getHeight(null), tileX, tileY);
    }

    private Point getUnitImagePositionInTile(int unitImageWidth, int unitImageHeight, int tileX, int tileY) {
        int unitX = tileX + this.getTileWidth() / 2 - unitImageWidth / 2;
        int unitY = tileY + this.getTileHeight() / 2 - unitImageHeight / 2 - (int)(20.0f * this.lib.getScalingFactor());
        return new Point(unitX, unitY);
    }

    public Point getUnitLabelPositionInTile(JLabel unitLabel, Tile tile) {
        return this.getUnitLabelPositionInTile(unitLabel, this.getTilePosition(tile));
    }

    public Point getUnitLabelPositionInTile(JLabel unitLabel, Point tileP) {
        if (tileP != null) {
            int labelX = tileP.x;
            int labelY = tileP.y + this.getTileHeight() / 2 - unitLabel.getHeight() / 2 - (int)(20.0f * this.lib.getScalingFactor());
            return new Point(labelX, labelY);
        }
        return null;
    }

    public JLabel getUnitLabel(Unit unit) {
        Image unitImg = this.lib.getUnitImageIcon(unit).getImage();
        Image chipImg = this.getOccupationIndicatorImage(unit);
        int width = this.tileWidth / 2 + unitImg.getWidth(null) / 2;
        int height = unitImg.getHeight(null);
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics g = img.getGraphics();
        int unitX = width - unitImg.getWidth(null);
        g.drawImage(unitImg, unitX, 0, null);
        int chipX = (int)(25.0f * this.lib.getScalingFactor());
        int chipY = (int)((float)(height / 2) + 20.0f * this.lib.getScalingFactor() - (float)(this.tileHeight / 2));
        g.drawImage(chipImg, chipX, chipY, null);
        JLabel label = new JLabel(new ImageIcon(img));
        label.setBounds(0, 0, width, height);
        return label;
    }

    private void drawCursor(Graphics2D g, int x, int y) {
        g.drawImage(this.cursorImage, x, y, null);
    }

    public void setInGame(boolean inGame) {
        this.inGame = inGame;
    }

    public boolean isInGame() {
        return this.inGame;
    }

    public boolean onScreen(int x, int y) {
        if (this.bottomRow < 0) {
            this.positionMap();
            return y - 2 > this.topRow && y + 4 < this.bottomRow && x - 1 > this.leftColumn && x + 2 < this.rightColumn;
        }
        return y - 2 > this.topRow && y + 4 < this.bottomRow && x - 1 > this.leftColumn && x + 2 < this.rightColumn;
    }

    public boolean onScreen(Map.Position position) {
        return this.onScreen(position.getX(), position.getY());
    }

    public Map.Position convertToMapCoordinates(int x, int y) {
        Game gameData = this.freeColClient.getGame();
        if (gameData == null || gameData.getMap() == null) {
            return null;
        }
        int leftOffset = this.focus.getX() < this.getLeftColumns() ? (this.focus.getY() % 2 == 0 ? this.tileWidth * this.focus.getX() + this.tileWidth / 2 : this.tileWidth * (this.focus.getX() + 1)) : (this.focus.getX() >= gameData.getMap().getWidth() - this.getRightColumns() ? (this.focus.getY() % 2 == 0 ? this.size.width - (gameData.getMap().getWidth() - this.focus.getX()) * this.tileWidth : this.size.width - (gameData.getMap().getWidth() - this.focus.getX() - 1) * this.tileWidth - this.tileWidth / 2) : (this.focus.getY() % 2 == 0 ? this.size.width / 2 : this.size.width / 2 + this.tileWidth / 2));
        int topOffset = this.focus.getY() < this.topRows ? (this.focus.getY() + 1) * (this.tileHeight / 2) : (this.focus.getY() >= gameData.getMap().getHeight() - this.bottomRows ? this.size.height - (gameData.getMap().getHeight() - this.focus.getY()) * (this.tileHeight / 2) : this.size.height / 2);
        int diffUp = (topOffset - y) / (this.tileHeight / 4);
        int diffLeft = (leftOffset - x) / (this.tileWidth / 4);
        int orDiffUp = diffUp;
        int orDiffLeft = diffLeft;
        int remainderUp = (topOffset - y) % (this.tileHeight / 4);
        int remainderLeft = (leftOffset - x) % (this.tileWidth / 4);
        diffUp = diffUp % 2 == 0 ? (diffUp /= 2) : (diffUp < 0 ? diffUp / 2 - 1 : diffUp / 2 + 1);
        diffLeft = diffLeft % 2 == 0 ? (diffLeft /= 2) : (diffLeft < 0 ? diffLeft / 2 - 1 : diffLeft / 2 + 1);
        boolean done = false;
        while (!done) {
            if (diffUp % 2 == 0) {
                if (diffLeft % 2 == 0) {
                    diffLeft /= 2;
                    done = true;
                    continue;
                }
                if (orDiffLeft % 2 == 0 && orDiffUp % 2 == 0) {
                    if (orDiffLeft > 0 && orDiffUp > 0) {
                        if (remainderUp * 2 > remainderLeft) {
                            ++diffUp;
                            continue;
                        }
                        ++diffLeft;
                        continue;
                    }
                    if (orDiffUp > 0) {
                        if (remainderUp * 2 > -remainderLeft) {
                            ++diffUp;
                            continue;
                        }
                        --diffLeft;
                        continue;
                    }
                    if (orDiffLeft > 0 && orDiffUp == 0) {
                        if (remainderUp > 0) {
                            if (remainderUp * 2 > remainderLeft) {
                                ++diffUp;
                                continue;
                            }
                            ++diffLeft;
                            continue;
                        }
                        if (-remainderUp * 2 > remainderLeft) {
                            --diffUp;
                            continue;
                        }
                        ++diffLeft;
                        continue;
                    }
                    if (orDiffUp == 0) {
                        if (remainderUp > 0) {
                            if (remainderUp * 2 > -remainderLeft) {
                                ++diffUp;
                                continue;
                            }
                            --diffLeft;
                            continue;
                        }
                        if (-remainderUp * 2 > -remainderLeft) {
                            --diffUp;
                            continue;
                        }
                        --diffLeft;
                        continue;
                    }
                    if (orDiffLeft > 0) {
                        if (-remainderUp * 2 > remainderLeft) {
                            --diffUp;
                            continue;
                        }
                        ++diffLeft;
                        continue;
                    }
                    if (-remainderUp * 2 > -remainderLeft) {
                        --diffUp;
                        continue;
                    }
                    --diffLeft;
                    continue;
                }
                if (orDiffLeft % 2 == 0) {
                    if (orDiffLeft > 0 && orDiffUp > 0) {
                        if (remainderUp * 2 + remainderLeft > this.tileWidth / 4) {
                            ++diffLeft;
                            continue;
                        }
                        --diffUp;
                        continue;
                    }
                    if (orDiffUp > 0) {
                        if (remainderUp * 2 - remainderLeft > this.tileWidth / 4) {
                            --diffLeft;
                            continue;
                        }
                        --diffUp;
                        continue;
                    }
                    if (orDiffLeft > 0) {
                        if (-remainderUp * 2 + remainderLeft > this.tileWidth / 4) {
                            ++diffLeft;
                            continue;
                        }
                        ++diffUp;
                        continue;
                    }
                    if (-remainderUp * 2 - remainderLeft > this.tileWidth / 4) {
                        --diffLeft;
                        continue;
                    }
                    ++diffUp;
                    continue;
                }
                if (orDiffUp % 2 == 0) {
                    if (orDiffLeft > 0 && orDiffUp > 0) {
                        if (remainderUp * 2 + remainderLeft > this.tileWidth / 4) {
                            ++diffUp;
                            continue;
                        }
                        --diffLeft;
                        continue;
                    }
                    if (orDiffUp > 0) {
                        if (remainderUp * 2 - remainderLeft > this.tileWidth / 4) {
                            ++diffUp;
                            continue;
                        }
                        ++diffLeft;
                        continue;
                    }
                    if (orDiffLeft > 0 && orDiffUp == 0) {
                        if (remainderUp > 0) {
                            if (remainderUp * 2 + remainderLeft > this.tileWidth / 4) {
                                ++diffUp;
                                continue;
                            }
                            --diffLeft;
                            continue;
                        }
                        if (-remainderUp * 2 + remainderLeft > this.tileWidth / 4) {
                            --diffUp;
                            continue;
                        }
                        --diffLeft;
                        continue;
                    }
                    if (orDiffUp == 0) {
                        if (remainderUp > 0) {
                            if (remainderUp * 2 - remainderLeft > this.tileWidth / 4) {
                                ++diffUp;
                                continue;
                            }
                            ++diffLeft;
                            continue;
                        }
                        if (-remainderUp * 2 - remainderLeft > this.tileWidth / 4) {
                            --diffUp;
                            continue;
                        }
                        ++diffLeft;
                        continue;
                    }
                    if (orDiffLeft > 0) {
                        if (-remainderUp * 2 + remainderLeft > this.tileWidth / 4) {
                            --diffUp;
                            continue;
                        }
                        --diffLeft;
                        continue;
                    }
                    if (-remainderUp * 2 - remainderLeft > this.tileWidth / 4) {
                        --diffUp;
                        continue;
                    }
                    ++diffLeft;
                    continue;
                }
                if (orDiffLeft > 0 && orDiffUp > 0) {
                    if (remainderUp * 2 > remainderLeft) {
                        --diffLeft;
                        continue;
                    }
                    --diffUp;
                    continue;
                }
                if (orDiffUp > 0) {
                    if (remainderUp * 2 > -remainderLeft) {
                        ++diffLeft;
                        continue;
                    }
                    --diffUp;
                    continue;
                }
                if (orDiffLeft > 0) {
                    if (-remainderUp * 2 > remainderLeft) {
                        --diffLeft;
                        continue;
                    }
                    ++diffUp;
                    continue;
                }
                if (-remainderUp * 2 > -remainderLeft) {
                    ++diffLeft;
                    continue;
                }
                ++diffUp;
                continue;
            }
            if (diffLeft % 2 == 0) {
                if (orDiffLeft % 2 == 0 && orDiffUp % 2 == 0) {
                    if (orDiffLeft > 0 && orDiffUp > 0) {
                        if (remainderUp * 2 > remainderLeft) {
                            ++diffUp;
                            continue;
                        }
                        ++diffLeft;
                        continue;
                    }
                    if (orDiffLeft > 0) {
                        if (-remainderUp * 2 > remainderLeft) {
                            --diffUp;
                            continue;
                        }
                        ++diffLeft;
                        continue;
                    }
                    if (orDiffUp > 0 && orDiffLeft == 0) {
                        if (remainderLeft > 0) {
                            if (remainderUp * 2 > remainderLeft) {
                                ++diffUp;
                                continue;
                            }
                            ++diffLeft;
                            continue;
                        }
                        if (remainderUp * 2 > -remainderLeft) {
                            ++diffUp;
                            continue;
                        }
                        --diffLeft;
                        continue;
                    }
                    if (orDiffLeft == 0) {
                        if (remainderLeft > 0) {
                            if (-remainderUp * 2 > remainderLeft) {
                                --diffUp;
                                continue;
                            }
                            ++diffLeft;
                            continue;
                        }
                        if (-remainderUp * 2 > -remainderLeft) {
                            --diffUp;
                            continue;
                        }
                        --diffLeft;
                        continue;
                    }
                    if (orDiffUp > 0) {
                        if (remainderUp * 2 > -remainderLeft) {
                            ++diffUp;
                            continue;
                        }
                        --diffLeft;
                        continue;
                    }
                    if (-remainderUp * 2 > -remainderLeft) {
                        --diffUp;
                        continue;
                    }
                    --diffLeft;
                    continue;
                }
                if (orDiffLeft % 2 == 0) {
                    if (orDiffLeft > 0 && orDiffUp > 0) {
                        if (remainderUp * 2 + remainderLeft > this.tileWidth / 4) {
                            ++diffLeft;
                            continue;
                        }
                        --diffUp;
                        continue;
                    }
                    if (orDiffLeft > 0) {
                        if (-remainderUp * 2 + remainderLeft > this.tileWidth / 4) {
                            ++diffLeft;
                            continue;
                        }
                        ++diffUp;
                        continue;
                    }
                    if (orDiffUp > 0 && orDiffLeft == 0) {
                        if (remainderLeft > 0) {
                            if (remainderUp * 2 + remainderLeft > this.tileWidth / 4) {
                                ++diffLeft;
                                continue;
                            }
                            --diffUp;
                            continue;
                        }
                        if (remainderUp * 2 - remainderLeft > this.tileWidth / 4) {
                            --diffLeft;
                            continue;
                        }
                        --diffUp;
                        continue;
                    }
                    if (orDiffLeft == 0) {
                        if (remainderLeft > 0) {
                            if (-remainderUp * 2 + remainderLeft > this.tileWidth / 4) {
                                ++diffLeft;
                                continue;
                            }
                            ++diffUp;
                            continue;
                        }
                        if (-remainderUp * 2 - remainderLeft > this.tileWidth / 4) {
                            --diffLeft;
                            continue;
                        }
                        ++diffUp;
                        continue;
                    }
                    if (orDiffUp > 0) {
                        if (remainderUp * 2 - remainderLeft > this.tileWidth / 4) {
                            --diffLeft;
                            continue;
                        }
                        --diffUp;
                        continue;
                    }
                    if (-remainderUp * 2 - remainderLeft > this.tileWidth / 4) {
                        --diffLeft;
                        continue;
                    }
                    ++diffUp;
                    continue;
                }
                if (orDiffUp % 2 == 0) {
                    if (orDiffLeft > 0 && orDiffUp > 0) {
                        if (remainderUp * 2 + remainderLeft > this.tileWidth / 4) {
                            ++diffUp;
                            continue;
                        }
                        --diffLeft;
                        continue;
                    }
                    if (orDiffUp > 0) {
                        if (remainderUp * 2 - remainderLeft > this.tileWidth / 4) {
                            ++diffUp;
                            continue;
                        }
                        ++diffLeft;
                        continue;
                    }
                    if (orDiffLeft > 0) {
                        if (-remainderUp * 2 + remainderLeft > this.tileWidth / 4) {
                            --diffUp;
                            continue;
                        }
                        --diffLeft;
                        continue;
                    }
                    if (-remainderUp * 2 - remainderLeft > this.tileWidth / 4) {
                        --diffUp;
                        continue;
                    }
                    ++diffLeft;
                    continue;
                }
                if (orDiffLeft > 0 && orDiffUp > 0) {
                    if (remainderUp * 2 > remainderLeft) {
                        --diffLeft;
                        continue;
                    }
                    --diffUp;
                    continue;
                }
                if (orDiffUp > 0) {
                    if (remainderUp * 2 > -remainderLeft) {
                        ++diffLeft;
                        continue;
                    }
                    --diffUp;
                    continue;
                }
                if (orDiffLeft > 0) {
                    if (-remainderUp * 2 > remainderLeft) {
                        --diffLeft;
                        continue;
                    }
                    ++diffUp;
                    continue;
                }
                if (-remainderUp * 2 > -remainderLeft) {
                    ++diffLeft;
                    continue;
                }
                ++diffUp;
                continue;
            }
            diffLeft = this.focus.getY() % 2 == 0 ? (diffLeft < 0 ? (diffLeft /= 2) : diffLeft / 2 + 1) : (diffLeft < 0 ? diffLeft / 2 - 1 : (diffLeft /= 2));
            done = true;
        }
        return new Map.Position(this.focus.getX() - diffLeft, this.focus.getY() - diffUp);
    }

    public boolean isMapNearTop(int y) {
        return y < this.topRows;
    }

    public boolean isMapNearBottom(int y) {
        return y >= this.freeColClient.getGame().getMap().getHeight() - this.bottomRows;
    }

    public boolean isMapNearLeft(int x, int y) {
        return x < this.getLeftColumns(y);
    }

    public boolean isMapNearRight(int x, int y) {
        return x >= this.freeColClient.getGame().getMap().getWidth() - this.getRightColumns(y);
    }

    public ImageLibrary getImageLibrary() {
        return this.lib;
    }

    public Point getTilePosition(Tile t) {
        if (t.getY() >= this.topRow && t.getY() <= this.bottomRow && t.getX() >= this.leftColumn && t.getX() <= this.rightColumn) {
            int x = (t.getX() - this.leftColumn) * this.tileWidth + this.leftColumnX;
            int y = (t.getY() - this.topRow) * this.tileHeight / 2 + this.topRowY;
            if (t.getY() % 2 != 0) {
                x += this.tileWidth / 2;
            }
            return new Point(x, y);
        }
        return null;
    }

    public Rectangle getTileBounds(Tile tile) {
        return this.getTileBounds(tile.getX(), tile.getY());
    }

    public Rectangle getTileBounds(int x, int y) {
        Rectangle result = new Rectangle(0, 0, this.size.width, this.size.height);
        if (y >= this.topRow && y <= this.bottomRow && x >= this.leftColumn && x <= this.rightColumn) {
            result.y = (y - this.topRow) * this.tileHeight / 2 + this.topRowY - this.tileHeight;
            result.x = (x - this.leftColumn) * this.tileWidth + this.leftColumnX;
            if (y % 2 != 0) {
                result.x += this.tileWidth / 2;
            }
            result.width = this.tileWidth;
            result.height = this.tileHeight * 2;
        }
        return result;
    }

    public void forceReposition() {
        this.bottomRow = -1;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    static class GrayLayer
    extends Component {
        private static final Color MASK_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.6f);
        private static final int DEFAULT_FONT_SIZE = 18;
        private static final int FONT_SIZE_DECREMENT = 2;
        private static final int MAX_TEXT_WIDTH = 640;
        private ImageLibrary imageLibrary;
        private Player player;

        public GrayLayer(ImageLibrary imageLibrary) {
            this.imageLibrary = imageLibrary;
        }

        public void paint(Graphics g) {
            Rectangle textBounds;
            Rectangle clipArea = g.getClipBounds();
            if (clipArea == null) {
                clipArea = this.getBounds();
                clipArea.y = 0;
                clipArea.x = 0;
            }
            if (clipArea.isEmpty()) {
                return;
            }
            g.setColor(MASK_COLOR);
            g.fillRect(clipArea.x, clipArea.y, clipArea.width, clipArea.height);
            if (this.player == null) {
                return;
            }
            ImageIcon coatOfArmsIcon = this.imageLibrary.getCoatOfArmsImageIcon(this.player.getNation());
            Rectangle iconBounds = new Rectangle();
            if (coatOfArmsIcon != null) {
                iconBounds.width = coatOfArmsIcon.getIconWidth();
                iconBounds.height = coatOfArmsIcon.getIconHeight();
            }
            Font nameFont = this.getFont();
            FontMetrics nameFontMetrics = this.getFontMetrics(nameFont);
            String message = Messages.message("waitingFor", "%nation%", this.player.getNationAsString());
            int fontSize = 18;
            int maxWidth = Math.min(640, this.getSize().width);
            do {
                nameFont = nameFont.deriveFont(1, fontSize);
                nameFontMetrics = this.getFontMetrics(nameFont);
                textBounds = nameFontMetrics.getStringBounds(message, g).getBounds();
                fontSize -= 2;
            } while (textBounds.width > maxWidth);
            Dimension size = this.getSize();
            textBounds.x = (size.width - textBounds.width) / 2;
            textBounds.y = (size.height - textBounds.height - iconBounds.height) / 2;
            iconBounds.x = (size.width - iconBounds.width) / 2;
            iconBounds.y = (size.height - iconBounds.height) / 2 + textBounds.height;
            if (textBounds.intersects(clipArea)) {
                g.setFont(nameFont);
                g.setColor(this.player.getColor());
                g.drawString(message, textBounds.x, textBounds.y + textBounds.height);
            }
            if (coatOfArmsIcon != null && iconBounds.intersects(clipArea)) {
                coatOfArmsIcon.paintIcon(this, g, iconBounds.x, iconBounds.y);
            }
        }

        public void setPlayer(Player player) {
            if (this.player == player) {
                return;
            }
            this.player = player;
            this.repaint();
        }
    }
}

