/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.panel.ImageProvider;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.resources.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImageLibrary
extends ImageProvider {
    private static final Logger logger = Logger.getLogger(ImageLibrary.class.getName());
    public static final int RIVER_STYLES = 81;
    public static final String UNIT_SELECT = "unitSelect.image";
    public static final String DELETE = "delete.image";
    public static final String PLOWED = "model.improvement.Plow.image";
    public static final String TILE_TAKEN = "tileTaken.image";
    public static final String TILE_OWNED_BY_INDIANS = "nativeLand.image";
    public static final String LOST_CITY_RUMOUR = "lostCityRumour.image";
    public static final String DARKNESS = "halo.dark.image";
    public static final int UNIT_BUTTON_WAIT = 0;
    public static final int UNIT_BUTTON_DONE = 1;
    public static final int UNIT_BUTTON_FORTIFY = 2;
    public static final int UNIT_BUTTON_SENTRY = 3;
    public static final int UNIT_BUTTON_CLEAR = 4;
    public static final int UNIT_BUTTON_PLOW = 5;
    public static final int UNIT_BUTTON_ROAD = 6;
    public static final int UNIT_BUTTON_BUILD = 7;
    public static final int UNIT_BUTTON_DISBAND = 8;
    public static final int UNIT_BUTTON_ZOOM_IN = 9;
    public static final int UNIT_BUTTON_ZOOM_OUT = 10;
    public static final int UNIT_BUTTON_COUNT = 11;
    private static final String path = new String("images/");
    private static final String extension = new String(".png");
    private static final String terrainDirectory = new String("terrain/");
    private static final String tileName = new String("center");
    private static final String borderName = new String("border");
    private static final String unexploredDirectory = new String("unexplored/");
    private static final String unexploredName = new String("unexplored");
    private static final String riverDirectory = new String("river/");
    private static final String riverName = new String("river");
    private static final String unitButtonDirectory = new String("order-buttons/");
    private static final String unitButtonName = new String("button");
    private final String dataDirectory;
    private List<ImageIcon> rivers;
    private Map<String, ImageIcon> terrain1;
    private Map<String, ImageIcon> terrain2;
    private Map<String, ImageIcon> overlay1;
    private Map<String, ImageIcon> overlay2;
    private Map<String, ImageIcon> forests;
    private Map<String, ArrayList<ImageIcon>> border1;
    private Map<String, ArrayList<ImageIcon>> border2;
    private Map<String, ArrayList<ImageIcon>> coast1;
    private Map<String, ArrayList<ImageIcon>> coast2;
    private List<ArrayList<ImageIcon>> unitButtons;
    private EnumMap<Tension.Level, Image> alarmChips;
    private EnumMap<Tension.Level, Image> alarmChipsUnvisited;
    private Map<Color, Image> colorChips;
    private Map<Color, Image> missionChips;
    private Map<Color, Image> expertMissionChips;
    private final float scalingFactor;

    public ImageLibrary() throws FreeColException {
        this("");
    }

    public ImageLibrary(String freeColHome) throws FreeColException {
        this.scalingFactor = 1.0f;
        if ("".equals(freeColHome)) {
            this.dataDirectory = "data/";
            this.init(true);
        } else {
            this.dataDirectory = freeColHome;
            this.init(false);
        }
    }

    private ImageLibrary(String dataDirectory, float scalingFactor) {
        this.dataDirectory = dataDirectory;
        this.scalingFactor = scalingFactor;
    }

    private void init(boolean doLookup) throws FreeColException {
        GraphicsConfiguration gc = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (!ge.isHeadless()) {
            gc = ge.getDefaultScreenDevice().getDefaultConfiguration();
        }
        Class<FreeCol> resourceLocator = FreeCol.class;
        this.loadTerrain(gc, resourceLocator, doLookup);
        this.loadForests(gc, resourceLocator, doLookup);
        this.loadRivers(gc, resourceLocator, doLookup);
        this.loadUnitButtons(gc, resourceLocator, doLookup);
        this.alarmChips = new EnumMap(Tension.Level.class);
        this.alarmChipsUnvisited = new EnumMap(Tension.Level.class);
        this.colorChips = new HashMap<Color, Image>();
        this.missionChips = new HashMap<Color, Image>();
        this.expertMissionChips = new HashMap<Color, Image>();
    }

    public float getScalingFactor() {
        return this.scalingFactor;
    }

    public ImageLibrary getScaledImageLibrary(float scalingFactor) throws FreeColException {
        ImageLibrary scaledLibrary = new ImageLibrary("", scalingFactor);
        scaledLibrary.rivers = this.scaleImages(this.rivers, scalingFactor);
        scaledLibrary.terrain1 = this.scaleImages(this.terrain1, scalingFactor);
        scaledLibrary.terrain2 = this.scaleImages(this.terrain2, scalingFactor);
        scaledLibrary.overlay1 = this.scaleImages(this.overlay1, scalingFactor);
        scaledLibrary.overlay2 = this.scaleImages(this.overlay2, scalingFactor);
        scaledLibrary.forests = this.scaleImages(this.forests, scalingFactor);
        scaledLibrary.border1 = this.scaleImages2(this.border1, scalingFactor);
        scaledLibrary.border2 = this.scaleImages2(this.border2, scalingFactor);
        scaledLibrary.coast1 = this.scaleImages2(this.coast1, scalingFactor);
        scaledLibrary.coast2 = this.scaleImages2(this.coast2, scalingFactor);
        scaledLibrary.unitButtons = new ArrayList<ArrayList<ImageIcon>>(this.unitButtons);
        scaledLibrary.alarmChips = new EnumMap<Tension.Level, Image>(this.alarmChips);
        scaledLibrary.alarmChipsUnvisited = new EnumMap<Tension.Level, Image>(this.alarmChipsUnvisited);
        scaledLibrary.colorChips = new HashMap<Color, Image>(this.colorChips);
        scaledLibrary.missionChips = new HashMap<Color, Image>(this.missionChips);
        scaledLibrary.expertMissionChips = new HashMap<Color, Image>(this.expertMissionChips);
        return scaledLibrary;
    }

    public Image scaleImage(Image image, float scale) {
        return image.getScaledInstance(Math.round((float)image.getWidth(null) * scale), Math.round((float)image.getHeight(null) * scale), 4);
    }

    public ImageIcon scaleIcon(ImageIcon icon, float scale) {
        return new ImageIcon(this.scaleImage(icon.getImage(), scale));
    }

    private Map<Color, Image> scaleChips(Map<Color, Image> input, float scale) {
        HashMap<Color, Image> output = new HashMap<Color, Image>();
        for (Map.Entry<Color, Image> entry : input.entrySet()) {
            output.put(entry.getKey(), this.scaleImage(entry.getValue(), scale));
        }
        return output;
    }

    private Map<String, ImageIcon> scaleImages(Map<String, ImageIcon> input, float scale) {
        HashMap<String, ImageIcon> output = new HashMap<String, ImageIcon>();
        for (Map.Entry<String, ImageIcon> entry : input.entrySet()) {
            output.put(entry.getKey(), this.scaleIcon(entry.getValue(), scale));
        }
        return output;
    }

    private ArrayList<ImageIcon> scaleImages(List<ImageIcon> input, float scale) {
        ArrayList<ImageIcon> output = new ArrayList<ImageIcon>();
        for (ImageIcon icon : input) {
            if (icon == null) {
                output.add(null);
                continue;
            }
            output.add(this.scaleIcon(icon, scale));
        }
        return output;
    }

    private Map<String, ArrayList<ImageIcon>> scaleImages2(Map<String, ArrayList<ImageIcon>> input, float scale) {
        HashMap<String, ArrayList<ImageIcon>> output = new HashMap<String, ArrayList<ImageIcon>>();
        for (Map.Entry<String, ArrayList<ImageIcon>> entry : input.entrySet()) {
            if (entry.getValue() == null) {
                output.put(entry.getKey(), null);
                continue;
            }
            output.put(entry.getKey(), this.scaleImages((List<ImageIcon>)entry.getValue(), scale));
        }
        return output;
    }

    private ArrayList<ArrayList<ImageIcon>> scaleImages2(ArrayList<ArrayList<ImageIcon>> input, float scale) {
        ArrayList<ArrayList<ImageIcon>> output = new ArrayList<ArrayList<ImageIcon>>();
        for (ArrayList<ImageIcon> list : input) {
            if (list == null) {
                output.add(null);
                continue;
            }
            output.add(this.scaleImages(list, scale));
        }
        return output;
    }

    private EnumMap<Unit.Role, Map<UnitType, ImageIcon>> scaleUnitImages(EnumMap<Unit.Role, Map<UnitType, ImageIcon>> input, float f) {
        EnumMap<Unit.Role, Map<UnitType, ImageIcon>> result = new EnumMap<Unit.Role, Map<UnitType, ImageIcon>>(Unit.Role.class);
        for (Unit.Role role : Unit.Role.values()) {
            Map<UnitType, ImageIcon> oldMap = input.get((Object)role);
            HashMap<UnitType, ImageIcon> newMap = new HashMap<UnitType, ImageIcon>();
            for (Map.Entry<UnitType, ImageIcon> entry : oldMap.entrySet()) {
                ImageIcon oldIcon = entry.getValue();
                ImageIcon newIcon = new ImageIcon(oldIcon.getImage().getScaledInstance(Math.round((float)oldIcon.getIconWidth() * f), Math.round((float)oldIcon.getIconHeight() * f), 4));
                newMap.put(entry.getKey(), newIcon);
            }
            result.put(role, newMap);
        }
        return result;
    }

    private ImageIcon findImage(String filePath, Class<FreeCol> resourceLocator, boolean doLookup) throws FreeColException {
        URL url;
        if (doLookup && (url = resourceLocator.getResource(filePath)) != null) {
            return new ImageIcon(url);
        }
        File tmpFile = new File(filePath);
        if (!(tmpFile.exists() && tmpFile.isFile() && tmpFile.canRead())) {
            throw new FreeColException("The data file \"" + filePath + "\" could not be found.");
        }
        return new ImageIcon(filePath);
    }

    private void loadTerrain(GraphicsConfiguration gc, Class<FreeCol> resourceLocator, boolean doLookup) throws FreeColException {
        this.terrain1 = new HashMap<String, ImageIcon>();
        this.terrain2 = new HashMap<String, ImageIcon>();
        this.overlay1 = new HashMap<String, ImageIcon>();
        this.overlay2 = new HashMap<String, ImageIcon>();
        this.border1 = new HashMap<String, ArrayList<ImageIcon>>();
        this.border2 = new HashMap<String, ArrayList<ImageIcon>>();
        this.coast1 = new HashMap<String, ArrayList<ImageIcon>>();
        this.coast2 = new HashMap<String, ArrayList<ImageIcon>>();
        for (TileType type : FreeCol.getSpecification().getTileTypeList()) {
            String filePath = this.dataDirectory + path + type.getArtBasic() + tileName;
            this.terrain1.put(type.getId(), this.findImage(filePath + "0" + extension, resourceLocator, doLookup));
            this.terrain2.put(type.getId(), this.findImage(filePath + "1" + extension, resourceLocator, doLookup));
            if (type.getArtOverlay() != null) {
                filePath = this.dataDirectory + path + type.getArtOverlay();
                this.overlay1.put(type.getId(), this.findImage(filePath + "0" + extension, resourceLocator, doLookup));
                this.overlay2.put(type.getId(), this.findImage(filePath + "1" + extension, resourceLocator, doLookup));
            }
            ArrayList<ImageIcon> tempArrayList1 = new ArrayList<ImageIcon>();
            ArrayList<ImageIcon> tempArrayList2 = new ArrayList<ImageIcon>();
            for (Map.Direction direction : Map.Direction.values()) {
                filePath = this.dataDirectory + path + type.getArtBasic() + borderName + "_" + direction.toString();
                tempArrayList1.add(this.findImage(filePath + "_even" + extension, resourceLocator, doLookup));
                tempArrayList2.add(this.findImage(filePath + "_odd" + extension, resourceLocator, doLookup));
            }
            this.border1.put(type.getId(), tempArrayList1);
            this.border2.put(type.getId(), tempArrayList2);
            if (type.getArtCoast() == null) continue;
            tempArrayList1 = new ArrayList();
            tempArrayList2 = new ArrayList();
            for (Map.Direction direction : Map.Direction.values()) {
                filePath = this.dataDirectory + path + type.getArtCoast() + borderName + "_" + direction.toString();
                tempArrayList1.add(this.findImage(filePath + "_even" + extension, resourceLocator, doLookup));
                tempArrayList2.add(this.findImage(filePath + "_odd" + extension, resourceLocator, doLookup));
            }
            this.coast1.put(type.getId(), tempArrayList1);
            this.coast2.put(type.getId(), tempArrayList2);
        }
        String unexploredPath = this.dataDirectory + path + terrainDirectory + unexploredDirectory + tileName;
        this.terrain1.put(unexploredName, this.findImage(unexploredPath + "0" + extension, resourceLocator, doLookup));
        this.terrain2.put(unexploredName, this.findImage(unexploredPath + "1" + extension, resourceLocator, doLookup));
        ArrayList<ImageIcon> unexploredArrayList1 = new ArrayList<ImageIcon>();
        ArrayList<ImageIcon> unexploredArrayList2 = new ArrayList<ImageIcon>();
        for (Map.Direction direction : Map.Direction.values()) {
            unexploredPath = this.dataDirectory + path + terrainDirectory + unexploredDirectory + borderName + "_" + direction.toString();
            unexploredArrayList1.add(this.findImage(unexploredPath + "_even" + extension, resourceLocator, doLookup));
            unexploredArrayList2.add(this.findImage(unexploredPath + "_odd" + extension, resourceLocator, doLookup));
        }
        this.border1.put(unexploredName, unexploredArrayList1);
        this.border2.put(unexploredName, unexploredArrayList2);
    }

    private void loadRivers(GraphicsConfiguration gc, Class<FreeCol> resourceLocator, boolean doLookup) throws FreeColException {
        this.rivers = new ArrayList<ImageIcon>(81);
        for (int i = 0; i < 81; ++i) {
            String filePath = this.dataDirectory + path + riverDirectory + riverName + i + extension;
            this.rivers.add(this.findImage(filePath, resourceLocator, doLookup));
        }
    }

    private void loadForests(GraphicsConfiguration gc, Class<FreeCol> resourceLocator, boolean doLookup) throws FreeColException {
        this.forests = new HashMap<String, ImageIcon>();
        for (TileType type : FreeCol.getSpecification().getTileTypeList()) {
            if (type.getArtForest() == null) continue;
            String filePath = this.dataDirectory + path + type.getArtForest();
            this.forests.put(type.getId(), this.findImage(filePath, resourceLocator, doLookup));
        }
    }

    private void loadUnitButtons(GraphicsConfiguration gc, Class<FreeCol> resourceLocator, boolean doLookup) throws FreeColException {
        int i;
        this.unitButtons = new ArrayList<ArrayList<ImageIcon>>(4);
        for (i = 0; i < 4; ++i) {
            this.unitButtons.add(new ArrayList(11));
        }
        for (i = 0; i < 4; ++i) {
            String subDirectory;
            switch (i) {
                case 0: {
                    subDirectory = new String("order-buttons00/");
                    break;
                }
                case 1: {
                    subDirectory = new String("order-buttons01/");
                    break;
                }
                case 2: {
                    subDirectory = new String("order-buttons02/");
                    break;
                }
                case 3: {
                    subDirectory = new String("order-buttons03/");
                    break;
                }
                default: {
                    subDirectory = new String("");
                }
            }
            for (int j = 0; j < 11; ++j) {
                String filePath = this.dataDirectory + path + unitButtonDirectory + subDirectory + unitButtonName + j + extension;
                this.unitButtons.get(i).add(this.findImage(filePath, resourceLocator, doLookup));
            }
        }
    }

    private void loadColorChip(GraphicsConfiguration gc, Color c) {
        BufferedImage tempImage = gc.createCompatibleImage(11, 17);
        Graphics g = tempImage.getGraphics();
        if (c.equals(Color.BLACK)) {
            g.setColor(Color.WHITE);
        } else {
            g.setColor(Color.BLACK);
        }
        g.drawRect(0, 0, 10, 16);
        g.setColor(c);
        g.fillRect(1, 1, 9, 15);
        this.colorChips.put(c, tempImage);
    }

    private void loadMissionChip(GraphicsConfiguration gc, Color c, boolean expertMission) {
        BufferedImage tempImage = gc.createCompatibleImage(10, 17);
        Graphics2D g = (Graphics2D)tempImage.getGraphics();
        if (expertMission) {
            g.setColor(Color.BLACK);
        } else {
            g.setColor(Color.DARK_GRAY);
        }
        g.fillRect(0, 0, 10, 17);
        GeneralPath cross = new GeneralPath(0);
        cross.moveTo(4.0f, 1.0f);
        cross.lineTo(6.0f, 1.0f);
        cross.lineTo(6.0f, 4.0f);
        cross.lineTo(9.0f, 4.0f);
        cross.lineTo(9.0f, 6.0f);
        cross.lineTo(6.0f, 6.0f);
        cross.lineTo(6.0f, 16.0f);
        cross.lineTo(4.0f, 16.0f);
        cross.lineTo(4.0f, 6.0f);
        cross.lineTo(1.0f, 6.0f);
        cross.lineTo(1.0f, 4.0f);
        cross.lineTo(4.0f, 4.0f);
        cross.closePath();
        if (expertMission && c.equals(Color.BLACK)) {
            g.setColor(Color.DARK_GRAY);
        } else if (!expertMission && c.equals(Color.DARK_GRAY)) {
            g.setColor(Color.BLACK);
        } else {
            g.setColor(c);
        }
        g.fill(cross);
        if (expertMission) {
            this.expertMissionChips.put(c, tempImage);
        } else {
            this.missionChips.put(c, tempImage);
        }
    }

    private void loadAlarmChip(GraphicsConfiguration gc, Tension.Level alarm, boolean visited) {
        BufferedImage tempImage = gc.createCompatibleImage(10, 17);
        Graphics2D g = (Graphics2D)tempImage.getGraphics();
        g.setColor(Color.BLACK);
        g.drawRect(0, 0, 10, 16);
        switch (alarm) {
            case HAPPY: {
                g.setColor(Color.GREEN);
                break;
            }
            case CONTENT: {
                g.setColor(Color.BLUE);
                break;
            }
            case DISPLEASED: {
                g.setColor(Color.YELLOW);
                break;
            }
            case ANGRY: {
                g.setColor(Color.ORANGE);
                break;
            }
            case HATEFUL: {
                g.setColor(Color.RED);
            }
        }
        g.fillRect(1, 1, 8, 15);
        g.setColor(Color.BLACK);
        if (visited) {
            g.fillRect(4, 3, 2, 7);
        } else {
            g.fillRect(3, 3, 4, 2);
            g.fillRect(6, 4, 2, 2);
            g.fillRect(4, 6, 3, 1);
            g.fillRect(4, 7, 2, 3);
        }
        g.fillRect(4, 12, 2, 2);
        (visited ? this.alarmChips : this.alarmChipsUnvisited).put(alarm, tempImage);
    }

    public Image getFoundingFatherImage(FoundingFather father) {
        return ResourceManager.getImage(father.getId() + ".image");
    }

    public Image getMonarchImage(Nation nation) {
        return ResourceManager.getImage(nation.getId() + ".monarch.image");
    }

    public ImageIcon getMonarchImageIcon(Nation nation) {
        return ResourceManager.getImageIcon(nation.getId() + ".monarch.image");
    }

    public ImageIcon getCoatOfArmsImageIcon(Nation nation) {
        return ResourceManager.getImageIcon(nation.getId() + ".coat-of-arms.image");
    }

    public Image getCoatOfArmsImage(Nation nation) {
        return ResourceManager.getImage(nation.getId() + ".coat-of-arms.image");
    }

    public Image getBonusImage(Tile tile) {
        if (tile.hasResource()) {
            return this.getBonusImage(tile.getTileItemContainer().getResource().getType());
        }
        return null;
    }

    public Image getBonusImage(ResourceType type) {
        return ResourceManager.getImage(type.getId() + ".image", this.scalingFactor);
    }

    public ImageIcon getBonusImageIcon(ResourceType type) {
        return new ImageIcon(this.getBonusImage(type));
    }

    public ImageIcon getScaledBonusImageIcon(ResourceType type, float scale) {
        return this.getScaledImageIcon(this.getBonusImageIcon(type), scale);
    }

    private ImageIcon convertToGrayscale(Image image) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        ColorConvertOp filter = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        BufferedImage srcImage = new BufferedImage(width, height, 2);
        srcImage.createGraphics().drawImage(image, 0, 0, null);
        return new ImageIcon(filter.filter(srcImage, null));
    }

    public Image getScaledTerrainImage(TileType type, float scale) {
        Graphics2D g;
        BufferedImage compositeImage;
        GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        Image terrainImage = this.getTerrainImage(type, 0, 0);
        int width = this.getTerrainImageWidth(type);
        int height = this.getTerrainImageHeight(type);
        if (type.getArtOverlay() != null) {
            compositeImage = gc.createCompatibleImage(width, height, 3);
            g = compositeImage.createGraphics();
            g.drawImage(terrainImage, 0, 0, null);
            g.drawImage(this.getOverlayImage(type, 0, 0), 0, -32, null);
            g.dispose();
            terrainImage = compositeImage;
        }
        if (type.isForested()) {
            compositeImage = gc.createCompatibleImage(width, height, 3);
            g = compositeImage.createGraphics();
            g.drawImage(terrainImage, 0, 0, null);
            g.drawImage(this.getForestImage(type), 0, 0, null);
            g.dispose();
            terrainImage = compositeImage;
        }
        if (scale == 1.0f) {
            return terrainImage;
        }
        return terrainImage.getScaledInstance((int)((float)width * scale), (int)((float)height * scale), 4);
    }

    public Image getOverlayImage(TileType type, int x, int y) {
        if ((x + y) % 2 == 0) {
            return this.overlay1.get(type.getId()).getImage();
        }
        return this.overlay2.get(type.getId()).getImage();
    }

    @Override
    public Image getTerrainImage(TileType type, int x, int y) {
        String key = type != null ? type.getId() : unexploredName;
        if (y % 8 <= 2 || (x + y) % 2 == 0) {
            return this.terrain1.get(key).getImage();
        }
        return this.terrain2.get(key).getImage();
    }

    public Image getBorderImage(TileType type, Map.Direction direction, int x, int y) {
        int borderType = direction.ordinal();
        String key = type != null ? type.getId() : unexploredName;
        if ((x + y) % 2 == 0) {
            return this.border1.get(key).get(borderType).getImage();
        }
        return this.border2.get(key).get(borderType).getImage();
    }

    public Image getCoastImage(TileType type, Map.Direction direction, int x, int y) {
        int borderType = direction.ordinal();
        String key = type != null ? type.getId() : unexploredName;
        if ((x + y) % 2 == 0) {
            return this.coast1.get(key).get(borderType).getImage();
        }
        return this.coast2.get(key).get(borderType).getImage();
    }

    public Image getRiverImage(int index) {
        return this.rivers.get(index).getImage();
    }

    public Image getForestImage(TileType type) {
        return this.forests.get(type.getId()).getImage();
    }

    @Override
    public Image getMiscImage(String id) {
        return ResourceManager.getImage(id, this.scalingFactor);
    }

    public ImageIcon getMiscImageIcon(String id) {
        return new ImageIcon(this.getMiscImage(id));
    }

    @Override
    public ImageIcon getUnitButtonImageIcon(int index, int state) {
        return this.unitButtons.get(state).get(index);
    }

    @Override
    public Image getGoodsImage(GoodsType goodsType) {
        return ResourceManager.getImage(goodsType.getId() + ".image");
    }

    @Override
    public ImageIcon getGoodsImageIcon(GoodsType goodsType) {
        return ResourceManager.getImageIcon(goodsType.getId() + ".image");
    }

    public ImageIcon getScaledGoodsImageIcon(GoodsType type, float scale) {
        return this.getScaledImageIcon(this.getGoodsImageIcon(type), scale);
    }

    @Override
    public Image getColorChip(Color color) {
        Image colorChip = this.colorChips.get(color);
        if (colorChip == null) {
            GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            this.loadColorChip(gc, color);
            colorChip = this.colorChips.get(color);
        }
        return colorChip;
    }

    public Image getMissionChip(Color color, boolean expertMission) {
        Image missionChip = expertMission ? this.expertMissionChips.get(color) : this.missionChips.get(color);
        if (missionChip == null) {
            GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            this.loadMissionChip(gc, color, expertMission);
            missionChip = expertMission ? this.expertMissionChips.get(color) : this.missionChips.get(color);
        }
        return missionChip;
    }

    public Image getAlarmChip(Tension.Level alarm, boolean visited) {
        Image alarmChip = (visited ? this.alarmChips : this.alarmChipsUnvisited).get((Object)alarm);
        if (alarmChip == null) {
            GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            this.loadAlarmChip(gc, alarm, visited);
            alarmChip = (visited ? this.alarmChips : this.alarmChipsUnvisited).get((Object)alarm);
        }
        return alarmChip;
    }

    @Override
    public int getTerrainImageWidth(TileType type) {
        String key = type != null ? type.getId() : unexploredName;
        return this.terrain1.get(key).getIconWidth();
    }

    @Override
    public int getTerrainImageHeight(TileType type) {
        String key = type != null ? type.getId() : unexploredName;
        return this.terrain1.get(key).getIconHeight();
    }

    public Image getSettlementImage(Settlement.SettlementType settlementType) {
        return ResourceManager.getImage(settlementType.toString() + ".image", this.scalingFactor);
    }

    public Image getSettlementImage(Settlement settlement) {
        if (settlement instanceof Colony) {
            Colony colony = (Colony)settlement;
            if (colony.isUndead()) {
                return this.getSettlementImage(Settlement.SettlementType.UNDEAD);
            }
            int stockadeLevel = 0;
            if (colony.getStockade() != null) {
                stockadeLevel = colony.getStockade().getLevel();
            }
            switch (stockadeLevel) {
                case 0: {
                    if (colony.getUnitCount() <= 3) {
                        return this.getSettlementImage(Settlement.SettlementType.SMALL);
                    }
                    if (colony.getUnitCount() <= 7) {
                        return this.getSettlementImage(Settlement.SettlementType.MEDIUM);
                    }
                    return this.getSettlementImage(Settlement.SettlementType.LARGE);
                }
                case 1: {
                    if (colony.getUnitCount() > 7) {
                        return this.getSettlementImage(Settlement.SettlementType.LARGE_STOCKADE);
                    }
                    if (colony.getUnitCount() > 3) {
                        return this.getSettlementImage(Settlement.SettlementType.MEDIUM_STOCKADE);
                    }
                    return this.getSettlementImage(Settlement.SettlementType.SMALL_STOCKADE);
                }
                case 2: {
                    if (colony.getUnitCount() > 7) {
                        return this.getSettlementImage(Settlement.SettlementType.LARGE_FORT);
                    }
                    return this.getSettlementImage(Settlement.SettlementType.MEDIUM_FORT);
                }
                case 3: {
                    return this.getSettlementImage(Settlement.SettlementType.LARGE_FORTRESS);
                }
            }
            return this.getSettlementImage(Settlement.SettlementType.SMALL);
        }
        return this.getSettlementImage(((IndianSettlement)settlement).getTypeOfSettlement());
    }

    public ImageIcon getUnitImageIcon(Unit unit) {
        return this.getUnitImageIcon(unit.getType(), unit.getRole());
    }

    public ImageIcon getUnitImageIcon(UnitType unitType) {
        Image im = ResourceManager.getImage(unitType.getId() + ".image", this.scalingFactor);
        return im != null ? new ImageIcon(im) : null;
    }

    public ImageIcon getUnitImageIcon(UnitType unitType, Unit.Role role) {
        String roleStr = role != Unit.Role.DEFAULT ? "." + role.getId() : "";
        Image im = ResourceManager.getImage(unitType.getId() + roleStr + ".image", this.scalingFactor);
        return im != null ? new ImageIcon(im) : null;
    }

    public ImageIcon getUnitImageIcon(Unit unit, boolean grayscale) {
        return this.getUnitImageIcon(unit.getType(), unit.getRole(), grayscale);
    }

    public ImageIcon getUnitImageIcon(UnitType unitType, boolean grayscale) {
        return this.getUnitImageIcon(unitType, Unit.Role.DEFAULT, grayscale);
    }

    public ImageIcon getUnitImageIcon(UnitType unitType, Unit.Role role, boolean grayscale) {
        if (grayscale) {
            String roleStr = role != Unit.Role.DEFAULT ? "." + role.getId() : "";
            Image im = ResourceManager.getGrayscaleImage(unitType.getId() + roleStr + ".image", this.scalingFactor);
            return im != null ? new ImageIcon(im) : null;
        }
        return this.getUnitImageIcon(unitType, role);
    }

    public ImageIcon getScaledImageIcon(ImageIcon inputIcon, float scale) {
        Image image = inputIcon.getImage();
        return new ImageIcon(image.getScaledInstance(Math.round((float)image.getWidth(null) * scale), Math.round((float)image.getHeight(null) * scale), 4));
    }

    public ImageIcon getScaledImageIcon(Image image, float scale) {
        return new ImageIcon(image.getScaledInstance(Math.round((float)image.getWidth(null) * scale), Math.round((float)image.getHeight(null) * scale), 4));
    }
}

