/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FreeColMenuBar;
import net.sf.freecol.client.gui.action.ImprovementActionType;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.menu.DebugMenu;

public class InGameMenuBar
extends FreeColMenuBar {
    private static final Logger logger = Logger.getLogger(InGameMenuBar.class.getName());
    public static final int UNIT_ORDER_WAIT = 0;
    public static final int UNIT_ORDER_FORTIFY = 1;
    public static final int UNIT_ORDER_SENTRY = 2;
    public static final int UNIT_ORDER_CLEAR_ORDERS = 3;
    public static final int UNIT_ORDER_BUILD_COL = 5;
    public static final int UNIT_ORDER_SKIP = 9;
    public static final int UNIT_ORDER_DISBAND = 11;
    private JMenuItem reportsTradeMenuItem = null;

    public InGameMenuBar(FreeColClient f) {
        super(f);
        this.reset();
    }

    public void reset() {
        this.removeAll();
        this.buildGameMenu();
        this.buildViewMenu();
        this.buildOrdersMenu();
        this.buildReportMenu();
        this.buildColopediaMenu();
        if (FreeCol.isInDebugMode()) {
            this.add(new DebugMenu(this.freeColClient));
        }
        this.update();
    }

    private void buildGameMenu() {
        JMenu menu = new JMenu(Messages.message("menuBar.game", new String[0]));
        menu.setOpaque(false);
        menu.setMnemonic(71);
        menu.add(this.getMenuItem("newAction"));
        menu.add(this.getMenuItem("openAction"));
        menu.add(this.getMenuItem("saveAction"));
        menu.addSeparator();
        menu.add(this.getMenuItem("preferencesAction"));
        menu.add(this.getMenuItem("reconnectAction"));
        menu.addSeparator();
        menu.add(this.getMenuItem("chatAction"));
        menu.add(this.getMenuItem("declareIndependenceAction"));
        menu.add(this.getMenuItem("endTurnAction"));
        menu.addSeparator();
        menu.add(this.getMenuItem("showMainAction"));
        menu.add(this.getMenuItem("reportHighScoresAction"));
        menu.add(this.getMenuItem("retireAction"));
        menu.add(this.getMenuItem("quitAction"));
        this.add(menu);
    }

    private void buildViewMenu() {
        JMenu menu = new JMenu(Messages.message("menuBar.view", new String[0]));
        menu.setOpaque(false);
        menu.setMnemonic(86);
        menu.add(this.getCheckBoxMenuItem("mapControlsAction"));
        menu.add(this.getCheckBoxMenuItem("displayGridAction"));
        menu.add(this.getMenuItem("toggleViewModeAction"));
        menu.add(this.getCheckBoxMenuItem("changeWindowedModeAction"));
        menu.addSeparator();
        ButtonGroup group = new ButtonGroup();
        menu.add(this.getRadioButtonMenuItem("displayTileEmptyAction", group));
        menu.add(this.getRadioButtonMenuItem("displayTileNamesAction", group));
        menu.add(this.getRadioButtonMenuItem("displayTileOwnersAction", group));
        menu.add(this.getRadioButtonMenuItem("displayTileRegionsAction", group));
        menu.addSeparator();
        menu.add(this.getMenuItem("zoomInAction"));
        menu.add(this.getMenuItem("zoomOutAction"));
        menu.addSeparator();
        menu.add(this.getMenuItem("europeAction"));
        menu.add(this.getMenuItem("tradeRouteAction"));
        menu.add(this.getMenuItem("findColonyAction"));
        this.add(menu);
    }

    private void buildOrdersMenu() {
        JMenu menu = new JMenu(Messages.message("menuBar.orders", new String[0]));
        menu.setOpaque(false);
        menu.setMnemonic(79);
        menu.add(this.getMenuItem("sentryAction"));
        menu.add(this.getMenuItem("fortifyAction"));
        menu.addSeparator();
        menu.add(this.getMenuItem("gotoAction"));
        menu.add(this.getMenuItem("gotoTileAction"));
        menu.add(this.getMenuItem("executeGotoOrdersAction"));
        menu.add(this.getMenuItem("assignTradeRouteAction"));
        menu.addSeparator();
        menu.add(this.getMenuItem("buildColonyAction"));
        for (ImprovementActionType iaType : FreeCol.getSpecification().getImprovementActionTypeList()) {
            menu.add(this.getMenuItem(iaType.getId()));
        }
        menu.addSeparator();
        menu.add(this.getMenuItem("loadAction"));
        menu.add(this.getMenuItem("unloadAction"));
        menu.addSeparator();
        menu.add(this.getMenuItem("waitAction"));
        menu.add(this.getMenuItem("skipUnitAction"));
        menu.add(this.getMenuItem("changeAction"));
        menu.addSeparator();
        menu.add(this.getMenuItem("clearOrdersAction"));
        menu.add(this.getMenuItem("renameAction"));
        menu.add(this.getMenuItem("disbandUnitAction"));
        this.add(menu);
    }

    private void buildReportMenu() {
        JMenu menu = new JMenu(Messages.message("menuBar.report", new String[0]));
        menu.setOpaque(false);
        menu.setMnemonic(82);
        menu.add(this.getMenuItem("reportReligionAction"));
        menu.add(this.getMenuItem("reportLabourAction"));
        menu.add(this.getMenuItem("reportColonyAction"));
        menu.add(this.getMenuItem("reportForeignAction"));
        menu.add(this.getMenuItem("reportIndianAction"));
        menu.add(this.getMenuItem("reportContinentalCongressAction"));
        menu.add(this.getMenuItem("reportMilitaryAction"));
        menu.add(this.getMenuItem("reportNavalAction"));
        menu.add(this.getMenuItem("reportCargoAction"));
        menu.add(this.getMenuItem("reportTradeAction"));
        menu.add(this.getMenuItem("reportTurnAction"));
        menu.add(this.getMenuItem("reportRequirementsAction"));
        menu.add(this.getMenuItem("reportExplorationAction"));
        menu.add(this.getMenuItem("reportHistoryAction"));
        this.add(menu);
    }

    public JMenuItem getReportsTradeMenuItem() {
        return this.reportsTradeMenuItem;
    }

    private void buildColopediaMenu() {
        JMenu menu = new JMenu(Messages.message("menuBar.colopedia", new String[0]));
        menu.setOpaque(false);
        menu.setMnemonic(67);
        menu.add(this.getMenuItem("colopediaTerrainAction"));
        menu.add(this.getMenuItem("colopediaResourceAction"));
        menu.add(this.getMenuItem("colopediaUnitAction"));
        menu.add(this.getMenuItem("colopediaGoodsAction"));
        menu.add(this.getMenuItem("colopediaSkillAction"));
        menu.add(this.getMenuItem("colopediaBuildingAction"));
        menu.add(this.getMenuItem("colopediaFatherAction"));
        menu.add(this.getMenuItem("colopediaNationAction"));
        menu.add(this.getMenuItem("colopediaNationTypeAction"));
        menu.addSeparator();
        menu.add(this.getMenuItem("aboutAction"));
        this.add(menu);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        String displayString = Messages.message("menuBar.statusLine", "%gold%", Integer.toString(this.freeColClient.getMyPlayer().getGold()), "%tax%", Integer.toString(this.freeColClient.getMyPlayer().getTax()), "%score%", Integer.toString(this.freeColClient.getMyPlayer().getScore()), "%year%", this.freeColClient.getGame().getTurn().toString());
        Rectangle2D displayStringBounds = g2.getFontMetrics().getStringBounds(displayString, g);
        int y = 15 + this.getInsets().top;
        g2.drawString(displayString, this.getWidth() - 10 - (int)displayStringBounds.getWidth(), y);
    }
}

