/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FreeColMenuBar;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.menu.DebugMenu;
import net.sf.freecol.server.generator.MapGeneratorOptions;

public class MapEditorMenuBar
extends FreeColMenuBar {
    private static final Logger logger = Logger.getLogger(MapEditorMenuBar.class.getName());

    public MapEditorMenuBar(FreeColClient freeColClient) {
        super(freeColClient);
        this.reset();
    }

    public void reset() {
        this.removeAll();
        this.buildGameMenu();
        this.buildViewMenu();
        this.buildToolsMenu();
        this.buildColopediaMenu();
        if (FreeCol.isInDebugMode()) {
            this.add(new DebugMenu(this.freeColClient));
        }
        this.update();
    }

    private void buildGameMenu() {
        JMenu menu = new JMenu(Messages.message("menuBar.game", new String[0]));
        menu.setOpaque(false);
        menu.setMnemonic(71);
        menu.add(this.getMenuItem("newAction"));
        menu.add(this.getMenuItem("newEmptyMapAction"));
        menu.addSeparator();
        menu.add(this.getMenuItem("openAction"));
        menu.add(this.getMenuItem("saveAction"));
        JMenuItem playItem = new JMenuItem(Messages.message("startGame", new String[0]));
        playItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                File saveGameFile = new File(FreeCol.getAutosaveDirectory(), "tempMap");
                MapGeneratorOptions options = MapEditorMenuBar.this.freeColClient.getPreGameController().getMapGeneratorOptions();
                if (options == null) {
                    options = new MapGeneratorOptions();
                }
                options.setFile("model.option.importFile", saveGameFile);
                MapEditorMenuBar.this.freeColClient.getMapEditorController().saveGame(saveGameFile);
                MapEditorMenuBar.this.freeColClient.getPreGameController().sendMapGeneratorOptions();
                MapEditorMenuBar.this.freeColClient.getCanvas().newGame();
            }
        });
        menu.add(playItem);
        menu.addSeparator();
        menu.add(this.getMenuItem("preferencesAction"));
        menu.addSeparator();
        menu.add(this.getMenuItem("showMainAction"));
        menu.add(this.getMenuItem("quitAction"));
        this.add(menu);
    }

    private void buildViewMenu() {
        JMenu menu = new JMenu(Messages.message("menuBar.view", new String[0]));
        menu.setOpaque(false);
        menu.setMnemonic(86);
        menu.add(this.getCheckBoxMenuItem("mapControlsAction"));
        menu.add(this.getCheckBoxMenuItem("displayGridAction"));
        menu.add(this.getCheckBoxMenuItem("changeWindowedModeAction"));
        menu.addSeparator();
        ButtonGroup tileTextGroup = new ButtonGroup();
        menu.add(this.getRadioButtonMenuItem("displayTileEmptyAction", tileTextGroup));
        menu.add(this.getRadioButtonMenuItem("displayTileNamesAction", tileTextGroup));
        menu.add(this.getRadioButtonMenuItem("displayTileOwnersAction", tileTextGroup));
        menu.add(this.getRadioButtonMenuItem("displayTileRegionsAction", tileTextGroup));
        menu.addSeparator();
        menu.add(this.getMenuItem("zoomInAction"));
        menu.add(this.getMenuItem("zoomOutAction"));
        this.add(menu);
    }

    private void buildToolsMenu() {
        JMenu menu = new JMenu(Messages.message("menuBar.tools", new String[0]));
        menu.setOpaque(false);
        menu.setMnemonic(84);
        menu.add(this.getMenuItem("scaleMapAction"));
        menu.add(this.getMenuItem("determineHighSeasAction"));
        this.add(menu);
    }

    private void buildColopediaMenu() {
        JMenu menu = new JMenu(Messages.message("menuBar.colopedia", new String[0]));
        menu.setOpaque(false);
        menu.setMnemonic(67);
        menu.add(this.getMenuItem("colopediaTerrainAction"));
        menu.add(this.getMenuItem("colopediaUnitAction"));
        menu.add(this.getMenuItem("colopediaGoodsAction"));
        menu.add(this.getMenuItem("colopediaSkillAction"));
        menu.add(this.getMenuItem("colopediaBuildingAction"));
        menu.add(this.getMenuItem("colopediaFatherAction"));
        menu.add(this.getMenuItem("colopediaNationAction"));
        menu.add(this.getMenuItem("colopediaNationTypeAction"));
        menu.addSeparator();
        menu.add(this.getMenuItem("aboutAction"));
        this.add(menu);
    }
}

