/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.UnloadAction;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.TransportMission;

public final class TilePopup
extends JPopupMenu {
    private static final Logger logger = Logger.getLogger(TilePopup.class.getName());
    public static final int UNITS_IN_FIRST_MENU = 9;
    public static final int UNITS_IN_OTHER_MENUS = 19;
    private final Canvas canvas;
    private final GUI gui;
    private boolean hasAnItem = false;

    public TilePopup(final Tile tile, final FreeColClient freeColClient, final Canvas canvas, GUI gui) {
        super(Messages.message("tile", "%x%", String.valueOf(tile.getX()), "%y%", String.valueOf(tile.getY())));
        Settlement settlement;
        this.canvas = canvas;
        this.gui = gui;
        final Unit activeUnit = gui.getActiveUnit();
        if (activeUnit != null) {
            JMenuItem gotoMenuItem = null;
            if (activeUnit.isOffensiveUnit() && activeUnit.getTile().isAdjacent(tile) && activeUnit.getMoveType(tile) == Unit.MoveType.ATTACK) {
                CombatModel.CombatOdds combatOdds = activeUnit.getGame().getCombatModel().calculateCombatOdds(activeUnit, tile.getDefendingUnit(activeUnit));
                String victoryPercent = tile.getSettlement() != null || combatOdds.win == -1.0f ? "??" : Integer.toString((int)(combatOdds.win * 100.0f));
                gotoMenuItem = new JMenuItem(Messages.message("attackTileOdds", "%chance%", victoryPercent));
            } else if (activeUnit.getMoveType(null, tile, Integer.MAX_VALUE) != Unit.MoveType.ILLEGAL_MOVE) {
                gotoMenuItem = new JMenuItem(Messages.message("gotoThisTile", new String[0]));
            }
            if (gotoMenuItem != null) {
                gotoMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        if (activeUnit.getTile() != tile) {
                            freeColClient.getInGameController().setDestination(activeUnit, tile);
                            if (freeColClient.getGame().getCurrentPlayer() == freeColClient.getMyPlayer()) {
                                freeColClient.getInGameController().moveToDestination(activeUnit);
                            }
                        }
                    }
                });
                this.add(gotoMenuItem);
                this.hasAnItem = true;
                this.addSeparator();
            }
        }
        int unitCount = 0;
        int maxUnits = 9;
        JComponent currentMenu = this;
        for (Unit currentUnit : tile.getUnitList()) {
            if (unitCount > maxUnits) {
                JMenu more = new JMenu(Messages.message("more", new String[0]));
                more.setFont(more.getFont().deriveFont(2));
                more.setOpaque(false);
                currentMenu.add(more);
                currentMenu = more;
                unitCount = 0;
                maxUnits = 19;
            }
            this.addUnit(currentMenu, currentUnit, !currentUnit.isUnderRepair(), false);
            ++unitCount;
            for (Unit unit : currentUnit.getUnitList()) {
                this.addUnit(currentMenu, unit, true, true);
                ++unitCount;
            }
            boolean hasGoods = false;
            for (Goods goods : currentUnit.getGoodsList()) {
                this.addGoods(goods, false, true);
                hasGoods = true;
            }
            if (!hasGoods) continue;
            JMenuItem dumpItem = new JMenuItem(Messages.message("dumpCargo", new String[0]));
            dumpItem.setAction(new UnloadAction(freeColClient));
            this.add(dumpItem);
        }
        if (tile.getUnitCount() > 0) {
            this.addSeparator();
        }
        if ((settlement = tile.getSettlement()) != null) {
            if (settlement.getOwner() == freeColClient.getMyPlayer()) {
                this.addColony((Colony)settlement);
            } else if (settlement instanceof IndianSettlement) {
                this.addIndianSettlement((IndianSettlement)settlement);
            }
            if (this.hasItem()) {
                this.addSeparator();
            }
        }
        this.addTile(tile);
        if (FreeCol.isInDebugMode() && freeColClient.getFreeColServer() != null) {
            this.addSeparator();
            JMenu takeOwnership = new JMenu("Take ownership");
            takeOwnership.setOpaque(false);
            boolean notEmpty = false;
            for (final Unit currentUnit : tile.getUnitList()) {
                AIUnit au;
                JMenuItem toMenuItem = new JMenuItem(currentUnit.toString());
                toMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        Player mp = (Player)freeColClient.getFreeColServer().getGame().getFreeColGameObject(freeColClient.getMyPlayer().getId());
                        currentUnit.setOwner(mp);
                        for (Unit unit : currentUnit.getUnitList()) {
                            unit.setOwner(mp);
                        }
                    }
                });
                takeOwnership.add(toMenuItem);
                notEmpty = true;
                if (!currentUnit.isCarrier() || (au = (AIUnit)freeColClient.getFreeColServer().getAIMain().getAIObject(currentUnit)).getMission() == null || !(au.getMission() instanceof TransportMission)) continue;
                JMenuItem menuItem = new JMenuItem("Transport list for: " + currentUnit.toString() + " (" + currentUnit.hashCode() + ")");
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        canvas.showInformationMessage(au.getMission().toString());
                    }
                });
            }
            if (tile.getSettlement() != null) {
                if (!notEmpty) {
                    takeOwnership.addSeparator();
                }
                JMenuItem toMenuItem = new JMenuItem(tile.getSettlement().toString());
                toMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        Player mp = (Player)freeColClient.getFreeColServer().getGame().getFreeColGameObject(freeColClient.getMyPlayer().getId());
                        tile.getSettlement().setOwner(mp);
                    }
                });
                takeOwnership.add(toMenuItem);
                notEmpty = true;
            }
            if (notEmpty) {
                this.add(takeOwnership);
                this.hasAnItem = true;
            }
        }
    }

    private void addUnit(Container menu, final Unit unit, boolean enabled, boolean indent) {
        String occ = unit.getDetailedOccupationIndicator();
        if (occ.length() > 0) {
            occ = " (" + occ + ")";
        }
        String text = (indent ? "    " : "") + Messages.message("model.unit.nationUnit", "%nation%", unit.getOwner().getNationAsString(), "%unit%", unit.getName()) + occ;
        JMenuItem menuItem = new JMenuItem(text);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                TilePopup.this.gui.setActiveUnit(unit);
            }
        });
        if (indent) {
            menuItem.setFont(menuItem.getFont().deriveFont(2));
        }
        if (!enabled) {
            menuItem.setEnabled(false);
        }
        menu.add(menuItem);
        this.hasAnItem = true;
    }

    private void addGoods(Goods goods, boolean enabled, boolean indent) {
        String text = (indent ? "    " : "") + goods.toString();
        JMenuItem menuItem = new JMenuItem(text);
        if (indent) {
            menuItem.setFont(menuItem.getFont().deriveFont(2));
        }
        if (!enabled) {
            menuItem.setEnabled(false);
        }
        this.add(menuItem);
        this.hasAnItem = true;
    }

    private void addColony(final Colony colony) {
        JMenuItem menuItem = new JMenuItem(colony.toString());
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                TilePopup.this.canvas.showColonyPanel(colony);
            }
        });
        this.add(menuItem);
        this.hasAnItem = true;
    }

    private void addIndianSettlement(final IndianSettlement settlement) {
        JMenuItem menuItem = new JMenuItem(settlement.getLocationName());
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                TilePopup.this.canvas.showIndianSettlementPanel(settlement);
            }
        });
        this.add(menuItem);
        this.hasAnItem = true;
    }

    private void addTile(final Tile tile) {
        JMenuItem menuItem = new JMenuItem(tile.getName());
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                TilePopup.this.canvas.showTilePanel(tile);
            }
        });
        this.add(menuItem);
    }

    public boolean hasItem() {
        return this.hasAnItem;
    }
}

