/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.util.logging.Logger;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.TerrainCursor;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;

public class ViewMode {
    public static final int MOVE_UNITS_MODE = 0;
    public static final int VIEW_TERRAIN_MODE = 1;
    private static final Logger logger = Logger.getLogger(GUI.class.getName());
    private int currentMode;
    private Unit savedActiveUnit;
    private GUI gui;

    public ViewMode(GUI gui) {
        this.gui = gui;
    }

    public void toggleViewMode() {
        logger.warning("Changing view");
        this.changeViewMode(1 - this.currentMode);
    }

    public void changeViewMode(int newViewMode) {
        if (newViewMode == this.currentMode) {
            logger.warning("Trying to change to the same view mode");
            return;
        }
        this.currentMode = newViewMode;
        switch (this.currentMode) {
            case 0: {
                if (this.gui.getActiveUnit() == null) {
                    this.gui.setActiveUnit(this.savedActiveUnit);
                }
                this.savedActiveUnit = null;
                logger.warning("Change view to Move Units Mode");
                break;
            }
            case 1: {
                this.savedActiveUnit = this.gui.getActiveUnit();
                this.gui.setActiveUnit(null);
                logger.warning("Change view to View Terrain Mode");
            }
        }
    }

    public int getView() {
        return this.currentMode;
    }

    public boolean displayTileCursor(Tile tile, int canvasX, int canvasY) {
        if (this.currentMode == 1) {
            Map.Position selectedTilePos = this.gui.getSelectedTile();
            if (selectedTilePos == null || tile == null) {
                return false;
            }
            if (selectedTilePos.getX() == tile.getX() && selectedTilePos.getY() == tile.getY()) {
                TerrainCursor cursor = this.gui.getCursor();
                cursor.setTile(tile);
                cursor.setCanvasPos(canvasX, canvasY);
                return true;
            }
        }
        return false;
    }

    public boolean displayUnitCursor(Unit unit, int canvasX, int canvasY) {
        if (this.currentMode == 0) {
            TerrainCursor cursor = this.gui.getCursor();
            if (unit == this.gui.getActiveUnit() && (cursor.isActive() || unit.getMovesLeft() == 0)) {
                cursor.setTile(unit.getTile());
                cursor.setCanvasPos(canvasX, canvasY);
                return true;
            }
        }
        return false;
    }
}

