/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.MapboardAction;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;

public class ChangeAction
extends MapboardAction {
    private static final Logger logger = Logger.getLogger(ChangeAction.class.getName());
    public static final String id = "changeAction";

    ChangeAction(FreeColClient freeColClient) {
        super(freeColClient, "menuBar.orders.nextUnitOnTile", null, KeyStroke.getKeyStroke(9, 0));
    }

    public void update() {
        Unit unit;
        super.update();
        GUI gui = this.getFreeColClient().getGUI();
        if (gui != null && this.getFreeColClient().getGUI().getActiveUnit() != null && (unit = this.getFreeColClient().getGUI().getActiveUnit()).getTile() != null) {
            if (unit.getColony() != null) {
                this.putValue("Name", Messages.message("menuBar.orders.enterColony", new String[0]));
            } else if (unit.isOnCarrier()) {
                this.putValue("Name", Messages.message("menuBar.orders.selectCarrier", new String[0]));
            } else {
                this.putValue("Name", Messages.message("menuBar.orders.nextUnitOnTile", new String[0]));
            }
        }
    }

    protected boolean shouldBeEnabled() {
        if (!super.shouldBeEnabled()) {
            return false;
        }
        GUI gui = this.getFreeColClient().getGUI();
        if (gui == null) {
            return false;
        }
        Unit unit = this.getFreeColClient().getGUI().getActiveUnit();
        if (unit == null) {
            return false;
        }
        return unit.getTile() != null;
    }

    public String getId() {
        return id;
    }

    public void actionPerformed(ActionEvent e) {
        Unit unit = this.getFreeColClient().getGUI().getActiveUnit();
        Tile tile = unit.getTile();
        if (tile.getColony() != null) {
            this.getFreeColClient().getCanvas().showColonyPanel(tile.getColony());
        } else if (unit.isOnCarrier()) {
            this.getFreeColClient().getGUI().setActiveUnit((Unit)unit.getLocation());
        } else {
            Unit u;
            Iterator<Unit> unitIterator = tile.getUnitIterator();
            boolean activeUnitFound = false;
            while (unitIterator.hasNext()) {
                u = unitIterator.next();
                if (u == unit) {
                    activeUnitFound = true;
                    continue;
                }
                if (!activeUnitFound || u.getState() != Unit.UnitState.ACTIVE || u.getMovesLeft() <= 0) continue;
                this.getFreeColClient().getGUI().setActiveUnit(u);
                return;
            }
            unitIterator = tile.getUnitIterator();
            while (unitIterator.hasNext()) {
                u = unitIterator.next();
                if (u == unit) {
                    return;
                }
                if (u.getState() != Unit.UnitState.ACTIVE || u.getMovesLeft() <= 0) continue;
                this.getFreeColClient().getGUI().setActiveUnit(u);
                return;
            }
        }
    }
}

