/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.action.FreeColAction;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.server.generator.TerrainGenerator;

public class DetermineHighSeasAction
extends FreeColAction {
    private static final Logger logger = Logger.getLogger(DetermineHighSeasAction.class.getName());
    public static final String id = "determineHighSeasAction";

    DetermineHighSeasAction(FreeColClient freeColClient) {
        super(freeColClient, "menuBar.tools.determineHighSeas", null, 0, null);
    }

    public String getId() {
        return id;
    }

    protected boolean shouldBeEnabled() {
        return super.shouldBeEnabled() && this.freeColClient.isMapEditor() && this.freeColClient.getGame() != null && this.freeColClient.getGame().getMap() != null;
    }

    public void actionPerformed(ActionEvent e) {
        Game game = this.freeColClient.getGame();
        Map map = game.getMap();
        Parameters p = this.showParametersDialog();
        if (p != null) {
            TerrainGenerator.determineHighSeas(map, p.distToLandFromHighSeas, p.maxDistanceToEdge);
        }
    }

    private Parameters showParametersDialog() {
        int COLUMNS = 5;
        int DEFAULT_distToLandFromHighSeas = 4;
        int DEFAULT_maxDistanceToEdge = 12;
        final Canvas canvas = this.getFreeColClient().getCanvas();
        String okText = Messages.message("ok", new String[0]);
        String cancelText = Messages.message("cancel", new String[0]);
        String dText = Messages.message("menuBar.tools.determineHighSeas.distToLandFromHighSeas", new String[0]);
        String mText = Messages.message("menuBar.tools.determineHighSeas.maxDistanceToEdge", new String[0]);
        final JTextField inputD = new JTextField(Integer.toString(4), 5);
        final JTextField inputM = new JTextField(Integer.toString(12), 5);
        final FreeColDialog inputDialog = new FreeColDialog(){

            public void requestFocus() {
                inputD.requestFocus();
            }
        };
        inputDialog.setLayout(new BoxLayout(inputDialog, 1));
        JPanel buttons = new JPanel();
        buttons.setOpaque(false);
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    int d = Integer.parseInt(inputD.getText());
                    int m = Integer.parseInt(inputM.getText());
                    if (d <= 0 || m <= 0) {
                        throw new NumberFormatException();
                    }
                    inputDialog.setResponse(new Parameters(d, m));
                }
                catch (NumberFormatException nfe) {
                    canvas.errorMessage("integerAboveZero");
                }
            }
        };
        JButton okButton = new JButton(okText);
        buttons.add(okButton);
        JButton cancelButton = new JButton(cancelText);
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                inputDialog.setResponse(null);
            }
        });
        buttons.add(cancelButton);
        inputDialog.setCancelComponent(cancelButton);
        okButton.addActionListener(al);
        inputD.addActionListener(al);
        inputM.addActionListener(al);
        JLabel widthLabel = new JLabel(dText);
        widthLabel.setLabelFor(inputD);
        JLabel heightLabel = new JLabel(mText);
        heightLabel.setLabelFor(inputM);
        JPanel widthPanel = new JPanel(new FlowLayout());
        widthPanel.setOpaque(false);
        widthPanel.add(widthLabel);
        widthPanel.add(inputD);
        JPanel heightPanel = new JPanel(new FlowLayout());
        heightPanel.setOpaque(false);
        heightPanel.add(heightLabel);
        heightPanel.add(inputM);
        inputDialog.add(widthPanel);
        inputDialog.add(heightPanel);
        inputDialog.add(buttons);
        inputDialog.setSize(inputDialog.getPreferredSize());
        return (Parameters)canvas.showFreeColDialog(inputDialog);
    }

    private class Parameters {
        int distToLandFromHighSeas;
        int maxDistanceToEdge;

        Parameters(int distToLandFromHighSeas, int maxDistanceToEdge) {
            this.distToLandFromHighSeas = distToLandFromHighSeas;
            this.maxDistanceToEdge = maxDistanceToEdge;
        }
    }
}

