/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.MapboardAction;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;

public class GotoTileAction
extends MapboardAction {
    public static final String id = "gotoTileAction";

    public String getId() {
        return id;
    }

    public void actionPerformed(ActionEvent e) {
        GUI gui = this.getFreeColClient().getCanvas().getGUI();
        if (gui.getActiveUnit() == null) {
            return;
        }
        if (!gui.isGotoStarted()) {
            gui.startGoto();
            Point pt = this.getFreeColClient().getCanvas().getMousePosition();
            if (pt != null) {
                Tile tile;
                Map map = this.getFreeColClient().getGame().getMap();
                Map.Position p = gui.convertToMapCoordinates(pt.x, pt.y);
                if (p != null && map.isValid(p) && (tile = map.getTile(p)) != null && gui.getActiveUnit().getTile() != tile) {
                    PathNode dragPath = gui.getActiveUnit().findPath(tile);
                    gui.setGotoPath(dragPath);
                }
            }
        } else {
            gui.stopGoto();
        }
    }

    GotoTileAction(FreeColClient freeColClient) {
        super(freeColClient, "unit.state.11", null, KeyStroke.getKeyStroke(71, 0));
    }

    protected boolean shouldBeEnabled() {
        if (!super.shouldBeEnabled()) {
            return false;
        }
        Unit activeUnit = this.getFreeColClient().getGUI().getActiveUnit();
        return activeUnit != null && activeUnit.getTile() != null;
    }
}

