/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.ImprovementActionType;
import net.sf.freecol.client.gui.action.MapboardAction;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.Unit;

public class ImprovementAction
extends MapboardAction {
    private static final Logger logger = Logger.getLogger(ImprovementAction.class.getName());
    public ImprovementActionType iaType;
    int actionID;

    public ImprovementAction(FreeColClient freeColClient, ImprovementActionType iaType) {
        super(freeColClient, iaType.getNames().get(0), null, KeyStroke.getKeyStroke((int)iaType.getAccelerator(), 0));
        this.iaType = iaType;
        this.actionID = -1;
        this.updateValues(0);
    }

    private void updateValues(int newActionID) {
        if (this.actionID == newActionID) {
            return;
        }
        this.actionID = newActionID;
        this.putValue("BUTTON_IMAGE", this.getFreeColClient().getImageLibrary().getUnitButtonImageIcon(this.iaType.getImageIDs().get(this.actionID), 0));
        this.putValue("BUTTON_ROLLOVER_IMAGE", this.getFreeColClient().getImageLibrary().getUnitButtonImageIcon(this.iaType.getImageIDs().get(this.actionID), 1));
        this.putValue("BUTTON_PRESSED_IMAGE", this.getFreeColClient().getImageLibrary().getUnitButtonImageIcon(this.iaType.getImageIDs().get(this.actionID), 2));
        this.putValue("BUTTON_DISABLED_IMAGE", this.getFreeColClient().getImageLibrary().getUnitButtonImageIcon(this.iaType.getImageIDs().get(this.actionID), 3));
        this.putValue("Name", Messages.message(this.iaType.getNames().get(this.actionID), new String[0]));
    }

    public void update() {
        super.update();
        GUI gui = this.getFreeColClient().getGUI();
        if (gui != null) {
            Unit selectedOne = this.getFreeColClient().getGUI().getActiveUnit();
            if (this.enabled && selectedOne != null && selectedOne.getTile() != null) {
                Tile tile = selectedOne.getTile();
                int newActionID = 0;
                for (TileImprovementType impType : this.iaType.getImpTypes()) {
                    if (!impType.isTileAllowed(tile) || !impType.isWorkerAllowed(selectedOne)) continue;
                    newActionID = this.iaType.getImpTypes().indexOf(impType);
                    break;
                }
                this.updateValues(newActionID);
            } else {
                this.updateValues(0);
            }
        }
    }

    protected boolean shouldBeEnabled() {
        if (!super.shouldBeEnabled()) {
            return false;
        }
        GUI gui = this.getFreeColClient().getGUI();
        if (gui == null) {
            return false;
        }
        Unit selectedOne = this.getFreeColClient().getGUI().getActiveUnit();
        if (selectedOne == null || !selectedOne.checkSetState(Unit.UnitState.IMPROVING)) {
            return false;
        }
        Tile tile = selectedOne.getTile();
        if (tile == null) {
            return false;
        }
        for (TileImprovementType impType : this.iaType.getImpTypes()) {
            if (!impType.isTileAllowed(tile) || !impType.isWorkerAllowed(selectedOne)) continue;
            return true;
        }
        return false;
    }

    public String getId() {
        return this.iaType.getId();
    }

    public void actionPerformed(ActionEvent e) {
        this.getFreeColClient().getInGameController().changeWorkImprovementType(this.getFreeColClient().getGUI().getActiveUnit(), this.iaType.getImpTypes().get(this.actionID));
        this.getFreeColClient().getInGameController().nextActiveUnit();
    }
}

