/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.MapboardAction;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Unit;

public class LoadAction
extends MapboardAction {
    private static final Logger logger = Logger.getLogger(LoadAction.class.getName());
    public static final String id = "loadAction";

    public LoadAction(FreeColClient freeColClient) {
        super(freeColClient, "menuBar.orders.load", null, KeyStroke.getKeyStroke(76, 0));
    }

    public String getId() {
        return id;
    }

    protected boolean shouldBeEnabled() {
        GUI gui;
        if (super.shouldBeEnabled() && (gui = this.getFreeColClient().getGUI()) != null) {
            Unit unit = this.getFreeColClient().getGUI().getActiveUnit();
            return unit != null && unit.isCarrier() && unit.getGoodsCount() > 0 && unit.getColony() != null;
        }
        return false;
    }

    public void actionPerformed(ActionEvent e) {
        Colony colony;
        Unit unit = this.getFreeColClient().getGUI().getActiveUnit();
        if (unit != null && (colony = unit.getColony()) != null) {
            Iterator<Goods> goodsIterator = unit.getGoodsIterator();
            while (goodsIterator.hasNext()) {
                Goods goods = goodsIterator.next();
                if (goods.getAmount() >= 100 || colony.getGoodsCount(goods.getType()) <= 0) continue;
                int amount = Math.min(100 - goods.getAmount(), colony.getGoodsCount(goods.getType()));
                Goods newGoods = new Goods(goods.getGame(), colony, goods.getType(), amount);
                this.getFreeColClient().getInGameController().loadCargo(newGoods, unit);
            }
        }
    }
}

