/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.KeyStroke;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.action.SelectableAction;
import net.sf.freecol.client.gui.panel.MapControls;

public class MapControlsAction
extends SelectableAction {
    private static final Logger logger = Logger.getLogger(MapControlsAction.class.getName());
    public static final String id = "mapControlsAction";
    private MapControls mapControls;

    MapControlsAction(FreeColClient freeColClient) {
        super(freeColClient, "menuBar.view.mapControls", null, KeyStroke.getKeyStroke(77, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.setSelected(freeColClient.getClientOptions().getBoolean("model.option.displayMapControls"));
    }

    public void update() {
        super.update();
        this.showMapControls(this.enabled && this.isSelected());
    }

    public String getId() {
        return id;
    }

    public MapControls getMapControls() {
        return this.mapControls;
    }

    public void actionPerformed(ActionEvent e) {
        this.selected = ((AbstractButton)e.getSource()).isSelected();
        this.showMapControls(this.enabled && this.selected);
    }

    private void showMapControls(boolean value) {
        if (value && this.getFreeColClient().getGUI().isInGame()) {
            if (this.mapControls == null) {
                this.mapControls = new MapControls(this.getFreeColClient());
            }
            this.mapControls.update();
        }
        if (this.mapControls != null) {
            if (value) {
                if (!this.mapControls.isShowing()) {
                    this.mapControls.addToComponent(this.getFreeColClient().getCanvas());
                }
                this.mapControls.update();
            } else if (this.mapControls.isShowing()) {
                this.mapControls.removeFromComponent(this.getFreeColClient().getCanvas());
            }
        }
    }
}

