/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.action.MapboardAction;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.server.generator.MapGenerator;

public class NewEmptyMapAction
extends MapboardAction {
    private static final Logger logger = Logger.getLogger(NewEmptyMapAction.class.getName());
    public static final String id = "newEmptyMapAction";

    NewEmptyMapAction(FreeColClient freeColClient) {
        super(freeColClient, "menuBar.game.newEmptyMap", null, null);
    }

    protected boolean shouldBeEnabled() {
        return this.freeColClient.isMapEditor();
    }

    public String getId() {
        return id;
    }

    public void actionPerformed(ActionEvent e) {
        Canvas c = this.getFreeColClient().getCanvas();
        Game game = this.freeColClient.getGame();
        MapSize size = this.showMapSizeDialog();
        if (size == null) {
            return;
        }
        MapGenerator mapGenerator = (MapGenerator)this.freeColClient.getFreeColServer().getMapGenerator();
        mapGenerator.getTerrainGenerator().createMap(game, new boolean[size.width][size.height]);
        this.freeColClient.getGUI().setFocus(1, 1);
        this.freeColClient.getActionManager().update();
        c.refresh();
    }

    private MapSize showMapSizeDialog() {
        int DEFAULT_WIDTH = 28;
        int DEFAULT_HEIGHT = 128;
        int COLUMNS = 5;
        final Canvas canvas = this.getFreeColClient().getCanvas();
        String okText = Messages.message("ok", new String[0]);
        String cancelText = Messages.message("cancel", new String[0]);
        String widthText = Messages.message("width", new String[0]);
        String heightText = Messages.message("height", new String[0]);
        final JTextField inputWidth = new JTextField(Integer.toString(28), 5);
        final JTextField inputHeight = new JTextField(Integer.toString(128), 5);
        final FreeColDialog inputDialog = new FreeColDialog(){

            public void requestFocus() {
                inputWidth.requestFocus();
            }
        };
        inputDialog.setLayout(new BoxLayout(inputDialog, 1));
        JPanel buttons = new JPanel();
        buttons.setOpaque(false);
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    int width = Integer.parseInt(inputWidth.getText());
                    int height = Integer.parseInt(inputHeight.getText());
                    if (width <= 0 || height <= 0) {
                        throw new NumberFormatException();
                    }
                    inputDialog.setResponse(new MapSize(width, height));
                }
                catch (NumberFormatException nfe) {
                    canvas.errorMessage("integerAboveZero");
                }
            }
        };
        JButton okButton = new JButton(okText);
        buttons.add(okButton);
        JButton cancelButton = new JButton(cancelText);
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                inputDialog.setResponse(null);
            }
        });
        buttons.add(cancelButton);
        inputDialog.setCancelComponent(cancelButton);
        okButton.addActionListener(al);
        inputWidth.addActionListener(al);
        inputHeight.addActionListener(al);
        JLabel widthLabel = new JLabel(widthText);
        widthLabel.setLabelFor(inputWidth);
        JLabel heightLabel = new JLabel(heightText);
        heightLabel.setLabelFor(inputHeight);
        JPanel widthPanel = new JPanel(new FlowLayout());
        widthPanel.setOpaque(false);
        widthPanel.add(widthLabel);
        widthPanel.add(inputWidth);
        JPanel heightPanel = new JPanel(new FlowLayout());
        heightPanel.setOpaque(false);
        heightPanel.add(heightLabel);
        heightPanel.add(inputHeight);
        inputDialog.add(widthPanel);
        inputDialog.add(heightPanel);
        inputDialog.add(buttons);
        inputDialog.setSize(inputDialog.getPreferredSize());
        return (MapSize)canvas.showFreeColDialog(inputDialog);
    }

    private class MapSize {
        int width;
        int height;

        MapSize(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }
}

