/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.action.MapControlsAction;
import net.sf.freecol.client.gui.action.MapboardAction;
import net.sf.freecol.client.gui.panel.MapControls;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Unit;

public class UnloadAction
extends MapboardAction {
    private static final Logger logger = Logger.getLogger(UnloadAction.class.getName());
    public static final String id = "unloadAction";

    public UnloadAction(FreeColClient freeColClient) {
        super(freeColClient, "menuBar.orders.unload", null, KeyStroke.getKeyStroke(85, 0));
    }

    public String getId() {
        return id;
    }

    protected boolean shouldBeEnabled() {
        GUI gui;
        if (super.shouldBeEnabled() && (gui = this.getFreeColClient().getGUI()) != null) {
            Unit unit = this.getFreeColClient().getGUI().getActiveUnit();
            return unit != null && unit.isCarrier() && unit.getGoodsCount() > 0;
        }
        return false;
    }

    public void actionPerformed(ActionEvent e) {
        Unit unit = this.getFreeColClient().getGUI().getActiveUnit();
        if (unit != null) {
            if (!unit.isInEurope() && unit.getColony() == null) {
                if (this.getFreeColClient().getCanvas().showConfirmDialog("dumpAllCargo", "yes", "no", new String[0])) {
                    this.unloadAllCargo(unit);
                    MapControls controls = ((MapControlsAction)this.getFreeColClient().getActionManager().getFreeColAction("mapControlsAction")).getMapControls();
                    if (controls != null) {
                        controls.update();
                    }
                }
            } else {
                this.unloadAllCargo(unit);
                this.unloadAllUnits(unit);
                MapControls controls = ((MapControlsAction)this.getFreeColClient().getActionManager().getFreeColAction("mapControlsAction")).getMapControls();
                if (controls != null) {
                    controls.update();
                }
            }
        }
    }

    private void unloadAllUnits(Unit unit) {
        Iterator<Unit> unitIterator = unit.getUnitIterator();
        while (unitIterator.hasNext()) {
            Unit newUnit = unitIterator.next();
            this.getFreeColClient().getInGameController().leaveShip(newUnit);
        }
    }

    private void unloadAllCargo(Unit unit) {
        Iterator<Goods> goodsIterator = unit.getGoodsIterator();
        while (goodsIterator.hasNext()) {
            Goods goods = goodsIterator.next();
            this.getFreeColClient().getInGameController().unloadCargo(goods);
        }
    }
}

