/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.action.FreeColAction;

public class ZoomInAction
extends FreeColAction {
    private static final Logger logger = Logger.getLogger(ZoomInAction.class.getName());
    public static final String id = "zoomInAction";

    ZoomInAction(FreeColClient freeColClient) {
        super(freeColClient, "menuBar.view.zoomIn", null, KeyStroke.getKeyStroke(521, 0));
    }

    protected boolean shouldBeEnabled() {
        if (!super.shouldBeEnabled()) {
            return false;
        }
        Canvas canvas = this.getFreeColClient().getCanvas();
        if (canvas == null || !canvas.isMapboardActionsEnabled()) {
            return false;
        }
        float oldScaling = this.getFreeColClient().getGUI().getImageLibrary().getScalingFactor();
        return (double)oldScaling < 1.0;
    }

    public String getId() {
        return id;
    }

    public void actionPerformed(ActionEvent e) {
        ImageLibrary im;
        float oldScaling = this.getFreeColClient().getGUI().getImageLibrary().getScalingFactor();
        float newScaling = oldScaling + 0.25f;
        if (newScaling >= 1.0f) {
            newScaling = 1.0f;
            im = this.getFreeColClient().getImageLibrary();
        } else {
            try {
                im = this.getFreeColClient().getImageLibrary().getScaledImageLibrary(newScaling);
            }
            catch (Exception ex) {
                logger.warning("Failed to retrieve scaled image library.");
                im = this.getFreeColClient().getImageLibrary();
            }
        }
        this.getFreeColClient().getGUI().setImageLibrary(im);
        this.getFreeColClient().getGUI().forceReposition();
        this.getFreeColClient().getCanvas().refresh();
        this.update();
        this.freeColClient.getActionManager().getFreeColAction("zoomOutAction").update();
    }
}

