/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.animation;

import java.awt.Rectangle;
import java.util.logging.Logger;
import net.sf.freecol.client.gui.Canvas;

public abstract class Animation {
    private static final Logger logger = Logger.getLogger(Animation.class.getName());
    protected final Canvas canvas;
    private static final int ANIMATION_DELAY = 33;

    public Animation(Canvas canvas) {
        this.canvas = canvas;
    }

    public void animate() {
        logger.finer("Starting animation");
        while (!this.isFinished()) {
            long time = System.currentTimeMillis();
            this.drawNextFrame();
            time = System.currentTimeMillis() - time;
            if (time < 33L) {
                try {
                    Thread.sleep(33L - time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            logger.finest("Frame took " + time + "ms to render.");
        }
        logger.finer("Finishing animation");
    }

    protected void drawNextFrame() {
        this.readyNextFrame();
        logger.finest("Drawing next animation frame");
        this.canvas.paintImmediately(this.getDirtyAnimationArea());
    }

    protected abstract void readyNextFrame();

    protected abstract Rectangle getAnimationArea();

    protected abstract Rectangle getDirtyAnimationArea();

    protected abstract boolean isFinished();
}

