/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.animation;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.animation.Animation;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;

public final class UnitMoveAnimation
extends Animation {
    private static final Logger logger = Logger.getLogger(UnitMoveAnimation.class.getName());
    private final Unit unit;
    private final Location currentLocation;
    private final Tile destinationTile;
    private final Point destinationPoint;
    private Point currentPoint;
    private JLabel unitLabel;
    private static final Integer UNIT_LABEL_LAYER = JLayeredPane.DEFAULT_LAYER;
    private final int signalX;
    private final int signalY;
    private final int movementRatio;
    private static final int X_RATIO = 2;
    private static final int Y_RATIO = 1;
    private int distanceToTarget;

    public UnitMoveAnimation(Canvas canvas, Unit unit, Map.Direction direction) {
        this(canvas, unit, unit.getGame().getMap().getNeighbourOrNull(direction, unit.getTile()));
    }

    public UnitMoveAnimation(Canvas canvas, Unit unit, Tile destinationTile) {
        super(canvas);
        this.unit = unit;
        this.destinationTile = destinationTile;
        this.currentLocation = unit.getLocation();
        String key = canvas.getClient().getMyPlayer() == unit.getOwner() ? "model.option.moveAnimationSpeed" : "model.option.enemyMoveAnimationSpeed";
        int movementSpeed = canvas.getClient().getClientOptions().getInteger(key);
        GUI gui = canvas.getGUI();
        Point currP = gui.getTilePosition(unit.getTile());
        Point destP = gui.getTilePosition(destinationTile);
        if (currP != null && destP != null && movementSpeed > 0) {
            this.movementRatio = (int)(Math.pow(2.0, movementSpeed) * (double)canvas.getGUI().getImageLibrary().getScalingFactor());
            this.unitLabel = gui.getUnitLabel(unit);
            this.currentPoint = gui.getUnitLabelPositionInTile(this.unitLabel, currP);
            this.destinationPoint = gui.getUnitLabelPositionInTile(this.unitLabel, destP);
            this.unitLabel.setLocation(this.currentPoint);
            canvas.add((Component)this.unitLabel, UNIT_LABEL_LAYER, false);
            if (this.currentPoint.getX() == this.destinationPoint.getX()) {
                this.signalX = 0;
            } else {
                int n = this.signalX = this.currentPoint.getX() > this.destinationPoint.getX() ? -1 : 1;
            }
            this.signalY = this.currentPoint.getY() == this.destinationPoint.getY() ? 0 : (this.currentPoint.getY() > this.destinationPoint.getY() ? -1 : 1);
            this.distanceToTarget = this.distance(this.destinationPoint, this.currentPoint);
        } else {
            logger.finest("Unit is offscreen or animation is off - no need to animate.");
            this.destinationPoint = null;
            this.currentPoint = null;
            this.signalY = 0;
            this.signalX = 0;
            this.distanceToTarget = 0;
            this.movementRatio = 0;
        }
    }

    protected void readyNextFrame() {
        logger.finest("Calculating and setting the new unit location.");
        this.currentPoint.x += this.signalX * 2 * this.movementRatio;
        this.currentPoint.y += this.signalY * 1 * this.movementRatio;
        this.unitLabel.setLocation(this.currentPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void animate() {
        logger.finest("Removing the unit temporarily from its Location and painting screen.");
        this.unit.setLocationNoUpdate(null);
        if (this.currentLocation instanceof Tile) {
            ((Tile)this.currentLocation).removeUnitNoUpdate(this.unit);
        }
        this.canvas.paintImmediately(this.canvas.getBounds());
        try {
            super.animate();
        }
        finally {
            logger.finest("Adding the unit back to its Tile and removing the label component.");
            this.unit.setLocationNoUpdate(this.currentLocation);
            if (this.currentLocation instanceof Tile) {
                ((Tile)this.currentLocation).addUnitNoUpdate(this.unit);
            }
            this.canvas.remove(this.unitLabel, false);
        }
    }

    protected int distance(Point p1, Point p2) {
        return Math.abs(p1.x - p2.x) + Math.abs(p1.y - p2.y);
    }

    protected boolean isFinished() {
        if (this.currentPoint != null && this.destinationPoint != null) {
            int newDistanceToTarget = this.distance(this.currentPoint, this.destinationPoint);
            if (newDistanceToTarget > this.distanceToTarget) {
                this.distanceToTarget = 0;
                return true;
            }
            if (newDistanceToTarget == 0) {
                this.distanceToTarget = newDistanceToTarget;
                return true;
            }
            this.distanceToTarget = newDistanceToTarget;
            return false;
        }
        this.distanceToTarget = 0;
        return true;
    }

    protected Rectangle getAnimationArea() {
        Rectangle r1 = this.canvas.getGUI().getTileBounds(this.currentLocation.getTile());
        Rectangle r2 = this.canvas.getGUI().getTileBounds(this.destinationTile);
        return r1.union(r2);
    }

    protected Rectangle getDirtyAnimationArea() {
        return this.getAnimationArea();
    }
}

