/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.i18n;

import java.io.File;
import java.io.FileInputStream;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Logger;
import net.sf.freecol.FreeCol;

public class Messages {
    private static final Logger logger = Logger.getLogger(Messages.class.getName());
    public static final String STRINGS_DIRECTORY = "strings";
    public static final String FILE_PREFIX = "FreeColMessages";
    public static final String FILE_SUFFIX = ".properties";
    private static Properties messageBundle = null;

    public static void setMessageBundle(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("Parameter locale must not be null");
        }
        if (!Locale.getDefault().equals(locale)) {
            Locale.setDefault(locale);
        }
        Messages.setMessageBundle(locale.getLanguage(), locale.getCountry(), locale.getVariant());
    }

    private static void setMessageBundle(String language, String country, String variant) {
        String[] fileNames;
        messageBundle = new Properties();
        if (!language.equals("")) {
            language = "_" + language;
        }
        if (!country.equals("")) {
            country = "_" + country;
        }
        if (!variant.equals("")) {
            variant = "_" + variant;
        }
        for (String fileName : fileNames = new String[]{"FreeColMessages.properties", FILE_PREFIX + language + FILE_SUFFIX, FILE_PREFIX + language + country + FILE_SUFFIX, FILE_PREFIX + language + country + variant + FILE_SUFFIX}) {
            File resourceFile = new File(Messages.getI18nDirectory(), fileName);
            Messages.loadResources(resourceFile);
        }
    }

    public static File getI18nDirectory() {
        return new File(FreeCol.getDataDirectory(), STRINGS_DIRECTORY);
    }

    public static String message(String messageId, String ... data) {
        String message;
        if (messageId == null) {
            throw new NullPointerException();
        }
        if (data != null && data.length % 2 != 0) {
            throw new IllegalArgumentException("Programming error, the data should consist of only pairs.");
        }
        if (messageBundle == null) {
            Messages.setMessageBundle(Locale.getDefault());
        }
        if ((message = messageBundle.getProperty(messageId)) == null) {
            return messageId;
        }
        if (data != null && data.length > 0) {
            for (int i = 0; i < data.length; i += 2) {
                if (data[i] == null || data[i + 1] == null) {
                    throw new IllegalArgumentException("Programming error, no data should be <null>.");
                }
                String escapedStr = data[i + 1].replaceAll("\\$", "\\\\\\$");
                message = message.replaceAll(data[i], escapedStr);
            }
        }
        return message.trim();
    }

    public static boolean containsKey(String key) {
        if (messageBundle == null) {
            Messages.setMessageBundle(Locale.getDefault());
        }
        return messageBundle.getProperty(key) != null;
    }

    public static String getKey(String preferredKey, String defaultKey) {
        if (Messages.containsKey(preferredKey)) {
            return preferredKey;
        }
        return defaultKey;
    }

    public static void loadResources(File resourceFile) {
        if (resourceFile != null && resourceFile.exists() && resourceFile.isFile() && resourceFile.canRead()) {
            try {
                messageBundle.load(new FileInputStream(resourceFile));
            }
            catch (Exception e) {
                logger.warning("Unable to load resource file " + resourceFile.getPath());
            }
        }
    }
}

