/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.menu;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ChoiceItem;
import net.sf.freecol.client.gui.panel.StatisticsPanel;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;

public class DebugMenu
extends JMenu {
    private FreeColClient freeColClient;
    private final Canvas canvas;
    private final GUI gui;

    public DebugMenu(FreeColClient fcc) {
        super(Messages.message("menuBar.debug", new String[0]));
        this.freeColClient = fcc;
        this.gui = this.freeColClient.getGUI();
        this.canvas = this.freeColClient.getCanvas();
        this.buildDebugMenu();
    }

    private void buildDebugMenu() {
        this.setOpaque(false);
        this.setMnemonic(68);
        this.add(this);
        JMenu debugFixMenu = new JMenu("Fixes");
        debugFixMenu.setOpaque(false);
        debugFixMenu.setMnemonic(70);
        this.add(debugFixMenu);
        JCheckBoxMenuItem crossBug = new JCheckBoxMenuItem("Fix \"not enough crosses\"-bug");
        crossBug.setOpaque(false);
        crossBug.setMnemonic(66);
        debugFixMenu.add(crossBug);
        crossBug.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenu.this.freeColClient.getMyPlayer().updateCrossesRequired();
                if (DebugMenu.this.freeColClient.getFreeColServer() != null) {
                    Iterator<Player> pi = DebugMenu.this.freeColClient.getFreeColServer().getGame().getPlayerIterator();
                    while (pi.hasNext()) {
                        pi.next().updateCrossesRequired();
                    }
                }
            }
        });
        this.addSeparator();
        JCheckBoxMenuItem sc = new JCheckBoxMenuItem(Messages.message("menuBar.debug.showCoordinates", new String[0]), this.gui.displayCoordinates);
        sc.setOpaque(false);
        sc.setMnemonic(83);
        this.add(sc);
        sc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((DebugMenu)DebugMenu.this).gui.displayCoordinates = ((JCheckBoxMenuItem)e.getSource()).isSelected();
                DebugMenu.this.canvas.refresh();
            }
        });
        final JCheckBoxMenuItem dami = new JCheckBoxMenuItem("Additional AI-mission info", this.gui.debugShowMissionInfo);
        dami.setOpaque(false);
        dami.setMnemonic(73);
        dami.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((DebugMenu)DebugMenu.this).gui.debugShowMissionInfo = ((JCheckBoxMenuItem)e.getSource()).isSelected();
                DebugMenu.this.canvas.refresh();
            }
        });
        JCheckBoxMenuItem dam = new JCheckBoxMenuItem("Display AI-missions", this.gui.debugShowMission);
        dam.setOpaque(false);
        dam.setMnemonic(77);
        this.add(dam);
        dam.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((DebugMenu)DebugMenu.this).gui.debugShowMission = ((JCheckBoxMenuItem)e.getSource()).isSelected();
                dami.setEnabled(((DebugMenu)DebugMenu.this).gui.debugShowMission);
                DebugMenu.this.canvas.refresh();
            }
        });
        this.add(dami);
        dami.setEnabled(this.gui.debugShowMission);
        final JCheckBoxMenuItem reveal = new JCheckBoxMenuItem(Messages.message("menuBar.debug.revealEntireMap", new String[0]));
        reveal.setOpaque(false);
        reveal.setMnemonic(82);
        this.add(reveal);
        reveal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DebugMenu.this.freeColClient.getFreeColServer() != null) {
                    DebugMenu.this.freeColClient.getFreeColServer().revealMapForAllPlayers();
                }
                reveal.setEnabled(false);
            }
        });
        JMenu cvpMenu = new JMenu(Messages.message("menuBar.debug.showColonyValue", new String[0]));
        cvpMenu.setOpaque(false);
        ButtonGroup bg = new ButtonGroup();
        JRadioButtonMenuItem cv1 = new JRadioButtonMenuItem("Do not display", !this.gui.displayColonyValue);
        cv1.setOpaque(false);
        cv1.setMnemonic(67);
        cvpMenu.add(cv1);
        bg.add(cv1);
        cv1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((DebugMenu)DebugMenu.this).gui.displayColonyValue = false;
                ((DebugMenu)DebugMenu.this).gui.displayColonyValuePlayer = null;
                DebugMenu.this.canvas.refresh();
            }
        });
        this.add(cvpMenu);
        JRadioButtonMenuItem cv3 = new JRadioButtonMenuItem("Common values", this.gui.displayColonyValue && this.gui.displayColonyValuePlayer == null);
        cv3.setOpaque(false);
        cv3.setMnemonic(67);
        cvpMenu.add(cv3);
        bg.add(cv3);
        cv3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((DebugMenu)DebugMenu.this).gui.displayColonyValue = true;
                ((DebugMenu)DebugMenu.this).gui.displayColonyValuePlayer = null;
                DebugMenu.this.canvas.refresh();
            }
        });
        this.add(cvpMenu);
        cvpMenu.addSeparator();
        Iterator<Player> it = this.freeColClient.getGame().getPlayerIterator();
        while (it.hasNext()) {
            final Player p = it.next();
            if (!p.isEuropean() || !p.canBuildColonies()) continue;
            JRadioButtonMenuItem cv2 = new JRadioButtonMenuItem(p.getNationAsString(), this.gui.displayColonyValue && this.gui.displayColonyValuePlayer == p);
            cv2.setOpaque(false);
            cv2.setMnemonic(67);
            cvpMenu.add(cv2);
            bg.add(cv2);
            cv2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ((DebugMenu)DebugMenu.this).gui.displayColonyValue = true;
                    ((DebugMenu)DebugMenu.this).gui.displayColonyValuePlayer = p;
                    DebugMenu.this.canvas.refresh();
                }
            });
        }
        this.addSeparator();
        JMenuItem skipTurns = new JMenuItem("Skip turns");
        skipTurns.setOpaque(false);
        skipTurns.setMnemonic(83);
        this.add(skipTurns);
        skipTurns.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DebugMenu.this.freeColClient.getFreeColServer() != null) {
                    int skipTurns;
                    ((DebugMenu)DebugMenu.this).freeColClient.getFreeColServer().getInGameController().debugOnlyAITurns = skipTurns = Integer.parseInt(DebugMenu.this.freeColClient.getCanvas().showInputDialog("How many turns should be skipped:", Integer.toString(10), "ok", "cancel", new String[0]));
                    DebugMenu.this.freeColClient.getInGameController().endTurn();
                }
            }
        });
        if (this.freeColClient.getFreeColServer() != null) {
            JMenuItem giveBells = new JMenuItem("Adds 100 bells to each Colony");
            giveBells.setOpaque(false);
            giveBells.setMnemonic(66);
            this.add(giveBells);
            giveBells.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    for (Colony c : DebugMenu.this.freeColClient.getMyPlayer().getColonies()) {
                        c.addBells(100);
                        Colony sc = (Colony)DebugMenu.this.freeColClient.getFreeColServer().getGame().getFreeColGameObject(c.getId());
                        sc.addBells(100);
                    }
                }
            });
        }
        JMenuItem addFather = new JMenuItem("Add Founding Father");
        addFather.setOpaque(false);
        addFather.setMnemonic(70);
        this.add(addFather);
        addFather.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Player player = DebugMenu.this.freeColClient.getMyPlayer();
                ArrayList<ChoiceItem> fathers = new ArrayList<ChoiceItem>();
                for (FoundingFather father : FreeCol.getSpecification().getFoundingFathers()) {
                    if (player.hasFather(father)) continue;
                    fathers.add(new ChoiceItem(father.getName(), father));
                }
                ChoiceItem[] choices = fathers.toArray(new ChoiceItem[fathers.size()]);
                ChoiceItem response = (ChoiceItem)DebugMenu.this.freeColClient.getCanvas().showChoiceDialog("Select Founding Father", "cancel", choices);
                FoundingFather fatherToAdd = (FoundingFather)response.getObject();
                player.addFather(fatherToAdd);
                Player serverPlayer = (Player)DebugMenu.this.freeColClient.getFreeColServer().getGame().getFreeColGameObject(player.getId());
                serverPlayer.addFather(fatherToAdd);
            }
        });
        this.addSeparator();
        JMenuItem europeStatus = new JMenuItem("Display Europe Status");
        europeStatus.setOpaque(false);
        europeStatus.setMnemonic(69);
        this.add(europeStatus);
        europeStatus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DebugMenu.this.freeColClient.getFreeColServer() != null) {
                    AIMain aiMain = DebugMenu.this.freeColClient.getFreeColServer().getAIMain();
                    StringBuilder sb = new StringBuilder();
                    for (Player tp : DebugMenu.this.freeColClient.getGame().getPlayers()) {
                        Player p = (Player)DebugMenu.this.freeColClient.getFreeColServer().getGame().getFreeColGameObject(tp.getId());
                        if (p.getEurope() == null) continue;
                        sb.append("\n==");
                        sb.append(p.getNationAsString());
                        sb.append("==\n");
                        Iterator<Unit> it = p.getEurope().getUnitIterator();
                        while (it.hasNext()) {
                            Unit u = it.next();
                            sb.append('\n');
                            sb.append(u.getName());
                            sb.append('\n');
                            sb.append("    " + ((AIUnit)aiMain.getAIObject(u)).getMission().toString().replaceAll("\n", "    \n"));
                        }
                    }
                    DebugMenu.this.canvas.showInformationMessage(sb.toString());
                }
            }
        });
        JMenuItem useAI = new JMenuItem("Use AI");
        useAI.setOpaque(false);
        useAI.setMnemonic(65);
        useAI.setAccelerator(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8));
        this.add(useAI);
        useAI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DebugMenu.this.freeColClient.getFreeColServer() != null) {
                    AIMain aiMain = DebugMenu.this.freeColClient.getFreeColServer().getAIMain();
                    AIPlayer ap = (AIPlayer)aiMain.getAIObject(DebugMenu.this.freeColClient.getMyPlayer().getId());
                    ap.setDebuggingConnection(DebugMenu.this.freeColClient.getClient().getConnection());
                    ap.startWorking();
                    DebugMenu.this.freeColClient.getConnectController().reconnect();
                }
            }
        });
        this.addSeparator();
        JMenuItem compareMaps = new JMenuItem(Messages.message("menuBar.debug.compareMaps", new String[0]));
        compareMaps.setOpaque(false);
        compareMaps.setMnemonic(67);
        compareMaps.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8));
        this.add(compareMaps);
        compareMaps.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean problemDetected = false;
                Map serverMap = DebugMenu.this.freeColClient.getFreeColServer().getGame().getMap();
                Player myServerPlayer = (Player)DebugMenu.this.freeColClient.getFreeColServer().getGame().getFreeColGameObject(DebugMenu.this.freeColClient.getMyPlayer().getId());
                Map.WholeMapIterator it = serverMap.getWholeMapIterator();
                while (it.hasNext()) {
                    Tile t = serverMap.getTile((Map.Position)it.next());
                    if (!myServerPlayer.canSee(t)) continue;
                    Iterator<Unit> unitIterator = t.getUnitIterator();
                    while (unitIterator.hasNext()) {
                        Unit u = unitIterator.next();
                        if (!u.isVisibleTo(myServerPlayer)) continue;
                        if (DebugMenu.this.freeColClient.getGame().getFreeColGameObject(u.getId()) == null) {
                            System.out.println("Unsynchronization detected: Unit missing on client-side");
                            System.out.println(u.getName() + "(" + u.getId() + "). Position: " + u.getTile().getPosition());
                            try {
                                System.out.println("Possible unit on client-side: " + DebugMenu.this.freeColClient.getGame().getMap().getTile(u.getTile().getPosition()).getFirstUnit().getId());
                            }
                            catch (NullPointerException npe) {
                                // empty catch block
                            }
                            System.out.println();
                            problemDetected = true;
                            continue;
                        }
                        Unit clientSideUnit = (Unit)DebugMenu.this.freeColClient.getGame().getFreeColGameObject(u.getId());
                        if (clientSideUnit.getTile() == null || clientSideUnit.getTile().getId().equals(u.getTile().getId())) continue;
                        System.out.println("Unsynchronization detected: Unit located on different tiles");
                        System.out.println("Server: " + u.getName() + "(" + u.getId() + "). Position: " + u.getTile().getPosition());
                        System.out.println("Client: " + clientSideUnit.getName() + "(" + clientSideUnit.getId() + "). Position: " + clientSideUnit.getTile().getPosition());
                        System.out.println();
                        problemDetected = true;
                    }
                }
                if (problemDetected) {
                    DebugMenu.this.canvas.showInformationMessage("menuBar.debug.compareMaps.problem");
                } else {
                    DebugMenu.this.canvas.showInformationMessage("menuBar.debug.compareMaps.checkComplete");
                }
            }
        });
        JMenuItem statistics = new JMenuItem("Statistics");
        statistics.setOpaque(false);
        statistics.setMnemonic(73);
        this.add(statistics);
        statistics.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMenu.this.canvas.showPanel(new StatisticsPanel(DebugMenu.this.canvas, DebugMenu.this.freeColClient));
            }
        });
        JMenuItem gc = new JMenuItem(Messages.message("menuBar.debug.memoryManager.gc", new String[0]));
        gc.setOpaque(false);
        gc.setMnemonic(71);
        this.add(gc);
        gc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.gc();
            }
        });
        this.addSeparator();
        JMenuItem loadResource = new JMenuItem("Load resource");
        loadResource.setOpaque(false);
        this.add(loadResource);
        loadResource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    FileFilter ff = new FileFilter(){

                        public boolean accept(File f) {
                            return true;
                        }

                        public String getDescription() {
                            return "resource filter";
                        }
                    };
                    File resourceFile = DebugMenu.this.freeColClient.getCanvas().showLoadDialog(FreeCol.getSaveDirectory(), new FileFilter[]{ff});
                    Messages.loadResources(resourceFile);
                }
                catch (Exception ex) {
                    System.out.println("Failed to load resource bundle");
                }
            }
        });
    }
}

