/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import net.sf.freecol.client.gui.option.OptionUpdater;
import net.sf.freecol.common.option.BooleanOption;

public final class BooleanOptionUI
extends JPanel
implements OptionUpdater,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(BooleanOptionUI.class.getName());
    private final BooleanOption option;
    private final JCheckBox checkBox;
    private boolean originalValue;

    public BooleanOptionUI(final BooleanOption option, boolean editable) {
        super(new FlowLayout(0));
        this.option = option;
        this.originalValue = option.getValue();
        String name = option.getName();
        String description = option.getShortDescription();
        this.checkBox = new JCheckBox(name, option.getValue());
        this.checkBox.setEnabled(editable);
        this.checkBox.setToolTipText(description != null ? description : name);
        option.addPropertyChangeListener(this);
        this.checkBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (option.isPreviewEnabled()) {
                    boolean value = BooleanOptionUI.this.checkBox.isSelected();
                    if (option.getValue() != value) {
                        option.setValue(value);
                    }
                }
            }
        });
        this.add(this.checkBox);
        this.setBorder(null);
        this.setOpaque(false);
    }

    public void rollback() {
        this.option.setValue(this.originalValue);
    }

    public void unregister() {
        this.option.removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        boolean value;
        if (event.getPropertyName().equals("value") && (value = ((Boolean)event.getNewValue()).booleanValue()) != this.checkBox.isSelected()) {
            this.checkBox.setSelected(value);
            this.originalValue = value;
        }
    }

    public void updateOption() {
        this.option.setValue(this.checkBox.isSelected());
    }

    public void reset() {
        this.checkBox.setSelected(this.option.getValue());
    }

    public void setValue(boolean b) {
        this.checkBox.setSelected(b);
    }

    public void setEnabled(boolean b) {
        this.checkBox.setEnabled(b);
    }
}

