/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.freecol.client.gui.option.OptionUpdater;
import net.sf.freecol.common.option.IntegerOption;

public final class IntegerOptionUI
extends JPanel
implements OptionUpdater,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(IntegerOptionUI.class.getName());
    private final IntegerOption option;
    private final JSpinner spinner;
    private int originalValue;

    public IntegerOptionUI(final IntegerOption option, boolean editable) {
        super(new FlowLayout(0));
        this.option = option;
        this.originalValue = option.getValue();
        String name = option.getName();
        String description = option.getShortDescription();
        JLabel label = new JLabel(name, 2);
        label.setToolTipText(description != null ? description : name);
        this.add(label);
        int stepSize = Math.min((option.getMaximumValue() - option.getMinimumValue()) / 10, 1000);
        this.spinner = new JSpinner(new SpinnerNumberModel(option.getValue(), option.getMinimumValue(), option.getMaximumValue(), Math.max(1, stepSize)));
        this.spinner.setToolTipText(option.getShortDescription());
        this.add(this.spinner);
        this.spinner.setEnabled(editable);
        this.spinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (option.isPreviewEnabled()) {
                    int value = (Integer)IntegerOptionUI.this.spinner.getValue();
                    if (option.getValue() != value) {
                        option.setValue(value);
                    }
                }
            }
        });
        option.addPropertyChangeListener(this);
        this.setOpaque(false);
    }

    public void rollback() {
        this.option.setValue(this.originalValue);
    }

    public void unregister() {
        this.option.removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        int value;
        if (event.getPropertyName().equals("value") && (value = ((Integer)event.getNewValue()).intValue()) != (Integer)this.spinner.getValue()) {
            this.spinner.setValue(event.getNewValue());
            this.originalValue = value;
        }
    }

    public void updateOption() {
        this.option.setValue((Integer)this.spinner.getValue());
    }

    public void reset() {
        this.spinner.setValue(this.option.getValue());
    }
}

