/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.freecol.client.gui.option.OptionUpdater;
import net.sf.freecol.common.option.LanguageOption;

public final class LanguageOptionUI
extends JPanel
implements OptionUpdater,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(LanguageOptionUI.class.getName());
    private final LanguageOption option;
    private final JComboBox comboBox;
    private LanguageOption.Language originalValue;

    public LanguageOptionUI(final LanguageOption option, boolean editable) {
        super(new FlowLayout(0));
        this.option = option;
        this.originalValue = option.getValue();
        String name = option.getName();
        String description = option.getShortDescription();
        JLabel label = new JLabel(name, 2);
        label.setToolTipText(description != null ? description : name);
        this.add(label);
        LanguageOption.Language[] languages = option.getOptions();
        this.comboBox = new JComboBox<LanguageOption.Language>(languages);
        this.reset();
        this.add(this.comboBox);
        this.comboBox.setEnabled(editable);
        this.comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (option.isPreviewEnabled()) {
                    LanguageOption.Language value = (LanguageOption.Language)LanguageOptionUI.this.comboBox.getSelectedItem();
                    if (option.getValue() != value) {
                        option.setValue(value);
                    }
                }
            }
        });
        option.addPropertyChangeListener(this);
        this.setOpaque(false);
    }

    public void rollback() {
        this.option.setValue(this.originalValue);
    }

    public void unregister() {
        this.option.removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        LanguageOption.Language value;
        if (event.getPropertyName().equals("value") && (value = (LanguageOption.Language)event.getNewValue()) != this.comboBox.getSelectedItem()) {
            this.comboBox.setSelectedItem(value);
            this.originalValue = value;
        }
    }

    public void updateOption() {
        this.option.setValue((LanguageOption.Language)this.comboBox.getSelectedItem());
    }

    public void reset() {
        this.comboBox.setSelectedItem(this.option.getValue());
    }
}

