/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.action.FreeColAction;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.option.AudioMixerOptionUI;
import net.sf.freecol.client.gui.option.BooleanOptionUI;
import net.sf.freecol.client.gui.option.FileOptionUI;
import net.sf.freecol.client.gui.option.FreeColActionUI;
import net.sf.freecol.client.gui.option.IntegerOptionUI;
import net.sf.freecol.client.gui.option.LanguageOptionUI;
import net.sf.freecol.client.gui.option.OptionUpdater;
import net.sf.freecol.client.gui.option.PercentageOptionUI;
import net.sf.freecol.client.gui.option.RangeOptionUI;
import net.sf.freecol.client.gui.option.SelectOptionUI;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.common.option.AudioMixerOption;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.common.option.FileOption;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.LanguageOption;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.option.PercentageOption;
import net.sf.freecol.common.option.RangeOption;
import net.sf.freecol.common.option.SelectOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OptionGroupUI
extends JPanel
implements OptionUpdater {
    private static final Logger logger = Logger.getLogger(OptionGroupUI.class.getName());
    public static final int H_GAP = 10;
    private final OptionUpdater[] optionUpdaters;

    public OptionGroupUI(OptionGroup option, boolean editable, int level, HashMap<String, JComponent> optionUIs) {
        this.setLayout(new BoxLayout(this, 3));
        Container horizontalPanel = null;
        boolean buttonAdded = false;
        ArrayList<JComponent> ou = new ArrayList<JComponent>();
        Iterator<Option> it = option.iterator();
        while (it.hasNext()) {
            JPanel iou;
            JPanel soi;
            Option o = it.next();
            if (o instanceof OptionGroup) {
                OptionGroupUI groupUI;
                if (level == 2) {
                    groupUI = new OptionGroupUI((OptionGroup)o, editable, 1, optionUIs);
                    OptionGroupButton ogb = new OptionGroupButton(o.getName(), groupUI);
                    ou.add(ogb);
                    if (horizontalPanel == null || !buttonAdded) {
                        horizontalPanel = new JPanel(new FlowLayout(0));
                        ((JComponent)horizontalPanel).setOpaque(false);
                        this.add(horizontalPanel);
                    }
                    horizontalPanel.add(ogb);
                    buttonAdded = true;
                    continue;
                }
                groupUI = new OptionGroupUI((OptionGroup)o, editable, level + 1, optionUIs);
                this.add(groupUI);
                ou.add(groupUI);
                buttonAdded = false;
                continue;
            }
            if (o instanceof BooleanOption) {
                boolean alreadyAdded;
                BooleanOptionUI boi = new BooleanOptionUI((BooleanOption)o, editable);
                ou.add(boi);
                boolean bl = alreadyAdded = horizontalPanel != null && !buttonAdded;
                if (!alreadyAdded || buttonAdded) {
                    horizontalPanel = new JPanel(new GridLayout(1, 2, 10, 5));
                    ((JComponent)horizontalPanel).setOpaque(false);
                    this.add(horizontalPanel);
                }
                horizontalPanel.add(boi);
                if (alreadyAdded) {
                    horizontalPanel = null;
                }
                buttonAdded = false;
                if (o.getId().equals("NO_ID")) continue;
                optionUIs.put(o.getId(), boi);
                continue;
            }
            if (o instanceof PercentageOption) {
                soi = new PercentageOptionUI((PercentageOption)o, editable);
                this.add(soi);
                ou.add(soi);
                buttonAdded = false;
                if (o.getId().equals("NO_ID")) continue;
                optionUIs.put(o.getId(), soi);
                continue;
            }
            if (o instanceof IntegerOption) {
                iou = new IntegerOptionUI((IntegerOption)o, editable);
                this.add(iou);
                ou.add(iou);
                buttonAdded = false;
                if (o.getId().equals("NO_ID")) continue;
                optionUIs.put(o.getId(), iou);
                continue;
            }
            if (o instanceof FileOption) {
                iou = new FileOptionUI((FileOption)o, editable);
                this.add(iou);
                ou.add(iou);
                buttonAdded = false;
                if (o.getId().equals("NO_ID")) continue;
                optionUIs.put(o.getId(), iou);
                continue;
            }
            if (o instanceof RangeOption) {
                soi = new RangeOptionUI((RangeOption)o, editable);
                this.add(soi);
                ou.add(soi);
                buttonAdded = false;
                if (o.getId().equals("NO_ID")) continue;
                optionUIs.put(o.getId(), soi);
                continue;
            }
            if (o instanceof SelectOption) {
                soi = new SelectOptionUI((SelectOption)o, editable);
                this.add(soi);
                ou.add(soi);
                buttonAdded = false;
                if (o.getId().equals("NO_ID")) continue;
                optionUIs.put(o.getId(), soi);
                continue;
            }
            if (o instanceof LanguageOption) {
                soi = new LanguageOptionUI((LanguageOption)o, editable);
                this.add(soi);
                ou.add(soi);
                buttonAdded = false;
                if (o.getId().equals("NO_ID")) continue;
                optionUIs.put(o.getId(), soi);
                continue;
            }
            if (o instanceof AudioMixerOption) {
                soi = new AudioMixerOptionUI((AudioMixerOption)o, editable);
                this.add(soi);
                ou.add(soi);
                buttonAdded = false;
                if (o.getId().equals("NO_ID")) continue;
                optionUIs.put(o.getId(), soi);
                continue;
            }
            if (o instanceof FreeColAction) {
                FreeColActionUI fau = new FreeColActionUI((FreeColAction)o, this);
                ou.add(fau);
                this.add(fau);
                if (o.getId().equals("NO_ID")) continue;
                optionUIs.put(o.getId(), fau);
                continue;
            }
            logger.warning("Unknown option.");
        }
        this.optionUpdaters = ou.toArray(new OptionUpdater[0]);
        this.setBorder(BorderFactory.createTitledBorder(option.getName()));
        this.setOpaque(false);
    }

    @Override
    public void rollback() {
        for (int i = 0; i < this.optionUpdaters.length; ++i) {
            this.optionUpdaters[i].rollback();
        }
    }

    @Override
    public void unregister() {
        for (int i = 0; i < this.optionUpdaters.length; ++i) {
            this.optionUpdaters[i].unregister();
        }
    }

    @Override
    public void updateOption() {
        for (int i = 0; i < this.optionUpdaters.length; ++i) {
            this.optionUpdaters[i].updateOption();
        }
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.optionUpdaters.length; ++i) {
            this.optionUpdaters[i].reset();
        }
    }

    public void removeKeyStroke(KeyStroke keyStroke) {
        for (int i = 0; i < this.optionUpdaters.length; ++i) {
            if (!(this.optionUpdaters[i] instanceof FreeColActionUI)) continue;
            ((FreeColActionUI)this.optionUpdaters[i]).removeKeyStroke(keyStroke);
        }
    }

    private class OptionGroupButton
    extends JButton
    implements OptionUpdater {
        private final OptionGroupUI groupUI;
        private final OptionGroupButton optionGroupButton;
        private final OptionGroupPanel optionGroupPanel;

        OptionGroupButton(String name, OptionGroupUI groupUI) {
            super(name);
            this.groupUI = groupUI;
            this.optionGroupButton = this;
            this.optionGroupPanel = new OptionGroupPanel();
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OptionGroupButton.this.optionGroupButton.setEnabled(false);
                    FreeCol.getFreeColClient().getCanvas().addAsFrame(OptionGroupButton.this.optionGroupPanel);
                }
            });
        }

        public void rollback() {
            this.groupUI.rollback();
        }

        public void updateOption() {
            this.groupUI.updateOption();
        }

        public void reset() {
            this.groupUI.reset();
        }

        public void unregister() {
            this.groupUI.unregister();
            FreeCol.getFreeColClient().getCanvas().remove(this.optionGroupPanel);
        }

        private class OptionGroupPanel
        extends FreeColPanel {
            public OptionGroupPanel() {
                super(new BorderLayout());
                JButton button = new JButton(Messages.message("ok", new String[0]));
                button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        FreeCol.getFreeColClient().getCanvas().remove(OptionGroupButton.this.optionGroupPanel);
                        OptionGroupButton.this.optionGroupButton.setEnabled(true);
                    }
                });
                this.add((Component)OptionGroupButton.this.groupUI, "Center");
                this.add((Component)button, "South");
            }

            public Dimension getPreferredSize() {
                return new Dimension(400, 200);
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        }
    }
}

