/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import net.sf.freecol.client.gui.option.AudioMixerOptionUI;
import net.sf.freecol.client.gui.option.BooleanOptionUI;
import net.sf.freecol.client.gui.option.FileOptionUI;
import net.sf.freecol.client.gui.option.IntegerOptionUI;
import net.sf.freecol.client.gui.option.LanguageOptionUI;
import net.sf.freecol.client.gui.option.OptionGroupUI;
import net.sf.freecol.client.gui.option.OptionUpdater;
import net.sf.freecol.client.gui.option.PercentageOptionUI;
import net.sf.freecol.client.gui.option.RangeOptionUI;
import net.sf.freecol.client.gui.option.SelectOptionUI;
import net.sf.freecol.common.option.AudioMixerOption;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.common.option.FileOption;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.LanguageOption;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.option.OptionMap;
import net.sf.freecol.common.option.PercentageOption;
import net.sf.freecol.common.option.RangeOption;
import net.sf.freecol.common.option.SelectOption;

public final class OptionMapUI
extends JPanel
implements OptionUpdater {
    private static final Logger logger = Logger.getLogger(OptionMapUI.class.getName());
    private final OptionUpdater[] optionUpdaters;
    private final HashMap<String, JComponent> optionUIs;
    private final JTabbedPane tb;

    public OptionMapUI(OptionMap option) {
        this(option, true);
    }

    public OptionMapUI(OptionMap option, boolean editable) {
        super(new BorderLayout());
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new BoxLayout(northPanel, 1));
        northPanel.setOpaque(false);
        this.optionUIs = new HashMap();
        this.tb = new JTabbedPane(1);
        this.tb.setOpaque(false);
        ArrayList<JPanel> ou = new ArrayList<JPanel>();
        Iterator<Option> it = option.iterator();
        while (it.hasNext()) {
            JComponent c;
            Option o = it.next();
            if (o instanceof OptionGroup) {
                c = new OptionGroupUI((OptionGroup)o, editable, 1, this.optionUIs);
                c.setOpaque(true);
                ou.add((JPanel)c);
                JScrollPane scroll = new JScrollPane(c, 20, 31);
                scroll.getVerticalScrollBar().setUnitIncrement(16);
                scroll.setBorder(BorderFactory.createEmptyBorder());
                c.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 10));
                c = scroll;
                this.tb.addTab(o.getName(), null, c, o.getShortDescription());
                continue;
            }
            if (o instanceof BooleanOption) {
                c = new BooleanOptionUI((BooleanOption)o, editable);
                northPanel.add(c);
                ou.add((JPanel)c);
                if (o.getId().equals("NO_ID")) continue;
                this.optionUIs.put(o.getId(), c);
                continue;
            }
            if (o instanceof FileOption) {
                FileOptionUI iou = new FileOptionUI((FileOption)o, editable);
                northPanel.add(iou);
                ou.add(iou);
                if (o.getId().equals("NO_ID")) continue;
                this.optionUIs.put(o.getId(), iou);
                continue;
            }
            if (o instanceof PercentageOption) {
                c = new PercentageOptionUI((PercentageOption)o, editable);
                northPanel.add(c);
                ou.add((JPanel)c);
                if (o.getId().equals("NO_ID")) continue;
                this.optionUIs.put(o.getId(), c);
                continue;
            }
            if (o instanceof IntegerOption) {
                c = new IntegerOptionUI((IntegerOption)o, editable);
                northPanel.add(c);
                ou.add((JPanel)c);
                if (o.getId().equals("NO_ID")) continue;
                this.optionUIs.put(o.getId(), c);
                continue;
            }
            if (o instanceof RangeOption) {
                c = new RangeOptionUI((RangeOption)o, editable);
                northPanel.add(c);
                ou.add((JPanel)c);
                if (o.getId().equals("NO_ID")) continue;
                this.optionUIs.put(o.getId(), c);
                continue;
            }
            if (o instanceof SelectOption) {
                c = new SelectOptionUI((SelectOption)o, editable);
                northPanel.add(c);
                ou.add((JPanel)c);
                if (o.getId().equals("NO_ID")) continue;
                this.optionUIs.put(o.getId(), c);
                continue;
            }
            if (o instanceof LanguageOption) {
                System.out.println("found languageOption");
                c = new LanguageOptionUI((LanguageOption)o, editable);
                northPanel.add(c);
                ou.add((JPanel)c);
                if (o.getId().equals("NO_ID")) continue;
                this.optionUIs.put(o.getId(), c);
                continue;
            }
            if (o instanceof AudioMixerOption) {
                c = new AudioMixerOptionUI((AudioMixerOption)o, editable);
                northPanel.add(c);
                ou.add((JPanel)c);
                if (o.getId().equals("NO_ID")) continue;
                this.optionUIs.put(o.getId(), c);
                continue;
            }
            logger.warning("Unknown option.");
        }
        this.optionUpdaters = ou.toArray(new OptionUpdater[0]);
        this.add((Component)northPanel, "North");
        if (this.tb.getTabCount() > 0) {
            this.add((Component)this.tb, "Center");
        }
        this.setOpaque(false);
    }

    public void rollback() {
        for (int i = 0; i < this.optionUpdaters.length; ++i) {
            this.optionUpdaters[i].rollback();
        }
    }

    public void unregister() {
        for (int i = 0; i < this.optionUpdaters.length; ++i) {
            this.optionUpdaters[i].unregister();
        }
    }

    public void updateOption() {
        for (int i = 0; i < this.optionUpdaters.length; ++i) {
            this.optionUpdaters[i].updateOption();
        }
    }

    public JComponent getOptionUI(String key) {
        return this.optionUIs.get(key);
    }

    public void reset() {
        for (int i = 0; i < this.optionUpdaters.length; ++i) {
            this.optionUpdaters[i].reset();
        }
    }
}

