/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.Color;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.freecol.client.gui.option.OptionUpdater;
import net.sf.freecol.common.option.PercentageOption;

public final class PercentageOptionUI
extends JPanel
implements OptionUpdater,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(PercentageOptionUI.class.getName());
    private final PercentageOption option;
    private final JSlider slider;
    private int originalValue;

    public PercentageOptionUI(final PercentageOption option, boolean editable) {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), option.getName()));
        this.option = option;
        this.originalValue = option.getValue();
        String name = option.getName();
        String description = option.getShortDescription();
        this.slider = new JSlider(0, 0, 100, option.getValue());
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        labels.put(new Integer(0), new JLabel("0 %"));
        labels.put(new Integer(25), new JLabel("25 %"));
        labels.put(new Integer(50), new JLabel("50 %"));
        labels.put(new Integer(75), new JLabel("75 %"));
        labels.put(new Integer(100), new JLabel("100 %"));
        this.slider.setLabelTable(labels);
        this.slider.setValue(option.getValue());
        this.slider.setPaintLabels(true);
        this.slider.setMajorTickSpacing(5);
        this.slider.setExtent(0);
        this.slider.setPaintTicks(true);
        this.slider.setSnapToTicks(false);
        this.slider.setPreferredSize(new Dimension(500, 50));
        this.slider.setToolTipText(description != null ? description : name);
        this.add(this.slider);
        this.slider.setEnabled(editable);
        this.slider.setOpaque(false);
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (option.isPreviewEnabled() && option.getValue() != PercentageOptionUI.this.slider.getValue()) {
                    option.setValue(PercentageOptionUI.this.slider.getValue());
                }
            }
        });
        option.addPropertyChangeListener(this);
        this.setOpaque(false);
    }

    public void rollback() {
        this.option.setValue(this.originalValue);
    }

    public void unregister() {
        this.option.removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        int value;
        if (event.getPropertyName().equals("value") && (value = ((Integer)event.getNewValue()).intValue()) != this.slider.getValue()) {
            this.slider.setValue(value);
            this.originalValue = value;
        }
    }

    public void updateOption() {
        this.option.setValue(this.slider.getValue());
    }

    public void reset() {
        this.slider.setValue(this.option.getValue());
    }
}

