/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.Color;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.freecol.client.gui.option.OptionUpdater;
import net.sf.freecol.common.option.RangeOption;

public final class RangeOptionUI
extends JPanel
implements OptionUpdater,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(RangeOptionUI.class.getName());
    private final RangeOption option;
    private final JSlider slider;
    private int originalValue;

    public RangeOptionUI(final RangeOption option, boolean editable) {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), option.getName()));
        this.option = option;
        this.originalValue = option.getValue();
        String name = option.getName();
        String description = option.getShortDescription();
        String[] strings = option.getItemValues().values().toArray(new String[0]);
        this.slider = new JSlider(0, 0, strings.length - 1, option.getValueRank());
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        for (int i = 0; i < strings.length; ++i) {
            labels.put(new Integer(i), new JLabel(strings[i]));
        }
        this.slider.setLabelTable(labels);
        this.slider.setValue(option.getValueRank());
        this.slider.setPaintLabels(true);
        this.slider.setMajorTickSpacing(1);
        this.slider.setExtent(0);
        this.slider.setPaintTicks(true);
        this.slider.setSnapToTicks(true);
        this.slider.setPreferredSize(new Dimension(500, 50));
        this.slider.setToolTipText(description != null ? description : name);
        this.add(this.slider);
        this.slider.setEnabled(editable);
        this.slider.setOpaque(false);
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (option.isPreviewEnabled()) {
                    int value = RangeOptionUI.this.slider.getValue();
                    if (option.getValue() != value) {
                        option.setValueRank(value);
                    }
                }
            }
        });
        option.addPropertyChangeListener(this);
        this.setOpaque(false);
    }

    public void rollback() {
        this.option.setValue(this.originalValue);
    }

    public void unregister() {
        this.option.removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        int value;
        if (event.getPropertyName().equals("value") && (value = ((Integer)event.getNewValue()).intValue()) != this.slider.getValue()) {
            this.slider.setValue(value);
            this.originalValue = value;
        }
    }

    public void updateOption() {
        this.option.setValueRank(this.slider.getValue());
    }

    public void reset() {
        this.slider.setValue(this.option.getValueRank());
    }
}

