/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.freecol.client.gui.option.OptionUpdater;
import net.sf.freecol.common.option.SelectOption;

public final class SelectOptionUI
extends JPanel
implements OptionUpdater,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(SelectOptionUI.class.getName());
    private final SelectOption option;
    private final JComboBox comboBox;
    private int originalValue;

    public SelectOptionUI(final SelectOption option, boolean editable) {
        super(new FlowLayout(0));
        this.option = option;
        this.originalValue = option.getValue();
        String name = option.getName();
        String description = option.getShortDescription();
        JLabel label = new JLabel(name, 2);
        label.setToolTipText(description != null ? description : name);
        this.add(label);
        String[] strings = option.getItemValues().values().toArray(new String[0]);
        this.comboBox = new JComboBox<String>(strings);
        this.comboBox.setSelectedIndex(option.getValue());
        this.add(this.comboBox);
        this.comboBox.setEnabled(editable);
        this.comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (option.isPreviewEnabled()) {
                    int value = SelectOptionUI.this.comboBox.getSelectedIndex();
                    if (option.getValue() != value) {
                        option.setValue(value);
                    }
                }
            }
        });
        option.addPropertyChangeListener(this);
        this.setOpaque(false);
    }

    public void rollback() {
        this.option.setValue(this.originalValue);
    }

    public void unregister() {
        this.option.removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        int value;
        if (event.getPropertyName().equals("value") && (value = ((Integer)event.getNewValue()).intValue()) != this.comboBox.getSelectedIndex()) {
            this.comboBox.setSelectedIndex(value);
            this.originalValue = value;
        }
    }

    public void updateOption() {
        this.option.setValue(this.comboBox.getSelectedIndex());
    }

    public void reset() {
        this.comboBox.setSelectedIndex(this.option.getValue());
    }
}

