/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.common.resources.ResourceManager;

public final class AboutPanel
extends FreeColPanel
implements ActionListener {
    private static final Logger logger = Logger.getLogger(AboutPanel.class.getName());
    private static final int CLOSE = 0;
    private final Canvas parent;
    private JButton exitButton;

    public AboutPanel(Canvas parent) {
        this.parent = parent;
        this.setLayout(new BorderLayout());
        JPanel header = new JPanel();
        this.add((Component)header, "North");
        Image tempImage = ResourceManager.getImage("TitleImage");
        if (tempImage != null) {
            JLabel logoLabel = new JLabel(new ImageIcon(tempImage));
            logoLabel.setBorder(new CompoundBorder(new EmptyBorder(2, 2, 2, 2), new BevelBorder(1)));
            header.add((Component)logoLabel, Float.valueOf(0.5f));
        }
        JPanel infoPanel = new JPanel(new GridLayout(3, 1));
        this.add((Component)infoPanel, "Center");
        infoPanel.setBorder(new EmptyBorder(10, 10, 0, 10));
        JPanel table = new JPanel(new GridLayout(3, 2));
        infoPanel.add(table);
        table.add(new JLabel(Messages.message("aboutPanel.version", new String[0])));
        table.add(new JLabel(FreeCol.getRevision()));
        table.add(new JLabel(Messages.message("aboutPanel.officialSite", new String[0])));
        String siteURL = "http://www.freecol.org";
        JLabel site = new JLabel("<html><font color='Blue'>" + siteURL + "</font></html>");
        site.setFocusable(true);
        site.addMouseListener(new URLMouseListener(siteURL));
        table.add(site);
        table.add(new JLabel(Messages.message("aboutPanel.sfProject", new String[0])));
        String projectURL = "http://sourceforge.net/projects/freecol/";
        JLabel project = new JLabel("<html><font color='Blue'>" + projectURL + "</font></html>");
        project.setFocusable(true);
        project.addMouseListener(new URLMouseListener(projectURL));
        table.add(project);
        String disclaimer = Messages.message("aboutPanel.legalDisclaimer", new String[0]);
        JTextArea textarea = new JTextArea();
        textarea.setOpaque(false);
        textarea.setText(disclaimer);
        textarea.setLineWrap(true);
        textarea.setWrapStyleWord(true);
        textarea.setEditable(false);
        textarea.setFocusable(false);
        infoPanel.add(textarea);
        infoPanel.add((Component)new JLabel(Messages.message("aboutPanel.copyright", new String[0]), 0), "Center");
        this.exitButton = new JButton(Messages.message("close", new String[0]));
        this.exitButton.addActionListener(this);
        AboutPanel.enterPressesWhenFocused(this.exitButton);
        this.setCancelComponent(this.exitButton);
        this.exitButton.setActionCommand(String.valueOf(0));
        this.add((Component)this.exitButton, "South");
        this.exitButton.setFocusable(true);
        this.setSize(this.getPreferredSize());
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        try {
            switch (Integer.valueOf(command)) {
                case 0: {
                    this.parent.remove(this);
                    break;
                }
                default: {
                    logger.warning("Invalid Actioncommand: invalid number.");
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            logger.warning("Invalid Actioncommand: not a number.");
        }
    }

    public class URLMouseListener
    implements MouseListener {
        private String url;

        public URLMouseListener(String url) {
            this.url = url;
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1) {
                this.openBrowserURL();
            }
        }

        public void openBrowserURL() {
            String os = System.getProperty("os.name");
            String[] cmd = null;
            if (os == null) {
                return;
            }
            cmd = os.toLowerCase().contains("mac") ? new String[]{"open", "-a", "Safari", this.url} : (os.toLowerCase().contains("windows") ? new String[]{"rundll32.exe", "url.dll,FileProtocolHandler", this.url} : (os.toLowerCase().contains("linux") ? new String[]{"xdg-open", this.url} : new String[]{"firefox", this.url}));
            try {
                Runtime.getRuntime().exec(cmd);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

