/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.model.EuropeanNationType;
import net.sf.freecol.common.model.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AdvantageCellRenderer
implements TableCellRenderer {
    public static final int NONE = 0;
    public static final int FIXED = 1;
    public static final int SELECTABLE = 2;
    private static Vector<EuropeanNationType> europeans = new Vector<EuropeanNationType>(FreeCol.getSpecification().getEuropeanNationTypes());
    private static final JComboBox standardNationsComboBox = new JComboBox<EuropeanNationType>(europeans);
    private List<Player> players;
    private Player thisPlayer;
    private int advantages;

    public void setData(List<Player> players, Player owningPlayer, int advantages) {
        this.players = players;
        this.thisPlayer = owningPlayer;
        this.advantages = advantages;
    }

    private Player getPlayer(int i) {
        if (i == 0) {
            return this.thisPlayer;
        }
        if (this.players.get(i) == this.thisPlayer) {
            return this.players.get(0);
        }
        return this.players.get(i);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Player player = this.getPlayer(row);
        JComponent component = standardNationsComboBox;
        if (player == this.thisPlayer) {
            switch (this.advantages) {
                case 1: {
                    component = new JLabel(player.getNationType().getName());
                    break;
                }
                case 2: {
                    component = standardNationsComboBox;
                    ((JComboBox)component).setSelectedItem(player.getNationType());
                    break;
                }
                default: {
                    component = new JLabel(Messages.message("model.nationType.none.name", new String[0]));
                    break;
                }
            }
        } else {
            component = player.isEuropean() ? new JLabel(player.getNationType().getName()) : new JLabel();
        }
        if (player.isReady()) {
            ((Component)component).setForeground(Color.GRAY);
        } else {
            ((Component)component).setForeground(table.getForeground());
        }
        ((Component)component).setBackground(table.getBackground());
        return component;
    }
}

