/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildQueue;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.UnitType;

public class BuildQueuePanel
extends ReportPanel {
    private final BuildQueueTransferHandler buildQueueHandler = new BuildQueueTransferHandler();
    private BuildQueue finished;
    private BuildQueue current;
    private BuildQueue units;
    private BuildQueue buildings;
    private Colony colony;
    private GridLayout gridLayout = new GridLayout(0, 2);

    public BuildQueuePanel(Canvas parent) {
        super(parent, Messages.message("buildQueue", new String[0]));
    }

    public void initialize(Colony colony) {
        this.colony = colony;
        this.reportPanel.removeAll();
        this.current = new BuildQueue(colony.getBuildQueue());
        this.finished = new BuildQueue();
        for (Building building : colony.getBuildings()) {
            this.finished.addUnchecked(building.getType());
        }
        this.units = new BuildQueue(BuildQueue.Type.UNITS);
        for (UnitType unitType : FreeCol.getSpecification().getUnitTypeList()) {
            if (unitType.getGoodsRequired().isEmpty()) continue;
            this.units.addUnchecked(unitType);
        }
        this.buildings = new BuildQueue(BuildQueue.Type.BUILDINGS);
        for (BuildingType buildingType : FreeCol.getSpecification().getBuildingTypeList()) {
            if (this.hasBuildingType(colony, buildingType)) continue;
            this.buildings.add(buildingType);
        }
        BuildQueueCellRenderer cellRenderer = new BuildQueueCellRenderer();
        JList buildQueueList = new JList(this.current);
        buildQueueList.setTransferHandler(this.buildQueueHandler);
        buildQueueList.setSelectionMode(2);
        buildQueueList.setDragEnabled(true);
        buildQueueList.setCellRenderer(cellRenderer);
        JList unitList = new JList(this.units);
        unitList.setTransferHandler(this.buildQueueHandler);
        unitList.setSelectionMode(2);
        unitList.setDragEnabled(true);
        unitList.setCellRenderer(cellRenderer);
        JList buildingList = new JList(this.buildings);
        buildingList.setTransferHandler(this.buildQueueHandler);
        buildingList.setSelectionMode(2);
        buildingList.setDragEnabled(true);
        buildingList.setCellRenderer(cellRenderer);
        JScrollPane buildQueueView = new JScrollPane(buildQueueList);
        buildQueueView.setPreferredSize(new Dimension(240, 400));
        JPanel buildQueuePanel = new JPanel();
        buildQueuePanel.setLayout(new BorderLayout());
        buildQueuePanel.add((Component)buildQueueView, "Center");
        buildQueuePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JScrollPane unitView = new JScrollPane(unitList);
        unitView.setPreferredSize(new Dimension(240, 400));
        JPanel unitPanel = new JPanel();
        unitPanel.setLayout(new BorderLayout());
        unitPanel.add((Component)unitView, "Center");
        unitPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JScrollPane buildingView = new JScrollPane(buildingList);
        buildingView.setPreferredSize(new Dimension(240, 400));
        JPanel buildingPanel = new JPanel();
        buildingPanel.setLayout(new BorderLayout());
        buildingPanel.add((Component)buildingView, "Center");
        buildingPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.reportPanel.add(buildQueuePanel);
        this.reportPanel.add(unitPanel);
        this.reportPanel.add(buildingPanel);
        this.gridLayout.setHgap(5);
    }

    private boolean hasBuildingType(Colony colony, BuildingType buildingType) {
        if (colony.getBuilding(buildingType) == null) {
            return false;
        }
        if (colony.getBuilding(buildingType).getType() == buildingType) {
            return true;
        }
        if (buildingType.getUpgradesTo() != null) {
            return this.hasBuildingType(colony, buildingType.getUpgradesTo());
        }
        return false;
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        int action = Integer.valueOf(command);
        if (action == -1) {
            this.getCanvas().remove(this);
        } else {
            logger.warning("Invalid ActionCommand: " + action);
        }
    }

    class BuildQueueCellRenderer
    implements ListCellRenderer {
        private final int[] widths = new int[]{0, 5, 0};
        private final int[] heights = new int[]{83};
        HIGLayout layout = new HIGLayout(this.widths, this.heights);

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ImageIcon imageIcon;
            Image goodsImage;
            BuildingType building;
            GoodsType outputType;
            BuildableType item = (BuildableType)value;
            JPanel itemPanel = new JPanel(this.layout);
            JLabel imageLabel = new JLabel();
            ImageLibrary library = BuildQueuePanel.this.getCanvas().getGUI().getImageLibrary();
            if (value instanceof UnitType) {
                imageLabel = new JLabel(library.scaleIcon(library.getUnitImageIcon((UnitType)value), 0.66f));
                itemPanel.add((Component)imageLabel, FreeColPanel.higConst.rc(1, 1));
            } else if (value instanceof BuildingType && (outputType = (building = (BuildingType)value).getProducedGoodsType()) != null) {
                JPanel goodsPanel = new JPanel();
                goodsImage = library.getGoodsImage(outputType);
                imageIcon = new ImageIcon(library.scaleImage(goodsImage, 0.66f));
                for (int gindex = 0; gindex < building.getLevel(); ++gindex) {
                    goodsPanel.add(new JLabel(imageIcon));
                }
                if (isSelected) {
                    goodsPanel.setOpaque(false);
                }
                itemPanel.add((Component)goodsPanel, FreeColPanel.higConst.rc(1, 1));
            }
            JPanel costs = new JPanel(BuildQueuePanel.this.gridLayout);
            costs.setBorder(BorderFactory.createTitledBorder(item.getName()));
            costs.setOpaque(false);
            for (AbstractGoods goodsRequired : item.getGoodsRequired()) {
                goodsImage = library.getGoodsImage(goodsRequired.getType());
                imageIcon = new ImageIcon(library.scaleImage(goodsImage, 0.66f));
                costs.add(new JLabel(String.valueOf(goodsRequired.getAmount()), imageIcon, 0));
            }
            itemPanel.add((Component)costs, FreeColPanel.higConst.rc(1, 3));
            if (isSelected) {
                itemPanel.setOpaque(false);
            }
            return itemPanel;
        }
    }

    public class BuildQueueTransferHandler
    extends TransferHandler {
        private final DataFlavor buildQueueFlavor = new DataFlavor(BuildQueue.class, "BuildingQueueFlavor");
        JList source = null;
        int[] indices = null;
        int targetIndex = -1;
        int numberOfItems = 0;

        public boolean importData(JComponent comp, Transferable data) {
            BuildQueue targetQueue;
            JList target = null;
            BuildQueue buildQueue = null;
            if (!this.canImport(comp, data.getTransferDataFlavors())) {
                System.out.println("Can't import data flavor");
                return false;
            }
            try {
                target = (JList)comp;
                targetQueue = (BuildQueue)target.getModel();
                buildQueue = (BuildQueue)data.getTransferData(this.buildQueueFlavor);
            }
            catch (UnsupportedFlavorException e) {
                System.out.println("importData: unsupported data flavor " + e);
                return false;
            }
            catch (IOException e) {
                System.out.println("importData: I/O exception " + e);
                return false;
            }
            if (!buildQueue.dependenciesSatisfiedBy(targetQueue, BuildQueuePanel.this.finished)) {
                return false;
            }
            int preferredIndex = target.getSelectedIndex();
            if (this.source.equals(target)) {
                if (targetQueue.getType() == BuildQueue.Type.MIXED) {
                    if (this.indices != null && preferredIndex >= this.indices[0] - 1 && preferredIndex <= this.indices[this.indices.length - 1]) {
                        this.indices = null;
                        return true;
                    }
                    this.numberOfItems = buildQueue.size();
                } else {
                    return false;
                }
            }
            int maxIndex = targetQueue.getSize();
            if (preferredIndex < 0) {
                preferredIndex = maxIndex;
            } else if (++preferredIndex > maxIndex) {
                preferredIndex = maxIndex;
            }
            this.targetIndex = preferredIndex;
            targetQueue.addAll(preferredIndex, buildQueue);
            return true;
        }

        protected void exportDone(JComponent source, Transferable data, int action) {
            if (action == 2 && this.indices != null) {
                int i;
                BuildQueue model = (BuildQueue)((JList)source).getModel();
                if (this.numberOfItems > 0) {
                    for (i = 0; i < this.indices.length; ++i) {
                        if (this.indices[i] <= this.targetIndex) continue;
                        int n = i;
                        this.indices[n] = this.indices[n] + this.numberOfItems;
                    }
                }
                for (i = this.indices.length - 1; i >= 0; --i) {
                    model.remove(this.indices[i]);
                }
            }
            this.indices = null;
            this.targetIndex = -1;
            this.numberOfItems = 0;
        }

        public boolean canImport(JComponent comp, DataFlavor[] flavors) {
            if (flavors == null) {
                System.out.println("flavors == null");
                return false;
            }
            BuildQueue buildQueue = (BuildQueue)((JList)comp).getModel();
            for (DataFlavor flavor : flavors) {
                if (!flavor.equals(this.buildQueueFlavor)) continue;
                return true;
            }
            return false;
        }

        protected Transferable createTransferable(JComponent comp) {
            if (comp instanceof JList) {
                this.source = (JList)comp;
                this.indices = this.source.getSelectedIndices();
                BuildQueue buildQueue = new BuildQueue(this.source.getSelectedValues());
                return new BuildQueueTransferable(buildQueue);
            }
            return null;
        }

        public int getSourceActions(JComponent comp) {
            BuildQueue buildQueue = (BuildQueue)((JList)comp).getModel();
            if (buildQueue.isReadOnly()) {
                return 1;
            }
            return 2;
        }

        public class BuildQueueTransferable
        implements Transferable {
            private BuildQueue buildQueue;
            private final DataFlavor[] supportedFlavors;

            public BuildQueueTransferable(BuildQueue buildQueue) {
                this.supportedFlavors = new DataFlavor[]{BuildQueueTransferHandler.this.buildQueueFlavor};
                this.buildQueue = buildQueue;
            }

            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                if (this.isDataFlavorSupported(flavor)) {
                    return this.buildQueue;
                }
                throw new UnsupportedFlavorException(flavor);
            }

            public DataFlavor[] getTransferDataFlavors() {
                return this.supportedFlavors;
            }

            public boolean isDataFlavorSupported(DataFlavor flavor) {
                for (DataFlavor myFlavor : this.supportedFlavors) {
                    if (!myFlavor.equals(flavor)) continue;
                    return true;
                }
                return false;
            }
        }
    }
}

