/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Unit;

public class BuildingProductionPanel
extends FreeColPanel
implements ActionListener {
    private final JButton okButton = new JButton(Messages.message("ok", new String[0]));
    private final Canvas parent;

    public BuildingProductionPanel(Canvas canvas, Unit unit) {
        this.parent = canvas;
        Colony colony = unit.getColony();
        Building building = unit.getWorkLocation();
        GoodsType goodsType = building.getGoodsOutputType();
        Set<Modifier> basicModifiers = building.getProductivityModifiers(unit);
        basicModifiers.addAll(unit.getColony().getModifierSet(goodsType.getId()));
        Set<Modifier> modifiers = this.sortModifiers(basicModifiers);
        if (colony.getProductionBonus() != 0) {
            modifiers.add(colony.getProductionModifier(goodsType));
        }
        int numberOfModifiers = modifiers.size();
        int extraRows = 4;
        int numberOfRows = 2 * (numberOfModifiers + extraRows) - 1;
        int[] widths = new int[]{0, 20, 0, 0};
        int[] heights = new int[numberOfRows];
        int labelColumn = 1;
        int valueColumn = 3;
        int percentageColumn = 4;
        for (int index = 1; index < numberOfRows; index += 2) {
            heights[index] = 3;
        }
        this.okButton.setActionCommand("ok");
        this.okButton.addActionListener(this);
        BuildingProductionPanel.enterPressesWhenFocused(this.okButton);
        this.setLayout(new HIGLayout(widths, heights));
        int row = 1;
        this.add((Component)new JLabel(building.getName()), higConst.rc(row, labelColumn));
        this.add((Component)new UnitLabel(unit, this.parent, false, true), higConst.rc(row += 2, labelColumn));
        this.add((Component)new JLabel(this.parent.getGUI().getImageLibrary().getGoodsImageIcon(goodsType)), higConst.rc(row, valueColumn));
        row += 2;
        for (Modifier modifier : modifiers) {
            FreeColGameObjectType source = modifier.getSource();
            String sourceName = source == null ? "???" : source.getName();
            this.add((Component)new JLabel(sourceName), higConst.rc(row, labelColumn));
            String bonus = BuildingProductionPanel.getModifierFormat().format(modifier.getValue());
            switch (modifier.getType()) {
                case ADDITIVE: {
                    if (!(modifier.getValue() > 0.0f)) break;
                    bonus = "+" + bonus;
                    break;
                }
                case PERCENTAGE: {
                    if (modifier.getValue() > 0.0f) {
                        bonus = "+" + bonus;
                    }
                    this.add((Component)new JLabel("%"), higConst.rc(row, percentageColumn));
                    break;
                }
                case MULTIPLICATIVE: {
                    bonus = "\u00d7" + bonus;
                    break;
                }
            }
            this.add((Component)new JLabel(bonus), higConst.rc(row, valueColumn, "r"));
            row += 2;
        }
        Font bigFont = this.getFont().deriveFont(1, 20.0f);
        int result = (int)FeatureContainer.applyModifierSet(0.0f, building.getGame().getTurn(), basicModifiers) + colony.getProductionBonus();
        JLabel finalLabel = new JLabel(Messages.message("modifiers.finalResult.name", new String[0]));
        finalLabel.setFont(bigFont);
        this.add((Component)finalLabel, higConst.rc(row, labelColumn));
        JLabel finalResult = new JLabel(BuildingProductionPanel.getModifierFormat().format(result));
        finalResult.setFont(bigFont);
        this.add((Component)finalResult, higConst.rc(row, valueColumn, "r"));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setOpaque(false);
        buttonPanel.add(this.okButton);
        this.add((Component)buttonPanel, higConst.rcwh(heights.length, 1, widths.length, 1));
        this.setSize(this.getPreferredSize());
    }

    public void requestFocus() {
        this.okButton.requestFocus();
    }

    public void actionPerformed(ActionEvent event) {
        this.parent.remove(this);
    }
}

