/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Unit;

public final class CaptureGoodsDialog
extends FreeColDialog
implements ActionListener {
    private static final Logger logger = Logger.getLogger(CaptureGoodsDialog.class.getName());
    private final Canvas parent;
    private JButton allButton;
    private JButton noneButton;
    private JButton acceptButton;
    private JList goodsList;
    private int maxCargo;

    public CaptureGoodsDialog(Canvas parent) {
        this.parent = parent;
        this.setBorder(null);
        this.setOpaque(false);
        this.allButton = new JButton(Messages.message("all", new String[0]));
        this.noneButton = new JButton(Messages.message("none", new String[0]));
        this.acceptButton = new JButton(Messages.message("accept", new String[0]));
        this.goodsList = new JList();
        this.goodsList.setCellRenderer(new CheckBoxRenderer());
        this.goodsList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                int selectedIndex = CaptureGoodsDialog.this.goodsList.locationToIndex(me.getPoint());
                if (selectedIndex < 0) {
                    return;
                }
                GoodsItem item = (GoodsItem)CaptureGoodsDialog.this.goodsList.getModel().getElementAt(selectedIndex);
                if (item.isEnabled()) {
                    item.setSelected(!item.isSelected());
                }
                CaptureGoodsDialog.this.updateComponents();
            }
        });
        JScrollPane goodsListScroll = new JScrollPane(this.goodsList, 20, 31);
        goodsListScroll.setSize(140, 150);
        goodsListScroll.setLocation(10, 10);
        this.allButton.setLocation(10, 170);
        this.noneButton.setLocation(85, 170);
        this.acceptButton.setLocation(35, 200);
        this.allButton.setSize(65, 20);
        this.noneButton.setSize(64, 20);
        this.acceptButton.setSize(80, 20);
        CaptureGoodsDialog.enterPressesWhenFocused(this.allButton);
        CaptureGoodsDialog.enterPressesWhenFocused(this.noneButton);
        CaptureGoodsDialog.enterPressesWhenFocused(this.acceptButton);
        this.add(goodsListScroll);
        this.add(this.allButton);
        this.add(this.noneButton);
        this.add(this.acceptButton);
        this.setLayout(null);
        this.allButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < CaptureGoodsDialog.this.goodsList.getModel().getSize() && i < CaptureGoodsDialog.this.maxCargo; ++i) {
                    GoodsItem gi = (GoodsItem)CaptureGoodsDialog.this.goodsList.getModel().getElementAt(i);
                    gi.setSelected(true);
                    CaptureGoodsDialog.this.updateComponents();
                }
            }
        });
        this.noneButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < CaptureGoodsDialog.this.goodsList.getModel().getSize(); ++i) {
                    GoodsItem gi = (GoodsItem)CaptureGoodsDialog.this.goodsList.getModel().getElementAt(i);
                    gi.setSelected(false);
                    CaptureGoodsDialog.this.updateComponents();
                }
            }
        });
        this.noneButton.setMnemonic('n');
        this.allButton.setMnemonic('l');
        this.acceptButton.setMnemonic('a');
    }

    public void requestFocus() {
        this.acceptButton.requestFocus();
    }

    private void updateComponents() {
        GoodsItem gi;
        int i;
        int selectedCount = 0;
        for (i = 0; i < this.goodsList.getModel().getSize(); ++i) {
            gi = (GoodsItem)this.goodsList.getModel().getElementAt(i);
            if (!gi.isSelected()) continue;
            ++selectedCount;
        }
        if (selectedCount >= this.maxCargo) {
            this.allButton.setEnabled(false);
            for (i = 0; i < this.goodsList.getModel().getSize(); ++i) {
                gi = (GoodsItem)this.goodsList.getModel().getElementAt(i);
                if (gi.isSelected()) continue;
                gi.setEnabled(false);
            }
        } else {
            this.allButton.setEnabled(true);
            for (i = 0; i < this.goodsList.getModel().getSize(); ++i) {
                gi = (GoodsItem)this.goodsList.getModel().getElementAt(i);
                if (gi.isSelected()) continue;
                gi.setEnabled(true);
            }
        }
        this.goodsList.repaint();
    }

    public void initialize(Unit capturedUnit, Unit capturingUnit) {
        this.maxCargo = capturingUnit.getType().getSpace();
        GoodsItem[] goods = new GoodsItem[capturedUnit.getGoodsCount()];
        if (goods.length > 0) {
            Iterator<Goods> iter = capturedUnit.getGoodsIterator();
            int i = 0;
            while (iter.hasNext()) {
                Goods g = iter.next();
                goods[i] = new GoodsItem(g);
                ++i;
            }
        }
        this.goodsList.setListData(goods);
    }

    public void actionPerformed(ActionEvent e) {
        ArrayList<Goods> list = new ArrayList<Goods>(4);
        for (int i = 0; i < this.goodsList.getModel().getSize(); ++i) {
            GoodsItem gi = (GoodsItem)this.goodsList.getModel().getElementAt(i);
            if (!gi.isSelected()) continue;
            list.add(gi.getGoods());
        }
        this.setResponse(list);
    }

    class GoodsItem
    extends JCheckBox {
        private Goods good;

        public GoodsItem(Goods good) {
            this.good = good;
        }

        public Goods getGoods() {
            return this.good;
        }

        public String toString() {
            return this.good.getAmount() + " " + this.good.getType().getName();
        }
    }

    private class CheckBoxRenderer
    extends JCheckBox
    implements ListCellRenderer {
        public CheckBoxRenderer() {
            this.setBackground(UIManager.getColor("List.textBackground"));
            this.setForeground(UIManager.getColor("List.textForeground"));
        }

        public Component getListCellRendererComponent(JList listBox, Object obj, int currentindex, boolean isChecked, boolean hasFocus) {
            this.setSelected(((GoodsItem)obj).isSelected());
            this.setText(((GoodsItem)obj).toString());
            this.setEnabled(((GoodsItem)obj).isEnabled());
            return this;
        }
    }
}

