/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ColonyPanel;
import net.sf.freecol.client.gui.panel.DefaultTransferHandler;
import net.sf.freecol.client.gui.panel.DragListener;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.GoodsLabel;
import net.sf.freecol.client.gui.panel.MarketLabel;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;

public class CargoPanel
extends FreeColPanel {
    private Unit carrier;
    private final DefaultTransferHandler defaultTransferHandler;
    private final MouseListener pressListener;
    private final TitledBorder border;
    private boolean editable = true;
    private JPanel parentPanel;

    public CargoPanel(Canvas parent, boolean withTitle) {
        super(parent);
        this.defaultTransferHandler = new DefaultTransferHandler(parent, this);
        this.pressListener = new DragListener(this);
        this.border = withTitle ? BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), Messages.message("cargoOnCarrier", new String[0])) : null;
        this.setBorder(this.border);
        this.initialize();
    }

    public String getUIClassID() {
        return "CargoPanelUI";
    }

    public final JPanel getParentPanel() {
        return this.parentPanel;
    }

    public final void setParentPanel(JPanel newParentPanel) {
        this.parentPanel = newParentPanel;
    }

    public Unit getCarrier() {
        return this.carrier;
    }

    public void setCarrier(Unit newCarrier) {
        this.carrier = newCarrier;
        this.initialize();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean newEditable) {
        this.editable = newEditable;
    }

    public void initialize() {
        this.removeAll();
        if (this.carrier != null) {
            Iterator<Unit> unitIterator = this.carrier.getUnitIterator();
            while (unitIterator.hasNext()) {
                Unit unit = unitIterator.next();
                UnitLabel label = new UnitLabel(unit, this.getCanvas());
                if (this.isEditable()) {
                    label.setTransferHandler(this.defaultTransferHandler);
                    label.addMouseListener(this.pressListener);
                }
                this.add(label);
            }
            Iterator<Goods> goodsIterator = this.carrier.getGoodsIterator();
            while (goodsIterator.hasNext()) {
                Goods g = goodsIterator.next();
                GoodsLabel label = new GoodsLabel(g, this.getCanvas());
                if (this.isEditable()) {
                    label.setTransferHandler(this.defaultTransferHandler);
                    label.addMouseListener(this.pressListener);
                }
                this.add(label);
            }
        }
        this.updateTitle();
    }

    private void updateTitle() {
        if (this.border == null) {
            return;
        }
        if (this.carrier == null) {
            this.border.setTitle(Messages.message("cargoOnCarrier", new String[0]));
        } else {
            int spaceLeft = this.carrier.getSpaceLeft();
            this.border.setTitle(Messages.message("cargoOnCarrierLong", "%name%", this.carrier.getName(), "%space%", String.valueOf(spaceLeft)));
        }
    }

    public boolean isActive() {
        return this.carrier != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Component add(Component comp, boolean editState) {
        if (this.carrier == null) {
            return null;
        }
        if (editState) {
            InGameController inGameController = this.getCanvas().getClient().getInGameController();
            if (comp instanceof UnitLabel) {
                Container oldParent = comp.getParent();
                Unit unit = ((UnitLabel)comp).getUnit();
                if (!this.carrier.canAdd(unit)) return null;
                ((UnitLabel)comp).setSmall(false);
                if (!inGameController.boardShip(unit, this.carrier)) return null;
                if (oldParent != null) {
                    oldParent.remove(comp);
                    oldParent.repaint();
                }
                this.add(comp);
                this.updateTitle();
                return comp;
            }
            if (comp instanceof GoodsLabel) {
                Goods goods = ((GoodsLabel)comp).getGoods();
                int loadableAmount = this.carrier.getLoadableAmount(goods.getType());
                if (loadableAmount == 0) {
                    return null;
                }
                if (loadableAmount > goods.getAmount()) {
                    loadableAmount = goods.getAmount();
                }
                Goods goodsToAdd = new Goods(goods.getGame(), goods.getLocation(), goods.getType(), loadableAmount);
                goods.setAmount(goods.getAmount() - loadableAmount);
                inGameController.loadCargo(goodsToAdd, this.carrier);
                this.initialize();
                Container oldParent = comp.getParent();
                if (oldParent instanceof ColonyPanel.WarehousePanel) {
                    ((ColonyPanel.WarehousePanel)oldParent).initialize();
                    return comp;
                } else {
                    if (oldParent == null) return comp;
                    oldParent.remove(comp);
                }
                return comp;
            }
            if (!(comp instanceof MarketLabel)) return null;
            MarketLabel label = (MarketLabel)comp;
            Player player = this.carrier.getOwner();
            if (player.canTrade(label.getType())) {
                inGameController.buyGoods(label.getType(), label.getAmount(), this.carrier);
                inGameController.nextModelMessage();
                this.initialize();
                this.updateTitle();
                return comp;
            }
            inGameController.payArrears(label.getType());
            return null;
        }
        super.add(comp);
        return null;
    }

    public void remove(Component comp) {
        InGameController inGameController = this.getCanvas().getClient().getInGameController();
        if (comp instanceof UnitLabel) {
            Unit unit = ((UnitLabel)comp).getUnit();
            inGameController.leaveShip(unit);
            this.updateTitle();
            super.remove(comp);
        } else if (comp instanceof GoodsLabel) {
            Goods g = ((GoodsLabel)comp).getGoods();
            inGameController.unloadCargo(g);
            this.updateTitle();
            super.remove(comp);
        }
    }
}

