/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.panel.FreeColPanel;

public final class ChatPanel
extends FreeColPanel
implements ActionListener {
    private static final Logger logger = Logger.getLogger(ChatPanel.class.getName());
    public static final int CHAT = 1;
    private final Canvas parent;
    private final FreeColClient freeColClient;
    private final JTextField field;

    public ChatPanel(Canvas parent, FreeColClient freeColClient) {
        this.parent = parent;
        this.freeColClient = freeColClient;
        JLabel label = new JLabel("Message: ");
        this.field = new JTextField("", 40);
        this.setLayout(new BorderLayout(10, 10));
        this.field.setActionCommand(String.valueOf(1));
        this.field.addActionListener(this);
        this.add(label);
        this.add(this.field);
        label.setFocusable(false);
        this.field.setFocusable(true);
        this.setSize(this.getPreferredSize());
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        try {
            switch (Integer.valueOf(command)) {
                case 1: {
                    String message = this.getChatText();
                    this.freeColClient.getInGameController().sendChat(message);
                    this.parent.displayChatMessage(message);
                    this.parent.remove(this);
                    break;
                }
                default: {
                    logger.warning("Invalid Actioncommand: invalid number.");
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            logger.warning("Invalid Actioncommand: not a number.");
        }
    }

    public String getChatText() {
        String message = this.field.getText();
        this.field.setText("");
        return message;
    }

    public void requestFocus() {
        this.field.requestFocus();
    }
}

