/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.action.MapControlsAction;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.option.OptionMapUI;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.FreeColPanel;

public final class ClientOptionsDialog
extends FreeColDialog
implements ActionListener {
    private static final Logger logger = Logger.getLogger(ClientOptionsDialog.class.getName());
    private static final int OK = 0;
    private static final int CANCEL = 1;
    private static final int RESET = 2;
    private final Canvas parent;
    private final FreeColClient freeColClient;
    private JButton ok;
    private JPanel buttons = new JPanel(new FlowLayout());
    private JLabel header;
    private OptionMapUI ui;

    public ClientOptionsDialog(Canvas parent, FreeColClient freeColClient) {
        this.setLayout(new BorderLayout());
        this.parent = parent;
        this.freeColClient = freeColClient;
        this.ok = new JButton(Messages.message("ok", new String[0]));
        this.ok.setActionCommand(String.valueOf(0));
        this.ok.addActionListener(this);
        this.ok.setMnemonic('O');
        this.buttons.add(this.ok);
        JButton reset = new JButton(Messages.message("reset", new String[0]));
        reset.setActionCommand(String.valueOf(2));
        reset.addActionListener(this);
        reset.setMnemonic('R');
        this.buttons.add(reset);
        JButton cancel = new JButton(Messages.message("cancel", new String[0]));
        cancel.setActionCommand(String.valueOf(1));
        cancel.addActionListener(this);
        cancel.setMnemonic('C');
        this.buttons.add(cancel);
        FreeColPanel.enterPressesWhenFocused(this.ok);
        this.setCancelComponent(cancel);
        this.setSize(750, 540);
    }

    public Dimension getMinimumSize() {
        return new Dimension(750, 540);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void initialize() {
        this.removeAll();
        this.header = new JLabel(this.freeColClient.getClientOptions().getName(), 0);
        this.header.setFont(((Font)UIManager.get("HeaderFont")).deriveFont(0, 48.0f));
        this.header.setBorder(new EmptyBorder(20, 0, 0, 0));
        this.add((Component)this.header, "North");
        JPanel uiPanel = new JPanel(new BorderLayout());
        uiPanel.setOpaque(false);
        this.ui = new OptionMapUI(this.freeColClient.getClientOptions());
        uiPanel.add((Component)this.ui, "Center");
        uiPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)uiPanel, "Center");
        this.add((Component)this.buttons, "South");
    }

    public void requestFocus() {
        this.ok.requestFocus();
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        try {
            switch (Integer.valueOf(command)) {
                case 0: {
                    this.ui.unregister();
                    this.ui.updateOption();
                    this.parent.remove(this);
                    this.freeColClient.saveClientOptions();
                    this.freeColClient.getActionManager().update();
                    if (this.freeColClient.getCanvas().getJMenuBar() != null) {
                        this.freeColClient.getCanvas().resetFreeColMenuBar();
                    }
                    this.setResponse(new Boolean(true));
                    MapControlsAction mca = (MapControlsAction)this.freeColClient.getActionManager().getFreeColAction("mapControlsAction");
                    if (mca.getMapControls() != null) {
                        mca.getMapControls().update();
                    }
                    break;
                }
                case 1: {
                    this.ui.rollback();
                    this.ui.unregister();
                    this.parent.remove(this);
                    this.setResponse(new Boolean(false));
                    break;
                }
                case 2: {
                    this.ui.reset();
                    break;
                }
                default: {
                    logger.warning("Invalid ActionCommand: invalid number.");
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            logger.warning("Invalid Actioncommand: not a number.");
        }
    }
}

