/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ComponentInputMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.CargoPanel;
import net.sf.freecol.client.gui.panel.ChoiceItem;
import net.sf.freecol.client.gui.panel.DefaultTransferHandler;
import net.sf.freecol.client.gui.panel.DragListener;
import net.sf.freecol.client.gui.panel.DropListener;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.FreeColProgressBar;
import net.sf.freecol.client.gui.panel.GoodsLabel;
import net.sf.freecol.client.gui.panel.ProductionLabel;
import net.sf.freecol.client.gui.panel.ProductionMultiplesLabel;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.resources.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ColonyPanel
extends FreeColPanel
implements ActionListener,
PropertyChangeListener {
    private static Logger logger = Logger.getLogger(ColonyPanel.class.getName());
    public static final int SCROLL_AREA_HEIGHT = 40;
    public static final int SCROLL_SPEED = 40;
    private static final int EXIT = 0;
    private static final int BUY_BUILDING = 1;
    private static final int UNLOAD = 2;
    private static final int RENAME = 3;
    private static final int WAREHOUSE = 4;
    private static final int FILL = 5;
    private static final int BORDER_CORRECT = 4;
    private final Canvas parent;
    private final FreeColClient freeColClient;
    private InGameController inGameController;
    private final JLabel solLabel;
    private final FreeColProgressBar hammersLabel;
    private final FreeColProgressBar toolsLabel;
    private final JPanel productionPanel;
    private final JComboBox buildingBox;
    private final ActionListener buildingBoxListener;
    private final JComboBox nameBox;
    private final OutsideColonyPanel outsideColonyPanel;
    private final InPortPanel inPortPanel;
    private final ColonyCargoPanel cargoPanel;
    private final TitledBorder cargoBorder;
    private final WarehousePanel warehousePanel;
    private final TilePanel tilePanel;
    private final BuildingsPanel buildingsPanel;
    private final DefaultTransferHandler defaultTransferHandler;
    private final MouseListener pressListener;
    private final MouseListener releaseListener;
    private Colony colony;
    private Game game;
    private UnitLabel selectedUnit;
    private JButton exitButton = new JButton(Messages.message("close", new String[0]));
    private JButton buyBuilding = new JButton(Messages.message("colonyPanel.buyBuilding", new String[0]));
    private JButton unloadButton = new JButton(Messages.message("unload", new String[0]));
    private JButton fillButton = new JButton(Messages.message("fill", new String[0]));
    private JButton renameButton = new JButton(Messages.message("rename", new String[0]));
    private JButton warehouseButton = new JButton(Messages.message("warehouseDialog.name", new String[0]));
    private static final Font hugeFont = new Font("Dialog", 1, 24);

    public ColonyPanel(Canvas parent, FreeColClient freeColClient) {
        this.parent = parent;
        this.freeColClient = freeColClient;
        this.inGameController = freeColClient.getInGameController();
        this.setFocusCycleRoot(true);
        ComponentInputMap closeInputMap = new ComponentInputMap(this.exitButton);
        ((InputMap)closeInputMap).put(KeyStroke.getKeyStroke(27, 0, false), "pressed");
        ((InputMap)closeInputMap).put(KeyStroke.getKeyStroke(27, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.exitButton, 2, closeInputMap);
        ComponentInputMap unloadInputMap = new ComponentInputMap(this.unloadButton);
        ((InputMap)unloadInputMap).put(KeyStroke.getKeyStroke(85, 0, false), "pressed");
        ((InputMap)unloadInputMap).put(KeyStroke.getKeyStroke(85, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.unloadButton, 2, unloadInputMap);
        ComponentInputMap fillInputMap = new ComponentInputMap(this.fillButton);
        ((InputMap)fillInputMap).put(KeyStroke.getKeyStroke(76, 0, false), "pressed");
        ((InputMap)fillInputMap).put(KeyStroke.getKeyStroke(76, 0, true), "released");
        SwingUtilities.replaceUIInputMap(this.fillButton, 2, fillInputMap);
        this.productionPanel = new JPanel();
        this.productionPanel.setOpaque(false);
        this.outsideColonyPanel = new OutsideColonyPanel(this);
        this.inPortPanel = new InPortPanel();
        this.warehousePanel = new WarehousePanel(this);
        this.tilePanel = new TilePanel(this);
        this.buildingsPanel = new BuildingsPanel(this);
        this.cargoPanel = new ColonyCargoPanel(parent);
        this.cargoPanel.setParentPanel(this);
        this.defaultTransferHandler = new DefaultTransferHandler(parent, this);
        this.pressListener = new DragListener(this);
        this.releaseListener = new DropListener();
        this.outsideColonyPanel.setLayout(new GridLayout(0, 2));
        this.inPortPanel.setLayout(new GridLayout(0, 2));
        this.cargoPanel.setLayout(new GridLayout(1, 0));
        this.warehousePanel.setLayout(new GridLayout(2, 8));
        this.solLabel = new JLabel(Messages.message("sonsOfLiberty", new String[0]) + ": 0%, " + Messages.message("tory", new String[0]) + ": 100%");
        this.hammersLabel = new FreeColProgressBar(parent, Goods.HAMMERS);
        this.toolsLabel = new FreeColProgressBar(parent, Goods.TOOLS);
        this.buildingBox = new JComboBox();
        this.buildingBoxListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ColonyPanel.this.getClient().getInGameController().setCurrentlyBuilding(ColonyPanel.this.getColony(), (BuildableType)ColonyPanel.this.buildingBox.getSelectedItem());
                ColonyPanel.this.updateProgressLabel();
            }
        };
        this.buildingBox.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                BuildableType type = (BuildableType)value;
                String requirements = type.getGoodsRequiredAsString();
                if ("".equals(requirements)) {
                    return new JLabel(type.getName());
                }
                return new JLabel(new String(type.getName() + " (" + requirements + ")"));
            }
        });
        JScrollPane outsideColonyScroll = new JScrollPane(this.outsideColonyPanel, 20, 31);
        outsideColonyScroll.getVerticalScrollBar().setUnitIncrement(16);
        JScrollPane inPortScroll = new JScrollPane(this.inPortPanel, 20, 31);
        inPortScroll.getVerticalScrollBar().setUnitIncrement(16);
        JScrollPane cargoScroll = new JScrollPane(this.cargoPanel, 21, 30);
        JScrollPane warehouseScroll = new JScrollPane(this.warehousePanel, 21, 30);
        JScrollPane tilesScroll = new JScrollPane(this.tilePanel, 20, 30);
        JScrollPane buildingsScroll = new JScrollPane(this.buildingsPanel, 20, 30);
        buildingsScroll.getVerticalScrollBar().setUnitIncrement(16);
        this.nameBox = new JComboBox();
        this.nameBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ColonyPanel.this.initialize((Colony)ColonyPanel.this.nameBox.getSelectedItem(), ColonyPanel.this.getGame());
            }
        });
        this.nameBox.setFont(smallHeaderFont);
        buildingsScroll.setAutoscrolls(true);
        tilesScroll.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), Messages.message("surroundingArea", new String[0])), new BevelBorder(1)));
        buildingsScroll.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), Messages.message("buildings", new String[0])), BorderFactory.createEtchedBorder()));
        warehouseScroll.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), Messages.message("goods", new String[0])), BorderFactory.createEtchedBorder()));
        this.cargoBorder = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), Messages.message("cargoOnCarrier", new String[0]));
        cargoScroll.setBorder(BorderFactory.createCompoundBorder(this.cargoBorder, BorderFactory.createEtchedBorder()));
        inPortScroll.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), Messages.message("inPort", new String[0])), BorderFactory.createEtchedBorder()));
        outsideColonyScroll.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), Messages.message("outsideColony", new String[0])), BorderFactory.createEtchedBorder()));
        Border correctBorder = BorderFactory.createEmptyBorder(0, 4, 0, 4);
        this.productionPanel.setBorder(correctBorder);
        this.solLabel.setBorder(correctBorder);
        this.unloadButton.setBorder(BorderFactory.createCompoundBorder(correctBorder, this.unloadButton.getBorder()));
        this.fillButton.setBorder(BorderFactory.createCompoundBorder(correctBorder, this.fillButton.getBorder()));
        this.exitButton.setBorder(BorderFactory.createCompoundBorder(correctBorder, this.exitButton.getBorder()));
        this.warehouseButton.setBorder(BorderFactory.createCompoundBorder(correctBorder, this.warehouseButton.getBorder()));
        this.renameButton.setBorder(BorderFactory.createCompoundBorder(correctBorder, this.renameButton.getBorder()));
        this.buyBuilding.setBorder(BorderFactory.createCompoundBorder(correctBorder, this.buyBuilding.getBorder()));
        this.hammersLabel.setBorder(BorderFactory.createCompoundBorder(correctBorder, this.hammersLabel.getBorder()));
        this.toolsLabel.setBorder(BorderFactory.createCompoundBorder(correctBorder, this.toolsLabel.getBorder()));
        this.buildingBox.setBorder(BorderFactory.createCompoundBorder(correctBorder, this.buildingBox.getBorder()));
        this.buyBuilding.setActionCommand(String.valueOf(1));
        this.exitButton.setActionCommand(String.valueOf(0));
        this.unloadButton.setActionCommand(String.valueOf(2));
        this.fillButton.setActionCommand(String.valueOf(5));
        this.renameButton.setActionCommand(String.valueOf(3));
        this.warehouseButton.setActionCommand(String.valueOf(4));
        ColonyPanel.enterPressesWhenFocused(this.buyBuilding);
        ColonyPanel.enterPressesWhenFocused(this.exitButton);
        ColonyPanel.enterPressesWhenFocused(this.unloadButton);
        ColonyPanel.enterPressesWhenFocused(this.fillButton);
        ColonyPanel.enterPressesWhenFocused(this.renameButton);
        ColonyPanel.enterPressesWhenFocused(this.warehouseButton);
        this.buyBuilding.addActionListener(this);
        this.exitButton.addActionListener(this);
        this.unloadButton.addActionListener(this);
        this.fillButton.addActionListener(this);
        this.renameButton.addActionListener(this);
        this.warehouseButton.addActionListener(this);
        this.selectedUnit = null;
        this.addMouseListener(new MouseAdapter(){});
        int[] widths = new int[]{125, 125, 3, 138, 3, 215, 3, 204};
        int[] heights = new int[]{0, 3, 225, 3, 28, 3, 28, 3, 120, 3, 140, 3, 0};
        this.setLayout(new HIGLayout(widths, heights));
        int row = 1;
        this.add((Component)this.nameBox, higConst.rcwh(row, 1, 8, 1, ""));
        this.add((Component)tilesScroll, higConst.rcwh(row += 2, 1, 4, 1));
        this.add((Component)buildingsScroll, higConst.rcwh(row, 6, 3, 1));
        this.add((Component)this.productionPanel, higConst.rcwh(row += 2, 1, 4, 1, "tl"));
        this.add((Component)this.buildingBox, higConst.rc(row, 6));
        this.add((Component)this.hammersLabel, higConst.rc(row, 8));
        this.add((Component)this.solLabel, higConst.rcwh(row += 2, 1, 4, 1));
        this.add((Component)this.buyBuilding, higConst.rc(row, 6));
        this.add((Component)this.toolsLabel, higConst.rc(row, 8));
        this.add((Component)inPortScroll, higConst.rcwh(row += 2, 1, 2, 1));
        this.add((Component)cargoScroll, higConst.rcwh(row, 4, 3, 1));
        this.add((Component)outsideColonyScroll, higConst.rcwh(row, 8, 1, 3));
        this.add((Component)warehouseScroll, higConst.rcwh(row += 2, 1, 6, 1));
        this.add((Component)this.unloadButton, higConst.rc(row += 2, 1, "l"));
        this.add((Component)this.fillButton, higConst.rc(row, 2, "l"));
        this.add((Component)this.warehouseButton, higConst.rc(row, 4, "l"));
        this.add((Component)this.renameButton, higConst.rc(row, 6, "r"));
        this.add((Component)this.exitButton, higConst.rc(row, 8, "r"));
        this.setSize(this.getPreferredSize());
    }

    private Canvas getParentCanvas() {
        return this.parent;
    }

    @Override
    public void requestFocus() {
        this.exitButton.requestFocus();
    }

    public void refresh() {
        this.repaint(0, 0, this.getWidth(), this.getHeight());
    }

    public void initialize(Colony colony, Game game) {
        this.initialize(colony, game, null);
    }

    public void initialize(Colony colony, Game game, Unit preSelectedUnit) {
        this.setColony(colony);
        this.game = game;
        this.outsideColonyPanel.removeMouseListener(this.releaseListener);
        this.inPortPanel.removeMouseListener(this.releaseListener);
        this.cargoPanel.removeMouseListener(this.releaseListener);
        this.warehousePanel.removeMouseListener(this.releaseListener);
        if (this.isEditable()) {
            this.outsideColonyPanel.setTransferHandler(this.defaultTransferHandler);
            this.inPortPanel.setTransferHandler(this.defaultTransferHandler);
            this.cargoPanel.setTransferHandler(this.defaultTransferHandler);
            this.warehousePanel.setTransferHandler(this.defaultTransferHandler);
            this.outsideColonyPanel.addMouseListener(this.releaseListener);
            this.inPortPanel.addMouseListener(this.releaseListener);
            this.cargoPanel.addMouseListener(this.releaseListener);
            this.warehousePanel.addMouseListener(this.releaseListener);
        } else {
            this.outsideColonyPanel.setTransferHandler(null);
            this.inPortPanel.setTransferHandler(null);
            this.cargoPanel.setTransferHandler(null);
            this.warehousePanel.setTransferHandler(null);
        }
        this.buyBuilding.setEnabled(this.isEditable());
        this.unloadButton.setEnabled(this.isEditable());
        this.fillButton.setEnabled(this.isEditable());
        this.renameButton.setEnabled(this.isEditable());
        this.warehouseButton.setEnabled(this.isEditable());
        this.buildingBox.setEnabled(this.isEditable());
        this.nameBox.setEnabled(this.isEditable());
        this.cargoPanel.removeAll();
        this.warehousePanel.removeAll();
        this.outsideColonyPanel.removeAll();
        this.inPortPanel.removeAll();
        this.tilePanel.removeAll();
        Tile tile = colony.getTile();
        UnitLabel lastCarrier = null;
        UnitLabel preSelectedUnitLabel = null;
        this.selectedUnit = null;
        Iterator<Unit> tileUnitIterator = tile.getUnitIterator();
        while (tileUnitIterator.hasNext()) {
            Unit unit = tileUnitIterator.next();
            UnitLabel unitLabel = new UnitLabel(unit, this.parent);
            if (this.isEditable()) {
                unitLabel.setTransferHandler(this.defaultTransferHandler);
            }
            if (this.isEditable() || unit.isCarrier()) {
                unitLabel.addMouseListener(this.pressListener);
            }
            if (!unit.isCarrier()) {
                this.outsideColonyPanel.add((Component)unitLabel, false);
                continue;
            }
            TradeRoute tradeRoute = unit.getTradeRoute();
            if (tradeRoute != null) {
                unitLabel.setDescriptionLabel(unit.getName() + " (" + tradeRoute.getName() + ")");
            }
            this.inPortPanel.add(unitLabel);
            lastCarrier = unitLabel;
            if (unit != preSelectedUnit) continue;
            preSelectedUnitLabel = unitLabel;
        }
        if (preSelectedUnitLabel == null) {
            this.setSelectedUnitLabel(lastCarrier);
        } else {
            this.setSelectedUnitLabel(preSelectedUnitLabel);
        }
        this.updateCarrierButtons();
        this.warehousePanel.initialize();
        this.buildingsPanel.initialize();
        this.tilePanel.initialize();
        this.updateBuildingBox();
        this.updateNameBox();
        this.updateProductionPanel();
        this.updateSoLLabel();
        this.updateProgressLabel();
    }

    public void reinitialize() {
        if (this.selectedUnit != null) {
            this.initialize(this.getColony(), this.game, this.selectedUnit.getUnit());
        } else {
            this.initialize(this.getColony(), this.game, null);
        }
    }

    private void updateCarrierButtons() {
        Unit unit;
        this.unloadButton.setEnabled(false);
        this.fillButton.setEnabled(false);
        if (!this.isEditable()) {
            return;
        }
        if (this.selectedUnit != null && (unit = this.selectedUnit.getUnit()) != null && unit.isCarrier() && unit.getSpaceLeft() < unit.getType().getSpace()) {
            this.unloadButton.setEnabled(true);
            for (Goods goods : unit.getGoodsList()) {
                if (this.getColony().getGoodsCount(goods.getType()) <= 0) continue;
                this.fillButton.setEnabled(true);
                return;
            }
        }
    }

    private void updateCargoLabel() {
        if (this.cargoPanel.getCarrier() != null) {
            Unit carrier = this.cargoPanel.getCarrier();
            this.cargoPanel.getParent().setEnabled(true);
            int spaceLeft = carrier.getSpaceLeft();
            this.cargoBorder.setTitle(Messages.message("cargoOnCarrierLong", "%name%", carrier.getName(), "%space%", String.valueOf(spaceLeft)));
        } else {
            this.cargoPanel.getParent().setEnabled(false);
            this.cargoBorder.setTitle(Messages.message("cargoOnCarrier", new String[0]));
        }
    }

    private void updateSoLLabel() {
        if (this.getColony() == null) {
            logger.warning("Colony panel has 'null' colony.");
            return;
        }
        this.solLabel.setText(Messages.message("colonyPanel.solLabel", "%solPercent%", Integer.toString(this.getColony().getSoL()), "%solNumber%", Integer.toString(this.getColony().getMembers()), "%toryPercent%", Integer.toString(this.getColony().getTory()), "%toryNumber%", Integer.toString(this.getColony().getUnitCount() - this.getColony().getMembers()), "%bonus%", Integer.toString(this.getColony().getProductionBonus())));
    }

    public void updateNameBox() {
        ActionListener[] listeners;
        for (ActionListener al : listeners = this.nameBox.getActionListeners()) {
            this.nameBox.removeActionListener(al);
        }
        if (this.getColony() == null) {
            return;
        }
        this.nameBox.removeAllItems();
        List<Colony> settlements = this.getColony().getOwner().getColonies();
        this.sortColonies(settlements);
        for (Colony colony : settlements) {
            this.nameBox.addItem(colony);
        }
        this.nameBox.setSelectedItem(this.getColony());
        for (ActionListener al : listeners) {
            this.nameBox.addActionListener(al);
        }
    }

    private void sortBuildings(List<Building> buildings) {
        Collections.sort(buildings, Building.getBuildingComparator());
    }

    private void sortColonies(List<Colony> colonies) {
        Collections.sort(colonies, this.freeColClient.getClientOptions().getColonyComparator());
    }

    public void updateBuildingBox() {
        this.buildingBox.removeActionListener(this.buildingBoxListener);
        this.buildingBox.removeAllItems();
        this.buildingBox.addItem(BuildableType.NOTHING);
        BuildableType currentlyBuilding = this.getColony().getCurrentlyBuilding();
        ArrayList<BuildingType> buildableTypes = new ArrayList<BuildingType>(FreeCol.getSpecification().getBuildingTypeList());
        buildableTypes.addAll(FreeCol.getSpecification().getUnitTypeList());
        for (BuildableType buildableType : buildableTypes) {
            if (!this.getColony().canBuild(buildableType)) continue;
            this.buildingBox.addItem(buildableType);
            if (buildableType != currentlyBuilding) continue;
            this.buildingBox.setSelectedIndex(this.buildingBox.getItemCount() - 1);
        }
        this.buildingBox.addActionListener(this.buildingBoxListener);
        this.updateProgressLabel();
    }

    public void updateWarehouse() {
        this.warehousePanel.initialize();
    }

    public void updateBuildingsPanel() {
        this.buildingsPanel.initialize();
        this.buildingsPanel.revalidate();
    }

    public void updateBuildingsPanel(GoodsType goodsType) {
        for (Component component : this.buildingsPanel.getComponents()) {
            BuildingsPanel.ASingleBuildingPanel buildingPanel;
            if (!(component instanceof BuildingsPanel.ASingleBuildingPanel) || (buildingPanel = (BuildingsPanel.ASingleBuildingPanel)component).getBuilding().getGoodsInputType() != goodsType) continue;
            buildingPanel.updateProductionLabel();
            this.buildingsPanel.revalidate();
        }
        this.buildingsPanel.revalidate();
    }

    private void updateProgressLabel() {
        if (this.getColony() == null) {
            return;
        }
        if (this.getColony().getCurrentlyBuilding() == BuildableType.NOTHING) {
            this.hammersLabel.update(0, 0, 0, 0);
            this.toolsLabel.update(0, 0, 0, 0);
            this.buyBuilding.setEnabled(false);
        } else {
            int hammers = this.getColony().getGoodsCount(Goods.HAMMERS);
            int tools = this.getColony().getGoodsCount(Goods.TOOLS);
            int nextHammers = this.getColony().getBuildingForProducing(Goods.HAMMERS).getProductionNextTurn();
            int nextTools = this.getColony().getBuildingForProducing(Goods.TOOLS).getProductionNextTurn();
            GoodsType produced = Goods.TOOLS.getProducedMaterial();
            if (produced != null) {
                nextTools -= this.getColony().getProductionNextTurn(produced);
            }
            int hammersNeeded = 0;
            int toolsNeeded = 0;
            for (AbstractGoods requiredGoods : this.getColony().getCurrentlyBuilding().getGoodsRequired()) {
                if (requiredGoods.getType() == Goods.HAMMERS) {
                    hammersNeeded = Math.max(requiredGoods.getAmount(), 0);
                    continue;
                }
                if (requiredGoods.getType() != Goods.TOOLS) continue;
                toolsNeeded = Math.max(requiredGoods.getAmount(), 0);
            }
            this.hammersLabel.update(0, hammersNeeded, hammers, nextHammers);
            this.toolsLabel.update(0, toolsNeeded, tools, nextTools);
            int price = this.getColony().getPriceForBuilding();
            if (this.getColony().getCurrentlyBuilding() instanceof BuildingType) {
                this.buyBuilding.setText(Messages.message("colonyPanel.buyBuilding", new String[0]));
            } else if (this.getColony().getCurrentlyBuilding() instanceof UnitType) {
                this.buyBuilding.setText(Messages.message("colonyPanel.buyUnit", new String[0]));
            }
            this.buyBuilding.setEnabled(this.isEditable() && price > 0 && price <= this.freeColClient.getMyPlayer().getGold());
        }
    }

    private void updateOutsideColonyPanel() {
        if (this.getColony() == null) {
            return;
        }
        this.outsideColonyPanel.removeAll();
        Tile tile = this.getColony().getTile();
        Iterator<Unit> tileUnitIterator = tile.getUnitIterator();
        while (tileUnitIterator.hasNext()) {
            Unit unit = tileUnitIterator.next();
            UnitLabel unitLabel = new UnitLabel(unit, this.parent);
            if (this.isEditable()) {
                unitLabel.setTransferHandler(this.defaultTransferHandler);
                unitLabel.addMouseListener(this.pressListener);
            }
            if (unit.isCarrier()) continue;
            this.outsideColonyPanel.add((Component)unitLabel, false);
        }
    }

    public void updateProductionPanel() {
        this.productionPanel.removeAll();
        int foodFarmsProduction = this.colony.getProductionOf(Goods.FOOD);
        int foodFishProduction = this.colony.getProductionOf(Goods.FISH);
        int humanFoodConsumption = this.colony.getFoodConsumption();
        int horsesProduced = this.colony.getProductionOf(Goods.HORSES);
        int horseStock = this.colony.getGoodsCount(Goods.HORSES);
        int bells = this.colony.getProductionOf(Goods.BELLS);
        int crosses = this.colony.getProductionOf(Goods.CROSSES);
        int foodProduction = foodFarmsProduction + foodFishProduction;
        horsesProduced = horseStock <= 0 ? 0 : horsesProduced;
        int usedFood = Math.min(humanFoodConsumption, foodProduction) + horsesProduced;
        int usedFish = this.colony.getFoodConsumptionByType(Goods.FISH);
        int usedCorn = Math.max(usedFood - usedFish, 0);
        if (usedFish == 0) {
            this.productionPanel.add(new ProductionLabel(Goods.FOOD, usedFood, this.parent));
        } else {
            this.productionPanel.add(new ProductionMultiplesLabel(Goods.FOOD, usedCorn, Goods.FISH, usedFish, this.parent));
        }
        int remainingCorn = foodFarmsProduction - usedCorn;
        int remainingFish = foodFishProduction - usedFish;
        int surplusFood = foodProduction - humanFoodConsumption - horsesProduced;
        remainingCorn = Math.min(surplusFood, remainingCorn);
        ProductionMultiplesLabel surplusLabel = new ProductionMultiplesLabel(Goods.FOOD, remainingCorn, Goods.FISH, remainingFish, this.parent);
        surplusLabel.setDrawPlus(true);
        this.productionPanel.add(surplusLabel);
        if (horsesProduced != 0) {
            ProductionLabel horseLabel = new ProductionLabel(Goods.HORSES, horsesProduced, this.parent);
            horseLabel.setMaxGoodsIcons(1);
            this.productionPanel.add(horseLabel);
        }
        this.productionPanel.add(new ProductionLabel(Goods.BELLS, bells, this.parent));
        int surplusBells = bells - this.colony.getBellUpkeep();
        this.productionPanel.add(new ProductionLabel(Goods.BELLS, surplusBells, this.parent));
        this.productionPanel.add(new ProductionLabel(Goods.CROSSES, crosses, this.parent));
        this.productionPanel.revalidate();
    }

    public Unit getSelectedUnit() {
        if (this.selectedUnit == null) {
            return null;
        }
        return this.selectedUnit.getUnit();
    }

    public UnitLabel getSelectedUnitLabel() {
        return this.selectedUnit;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        try {
            switch (Integer.valueOf(command)) {
                case 1: {
                    this.freeColClient.getInGameController().payForBuilding(this.getColony());
                    this.reinitialize();
                    this.freeColClient.getCanvas().updateGoldLabel();
                    this.requestFocus();
                    break;
                }
                case 0: {
                    this.closeColonyPanel();
                    break;
                }
                case 2: {
                    this.unload();
                    break;
                }
                case 3: {
                    this.freeColClient.getInGameController().rename(this.getColony());
                    this.updateNameBox();
                    break;
                }
                case 4: {
                    if (this.freeColClient.getCanvas().showWarehouseDialog(this.colony)) {
                        this.updateWarehouse();
                    }
                    break;
                }
                case 5: {
                    this.fill();
                    break;
                }
                default: {
                    logger.warning("Invalid action");
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            logger.warning("Invalid action number: " + command);
        }
    }

    private void unload() {
        Unit unit = this.getSelectedUnit();
        if (unit != null && unit.isCarrier()) {
            Iterator<Goods> goodsIterator = unit.getGoodsIterator();
            while (goodsIterator.hasNext()) {
                Goods goods = goodsIterator.next();
                this.inGameController.unloadCargo(goods);
                this.updateWarehouse();
                this.updateCargoPanel();
                this.updateCargoLabel();
                this.getCargoPanel().revalidate();
                this.refresh();
            }
            Iterator<Unit> unitIterator = unit.getUnitIterator();
            while (unitIterator.hasNext()) {
                Unit newUnit = unitIterator.next();
                this.inGameController.leaveShip(newUnit);
                this.updateCargoPanel();
                this.updateCargoLabel();
                this.updateOutsideColonyPanel();
                this.outsideColonyPanel.revalidate();
                this.getCargoPanel().revalidate();
                this.refresh();
            }
        }
        this.unloadButton.setEnabled(false);
        this.fillButton.setEnabled(false);
    }

    private void fill() {
        Unit unit = this.getSelectedUnit();
        if (unit != null && unit.isCarrier()) {
            Iterator<Goods> goodsIterator = unit.getGoodsIterator();
            while (goodsIterator.hasNext()) {
                Goods goods = goodsIterator.next();
                if (goods.getAmount() >= 100 || this.colony.getGoodsCount(goods.getType()) <= 0) continue;
                int amount = Math.min(100 - goods.getAmount(), this.colony.getGoodsCount(goods.getType()));
                this.inGameController.loadCargo(new Goods(goods.getGame(), this.colony, goods.getType(), amount), unit);
                this.updateWarehouse();
                this.updateCargoPanel();
                this.getCargoPanel().revalidate();
                this.refresh();
            }
        }
    }

    public void closeColonyPanel() {
        if (this.getColony().getUnitCount() > 0 || this.freeColClient.getCanvas().showConfirmDialog("abandonColony.text", "abandonColony.yes", "abandonColony.no", new String[0])) {
            if (this.getColony().getUnitCount() <= 0) {
                this.freeColClient.getInGameController().abandonColony(this.getColony());
            }
            this.parent.remove(this);
            if (this.freeColClient.getGame().getCurrentPlayer() == this.freeColClient.getMyPlayer()) {
                this.freeColClient.getInGameController().nextModelMessage();
                Unit activeUnit = this.parent.getGUI().getActiveUnit();
                if (activeUnit == null || activeUnit.getTile() == null || activeUnit.getMovesLeft() <= 0 || !(activeUnit.getLocation() instanceof Tile) && !activeUnit.isOnCarrier()) {
                    this.parent.getGUI().setActiveUnit(null);
                    this.freeColClient.getInGameController().nextActiveUnit();
                }
            }
            this.freeColClient.getGUI().restartBlinking();
        }
    }

    public void setSelectedUnit(Unit unit) {
        Component[] components = this.inPortPanel.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof UnitLabel) || ((UnitLabel)components[i]).getUnit() != unit) continue;
            this.setSelectedUnitLabel((UnitLabel)components[i]);
            break;
        }
        this.updateCarrierButtons();
    }

    public void setSelectedUnitLabel(UnitLabel unitLabel) {
        if (this.selectedUnit != unitLabel) {
            if (this.selectedUnit != null) {
                this.selectedUnit.setSelected(false);
            }
            this.selectedUnit = unitLabel;
            if (unitLabel == null) {
                this.cargoPanel.setCarrier(null);
            } else {
                this.cargoPanel.setCarrier(unitLabel.getUnit());
                unitLabel.setSelected(true);
            }
            this.updateCargoLabel();
            this.cargoPanel.revalidate();
            this.refresh();
        }
    }

    private void updateCargoPanel() {
        this.cargoPanel.initialize();
    }

    public final CargoPanel getCargoPanel() {
        return this.cargoPanel;
    }

    public final WarehousePanel getWarehousePanel() {
        return this.warehousePanel;
    }

    public final TilePanel getTilePanel() {
        return this.tilePanel;
    }

    public final FreeColClient getClient() {
        return this.freeColClient;
    }

    public final synchronized Colony getColony() {
        return this.colony;
    }

    private synchronized void setColony(Colony colony) {
        if (this.colony != null) {
            this.colony.removePropertyChangeListener(Colony.ColonyChangeEvent.BONUS_CHANGE.toString(), this);
        }
        this.colony = colony;
        if (this.colony != null) {
            this.colony.addPropertyChangeListener(Colony.ColonyChangeEvent.BONUS_CHANGE.toString(), this);
        }
        this.editable = colony.getOwner() == this.freeColClient.getMyPlayer();
    }

    public final Game getGame() {
        return this.game;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (!this.isShowing()) {
            return;
        }
        if (e.getSource() != this.getColony()) {
            return;
        }
        if (e.getPropertyName() != Colony.ColonyChangeEvent.BONUS_CHANGE.toString()) {
            return;
        }
        if (this.getColony() == null) {
            return;
        }
        ModelMessage msg = this.getColony().checkForGovMgtChangeMessage();
        if (msg != null) {
            this.parent.showInformationMessage(msg.getId(), msg.getDisplay(), msg.getData());
        }
    }

    public final class TilePanel
    extends FreeColPanel {
        private final ColonyPanel colonyPanel;

        public TilePanel(ColonyPanel colonyPanel2) {
            this.colonyPanel = colonyPanel2;
            this.setBackground(Color.BLACK);
            this.setBorder(null);
            this.setLayout(null);
        }

        public void initialize() {
            int layer = 2;
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 3; ++y) {
                    ColonyTile tile = ColonyPanel.this.getColony().getColonyTile(x, y);
                    if (tile == null) continue;
                    ASingleTilePanel p = new ASingleTilePanel(tile, x, y);
                    this.add((Component)p, new Integer(layer));
                    ++layer;
                }
            }
        }

        public void paintComponent(Graphics g) {
            GUI colonyTileGUI = ColonyPanel.this.parent.getColonyTileGUI();
            ImageLibrary lib = colonyTileGUI.getImageLibrary();
            g.setColor(Color.black);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (ColonyPanel.this.getColony() != null) {
                for (int x = 0; x < 3; ++x) {
                    for (int y = 0; y < 3; ++y) {
                        TileType tileType = ColonyPanel.this.getColony().getTile().getType();
                        Tile tile = ColonyPanel.this.getColony().getTile(x, y);
                        if (tile == null) continue;
                        colonyTileGUI.displayColonyTile((Graphics2D)g, ColonyPanel.this.game.getMap(), tile, (2 - x + y) * lib.getTerrainImageWidth(tileType) / 2, (x + y) * lib.getTerrainImageHeight(tileType) / 2, ColonyPanel.this.getColony());
                    }
                }
            }
        }

        public final class ASingleTilePanel
        extends JPanel {
            private ColonyTile colonyTile;

            public ASingleTilePanel(ColonyTile colonyTile, int x, int y) {
                this.setLayout(new FlowLayout(1, 0, 0));
                this.colonyTile = colonyTile;
                this.setOpaque(false);
                this.updateDescriptionLabel();
                if (colonyTile.getUnit() != null) {
                    Unit unit = colonyTile.getUnit();
                    UnitLabel unitLabel = new UnitLabel(unit, ColonyPanel.this.parent);
                    if (TilePanel.this.colonyPanel.isEditable()) {
                        unitLabel.setTransferHandler(ColonyPanel.this.defaultTransferHandler);
                        unitLabel.addMouseListener(ColonyPanel.this.pressListener);
                    }
                    this.add(unitLabel);
                    this.updateDescriptionLabel(unitLabel, true);
                }
                ImageLibrary lib = ColonyPanel.this.parent.getColonyTileGUI().getImageLibrary();
                if (colonyTile.isColonyCenterTile()) {
                    this.initializeAsCenterTile(lib);
                }
                if (TilePanel.this.colonyPanel.isEditable()) {
                    this.setTransferHandler(ColonyPanel.this.defaultTransferHandler);
                    this.addMouseListener(ColonyPanel.this.releaseListener);
                }
                TileType tileType = colonyTile.getTile().getType();
                this.setSize(lib.getTerrainImageWidth(tileType), lib.getTerrainImageHeight(tileType));
                this.setLocation((2 - x + y) * lib.getTerrainImageWidth(tileType) / 2, (x + y) * lib.getTerrainImageHeight(tileType) / 2);
            }

            private void initializeAsCenterTile(ImageLibrary lib) {
                this.setLayout(new GridLayout(2, 1));
                TileType tileType = this.colonyTile.getTile().getType();
                GoodsType primaryGood = this.colonyTile.getTile().primaryGoods();
                ImageIcon goodsIcon = ColonyPanel.this.parent.getGUI().getImageLibrary().getGoodsImageIcon(primaryGood);
                ProductionLabel pl = new ProductionLabel(primaryGood, this.colonyTile.getProductionOf(primaryGood), ColonyPanel.this.parent);
                pl.setSize(lib.getTerrainImageWidth(tileType), goodsIcon.getIconHeight());
                this.add(pl);
                GoodsType secondaryGood = this.colonyTile.getTile().secondaryGoods();
                if (this.colonyTile.getProductionOf(secondaryGood) != 0) {
                    goodsIcon = ColonyPanel.this.parent.getGUI().getImageLibrary().getGoodsImageIcon(secondaryGood);
                    ProductionLabel sl = new ProductionLabel(secondaryGood, this.colonyTile.getProductionOf(secondaryGood), ColonyPanel.this.parent);
                    sl.setSize(lib.getTerrainImageWidth(tileType), goodsIcon.getIconHeight());
                    this.add(sl);
                }
            }

            private void updateDescriptionLabel() {
                this.updateDescriptionLabel(null, false);
            }

            private void updateDescriptionLabel(UnitLabel unit, boolean toAdd) {
                String tileDescription = this.colonyTile.getLabel();
                if (unit == null) {
                    this.setToolTipText(tileDescription);
                } else {
                    String unitDescription = unit.getUnit().getName();
                    if (toAdd) {
                        unitDescription = tileDescription + " [" + unitDescription + "]";
                    }
                    unit.setDescriptionLabel(unitDescription);
                }
            }

            public ColonyTile getColonyTile() {
                return this.colonyTile;
            }

            /*
             * Enabled aggressive block sorting
             */
            public Component add(Component comp, boolean editState) {
                Container oldParent = comp.getParent();
                if (editState) {
                    if (!(comp instanceof UnitLabel)) {
                        logger.warning("An invalid component got dropped on this CargoPanel.");
                        return null;
                    }
                    Unit unit = ((UnitLabel)comp).getUnit();
                    int price = unit.getOwner().getLandPrice(this.colonyTile.getWorkTile());
                    if (price > 0) {
                        Player player = this.colonyTile.getWorkTile().getOwner();
                        ChoiceItem[] choices = new ChoiceItem[]{new ChoiceItem(Messages.message("indianLand.pay", new String[0]).replaceAll("%amount%", Integer.toString(price)), 1), new ChoiceItem(Messages.message("indianLand.take", new String[0]), 2)};
                        ChoiceItem ci = (ChoiceItem)ColonyPanel.this.parent.showChoiceDialog(Messages.message("indianLand.text", "%player%", player.getNationAsString()), Messages.message("indianLand.cancel", new String[0]), choices);
                        if (ci == null) {
                            return null;
                        }
                        if (ci.getChoice() == 1) {
                            if (price > ColonyPanel.this.freeColClient.getMyPlayer().getGold()) {
                                ColonyPanel.this.parent.errorMessage("notEnoughGold");
                                return null;
                            }
                            ColonyPanel.this.inGameController.buyLand(this.colonyTile.getWorkTile());
                        } else if (ci.getChoice() == 2) {
                            ColonyPanel.this.inGameController.stealLand(this.colonyTile.getWorkTile(), ColonyPanel.this.colony);
                        }
                    }
                    if (this.colonyTile.canAdd(unit)) {
                        oldParent.remove(comp);
                        ColonyPanel.this.inGameController.work(unit, this.colonyTile);
                        GoodsType workType = this.colonyTile.getWorkType(unit);
                        if (workType != unit.getWorkType()) {
                            ColonyPanel.this.inGameController.changeWorkType(unit, workType);
                        }
                        this.updateDescriptionLabel((UnitLabel)comp, true);
                        ColonyPanel.this.updateBuildingBox();
                        ColonyPanel.this.updateWarehouse();
                        ColonyPanel.this.updateBuildingsPanel();
                        ColonyPanel.this.updateProductionPanel();
                        ((UnitLabel)comp).setSmall(false);
                        TilePanel.this.colonyPanel.updateSoLLabel();
                    } else {
                        Settlement s = this.colonyTile.getWorkTile().getOwningSettlement();
                        if (s == null) return null;
                        if (s == ColonyPanel.this.getColony()) return null;
                        if (s.getOwner().isEuropean()) {
                            ColonyPanel.this.parent.errorMessage("tileTakenEuro");
                            return null;
                        }
                        if (!(s instanceof IndianSettlement)) return null;
                        if (price <= 0) return null;
                        ColonyPanel.this.parent.errorMessage("tileTakenInd");
                        return null;
                    }
                }
                Component c = this.add(comp);
                ColonyPanel.this.refresh();
                if (oldParent == null) return c;
                if (!(oldParent instanceof BuildingsPanel.ASingleBuildingPanel)) return c;
                ((BuildingsPanel.ASingleBuildingPanel)oldParent).updateProductionLabel();
                return c;
            }

            public void remove(Component comp) {
                if (comp instanceof UnitLabel) {
                    ((UnitLabel)comp).setSmall(false);
                    this.updateDescriptionLabel((UnitLabel)comp, false);
                }
                super.remove(comp);
            }

            public boolean contains(int px, int py) {
                int activePixels;
                if (!super.contains(px, py)) {
                    return false;
                }
                if (py >= 32) {
                    py = 32 - (py - 31);
                }
                return px >= 63 - (activePixels = py * 128 / 64) && px <= 63 + activePixels;
            }
        }
    }

    public final class WarehousePanel
    extends JPanel {
        private final ColonyPanel colonyPanel;

        public WarehousePanel(ColonyPanel colonyPanel2) {
            this.colonyPanel = colonyPanel2;
        }

        public String getUIClassID() {
            return "WarehousePanelUI";
        }

        public Component add(Component comp, boolean editState) {
            if (editState) {
                if (comp instanceof GoodsLabel) {
                    comp.getParent().remove(comp);
                    ((GoodsLabel)comp).setSmall(false);
                    ColonyPanel.this.updateBuildingsPanel(((GoodsLabel)comp).getGoods().getType());
                    ColonyPanel.this.updateProductionPanel();
                    ColonyPanel.this.reinitialize();
                    return comp;
                }
                logger.warning("An invalid component got dropped on this WarehousePanel.");
                return null;
            }
            Component c = this.add(comp);
            ColonyPanel.this.refresh();
            return c;
        }

        public void initialize() {
            this.removeAll();
            for (GoodsType goodsType : FreeCol.getSpecification().getGoodsTypeList()) {
                if (!goodsType.isStorable()) continue;
                Goods goods = ColonyPanel.this.colony.getGoodsContainer().getGoods(goodsType);
                GoodsLabel goodsLabel = new GoodsLabel(goods, ColonyPanel.this.parent);
                if (this.colonyPanel.isEditable()) {
                    goodsLabel.setTransferHandler(ColonyPanel.this.defaultTransferHandler);
                    goodsLabel.addMouseListener(ColonyPanel.this.pressListener);
                }
                this.add((Component)goodsLabel, false);
            }
            this.revalidate();
        }
    }

    public final class InPortPanel
    extends JPanel {
        public Component add(Component comp) {
            return super.add(comp);
        }

        public String getUIClassID() {
            return "InPortPanelUI";
        }
    }

    public final class OutsideColonyPanel
    extends JPanel {
        private final ColonyPanel colonyPanel;

        public OutsideColonyPanel(ColonyPanel colonyPanel2) {
            this.colonyPanel = colonyPanel2;
        }

        public Colony getColony() {
            return this.colonyPanel.getColony();
        }

        public String getUIClassID() {
            return "OutsideColonyPanelUI";
        }

        public Component add(Component comp, boolean editState) {
            Container oldParent = comp.getParent();
            if (editState) {
                if (comp instanceof UnitLabel) {
                    UnitLabel unitLabel = (UnitLabel)comp;
                    Unit unit = unitLabel.getUnit();
                    if (!unit.isOnCarrier()) {
                        ColonyPanel.this.inGameController.putOutsideColony(unit);
                    }
                    if (unit.getColony() == null) {
                        ColonyPanel.this.closeColonyPanel();
                        return null;
                    }
                    if (!(unit.getLocation() instanceof Tile) && !unit.isOnCarrier()) {
                        return null;
                    }
                    oldParent.remove(comp);
                    ColonyPanel.this.updateBuildingsPanel();
                    ColonyPanel.this.updateBuildingBox();
                    ColonyPanel.this.updateProductionPanel();
                } else {
                    logger.warning("An invalid component got dropped on this ColonistsPanel.");
                    return null;
                }
            }
            ((UnitLabel)comp).setSmall(false);
            Component c = this.add(comp);
            ColonyPanel.this.refresh();
            this.colonyPanel.updateSoLLabel();
            if (oldParent != null && oldParent.getParent() instanceof BuildingsPanel.ASingleBuildingPanel) {
                ((BuildingsPanel.ASingleBuildingPanel)oldParent.getParent()).updateProductionLabel();
            }
            return c;
        }
    }

    public final class BuildingsPanel
    extends JPanel {
        private final ColonyPanel colonyPanel;

        public BuildingsPanel(ColonyPanel colonyPanel2) {
            this.setLayout(new BoxLayout(this, 3));
            this.colonyPanel = colonyPanel2;
        }

        public String getUIClassID() {
            return "BuildingsPanelUI";
        }

        public void initialize() {
            this.removeAll();
            List<Building> buildings = ColonyPanel.this.getColony().getBuildings();
            ColonyPanel.this.sortBuildings(buildings);
            for (Building building : buildings) {
                ASingleBuildingPanel aSingleBuildingPanel = new ASingleBuildingPanel(building);
                if (this.colonyPanel.isEditable()) {
                    aSingleBuildingPanel.addMouseListener(ColonyPanel.this.releaseListener);
                    aSingleBuildingPanel.setTransferHandler(ColonyPanel.this.defaultTransferHandler);
                }
                aSingleBuildingPanel.setOpaque(false);
                this.add(aSingleBuildingPanel);
            }
        }

        public final class ASingleBuildingPanel
        extends JPanel
        implements Autoscroll {
            Building building;
            ProductionLabel productionLabel;
            public final int[] widths = new int[]{64, 46, 46, 46, 78, 32, 78};
            public final int[] heights = new int[]{20, 4, 40, 0, 0};
            public static final int labelColumn = 1;
            public static final int unitColumn = 2;
            public static final int productionColumn = 5;

            public ASingleBuildingPanel(Building building) {
                this.building = building;
                this.setBackground(Color.WHITE);
                this.setLayout(new HIGLayout(this.widths, this.heights));
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, FreeColPanel.LINK_COLOR), BorderFactory.createEmptyBorder(0, 0, 1, 0)));
                this.initialize();
            }

            public void initialize() {
                JLabel arrow = new JLabel("\u2192");
                arrow.setFont(hugeFont);
                this.removeAll();
                JLabel buildingName = new JLabel();
                if (this.building.getMaxUnits() == 0) {
                    buildingName.setText("(" + this.building.getName() + ")");
                } else {
                    buildingName.setText(this.building.getName());
                }
                this.add((Component)buildingName, FreeColPanel.higConst.rcwh(1, 1, this.widths.length, 1));
                List<Unit> unitList = this.building.getUnitList();
                for (int index = 0; index < unitList.size(); ++index) {
                    Unit unit = unitList.get(index);
                    UnitLabel unitLabel = new UnitLabel(unit, ColonyPanel.this.parent, true);
                    if (BuildingsPanel.this.colonyPanel.isEditable()) {
                        unitLabel.setTransferHandler(ColonyPanel.this.defaultTransferHandler);
                        unitLabel.addMouseListener(ColonyPanel.this.pressListener);
                    }
                    this.add((Component)unitLabel, FreeColPanel.higConst.rc(3, 2 + index));
                    if (!this.building.getType().hasAbility("model.ability.teach") || unit.getStudent() == null) continue;
                    JLabel progress = new JLabel(unit.getTurnsOfTraining() + "/" + unit.getNeededTurnsOfTraining());
                    this.add((Component)progress, FreeColPanel.higConst.rc(4, 2 + index));
                    UnitLabel studentLabel = new UnitLabel(unit.getStudent(), ColonyPanel.this.parent, true);
                    studentLabel.setIgnoreLocation(true);
                    this.add((Component)studentLabel, FreeColPanel.higConst.rc(5, 2 + index));
                }
                if (this.building.getGoodsInputNextTurn() != 0) {
                    GoodsType inputType = this.building.getGoodsInputType();
                    ProductionLabel inputLabel = new ProductionLabel(inputType, this.building.getGoodsInputNextTurn(), this.building.getMaximumGoodsInput(), ColonyPanel.this.parent);
                    inputLabel.setGoodsIcon(ColonyPanel.this.parent.getGUI().getImageLibrary().getScaledGoodsImageIcon(inputType, 0.8f));
                    this.add((Component)inputLabel, FreeColPanel.higConst.rc(3, 5, ""));
                    if (this.building.getGoodsInputType() != null) {
                        this.add((Component)arrow, FreeColPanel.higConst.rc(3, 6, ""));
                    }
                }
                this.productionLabel = new ProductionLabel(this.building.getGoodsOutputType(), this.building.getProductionNextTurn(), this.building.getMaximumProduction(), ColonyPanel.this.parent);
                this.add((Component)this.productionLabel, FreeColPanel.higConst.rc(3, 7, ""));
                this.setSize(this.getPreferredSize());
            }

            public void autoscroll(Point p) {
                JViewport vp = (JViewport)BuildingsPanel.this.colonyPanel.buildingsPanel.getParent();
                if (this.getLocation().y + p.y - vp.getViewPosition().y < 40) {
                    vp.setViewPosition(new Point(vp.getViewPosition().x, Math.max(vp.getViewPosition().y - 40, 0)));
                } else if (this.getLocation().y + p.y - vp.getViewPosition().y >= vp.getHeight() - 40) {
                    vp.setViewPosition(new Point(vp.getViewPosition().x, Math.min(vp.getViewPosition().y + 40, BuildingsPanel.this.colonyPanel.buildingsPanel.getHeight() - vp.getHeight())));
                }
            }

            public Insets getAutoscrollInsets() {
                Rectangle r = this.getBounds();
                return new Insets(r.x, r.y, r.width, r.height);
            }

            public Building getBuilding() {
                return this.building;
            }

            public void updateProductionLabel() {
                this.initialize();
            }

            public void paintComponent(Graphics g) {
                int width = this.getWidth();
                int height = this.getHeight();
                Image bgImage = ResourceManager.getImage(this.building.getType().getId() + ".image");
                if (bgImage != null) {
                    g.drawImage(bgImage, 0, 0, this);
                } else {
                    Image tempImage = ResourceManager.getImage("BackgroundImage");
                    if (tempImage != null) {
                        for (int x = 0; x < width; x += tempImage.getWidth(null)) {
                            for (int y = 0; y < height; y += tempImage.getHeight(null)) {
                                g.drawImage(tempImage, x, y, null);
                            }
                        }
                    } else {
                        g.setColor(this.getBackground());
                        g.fillRect(0, 0, width, height);
                    }
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Component add(Component comp, boolean editState) {
                Container oldParent = comp.getParent();
                if (editState) {
                    if (comp instanceof UnitLabel) {
                        Unit unit = ((UnitLabel)comp).getUnit();
                        if (!this.building.canAdd(unit)) return null;
                        oldParent.remove(comp);
                        ColonyPanel.this.inGameController.work(unit, this.building);
                        ColonyPanel.this.updateBuildingBox();
                        ColonyPanel.this.updateWarehouse();
                    } else {
                        logger.warning("An invalid component got dropped on this BuildingsPanel.");
                        return null;
                    }
                }
                this.initialize();
                BuildingsPanel.this.colonyPanel.updateSoLLabel();
                ColonyPanel.this.updateProductionPanel();
                this.updateProductionLabel();
                if (oldParent instanceof ASingleBuildingPanel) {
                    ((ASingleBuildingPanel)oldParent).updateProductionLabel();
                    return null;
                } else {
                    if (!(oldParent instanceof TilePanel.ASingleTilePanel)) return null;
                    ColonyPanel.this.updateBuildingsPanel();
                }
                return null;
            }

            public void remove(Component comp) {
                super.remove(comp);
                this.updateProductionLabel();
            }
        }
    }

    public final class ColonyCargoPanel
    extends CargoPanel {
        public ColonyCargoPanel(Canvas parent) {
            super(parent, false);
        }

        public Component add(Component comp, boolean editState) {
            Component result = super.add(comp, editState);
            if (editState && result != null && result instanceof UnitLabel) {
                ColonyPanel.this.updateSoLLabel();
                ColonyPanel.this.updateProductionPanel();
                ColonyPanel.this.updateBuildingsPanel();
            }
            if (comp instanceof GoodsLabel) {
                ColonyPanel.this.updateBuildingsPanel(((GoodsLabel)comp).getGoods().getType());
                ColonyPanel.this.updateProductionPanel();
            }
            ColonyPanel.this.updateProgressLabel();
            ColonyPanel.this.updateCargoLabel();
            ColonyPanel.this.refresh();
            return result;
        }

        public void remove(Component comp) {
            super.remove(comp);
            ColonyPanel.this.updateCargoLabel();
        }

        public String getUIClassID() {
            return "CargoPanelUI";
        }
    }
}

