/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.ColopediaTreeCellRenderer;
import net.sf.freecol.client.gui.panel.ColopediaTreeItem;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.EuropeanNationType;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.Utils;

public final class ColopediaPanel
extends FreeColPanel
implements ActionListener,
TreeSelectionListener {
    private static final Logger logger = Logger.getLogger(ColopediaPanel.class.getName());
    private static final TileImprovementType road = Specification.getSpecification().getTileImprovementType("model.improvement.Road");
    private static final TileImprovementType river = Specification.getSpecification().getTileImprovementType("model.improvement.River");
    private static final TileImprovementType plowing = Specification.getSpecification().getTileImprovementType("model.improvement.Plow");
    private static final String OK = "OK";
    private static final String ROOT = "ROOT";
    private static final int MODIFIERS_PER_ROW = 5;
    private final Canvas parent;
    private final ImageLibrary library;
    private JLabel header;
    private JPanel listPanel;
    private JPanel detailPanel;
    private JButton ok;
    private JTree tree;

    public ColopediaPanel(Canvas parent) {
        super(new FlowLayout(1, 1000, 10));
        this.parent = parent;
        this.library = parent.getGUI().getImageLibrary();
        this.setLayout(new BorderLayout());
        this.header = ColopediaPanel.getDefaultHeader(Messages.message("menuBar.colopedia", new String[0]));
        this.add((Component)this.header, "North");
        this.listPanel = new JPanel();
        this.listPanel.setOpaque(false);
        JScrollPane sl = new JScrollPane(this.listPanel, 22, 30);
        sl.getVerticalScrollBar().setUnitIncrement(16);
        sl.getViewport().setOpaque(false);
        this.add((Component)sl, "West");
        this.detailPanel = new JPanel();
        this.detailPanel.setOpaque(false);
        this.detailPanel.setBorder(new EmptyBorder(20, 20, 20, 20));
        this.add((Component)this.detailPanel, "Center");
        this.ok = new JButton(Messages.message("ok", new String[0]));
        this.ok.setActionCommand(String.valueOf(OK));
        this.ok.addActionListener(this);
        ColopediaPanel.enterPressesWhenFocused(this.ok);
        this.setCancelComponent(this.ok);
        this.add((Component)this.ok, "South");
        this.setSize(this.getPreferredSize());
    }

    public Dimension getMinimumSize() {
        return new Dimension(850, 600);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.parent.getWidth(), this.parent.getHeight() - this.parent.getMenuBarHeight());
    }

    public void initialize(PanelType type) {
        this.initialize(type, null);
    }

    public void initialize(PanelType panelType, FreeColGameObjectType type) {
        this.listPanel.removeAll();
        this.detailPanel.removeAll();
        this.tree = this.buildTree();
        this.tree.expandRow(panelType.ordinal());
        this.selectDetail(panelType, type);
        this.detailPanel.validate();
    }

    public void initialize(FreeColGameObjectType type) {
        this.listPanel.removeAll();
        this.detailPanel.removeAll();
        this.tree = this.buildTree();
        if (type instanceof TileType) {
            this.tree.expandRow(PanelType.TERRAIN.ordinal());
            this.buildTerrainDetail((TileType)type);
        } else if (type instanceof ResourceType) {
            this.tree.expandRow(PanelType.RESOURCES.ordinal());
            this.buildResourceDetail((ResourceType)type);
        } else if (type instanceof UnitType) {
            if (((UnitType)type).hasSkill()) {
                this.tree.expandRow(PanelType.SKILLS.ordinal());
            } else {
                this.tree.expandRow(PanelType.UNITS.ordinal());
            }
            this.buildUnitDetail((UnitType)type);
        } else if (type instanceof GoodsType) {
            this.tree.expandRow(PanelType.GOODS.ordinal());
            this.buildGoodsDetail((GoodsType)type);
        } else if (type instanceof BuildingType) {
            this.tree.expandRow(PanelType.BUILDINGS.ordinal());
            this.buildBuildingDetail((BuildingType)type);
        } else if (type instanceof FoundingFather) {
            this.tree.expandRow(PanelType.FATHERS.ordinal());
            this.buildFatherDetail((FoundingFather)type);
        } else if (type instanceof Nation) {
            this.tree.expandRow(PanelType.NATIONS.ordinal());
            this.buildNationDetail((Nation)type);
        } else if (type instanceof NationType) {
            this.tree.expandRow(PanelType.NATION_TYPES.ordinal());
            this.buildNationTypeDetail((NationType)type);
        }
        this.detailPanel.validate();
    }

    public void selectDetail(PanelType panelType, FreeColGameObjectType type) {
        switch (panelType) {
            case TERRAIN: {
                this.buildTerrainDetail((TileType)type);
                break;
            }
            case RESOURCES: {
                this.buildResourceDetail((ResourceType)type);
                break;
            }
            case UNITS: 
            case SKILLS: {
                this.buildUnitDetail((UnitType)type);
                break;
            }
            case GOODS: {
                this.buildGoodsDetail((GoodsType)type);
                break;
            }
            case BUILDINGS: {
                this.buildBuildingDetail((BuildingType)type);
                break;
            }
            case FATHERS: {
                this.buildFatherDetail((FoundingFather)type);
                break;
            }
            case NATIONS: {
                this.buildNationDetail((Nation)type);
                break;
            }
            case NATION_TYPES: {
                this.buildNationTypeDetail((NationType)type);
                break;
            }
        }
    }

    public void requestFocus() {
        this.ok.requestFocus();
    }

    private JTree buildTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new ColopediaTreeItem(null, Messages.message("menuBar.colopedia", new String[0])));
        DefaultMutableTreeNode terrain = new DefaultMutableTreeNode(new ColopediaTreeItem(PanelType.TERRAIN, Messages.message("menuBar.colopedia.terrain", new String[0])));
        this.buildTerrainSubtree(terrain);
        root.add(terrain);
        DefaultMutableTreeNode resource = new DefaultMutableTreeNode(new ColopediaTreeItem(PanelType.RESOURCES, Messages.message("menuBar.colopedia.resource", new String[0])));
        this.buildResourceSubtree(resource);
        root.add(resource);
        DefaultMutableTreeNode units = new DefaultMutableTreeNode(new ColopediaTreeItem(PanelType.UNITS, Messages.message("menuBar.colopedia.unit", new String[0])));
        this.buildUnitSubtree(units);
        root.add(units);
        DefaultMutableTreeNode goods = new DefaultMutableTreeNode(new ColopediaTreeItem(PanelType.GOODS, Messages.message("menuBar.colopedia.goods", new String[0])));
        this.buildGoodsSubtree(goods);
        root.add(goods);
        DefaultMutableTreeNode skills = new DefaultMutableTreeNode(new ColopediaTreeItem(PanelType.SKILLS, Messages.message("menuBar.colopedia.skill", new String[0])));
        this.buildSkillsSubtree(skills);
        root.add(skills);
        DefaultMutableTreeNode buildings = new DefaultMutableTreeNode(new ColopediaTreeItem(PanelType.BUILDINGS, Messages.message("menuBar.colopedia.building", new String[0])));
        this.buildBuildingSubtree(buildings);
        root.add(buildings);
        DefaultMutableTreeNode fathers = new DefaultMutableTreeNode(new ColopediaTreeItem(PanelType.FATHERS, Messages.message("menuBar.colopedia.father", new String[0])));
        this.buildFathersSubtree(fathers);
        root.add(fathers);
        DefaultMutableTreeNode nations = new DefaultMutableTreeNode(new ColopediaTreeItem(PanelType.NATIONS, Messages.message("menuBar.colopedia.nation", new String[0])));
        this.buildNationsSubtree(nations);
        root.add(nations);
        DefaultMutableTreeNode nationTypes = new DefaultMutableTreeNode(new ColopediaTreeItem(PanelType.NATION_TYPES, Messages.message("menuBar.colopedia.nationType", new String[0])));
        this.buildNationTypesSubtree(nationTypes);
        root.add(nationTypes);
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        this.tree = new JTree(treeModel){

            public Dimension getPreferredSize() {
                return new Dimension(200, super.getPreferredSize().height);
            }
        };
        this.tree.setRootVisible(false);
        this.tree.setCellRenderer(new ColopediaTreeCellRenderer());
        this.tree.setOpaque(false);
        this.tree.addTreeSelectionListener(this);
        this.listPanel.setLayout(new GridLayout(0, 1));
        this.listPanel.add(this.tree);
        return this.tree;
    }

    private void buildTerrainSubtree(DefaultMutableTreeNode parent) {
        for (TileType t : Specification.getSpecification().getTileTypeList()) {
            this.buildTerrainItem(t, parent);
        }
    }

    private void buildResourceSubtree(DefaultMutableTreeNode parent) {
        for (ResourceType r : Specification.getSpecification().getResourceTypeList()) {
            this.buildResourceItem(r, parent);
        }
    }

    private void buildUnitSubtree(DefaultMutableTreeNode parent) {
        for (UnitType u : Specification.getSpecification().getUnitTypeList()) {
            if (u.getSkill() > 0 && !u.hasAbility("model.ability.expertSoldier")) continue;
            this.buildUnitItem(u, 0.5f, parent);
        }
    }

    private void buildGoodsSubtree(DefaultMutableTreeNode parent) {
        for (GoodsType g : Specification.getSpecification().getGoodsTypeList()) {
            this.buildGoodsItem(g, parent);
        }
    }

    private void buildSkillsSubtree(DefaultMutableTreeNode parent) {
        for (UnitType u : Specification.getSpecification().getUnitTypeList()) {
            if (u.getSkill() <= 0) continue;
            this.buildUnitItem(u, 0.5f, parent);
        }
    }

    private void buildBuildingSubtree(DefaultMutableTreeNode parent) {
        Image buildingImage = ResourceManager.getImage("Colopedia.buildingSection.image");
        ImageIcon buildingIcon = new ImageIcon(buildingImage != null ? buildingImage : null);
        List<BuildingType> buildingTypes = Specification.getSpecification().getBuildingTypeList();
        for (BuildingType buildingType : buildingTypes) {
            DefaultMutableTreeNode item = new DefaultMutableTreeNode(new ColopediaTreeItem(buildingType, buildingType.getName(), buildingIcon));
            parent.add(item);
        }
    }

    private void buildFathersSubtree(DefaultMutableTreeNode parent) {
        EnumMap fathersByType = new EnumMap(FoundingFather.FoundingFatherType.class);
        for (FoundingFather.FoundingFatherType fatherType : FoundingFather.FoundingFatherType.values()) {
            fathersByType.put(fatherType, new ArrayList());
        }
        for (FoundingFather foundingFather : Specification.getSpecification().getFoundingFathers()) {
            ((List)fathersByType.get((Object)foundingFather.getType())).add(foundingFather);
        }
        for (FoundingFather.FoundingFatherType fatherType : FoundingFather.FoundingFatherType.values()) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(new ColopediaTreeItem(PanelType.FATHERS, FoundingFather.getTypeAsString(fatherType)));
            parent.add(node);
            for (FoundingFather father : (List)fathersByType.get((Object)fatherType)) {
                this.buildFatherItem(father, node);
            }
        }
    }

    private void buildNationsSubtree(DefaultMutableTreeNode parent) {
        for (Nation type : Specification.getSpecification().getEuropeanNations()) {
            this.buildNationItem(type, parent);
        }
        for (Nation type : Specification.getSpecification().getIndianNations()) {
            this.buildNationItem(type, parent);
        }
    }

    private void buildNationTypesSubtree(DefaultMutableTreeNode parent) {
        ArrayList<NationType> nations = new ArrayList<NationType>();
        nations.addAll(Specification.getSpecification().getEuropeanNationTypes());
        nations.addAll(Specification.getSpecification().getREFNationTypes());
        nations.addAll(Specification.getSpecification().getIndianNationTypes());
        for (NationType type : nations) {
            this.buildNationTypeItem(type, parent);
        }
    }

    private void buildTerrainItem(TileType tileType, DefaultMutableTreeNode parent) {
        ImageIcon icon = new ImageIcon(this.library.getScaledTerrainImage(tileType, 0.25f));
        DefaultMutableTreeNode item = new DefaultMutableTreeNode(new ColopediaTreeItem(tileType, tileType.getName(), icon));
        parent.add(item);
    }

    private void buildResourceItem(ResourceType resType, DefaultMutableTreeNode parent) {
        ImageIcon icon = this.library.getScaledBonusImageIcon(resType, 0.75f);
        DefaultMutableTreeNode item = new DefaultMutableTreeNode(new ColopediaTreeItem(resType, resType.getName(), icon));
        parent.add(item);
    }

    private void buildUnitItem(UnitType unitType, float scale, DefaultMutableTreeNode parent) {
        ImageIcon icon = this.library.getScaledImageIcon(this.library.getUnitImageIcon(unitType), 0.5f);
        DefaultMutableTreeNode item = new DefaultMutableTreeNode(new ColopediaTreeItem(unitType, unitType.getName(), icon));
        parent.add(item);
    }

    private void buildGoodsItem(GoodsType goodsType, DefaultMutableTreeNode parent) {
        ImageIcon icon = this.library.getScaledGoodsImageIcon(goodsType, 0.75f);
        DefaultMutableTreeNode item = new DefaultMutableTreeNode(new ColopediaTreeItem(goodsType, goodsType.getName(), icon));
        parent.add(item);
    }

    private void buildFatherItem(FoundingFather foundingFather, DefaultMutableTreeNode parent) {
        String name = foundingFather.getName();
        ImageIcon icon = this.library.getScaledGoodsImageIcon(Goods.BELLS, 0.75f);
        DefaultMutableTreeNode item = new DefaultMutableTreeNode(new ColopediaTreeItem(foundingFather, name, icon));
        parent.add(item);
    }

    private void buildNationItem(Nation nation, DefaultMutableTreeNode parent) {
        String name = nation.getName();
        ImageIcon icon = this.library.getScaledImageIcon(this.library.getCoatOfArmsImageIcon(nation), 0.5f);
        DefaultMutableTreeNode item = new DefaultMutableTreeNode(new ColopediaTreeItem(nation, name, icon));
        parent.add(item);
    }

    private void buildNationTypeItem(NationType nationType, DefaultMutableTreeNode parent) {
        String name = nationType.getName();
        ImageIcon icon = this.library.getScaledGoodsImageIcon(Goods.BELLS, 0.75f);
        DefaultMutableTreeNode item = new DefaultMutableTreeNode(new ColopediaTreeItem(nationType, name, icon));
        parent.add(item);
    }

    private JButton getButton(FreeColGameObjectType type, String text, ImageIcon icon) {
        JButton button = ColopediaPanel.getLinkButton(text == null ? type.getName() : text, icon, type.getId());
        button.addActionListener(this);
        return button;
    }

    private JButton getButton(FreeColGameObjectType type) {
        return this.getButton(type, null, null);
    }

    private JButton getResourceButton(ResourceType resourceType) {
        return this.getButton(resourceType, null, this.library.getBonusImageIcon(resourceType));
    }

    private JButton getGoodsButton(GoodsType goodsType) {
        return this.getButton(goodsType, null, this.library.getGoodsImageIcon(goodsType));
    }

    private JButton getGoodsButton(GoodsType goodsType, String text) {
        return this.getButton(goodsType, text, this.library.getGoodsImageIcon(goodsType));
    }

    private JButton getGoodsButton(GoodsType goodsType, int amount) {
        return this.getButton(goodsType, Integer.toString(amount), this.library.getGoodsImageIcon(goodsType));
    }

    private JButton getUnitButton(UnitType unitType, Unit.Role role) {
        ImageIcon unitIcon = this.library.scaleIcon(this.library.getUnitImageIcon(unitType, role), 0.66f);
        JButton unitButton = this.getButton(unitType, null, unitIcon);
        unitButton.setHorizontalAlignment(2);
        return unitButton;
    }

    private JButton getUnitButton(UnitType unitType) {
        return this.getUnitButton(unitType, Unit.Role.DEFAULT);
    }

    private void buildTerrainDetail(TileType tileType) {
        this.detailPanel.removeAll();
        this.detailPanel.repaint();
        if (tileType == null) {
            return;
        }
        int[] widths = new int[]{0, 9, 0};
        int[] heights = new int[13];
        for (int index = 1; index < heights.length; index += 2) {
            heights[index] = 3;
        }
        int row = 1;
        int leftColumn = 1;
        int rightColumn = 3;
        HIGLayout layout = new HIGLayout(widths, heights);
        layout.setColumnWeight(rightColumn, 1);
        this.detailPanel.setLayout(layout);
        String movementCost = String.valueOf(tileType.getBasicMoveCost() / 3);
        String defenseBonus = "";
        Set<Modifier> defenceModifiers = tileType.getDefenceBonus();
        if (!defenceModifiers.isEmpty()) {
            defenseBonus = this.getModifierAsString(defenceModifiers.iterator().next());
        }
        GoodsType secondaryGoodsType = tileType.getSecondaryGoods();
        JLabel nameLabel = new JLabel(tileType.getName(), 0);
        nameLabel.setFont(smallHeaderFont);
        this.detailPanel.add((Component)nameLabel, higConst.rcwh(row, leftColumn, widths.length, 1));
        this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.terrain.terrainImage", new String[0])), higConst.rc(row += 2, leftColumn));
        Image terrainImage = this.library.getScaledTerrainImage(tileType, 1.0f);
        this.detailPanel.add((Component)new JLabel(new ImageIcon(terrainImage)), higConst.rc(row, rightColumn, "l"));
        this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.terrain.movementCost", new String[0])), higConst.rc(row += 2, leftColumn));
        this.detailPanel.add((Component)new JLabel(movementCost), higConst.rc(row, rightColumn));
        this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.terrain.defenseBonus", new String[0])), higConst.rc(row += 2, leftColumn));
        this.detailPanel.add((Component)new JLabel(defenseBonus), higConst.rc(row, rightColumn));
        row += 2;
        List<ResourceType> resourceList = tileType.getResourceTypeList();
        if (resourceList.size() > 0) {
            this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.terrain.resource", new String[0])), higConst.rc(row, leftColumn));
            JPanel resourcePanel = new JPanel();
            resourcePanel.setOpaque(false);
            for (ResourceType resourceType : resourceList) {
                resourcePanel.add(this.getResourceButton(resourceType));
            }
            this.detailPanel.add((Component)resourcePanel, higConst.rc(row, rightColumn, "l"));
            row += 2;
        }
        this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.terrain.production", new String[0])), higConst.rc(row, leftColumn));
        JPanel goodsPanel = new JPanel();
        goodsPanel.setOpaque(false);
        List<AbstractGoods> production = tileType.getProduction();
        for (AbstractGoods goods : production) {
            if ("model.tile.ocean".equals(tileType.getId()) && "model.goods.fish".equals(goods.getId())) {
                String text = Integer.toString(goods.getAmount()) + "/4";
                goodsPanel.add(this.getGoodsButton(goods.getType(), text));
                continue;
            }
            goodsPanel.add(this.getGoodsButton(goods.getType(), goods.getAmount()));
        }
        this.detailPanel.add((Component)goodsPanel, higConst.rc(row, rightColumn, "l"));
        this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.terrain.description", new String[0])), higConst.rc(row += 2, leftColumn, "tl"));
        this.detailPanel.add((Component)ColopediaPanel.getDefaultTextArea(tileType.getDescription()), higConst.rc(row, rightColumn));
        this.detailPanel.validate();
    }

    private void buildResourceDetail(ResourceType type) {
        this.detailPanel.removeAll();
        this.detailPanel.repaint();
        if (type == null) {
            return;
        }
        int[] widths = new int[]{0, 9, 0};
        int[] heights = new int[7];
        for (int index = 1; index < heights.length; index += 2) {
            heights[index] = 3;
        }
        int row = 1;
        int leftColumn = 1;
        int rightColumn = 3;
        HIGLayout layout = new HIGLayout(widths, heights);
        layout.setColumnWeight(rightColumn, 1);
        this.detailPanel.setLayout(layout);
        JLabel name = new JLabel(type.getName(), 0);
        name.setFont(smallHeaderFont);
        this.detailPanel.add((Component)name, higConst.rcwh(row, leftColumn, widths.length, 1));
        Set<Modifier> modifiers = type.getFeatureContainer().getModifiers();
        this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.resource.bonusProduction", new String[0])), higConst.rc(row += 2, leftColumn));
        JPanel goodsPanel = new JPanel();
        goodsPanel.setOpaque(false);
        for (Modifier modifier : modifiers) {
            String text = this.getModifierAsString(modifier);
            if (modifier.hasScope()) {
                ArrayList<String> scopeStrings = new ArrayList<String>();
                for (Scope scope : modifier.getScopes()) {
                    if (scope.getType() == null) continue;
                    FreeColGameObjectType objectType = Specification.getSpecification().getType(scope.getType());
                    scopeStrings.add(objectType.getName());
                }
                if (!scopeStrings.isEmpty()) {
                    text = text + " (" + Utils.join(", ", scopeStrings) + ")";
                }
            }
            GoodsType goodsType = Specification.getSpecification().getGoodsType(modifier.getId());
            JButton goodsButton = this.getGoodsButton(goodsType, text);
            goodsPanel.add(goodsButton);
        }
        this.detailPanel.add((Component)goodsPanel, higConst.rc(row, rightColumn, "l"));
        this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.resource.description", new String[0])), higConst.rc(row += 2, leftColumn, "tl"));
        this.detailPanel.add((Component)ColopediaPanel.getDefaultTextArea(type.getDescription()), higConst.rc(row, rightColumn));
        this.detailPanel.validate();
    }

    private void buildUnitDetail(UnitType type) {
        this.detailPanel.removeAll();
        this.detailPanel.repaint();
        if (type == null) {
            return;
        }
        Player player = this.parent.getClient().getMyPlayer();
        Europe europe = player == null ? null : player.getEurope();
        int rowsRequired = 5;
        String price = null;
        if (europe != null && europe.getUnitPrice(type) > 0) {
            price = String.valueOf(europe.getUnitPrice(type));
        } else if (type.getPrice() > 0) {
            price = String.valueOf(type.getPrice());
        }
        if (price != null) {
            ++rowsRequired;
        }
        if (!type.getAbilitiesRequired().isEmpty()) {
            ++rowsRequired;
        }
        String capacity = null;
        if (type.canCarryGoods() || type.canCarryUnits()) {
            capacity = String.valueOf(type.getSpace());
            ++rowsRequired;
        }
        JPanel goodsRequired = null;
        if (!type.getGoodsRequired().isEmpty()) {
            ++rowsRequired;
            goodsRequired = new JPanel();
            goodsRequired.setOpaque(false);
            for (AbstractGoods goods : type.getGoodsRequired()) {
                goodsRequired.add(this.getGoodsButton(goods.getType(), goods.getAmount()));
            }
        }
        String skill = null;
        JPanel schoolPanel = null;
        if (type.hasSkill()) {
            rowsRequired += 2;
            skill = String.valueOf(type.getSkill());
            schoolPanel = new JPanel();
            schoolPanel.setOpaque(false);
            for (BuildingType buildingType : Specification.getSpecification().getBuildingTypeList()) {
                if (!buildingType.hasAbility("model.ability.teach") || !buildingType.canAdd(type)) continue;
                schoolPanel.add(this.getButton(buildingType));
            }
        }
        JPanel productionPanel = null;
        ArrayList<Modifier> bonusList = new ArrayList<Modifier>();
        for (GoodsType goodsType : Specification.getSpecification().getGoodsTypeList()) {
            bonusList.addAll(type.getModifierSet(goodsType.getId()));
        }
        int bonusNumber = bonusList.size();
        if (bonusNumber > 0) {
            int rows = bonusNumber / 5;
            if (bonusNumber % 5 != 0) {
                ++rows;
            }
            int[] widths = new int[9];
            for (int index = 1; index < widths.length; index += 2) {
                widths[index] = 9;
            }
            int[] heights = new int[2 * rows - 1];
            for (int index = 1; index < heights.length; index += 2) {
                heights[index] = 3;
            }
            productionPanel = new JPanel(new HIGLayout(widths, heights));
            productionPanel.setOpaque(false);
            ++rowsRequired;
            int row = 1;
            int column = 1;
            for (Modifier productionBonus : bonusList) {
                GoodsType goodsType = Specification.getSpecification().getGoodsType(productionBonus.getId());
                String bonus = this.getModifierAsString(productionBonus);
                productionPanel.add((Component)this.getGoodsButton(goodsType, bonus), higConst.rc(row, column));
                if ((column += 2) != 11) continue;
                column = 1;
                row += 2;
            }
        }
        int[] widths = new int[]{0, 9, 0};
        int[] heights = new int[2 * rowsRequired - 1];
        for (int index = 1; index < heights.length; index += 2) {
            heights[index] = 3;
        }
        int labelColumn = 1;
        int valueColumn = 3;
        HIGLayout layout = new HIGLayout(widths, heights);
        layout.setColumnWeight(valueColumn, 1);
        this.detailPanel.setLayout(layout);
        int row = 1;
        JLabel name = new JLabel(type.getName(), 0);
        name.setFont(smallHeaderFont);
        this.detailPanel.add((Component)name, higConst.rcwh(row, labelColumn, widths.length, 1));
        this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.unit.offensivePower", new String[0])), higConst.rc(row += 2, labelColumn));
        this.detailPanel.add((Component)new JLabel(String.valueOf(type.getOffence())), higConst.rc(row, valueColumn, "r"));
        this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.unit.defensivePower", new String[0])), higConst.rc(row += 2, labelColumn));
        this.detailPanel.add((Component)new JLabel(String.valueOf(type.getDefence())), higConst.rc(row, valueColumn, "r"));
        this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.unit.movement", new String[0])), higConst.rc(row += 2, labelColumn));
        this.detailPanel.add((Component)new JLabel(String.valueOf(type.getMovement() / 3)), higConst.rc(row, valueColumn, "r"));
        row += 2;
        if (capacity != null) {
            this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.unit.capacity", new String[0])), higConst.rc(row, labelColumn));
            this.detailPanel.add((Component)new JLabel(capacity), higConst.rc(row, valueColumn, "r"));
            row += 2;
        }
        if (skill != null) {
            this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.unit.skill", new String[0])), higConst.rc(row, labelColumn));
            this.detailPanel.add((Component)new JLabel(skill), higConst.rc(row, valueColumn, "r"));
            this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.unit.school", new String[0])), higConst.rc(row += 2, labelColumn));
            this.detailPanel.add((Component)schoolPanel, higConst.rc(row, valueColumn, "l"));
            row += 2;
        }
        if (productionPanel != null) {
            this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.unit.productionBonus", new String[0])), higConst.rc(row, labelColumn, "tl"));
            this.detailPanel.add((Component)productionPanel, higConst.rc(row, valueColumn, "l"));
            row += 2;
        }
        if (price != null) {
            this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.unit.price", new String[0])), higConst.rc(row, labelColumn));
            this.detailPanel.add((Component)new JLabel(price), higConst.rc(row, valueColumn, "r"));
            row += 2;
        }
        if (goodsRequired != null) {
            this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.unit.goodsRequired", new String[0])), higConst.rc(row, labelColumn));
            this.detailPanel.add((Component)goodsRequired, higConst.rc(row, valueColumn, "l"));
            row += 2;
        }
        if (!type.getAbilitiesRequired().isEmpty()) {
            try {
                JTextPane textPane = ColopediaPanel.getDefaultTextPane();
                StyledDocument doc = textPane.getStyledDocument();
                this.appendRequiredAbilities(doc, type);
                this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.buildings.requires", new String[0])), higConst.rc(row, labelColumn, "tl"));
                this.detailPanel.add((Component)textPane, higConst.rc(row, valueColumn));
                row += 2;
            }
            catch (BadLocationException e) {
                logger.warning(e.toString());
            }
        }
        this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.unit.description", new String[0])), higConst.rc(row, labelColumn, "tl"));
        this.detailPanel.add((Component)ColopediaPanel.getDefaultTextArea(type.getDescription()), higConst.rc(row, valueColumn));
        this.detailPanel.validate();
    }

    private void buildGoodsDetail(GoodsType type) {
        this.detailPanel.removeAll();
        this.detailPanel.repaint();
        if (type == null) {
            return;
        }
        String isFarmed = Messages.message(type.isFarmed() ? "yes" : "no", new String[0]);
        int numberOfLines = type.isFarmed() ? 8 : 6;
        int[] widths = new int[]{0, 9, 0};
        int[] heights = new int[2 * numberOfLines - 1];
        for (int index = 1; index < heights.length; index += 2) {
            heights[index] = 3;
        }
        int labelColumn = 1;
        int valueColumn = 3;
        HIGLayout layout = new HIGLayout(widths, heights);
        layout.setColumnWeight(valueColumn, 1);
        this.detailPanel.setLayout(layout);
        int row = 1;
        JLabel name = new JLabel(type.getName(), 0);
        name.setFont(smallHeaderFont);
        this.detailPanel.add((Component)name, higConst.rcwh(row, labelColumn, widths.length, 1));
        this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.goods.isFarmed", new String[0])), higConst.rc(row += 2, labelColumn));
        this.detailPanel.add((Component)new JLabel(isFarmed), higConst.rc(row, valueColumn, "r"));
        row += 2;
        if (type.isFarmed()) {
            String improvedByPlowing = Messages.message(plowing.getBonus(type) > 0 ? "yes" : "no", new String[0]);
            String improvedByRiver = Messages.message(river.getBonus(type) > 0 ? "yes" : "no", new String[0]);
            String improvedByRoad = Messages.message(road.getBonus(type) > 0 ? "yes" : "no", new String[0]);
            this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.goods.improvedByPlowing", new String[0])), higConst.rc(row, labelColumn));
            this.detailPanel.add((Component)new JLabel(improvedByPlowing), higConst.rc(row, valueColumn, "r"));
            this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.goods.improvedByRiver", new String[0])), higConst.rc(row += 2, labelColumn));
            this.detailPanel.add((Component)new JLabel(improvedByRiver), higConst.rc(row, valueColumn, "r"));
            this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.goods.improvedByRoad", new String[0])), higConst.rc(row += 2, labelColumn));
            this.detailPanel.add((Component)new JLabel(improvedByRoad), higConst.rc(row, valueColumn, "r"));
        } else {
            this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.goods.madeFrom", new String[0])), higConst.rc(row, labelColumn));
            if (type.isRefined()) {
                this.detailPanel.add((Component)this.getGoodsButton(type.getRawMaterial()), higConst.rc(row, valueColumn, "l"));
            }
        }
        this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.goods.makes", new String[0])), higConst.rc(row += 2, labelColumn));
        if (type.isRawMaterial()) {
            this.detailPanel.add((Component)this.getGoodsButton(type.getProducedMaterial()), higConst.rc(row, valueColumn, "l"));
        }
        this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.goods.description", new String[0])), higConst.rc(row += 2, labelColumn, "tl"));
        this.detailPanel.add((Component)ColopediaPanel.getDefaultTextArea(type.getDescription()), higConst.rc(row, valueColumn));
        this.detailPanel.validate();
    }

    private void buildBuildingDetail(BuildingType buildingType) {
        this.detailPanel.removeAll();
        this.detailPanel.repaint();
        if (buildingType == null) {
            return;
        }
        int[] widths = new int[]{0, 9, 0};
        int[] heights = new int[17];
        for (int index = 0; index < 7; ++index) {
            heights[2 * index + 1] = 3;
        }
        int row = 1;
        int leftColumn = 1;
        int rightColumn = 3;
        HIGLayout layout = new HIGLayout(widths, heights);
        layout.setColumnWeight(rightColumn, 1);
        this.detailPanel.setLayout(layout);
        JLabel name = new JLabel(buildingType.getName(), 0);
        name.setFont(smallHeaderFont);
        this.detailPanel.add((Component)name, higConst.rcwh(row, leftColumn, widths.length, 1));
        row += 2;
        JTextPane textPane = ColopediaPanel.getDefaultTextPane();
        StyledDocument doc = textPane.getStyledDocument();
        try {
            if (buildingType.getUpgradesFrom() != null) {
                StyleConstants.setComponent(doc.getStyle("button"), this.getButton(buildingType.getUpgradesFrom()));
                doc.insertString(doc.getLength(), " ", doc.getStyle("button"));
                doc.insertString(doc.getLength(), "\n", doc.getStyle("regular"));
            }
            if (buildingType.getPopulationRequired() > 0) {
                doc.insertString(doc.getLength(), String.valueOf(buildingType.getPopulationRequired()) + " " + Messages.message("colonists", new String[0]) + "\n", doc.getStyle("regular"));
            }
            this.appendRequiredAbilities(doc, buildingType);
            this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.buildings.requires", new String[0])), higConst.rc(row, leftColumn, "tl"));
            this.detailPanel.add((Component)textPane, higConst.rc(row, rightColumn));
            row += 2;
        }
        catch (BadLocationException e) {
            logger.warning(e.toString());
        }
        this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.buildings.cost", new String[0])), higConst.rc(row, leftColumn));
        if (buildingType.getGoodsRequired().isEmpty()) {
            this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.buildings.autoBuilt", new String[0])), higConst.rc(row, rightColumn, "l"));
        } else {
            JPanel costs = new JPanel();
            costs.setOpaque(false);
            costs.setLayout(new FlowLayout(0));
            for (AbstractGoods goodsRequired : buildingType.getGoodsRequired()) {
                costs.add(this.getGoodsButton(goodsRequired.getType(), goodsRequired.getAmount()));
            }
            this.detailPanel.add((Component)costs, higConst.rc(row, rightColumn));
        }
        this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.buildings.specialist", new String[0])), higConst.rc(row += 2, leftColumn));
        UnitType unitType = Specification.getSpecification().getExpertForProducing(buildingType.getProducedGoodsType());
        if (unitType == null) {
            this.detailPanel.add((Component)new JLabel(Messages.message("none", new String[0])), higConst.rc(row, rightColumn));
        } else {
            this.detailPanel.add((Component)this.getUnitButton(unitType), higConst.rc(row, rightColumn, "l"));
        }
        row += 2;
        JPanel production = new JPanel();
        production.setOpaque(false);
        if (buildingType.hasAbility("model.ability.teach")) {
            production.setLayout(new GridLayout(0, 3));
            for (UnitType unitType2 : Specification.getSpecification().getUnitTypeList()) {
                if (!buildingType.canAdd(unitType2)) continue;
                production.add(this.getButton(unitType2));
            }
            this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.buildings.teaches", new String[0])), higConst.rc(row, leftColumn));
            this.detailPanel.add((Component)production, higConst.rc(row, rightColumn));
            row += 2;
        } else {
            GoodsType outputType;
            production.setLayout(new FlowLayout(0));
            GoodsType inputType = buildingType.getConsumedGoodsType();
            if (inputType != null) {
                JLabel label = new JLabel(Messages.message("colopedia.buildings.needs", new String[0]));
                label.setHorizontalTextPosition(10);
                production.add(label);
                production.add(this.getGoodsButton(inputType));
            }
            if ((outputType = buildingType.getProducedGoodsType()) != null) {
                JLabel label = new JLabel(Messages.message("colopedia.buildings.produces", new String[0]));
                label.setHorizontalTextPosition(10);
                production.add(label);
                production.add(this.getGoodsButton(outputType));
            }
            this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.buildings.production", new String[0])), higConst.rc(row, leftColumn));
            this.detailPanel.add((Component)production, higConst.rc(row, rightColumn));
            row += 2;
        }
        JPanel productionPanel = null;
        Set<Modifier> bonusList = buildingType.getFeatureContainer().getModifiers();
        int bonusNumber = bonusList.size();
        if (bonusNumber > 0) {
            int rows = bonusNumber / 5;
            if (bonusNumber % 5 != 0) {
                ++rows;
            }
            int[] pwidths = new int[9];
            for (int index = 1; index < pwidths.length; index += 2) {
                pwidths[index] = 9;
            }
            int[] pheights = new int[2 * rows - 1];
            for (int index = 1; index < pheights.length; index += 2) {
                pheights[index] = 3;
            }
            productionPanel = new JPanel(new HIGLayout(pwidths, pheights));
            productionPanel.setOpaque(false);
            int prow = 1;
            int pcolumn = 1;
            for (Modifier productionBonus : bonusList) {
                String bonus;
                try {
                    GoodsType goodsType = Specification.getSpecification().getGoodsType(productionBonus.getId());
                    bonus = this.getModifierAsString(productionBonus);
                    productionPanel.add((Component)this.getGoodsButton(goodsType, bonus), higConst.rc(prow, pcolumn));
                }
                catch (Exception e) {
                    bonus = productionBonus.getName() + ": " + this.getModifierAsString(productionBonus);
                    productionPanel.add((Component)new JLabel(bonus), higConst.rc(prow, pcolumn));
                }
                if ((pcolumn += 2) != 11) continue;
                pcolumn = 1;
                prow += 2;
            }
            this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.buildings.modifiers", new String[0])), higConst.rc(row, leftColumn));
            this.detailPanel.add((Component)productionPanel, higConst.rc(row, rightColumn));
            row += 2;
        }
        JTextArea notes = ColopediaPanel.getDefaultTextArea(buildingType.getDescription());
        this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.buildings.notes", new String[0])), higConst.rc(row, leftColumn, "tl"));
        this.detailPanel.add((Component)notes, higConst.rc(row, rightColumn));
        this.detailPanel.validate();
    }

    private void buildFatherDetail(FoundingFather father) {
        this.detailPanel.removeAll();
        this.detailPanel.repaint();
        if (father == null) {
            return;
        }
        this.detailPanel.setLayout(new FlowLayout());
        JLabel name = new JLabel(father.getName() + " (" + father.getTypeAsString() + ")", 0);
        name.setFont(smallHeaderFont);
        name.setPreferredSize(new Dimension(400, 50));
        this.detailPanel.add(name);
        Image image = this.library.getFoundingFatherImage(father);
        JLabel imageLabel = image != null ? new JLabel(new ImageIcon(image)) : new JLabel();
        this.detailPanel.add(imageLabel);
        String text = Messages.message(father.getDescription(), new String[0]) + "\n\n" + "[" + Messages.message(father.getBirthAndDeath(), new String[0]) + "] " + Messages.message(father.getText(), new String[0]);
        JTextArea description = ColopediaPanel.getDefaultTextArea(text);
        description.setColumns(32);
        description.setSize(description.getPreferredSize());
        this.detailPanel.add(description);
        this.detailPanel.validate();
    }

    private void buildNationDetail(Nation nation) {
        this.detailPanel.removeAll();
        this.detailPanel.repaint();
        if (nation == null) {
            return;
        }
        int[] widths = new int[]{0, 9, 0};
        int[] heights = new int[9];
        for (int index = 1; index < heights.length; index += 2) {
            heights[index] = 3;
        }
        int row = 1;
        int leftColumn = 1;
        int rightColumn = 3;
        HIGLayout layout = new HIGLayout(widths, heights);
        layout.setColumnWeight(rightColumn, 1);
        this.detailPanel.setLayout(layout);
        JLabel name = new JLabel(nation.getName(), 0);
        name.setFont(smallHeaderFont);
        this.detailPanel.add((Component)name, higConst.rcwh(row, leftColumn, widths.length, 1));
        JLabel artLabel = new JLabel(this.library.getMonarchImageIcon(nation));
        this.detailPanel.add((Component)artLabel, higConst.rc(row += 2, rightColumn, "l"));
        JLabel rulerLabel = new JLabel(Messages.message("colopedia.nation.ruler", new String[0]));
        this.detailPanel.add((Component)rulerLabel, higConst.rc(row += 2, leftColumn));
        JLabel rulerName = new JLabel(nation.getRulerName());
        this.detailPanel.add((Component)rulerName, higConst.rc(row, rightColumn, "l"));
        JLabel defaultLabel = new JLabel(Messages.message("colopedia.nation.defaultAdvantage", new String[0]));
        this.detailPanel.add((Component)defaultLabel, higConst.rc(row += 2, leftColumn));
        JButton defaultAdvantage = this.getButton(nation.getType());
        this.detailPanel.add((Component)defaultAdvantage, higConst.rc(row, rightColumn, "l"));
        JLabel currentLabel = new JLabel(Messages.message("colopedia.nation.currentAdvantage", new String[0]));
        this.detailPanel.add((Component)currentLabel, higConst.rc(row += 2, leftColumn));
        JButton currentAdvantage = this.getButton(nation.getType());
        this.detailPanel.add((Component)currentAdvantage, higConst.rc(row, rightColumn, "l"));
        this.detailPanel.validate();
    }

    private void buildNationTypeDetail(NationType nationType) {
        if (nationType instanceof EuropeanNationType) {
            this.buildEuropeanNationTypeDetail((EuropeanNationType)nationType);
        } else if (nationType instanceof IndianNationType) {
            this.buildIndianNationTypeDetail((IndianNationType)nationType);
        }
    }

    private void buildEuropeanNationTypeDetail(EuropeanNationType nationType) {
        this.detailPanel.removeAll();
        this.detailPanel.repaint();
        if (nationType == null) {
            return;
        }
        Set<Ability> abilities = nationType.getFeatureContainer().getAbilities();
        Set<Modifier> modifiers = nationType.getFeatureContainer().getModifiers();
        int numberOfRows = 4 + abilities.size() + modifiers.size();
        int[] widths = new int[]{0, 9, 0};
        int[] heights = new int[numberOfRows * 2];
        for (int index = 1; index < heights.length; index += 2) {
            heights[index] = 3;
        }
        int row = 1;
        int leftColumn = 1;
        int rightColumn = 3;
        HIGLayout layout = new HIGLayout(widths, heights);
        layout.setColumnWeight(rightColumn, 1);
        this.detailPanel.setLayout(layout);
        JLabel name = new JLabel(nationType.getName(), 0);
        name.setFont(smallHeaderFont);
        this.detailPanel.add((Component)name, higConst.rcwh(row, leftColumn, widths.length, 1));
        JLabel units = new JLabel(Messages.message("colopedia.nationType.units", new String[0]));
        this.detailPanel.add((Component)units, higConst.rc(row += 2, leftColumn, "lt"));
        List<AbstractUnit> startingUnits = nationType.getStartingUnits();
        if (!startingUnits.isEmpty()) {
            GridLayout gridLayout = new GridLayout(0, 2);
            gridLayout.setHgap(10);
            JPanel unitPanel = new JPanel(gridLayout);
            unitPanel.setOpaque(false);
            for (AbstractUnit startingUnit : startingUnits) {
                unitPanel.add(this.getUnitButton(startingUnit.getUnitType(), startingUnit.getRole()));
            }
            this.detailPanel.add((Component)unitPanel, higConst.rc(row, rightColumn, "lt"));
        }
        JLabel abilityLabel = new JLabel(Messages.message("abilities", new String[0]));
        this.detailPanel.add((Component)abilityLabel, higConst.rc(row += 2, leftColumn));
        row += 2;
        if (!abilities.isEmpty()) {
            String trueString = Messages.message("true", new String[0]);
            String falseString = Messages.message("false", new String[0]);
            for (Ability ability : abilities) {
                this.detailPanel.add((Component)new JLabel("* " + ability.getName()), higConst.rc(row, leftColumn, "l"));
                String value = ability.getValue() ? trueString : falseString;
                this.detailPanel.add((Component)new JLabel(value), higConst.rc(row, rightColumn, "r"));
                row += 2;
            }
        }
        JLabel modifierLabel = new JLabel(Messages.message("modifiers", new String[0]));
        this.detailPanel.add((Component)modifierLabel, higConst.rc(row, leftColumn));
        row += 2;
        if (!modifiers.isEmpty()) {
            for (Modifier modifier : modifiers) {
                this.detailPanel.add((Component)new JLabel("* " + modifier.getName()), higConst.rc(row, leftColumn, "l"));
                this.detailPanel.add((Component)new JLabel(this.getModifierAsString(modifier)), higConst.rc(row, rightColumn, "r"));
                row += 2;
            }
        }
        this.detailPanel.validate();
    }

    private void buildIndianNationTypeDetail(IndianNationType nationType) {
        this.detailPanel.removeAll();
        this.detailPanel.repaint();
        if (nationType == null) {
            return;
        }
        List<RandomChoice<UnitType>> skills = nationType.getSkills();
        int numberOfRows = 6;
        int[] widths = new int[]{0, 9, 0};
        int[] heights = new int[numberOfRows * 2];
        for (int index = 1; index < heights.length; index += 2) {
            heights[index] = 3;
        }
        int row = 1;
        int leftColumn = 1;
        int rightColumn = 3;
        HIGLayout layout = new HIGLayout(widths, heights);
        layout.setColumnWeight(rightColumn, 1);
        this.detailPanel.setLayout(layout);
        JLabel name = new JLabel(nationType.getName(), 0);
        name.setFont(smallHeaderFont);
        this.detailPanel.add((Component)name, higConst.rcwh(row, leftColumn, widths.length, 1));
        this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.nationType.aggression", new String[0])), higConst.rc(row += 2, leftColumn));
        this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.nationType.aggression." + nationType.getAggression().toString().toLowerCase(), new String[0])), higConst.rc(row, rightColumn, "r"));
        this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.nationType.numberOfSettlements", new String[0])), higConst.rc(row += 2, leftColumn));
        this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.nationType.numberOfSettlements." + nationType.getNumberOfSettlements().toString().toLowerCase(), new String[0])), higConst.rc(row, rightColumn, "r"));
        this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.nationType.typeOfSettlements", new String[0])), higConst.rc(row += 2, leftColumn));
        this.detailPanel.add((Component)new JLabel(nationType.getSettlementTypeAsString(), new ImageIcon(this.library.getSettlementImage(nationType.getTypeOfSettlement())), 0), higConst.rc(row, rightColumn, "r"));
        row += 2;
        ArrayList<String> regionNames = new ArrayList<String>();
        for (String regionName : nationType.getRegionNames()) {
            regionNames.add(Messages.message(regionName + ".name", new String[0]));
        }
        this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.nationType.regions", new String[0])), higConst.rc(row, leftColumn));
        this.detailPanel.add((Component)new JLabel(Utils.join(", ", regionNames)), higConst.rc(row, rightColumn, "r"));
        this.detailPanel.add((Component)new JLabel(Messages.message("colopedia.nationType.skills", new String[0])), higConst.rc(row += 2, leftColumn, "lt"));
        GridLayout gridLayout = new GridLayout(0, 2);
        gridLayout.setHgap(10);
        JPanel unitPanel = new JPanel(gridLayout);
        unitPanel.setOpaque(false);
        for (RandomChoice<UnitType> choice : skills) {
            unitPanel.add(this.getUnitButton(choice.getObject()));
        }
        this.detailPanel.add((Component)unitPanel, higConst.rc(row, rightColumn, "lt"));
        this.detailPanel.validate();
    }

    public void valueChanged(TreeSelectionEvent event) {
        if (event.getSource() == this.tree) {
            TreePath path = this.tree.getSelectionPath();
            if (path == null) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)path.getParentPath().getLastPathComponent();
            ColopediaTreeItem parentItem = (ColopediaTreeItem)parent.getUserObject();
            ColopediaTreeItem nodeItem = (ColopediaTreeItem)node.getUserObject();
            if (parentItem.getPanelType() != null) {
                this.selectDetail(parentItem.getPanelType(), nodeItem.getFreeColGameObjectType());
            }
        }
    }

    public static JTextArea getDefaultTextArea(String text) {
        JTextArea textArea = new JTextArea(text);
        textArea.setOpaque(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setFocusable(false);
        textArea.setFont(defaultFont);
        return textArea;
    }

    public String getModifierAsString(Modifier modifier) {
        String bonus = ColopediaPanel.getModifierFormat().format(modifier.getValue());
        switch (modifier.getType()) {
            case ADDITIVE: {
                if (!(modifier.getValue() > 0.0f)) break;
                bonus = "+" + bonus;
                break;
            }
            case PERCENTAGE: {
                if (modifier.getValue() > 0.0f) {
                    bonus = "+" + bonus;
                }
                bonus = bonus + "%";
                break;
            }
            case MULTIPLICATIVE: {
                bonus = "\u00d7" + bonus;
                break;
            }
        }
        return bonus;
    }

    public void appendRequiredAbilities(StyledDocument doc, BuildableType buildableType) throws BadLocationException {
        for (Map.Entry<String, Boolean> entry : buildableType.getAbilitiesRequired().entrySet()) {
            doc.insertString(doc.getLength(), Messages.message(entry.getKey() + ".name", new String[0]), doc.getStyle("regular"));
            ArrayList<JButton> requiredTypes = new ArrayList<JButton>();
            for (Ability ability : Specification.getSpecification().getAbilities(entry.getKey())) {
                if (ability.getValue() != entry.getValue().booleanValue() || ability.getSource() == null) continue;
                JButton typeButton = this.getButton(ability.getSource());
                typeButton.addActionListener(this);
                requiredTypes.add(typeButton);
            }
            if (!requiredTypes.isEmpty()) {
                doc.insertString(doc.getLength(), " (", doc.getStyle("regular"));
                StyleConstants.setComponent(doc.getStyle("button"), (Component)requiredTypes.get(0));
                doc.insertString(doc.getLength(), " ", doc.getStyle("button"));
                for (int index = 1; index < requiredTypes.size(); ++index) {
                    JButton button = (JButton)requiredTypes.get(index);
                    doc.insertString(doc.getLength(), " / ", doc.getStyle("regular"));
                    StyleConstants.setComponent(doc.getStyle("button"), button);
                    doc.insertString(doc.getLength(), " ", doc.getStyle("button"));
                }
                doc.insertString(doc.getLength(), ")", doc.getStyle("regular"));
            }
            doc.insertString(doc.getLength(), "\n", doc.getStyle("regular"));
        }
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (OK.equals(command)) {
            this.parent.remove(this);
        } else {
            FreeColGameObjectType type = Specification.getSpecification().getType(command);
            this.initialize(type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PanelType {
        TERRAIN,
        RESOURCES,
        UNITS,
        GOODS,
        SKILLS,
        BUILDINGS,
        FATHERS,
        NATIONS,
        NATION_TYPES;

    }
}

