/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import cz.autel.dmi.HIGLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.EuropePanel;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.common.model.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ColorCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private static final Logger logger = Logger.getLogger(EuropePanel.class.getName());
    private static final String EDIT = "EDIT";
    private static final String OK = "OK";
    private static final String CANCEL = "CANCEL";
    private final JButton colorEditButton;
    private final JColorChooser colorChooser;
    private final ColorChooserPanel colorChooserPanel;
    private final JPanel parent;
    private final Canvas canvas;
    private Color currentColor;
    private List<Player> players;
    private int lastRow;
    private Player thisPlayer;

    public ColorCellEditor(Canvas canvas, JPanel parent) {
        this.canvas = canvas;
        this.parent = parent;
        this.colorEditButton = new JButton();
        this.colorEditButton.setActionCommand(EDIT);
        this.colorEditButton.addActionListener(this);
        this.colorEditButton.setBorderPainted(false);
        this.colorChooser = new JColorChooser();
        this.colorChooserPanel = new ColorChooserPanel(this);
        this.colorChooserPanel.setLocation(canvas.getWidth() / 2 - this.colorChooserPanel.getWidth() / 2, canvas.getHeight() / 2 - this.colorChooserPanel.getHeight() / 2);
    }

    public void setData(List<Player> players, Player owningPlayer) {
        this.players = players;
        this.thisPlayer = owningPlayer;
    }

    private Player getPlayer(int i) {
        if (i == 0) {
            return this.thisPlayer;
        }
        if (this.players.get(i) == this.thisPlayer) {
            return this.players.get(0);
        }
        return this.players.get(i);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals(EDIT)) {
            if (!this.canvas.isAncestorOf(this.colorChooserPanel)) {
                this.colorChooser.setColor(this.currentColor);
                this.canvas.addAsFrame(this.colorChooserPanel);
                this.colorChooserPanel.requestFocus();
                this.parent.setEnabled(false);
            }
        } else if (event.getActionCommand().equals(OK)) {
            this.currentColor = this.colorChooser.getColor();
            if (this.lastRow >= 0 && this.lastRow < this.players.size()) {
                Player player = this.getPlayer(this.lastRow);
                player.setColor(this.currentColor);
            }
            this.canvas.remove(this.colorChooserPanel);
            this.parent.setEnabled(true);
            this.fireEditingStopped();
        } else if (event.getActionCommand().equals(CANCEL)) {
            this.canvas.remove(this.colorChooserPanel);
            this.parent.setEnabled(true);
            this.fireEditingCanceled();
        } else {
            logger.warning("Invalid action command");
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean hasFocus, int row, int column) {
        this.currentColor = (Color)value;
        this.lastRow = row;
        return this.colorEditButton;
    }

    @Override
    public Object getCellEditorValue() {
        return this.currentColor;
    }

    private final class ColorChooserPanel
    extends FreeColPanel {
        public ColorChooserPanel(ActionListener l) {
            ColorCellEditor.this.lastRow = -1;
            JButton okButton = new JButton(Messages.message("ok", new String[0]));
            JButton cancelButton = new JButton(Messages.message("cancel", new String[0]));
            this.setLayout(new HIGLayout(new int[]{220, 10, 220}, new int[]{350, 10, 0}));
            this.add((Component)ColorCellEditor.this.colorChooser, higConst.rcwh(1, 1, 3, 1));
            this.add((Component)okButton, higConst.rc(3, 1));
            this.add((Component)cancelButton, higConst.rc(3, 3));
            okButton.setActionCommand(ColorCellEditor.OK);
            cancelButton.setActionCommand(ColorCellEditor.CANCEL);
            okButton.addActionListener(l);
            cancelButton.addActionListener(l);
            this.setOpaque(true);
            this.setSize(this.getPreferredSize());
        }
    }
}

