/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.TransferHandler;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.panel.BuildingProductionPanel;
import net.sf.freecol.client.gui.panel.CargoPanel;
import net.sf.freecol.client.gui.panel.ColonyPanel;
import net.sf.freecol.client.gui.panel.ColonyTileProductionPanel;
import net.sf.freecol.client.gui.panel.ColopediaPanel;
import net.sf.freecol.client.gui.panel.EuropePanel;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.GoodsLabel;
import net.sf.freecol.client.gui.panel.MarketLabel;
import net.sf.freecol.client.gui.panel.UnitLabel;
import net.sf.freecol.common.Specification;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;

public final class DragListener
extends MouseAdapter {
    private final FreeColPanel parentPanel;

    public DragListener(FreeColPanel parentPanel) {
        this.parentPanel = parentPanel;
    }

    public void mousePressed(MouseEvent e) {
        JComponent comp = (JComponent)e.getSource();
        if (e.getButton() == 3 || e.isPopupTrigger()) {
            if (this.parentPanel.isEditable()) {
                int elements;
                JPopupMenu menu = null;
                if (comp instanceof UnitLabel) {
                    menu = this.getUnitMenu((UnitLabel)comp);
                } else if (comp instanceof GoodsLabel) {
                    menu = this.getGoodsMenu((GoodsLabel)comp);
                } else if (comp instanceof MarketLabel && this.parentPanel instanceof EuropePanel) {
                    ((EuropePanel)this.parentPanel).payArrears(((MarketLabel)comp).getType());
                }
                if (menu != null && (elements = menu.getSubElements().length) > 0) {
                    int lastIndex = menu.getComponentCount() - 1;
                    if (menu.getComponent(lastIndex) instanceof JPopupMenu.Separator) {
                        menu.remove(lastIndex);
                    }
                    menu.show(comp, e.getX(), e.getY());
                }
            }
        } else {
            TransferHandler handler = comp.getTransferHandler();
            if (e.isShiftDown()) {
                if (comp instanceof GoodsLabel) {
                    ((GoodsLabel)comp).setPartialChosen(true);
                } else if (comp instanceof MarketLabel) {
                    ((MarketLabel)comp).setPartialChosen(true);
                }
            } else if (comp instanceof GoodsLabel) {
                ((GoodsLabel)comp).setPartialChosen(false);
            } else if (comp instanceof MarketLabel) {
                ((MarketLabel)comp).setPartialChosen(false);
                ((MarketLabel)comp).setAmount(100);
            }
            if (comp instanceof UnitLabel && ((UnitLabel)comp).getUnit().isCarrier()) {
                if (this.parentPanel instanceof EuropePanel) {
                    Unit u = ((UnitLabel)comp).getUnit();
                    if (u.getState() != Unit.UnitState.TO_AMERICA && u.getState() != Unit.UnitState.TO_EUROPE) {
                        ((EuropePanel)this.parentPanel).setSelectedUnitLabel((UnitLabel)comp);
                    }
                } else if (this.parentPanel instanceof ColonyPanel) {
                    ((ColonyPanel)this.parentPanel).setSelectedUnitLabel((UnitLabel)comp);
                }
            }
            if (handler != null) {
                handler.exportAsDrag(comp, e, 1);
            }
        }
    }

    public JPopupMenu getUnitMenu(UnitLabel unitLabel) {
        ImageLibrary imageLibrary = unitLabel.getCanvas().getGUI().getImageLibrary();
        Unit tempUnit = unitLabel.getUnit();
        JPopupMenu menu = new JPopupMenu("Unit");
        ImageIcon unitIcon = imageLibrary.getUnitImageIcon(tempUnit);
        JMenuItem name = new JMenuItem(tempUnit.getName() + " (" + Messages.message("menuBar.colopedia", new String[0]) + ")", imageLibrary.getScaledImageIcon(unitIcon, 0.66f));
        name.setActionCommand(UnitLabel.UnitAction.COLOPEDIA.toString());
        name.addActionListener(unitLabel);
        menu.add(name);
        menu.addSeparator();
        if (tempUnit.isCarrier() && this.addCarrierItems(unitLabel, menu)) {
            menu.addSeparator();
        }
        if (tempUnit.getLocation().getTile() != null && tempUnit.getLocation().getTile().getColony() != null) {
            if (this.addWorkItems(unitLabel, menu)) {
                menu.addSeparator();
            }
            if (this.addEducationItems(unitLabel, menu)) {
                menu.addSeparator();
            }
            if (!(tempUnit.getLocation() instanceof WorkLocation) && this.addCommandItems(unitLabel, menu)) {
                menu.addSeparator();
            }
        }
        if (tempUnit.hasAbility("model.ability.canBeEquipped") && this.addEquipmentItems(unitLabel, menu)) {
            menu.addSeparator();
        }
        return menu;
    }

    private boolean addCarrierItems(UnitLabel unitLabel, JPopupMenu menu) {
        Unit tempUnit = unitLabel.getUnit();
        if (tempUnit.getSpaceLeft() < tempUnit.getType().getSpace()) {
            JMenuItem menuItem;
            JMenuItem cargo = new JMenuItem(Messages.message("cargoOnCarrier", new String[0]));
            menu.add(cargo);
            for (Unit passenger : tempUnit.getUnitList()) {
                menuItem = new JMenuItem("    " + passenger.getName());
                menuItem.setFont(menuItem.getFont().deriveFont(2));
                menu.add(menuItem);
            }
            for (Goods goods : tempUnit.getGoodsList()) {
                menuItem = new JMenuItem("    " + goods.toString());
                menuItem.setFont(menuItem.getFont().deriveFont(2));
                menu.add(menuItem);
            }
            return true;
        }
        return false;
    }

    private boolean addWorkItems(final UnitLabel unitLabel, JPopupMenu menu) {
        JMenuItem menuItem;
        JMenuItem menuItem2;
        final Unit tempUnit = unitLabel.getUnit();
        ImageLibrary imageLibrary = unitLabel.getCanvas().getGUI().getImageLibrary();
        Colony colony = tempUnit.getLocation().getColony();
        boolean separatorNeeded = false;
        List<GoodsType> farmedGoods = Specification.getSpecification().getFarmedGoodsTypeList();
        for (GoodsType goodsType : farmedGoods) {
            int maxpotential = colony.getVacantColonyTileProductionFor(tempUnit, goodsType);
            if (maxpotential <= 0) continue;
            UnitType expert = Specification.getSpecification().getExpertForProducing(goodsType);
            menuItem2 = new JMenuItem(Messages.message(goodsType.getId() + ".workAs", "%amount%", Integer.toString(maxpotential)), imageLibrary.getScaledGoodsImageIcon(goodsType, 0.66f));
            menuItem2.setActionCommand(UnitLabel.UnitAction.WORK_TILE.toString() + ":" + goodsType.getId());
            menuItem2.addActionListener(unitLabel);
            menu.add(menuItem2);
            separatorNeeded = true;
        }
        for (Building building : colony.getBuildings()) {
            if (tempUnit.getWorkLocation() == building || !building.canAdd(tempUnit)) continue;
            GoodsType goodsType = building.getGoodsOutputType();
            String locName = building.getName();
            menuItem2 = new JMenuItem(locName);
            if (goodsType != null) {
                menuItem2.setIcon(imageLibrary.getScaledGoodsImageIcon(goodsType, 0.66f));
                int addOutput = building.getAdditionalProductionNextTurn(tempUnit);
                locName = locName + " (" + addOutput;
                int potential = building.getAdditionalProduction(tempUnit);
                if (addOutput < potential) {
                    locName = locName + "/" + potential;
                }
                locName = locName + " " + goodsType.getName() + ")";
                menuItem2.setText(locName);
                if (addOutput == 0) {
                    menuItem2.setForeground(FreeColPanel.LINK_COLOR);
                }
            }
            menuItem2.setActionCommand(UnitLabel.UnitAction.WORK_BUILDING.toString() + ":" + building.getType().getId());
            menuItem2.addActionListener(unitLabel);
            menu.add(menuItem2);
            separatorNeeded = true;
        }
        if (tempUnit.getWorkTile() != null) {
            menuItem = new JMenuItem(Messages.message("showProduction", new String[0]));
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Canvas canvas = unitLabel.getCanvas();
                    canvas.showSubPanel(new ColonyTileProductionPanel(canvas, tempUnit.getWorkTile(), tempUnit.getWorkType()));
                }
            });
            menu.add(menuItem);
            separatorNeeded = true;
        } else if (tempUnit.getWorkLocation() != null) {
            menuItem = new JMenuItem(Messages.message("showProductivity", new String[0]));
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    Canvas canvas = unitLabel.getCanvas();
                    canvas.showSubPanel(new BuildingProductionPanel(canvas, tempUnit));
                }
            });
            menu.add(menuItem);
            separatorNeeded = true;
        }
        return separatorNeeded;
    }

    private boolean addEducationItems(UnitLabel unitLabel, JPopupMenu menu) {
        int experience;
        Unit tempUnit = unitLabel.getUnit();
        ImageLibrary imageLibrary = unitLabel.getCanvas().getGUI().getImageLibrary();
        boolean separatorNeeded = false;
        for (Unit teacher : tempUnit.getColony().getTeachers()) {
            if (!tempUnit.canBeStudent(teacher) || !(tempUnit.getLocation() instanceof WorkLocation) || teacher.getStudent() == tempUnit) continue;
            JMenuItem menuItem = new JMenuItem(Messages.message("assignToTeacher", new String[0]), imageLibrary.getScaledImageIcon(imageLibrary.getUnitImageIcon(teacher), 0.5f));
            menuItem.setActionCommand(UnitLabel.UnitAction.ASSIGN.toString() + ":" + teacher.getId());
            menuItem.addActionListener(unitLabel);
            menu.add(menuItem);
            separatorNeeded = true;
        }
        if (tempUnit.getTurnsOfTraining() > 0 && tempUnit.getStudent() != null) {
            JMenuItem teaching = new JMenuItem(Messages.message("menuBar.teacher", new String[0]) + ": " + tempUnit.getTurnsOfTraining() + "/" + tempUnit.getNeededTurnsOfTraining());
            teaching.setEnabled(false);
            menu.add(teaching);
            separatorNeeded = true;
        }
        if ((experience = Math.min(tempUnit.getExperience(), 200)) > 0 && tempUnit.getWorkType() != null) {
            UnitType workType = Specification.getSpecification().getExpertForProducing(tempUnit.getWorkType());
            if (tempUnit.getType().canBeUpgraded(workType, UnitType.UpgradeType.EXPERIENCE)) {
                JMenuItem experienceItem = new JMenuItem(Messages.message("menuBar.experience", new String[0]) + ": " + experience + "/5000");
                experienceItem.setEnabled(false);
                menu.add(experienceItem);
                separatorNeeded = true;
            }
        }
        return separatorNeeded;
    }

    private boolean addCommandItems(final UnitLabel unitLabel, JPopupMenu menu) {
        final Unit tempUnit = unitLabel.getUnit();
        JMenuItem menuItem = new JMenuItem(Messages.message("activateUnit", new String[0]));
        menuItem.setActionCommand(UnitLabel.UnitAction.ACTIVATE_UNIT.toString());
        menuItem.addActionListener(unitLabel);
        menuItem.setEnabled(true);
        menu.add(menuItem);
        menuItem = new JMenuItem(Messages.message("fortifyUnit", new String[0]));
        menuItem.setActionCommand(UnitLabel.UnitAction.FORTIFY.toString());
        menuItem.addActionListener(unitLabel);
        menuItem.setEnabled(tempUnit.getMovesLeft() > 0 && tempUnit.getState() != Unit.UnitState.FORTIFIED && tempUnit.getState() != Unit.UnitState.FORTIFYING);
        menu.add(menuItem);
        menuItem = new JMenuItem(Messages.message("sentryUnit", new String[0]));
        menuItem.setActionCommand(UnitLabel.UnitAction.SENTRY.toString());
        menuItem.addActionListener(unitLabel);
        menuItem.setEnabled(tempUnit.getState() != Unit.UnitState.SENTRY);
        menu.add(menuItem);
        if (tempUnit.canCarryTreasure() && !tempUnit.getColony().isLandLocked()) {
            menuItem = new JMenuItem(Messages.message("cashInTreasureTrain.order", new String[0]));
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    unitLabel.getCanvas().getClient().getInGameController().checkCashInTreasureTrain(tempUnit);
                }
            });
            menu.add(menuItem);
        }
        return true;
    }

    private boolean addEquipmentItems(final UnitLabel unitLabel, JPopupMenu menu) {
        JMenuItem menuItem;
        final Unit tempUnit = unitLabel.getUnit();
        ImageLibrary imageLibrary = unitLabel.getCanvas().getGUI().getImageLibrary();
        boolean separatorNeeded = false;
        for (EquipmentType equipmentType : Specification.getSpecification().getEquipmentTypeList()) {
            EquipmentType type;
            JMenuItem newItem;
            int count = 0;
            for (EquipmentType oldEquipment : tempUnit.getEquipment()) {
                if (equipmentType != oldEquipment) continue;
                ++count;
            }
            if (count > 0) {
                newItem = new JMenuItem(Messages.message(equipmentType.getId() + ".remove", new String[0]));
                if (!equipmentType.getGoodsRequired().isEmpty()) {
                    GoodsType goodsType = equipmentType.getGoodsRequired().get(0).getType();
                    newItem.setIcon(imageLibrary.getScaledGoodsImageIcon(goodsType, 0.66f));
                }
                final int items = count;
                type = equipmentType;
                newItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        unitLabel.getCanvas().getClient().getInGameController().equipUnit(tempUnit, type, -items);
                        unitLabel.updateIcon();
                    }
                });
                menu.add(newItem);
            }
            if (!tempUnit.canBeEquippedWith(equipmentType) || count != 0) continue;
            newItem = null;
            count = equipmentType.getMaximumCount() - count;
            if (equipmentType.getGoodsRequired().isEmpty()) {
                newItem = new JMenuItem();
                newItem.setText(Messages.message(equipmentType.getId() + ".add", new String[0]));
            } else if (tempUnit.isInEurope() && tempUnit.getOwner().getEurope().canBuildEquipment(equipmentType)) {
                int price = 0;
                newItem = new JMenuItem();
                for (AbstractGoods goodsRequired : equipmentType.getGoodsRequired()) {
                    price += tempUnit.getOwner().getMarket().getBidPrice(goodsRequired.getType(), goodsRequired.getAmount());
                    newItem.setIcon(imageLibrary.getScaledGoodsImageIcon(goodsRequired.getType(), 0.66f));
                }
                while (count * price > tempUnit.getOwner().getGold()) {
                    --count;
                }
                newItem.setText(Messages.message(equipmentType.getId() + ".add", new String[0]) + " (" + Messages.message("goldAmount", "%amount%", String.valueOf(count * price)) + ")");
            } else if (tempUnit.getColony() != null && tempUnit.getColony().canBuildEquipment(equipmentType)) {
                newItem = new JMenuItem();
                for (AbstractGoods goodsRequired : equipmentType.getGoodsRequired()) {
                    int present = tempUnit.getColony().getGoodsCount(goodsRequired.getType()) / goodsRequired.getAmount();
                    if (present < count) {
                        count = present;
                    }
                    newItem.setIcon(imageLibrary.getScaledGoodsImageIcon(goodsRequired.getType(), 0.66f));
                }
                newItem.setText(Messages.message(equipmentType.getId() + ".add", new String[0]));
            }
            if (newItem == null) continue;
            final int items = count;
            type = equipmentType;
            newItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    unitLabel.getCanvas().getClient().getInGameController().equipUnit(tempUnit, type, items);
                    unitLabel.updateIcon();
                }
            });
            menu.add(newItem);
        }
        separatorNeeded = true;
        if (tempUnit.getLocation() instanceof WorkLocation && tempUnit.getColony().canReducePopulation()) {
            menuItem = new JMenuItem(Messages.message("leaveTown", new String[0]));
            menuItem.setActionCommand(UnitLabel.UnitAction.LEAVE_TOWN.toString());
            menuItem.addActionListener(unitLabel);
            menu.add(menuItem);
            separatorNeeded = true;
        }
        if (separatorNeeded) {
            menu.addSeparator();
            separatorNeeded = false;
        }
        if (tempUnit.getType().getDowngrade(UnitType.DowngradeType.CLEAR_SKILL) != null) {
            menuItem = new JMenuItem(Messages.message("clearSpeciality", new String[0]));
            menuItem.setActionCommand(UnitLabel.UnitAction.CLEAR_SPECIALITY.toString());
            menuItem.addActionListener(unitLabel);
            menu.add(menuItem);
            separatorNeeded = true;
        }
        return separatorNeeded;
    }

    public JPopupMenu getGoodsMenu(final GoodsLabel goodsLabel) {
        final Goods goods = goodsLabel.getGoods();
        final InGameController inGameController = goodsLabel.getCanvas().getClient().getInGameController();
        ImageLibrary imageLibrary = goodsLabel.getCanvas().getGUI().getImageLibrary();
        JPopupMenu menu = new JPopupMenu("Cargo");
        JMenuItem name = new JMenuItem(goods.getName() + " (" + Messages.message("menuBar.colopedia", new String[0]) + ")", imageLibrary.getScaledGoodsImageIcon(goods.getType(), 0.66f));
        name.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                goodsLabel.getCanvas().showColopediaPanel(ColopediaPanel.PanelType.GOODS, goods.getType());
            }
        });
        menu.add(name);
        if (!(goods.getLocation() instanceof Colony)) {
            JMenuItem unload = new JMenuItem(Messages.message("unload", new String[0]));
            unload.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    inGameController.unloadCargo(goods);
                    if (DragListener.this.parentPanel instanceof CargoPanel) {
                        CargoPanel cargoPanel = (CargoPanel)DragListener.this.parentPanel;
                        cargoPanel.initialize();
                        if (cargoPanel.getParentPanel() instanceof ColonyPanel) {
                            ((ColonyPanel)cargoPanel.getParentPanel()).updateWarehouse();
                        }
                    }
                    DragListener.this.parentPanel.revalidate();
                }
            });
            menu.add(unload);
            JMenuItem dump = new JMenuItem(Messages.message("dumpCargo", new String[0]));
            dump.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    inGameController.unloadCargo(goods, true);
                    if (DragListener.this.parentPanel instanceof CargoPanel) {
                        ((CargoPanel)DragListener.this.parentPanel).initialize();
                    }
                    DragListener.this.parentPanel.revalidate();
                }
            });
            menu.add(dump);
        }
        return menu;
    }
}

